/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.plugin.ds;

import com.qlangtech.tis.plugin.ds.ColumnMetaData;
import com.qlangtech.tis.plugin.ds.IDataSourceDumper;
import com.qlangtech.tis.plugin.ds.TISTable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.StringUtils;

public class DataDumpers {
    public final int splitCount;
    public final Iterator<IDataSourceDumper> dumpers;

    public static DataDumpers create(final List<String> jdbcUrls, final TISTable table) {
        if (jdbcUrls == null || jdbcUrls.isEmpty()) {
            throw new IllegalArgumentException("param jdbcUrls can not be empty");
        }
        final int length = jdbcUrls.size();
        final AtomicInteger index = new AtomicInteger();
        Iterator<IDataSourceDumper> dsIt = new Iterator<IDataSourceDumper>(){

            @Override
            public boolean hasNext() {
                return index.get() < length;
            }

            @Override
            public IDataSourceDumper next() {
                String jdbcUrl = (String)jdbcUrls.get(index.getAndIncrement());
                return new DefaultDumper(jdbcUrl, table);
            }
        };
        DataDumpers dumpers = new DataDumpers(length, dsIt);
        return dumpers;
    }

    public DataDumpers(int splitCount, Iterator<IDataSourceDumper> dumpers) {
        this.splitCount = splitCount;
        this.dumpers = dumpers;
    }

    private static class DefaultDumper
    implements IDataSourceDumper {
        public final TISTable table;
        private final String jdbcUrl;

        public DefaultDumper(String jdbcUrl, TISTable table) {
            this.table = table;
            if (StringUtils.isEmpty((String)jdbcUrl)) {
                throw new IllegalArgumentException("param jdbcUrl can not be null");
            }
            this.jdbcUrl = jdbcUrl;
        }

        @Override
        public void closeResource() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getRowSize() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<ColumnMetaData> getMetaData() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<Map<String, Object>> startDump() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDbHost() {
            return this.jdbcUrl;
        }
    }
}

