/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.plugin.ds;

import com.qlangtech.tis.offline.DbScope;
import com.qlangtech.tis.plugin.KeyedPluginStore;
import com.qlangtech.tis.plugin.ds.DBIdentity;
import com.qlangtech.tis.plugin.ds.DataSourceFactory;
import com.qlangtech.tis.plugin.ds.PostedDSProp;
import java.util.Objects;
import java.util.Optional;

public class DSKey
extends KeyedPluginStore.Key<DataSourceFactory> {
    private final DbScope dbScope;

    public DSKey(String groupName, PostedDSProp dsProp, Class<DataSourceFactory> pluginClass) {
        this(groupName, dsProp.getDbType(), DSKey.getDBName(dsProp.getDbname()), pluginClass);
    }

    private static String getDBName(Optional<DBIdentity> dbName) {
        if (!dbName.isPresent()) {
            throw new IllegalStateException("dbName must be present");
        }
        return dbName.get().identityValue();
    }

    public DSKey(String groupName, DbScope dbScope, String keyVal, Class<DataSourceFactory> pluginClass) {
        super(groupName, keyVal, pluginClass);
        this.dbScope = dbScope;
    }

    @Override
    public String getSerializeFileName() {
        return super.getSerializeFileName() + this.dbScope.getDBType();
    }

    public boolean isFacadeType() {
        return this.dbScope == DbScope.FACADE;
    }

    public String toString() {
        return "DSKey{dbScope=" + this.dbScope + ", keyVal=" + this.keyVal + "}";
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.keyVal, this.dbScope, this.pluginClass);
    }
}

