/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.plugin.ds;

import com.alibaba.citrus.turbine.Context;
import com.alibaba.citrus.turbine.impl.DefaultContext;
import com.alibaba.fastjson.annotation.JSONField;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.qlangtech.tis.lang.TisException;
import com.qlangtech.tis.plugin.ds.IDbMeta;
import com.qlangtech.tis.plugin.ds.ISelectedTab;
import com.qlangtech.tis.plugin.ds.JDBCConnection;
import com.qlangtech.tis.plugin.ds.JDBCConnectionException;
import com.qlangtech.tis.plugin.ds.JDBCConnectionPool;
import com.qlangtech.tis.plugin.ds.JdbcUrlBuilder;
import com.qlangtech.tis.runtime.module.misc.IMessageHandler;
import com.qlangtech.tis.runtime.module.misc.impl.AdapterMessageHandler;
import com.qlangtech.tis.util.RobustReflectionConverter2;
import com.qlangtech.tis.web.start.TisAppLaunch;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBConfig
implements IDbMeta {
    private static final Logger logger = LoggerFactory.getLogger(DBConfig.class);
    private String dbType;
    private String name;
    private final JdbcUrlBuilder jdbcUrlBuilder;
    private Map<String, List<String>> dbEnum = new HashMap<String, List<String>>();
    private StringBuffer hostDesc;
    public static final int expireSec = TisAppLaunch.isTestMock() ? 200 : 15;

    public void setDbEnum(Map<String, List<String>> dbEnum) {
        this.dbEnum = dbEnum;
    }

    public DBConfig(JdbcUrlBuilder jdbcUrlBuilder) {
        this.jdbcUrlBuilder = jdbcUrlBuilder;
    }

    public DBConfig() {
        this(null);
    }

    @Override
    @JSONField(serialize=false)
    public String getFormatDBName() {
        return DBConfig.getFormatDBName(this.name);
    }

    @Override
    @JSONField(serialize=false)
    public String getDAOJarName() {
        return DBConfig.getDAOJarName(this.name);
    }

    public static String getFormatDBName(String dbName) {
        if (StringUtils.isEmpty((String)dbName)) {
            throw new IllegalArgumentException("param dbName can not be null");
        }
        return StringUtils.remove((String)StringUtils.lowerCase((String)dbName), (String)"_");
    }

    public static String getDAOJarName(String dbName) {
        return DBConfig.getFormatDBName(dbName) + "-dao.jar";
    }

    public StringBuffer getHostDesc() {
        return this.hostDesc;
    }

    public void setHostDesc(StringBuffer hostDesc) {
        this.hostDesc = hostDesc;
    }

    public void vistDbName(IProcess p) throws Exception {
        String jdbcUrl = null;
        for (Map.Entry<String, List<String>> entry : this.dbEnum.entrySet()) {
            for (String dbname : entry.getValue()) {
                jdbcUrl = this.jdbcUrlBuilder.buidJdbcUrl(this, entry.getKey(), dbname);
                if (!p.visit(this, jdbcUrl, entry.getKey(), dbname)) continue;
                return;
            }
        }
    }

    public void vistDbURL(boolean resolveHostIp, IDbUrlProcess urlProcess) {
        this.vistDbURL(resolveHostIp, expireSec, urlProcess);
    }

    public void vistDbURL(boolean resolveHostIp, int expireSec, IDbUrlProcess urlProcess) {
        this.vistDbURL(resolveHostIp, expireSec, urlProcess, false);
    }

    public void vistDbURL(boolean resolveHostIp, int expireSec, IDbUrlProcess urlProcess, boolean facade) {
        final String[] err = new String[1];
        try {
            if (!this.vistDbURL(resolveHostIp, urlProcess, facade, (IMessageHandler)new AdapterMessageHandler(){

                public void addErrorMessage(Context context, String msg) {
                    err[0] = msg;
                }
            }, (Context)new DefaultContext(), expireSec)) {
                throw TisException.create((String)("error:" + err[0]));
            }
        }
        catch (JDBCConnectionException e) {
            throw TisException.create((String)e.getMessage(), (Throwable)e);
        }
    }

    public boolean vistDbURL(boolean resolveHostIp, IDbUrlProcess urlProcess, boolean facade, IMessageHandler msgHandler, Context context) throws JDBCConnectionException {
        return this.vistDbURL(resolveHostIp, urlProcess, facade, msgHandler, context, expireSec);
    }

    public Map<String, HostDBs> getHostDBsMapper() throws Exception {
        HashMap ip2dbs = Maps.newHashMap();
        this.vistDbName((config, jdbcUrl, ip, dbName) -> {
            HostDBs dbs = (HostDBs)ip2dbs.get(ip);
            if (dbs == null) {
                dbs = new HostDBs(ip);
                ip2dbs.put(ip, dbs);
            }
            dbs.addDB(jdbcUrl, dbName);
            return false;
        });
        return ip2dbs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean vistDbURL(boolean resolveHostIp, IDbUrlProcess urlProcess, boolean facade, IMessageHandler msgHandler, Context context, int expireSec) throws JDBCConnectionException {
        int dbCount = 0;
        for (Map.Entry<String, List<String>> entry : this.getDbEnum().entrySet()) {
            dbCount += entry.getValue().size();
        }
        if (dbCount < 1) {
            throw new IllegalStateException("dbCount can not small than 1");
        }
        ExecutorService fixedThreadPool = Executors.newCachedThreadPool(runnable -> {
            Thread t = new Thread(runnable);
            return t;
        });
        try {
            JDBCConnectionPool connectionPool = JDBCConnection.connectionPool.get();
            RobustReflectionConverter2.PluginMetas pluginMetas = RobustReflectionConverter2.usedPluginInfo.get();
            CountDownLatch countDownLatch = new CountDownLatch(facade ? 1 : dbCount);
            int hostCount = 0;
            AtomicReference fjdbcUrl = new AtomicReference();
            AtomicReference exceptionCollect = new AtomicReference();
            block13: for (Map.Entry<String, List<String>> entry : this.getDbEnum().entrySet()) {
                Iterator<String> iterator = entry.getValue().iterator();
                while (iterator.hasNext()) {
                    String dbName;
                    String dbHost = resolveHostIp ? this.getHostIpAddress(entry.getKey()) : entry.getKey();
                    String jdbcUrl = this.jdbcUrlBuilder.buidJdbcUrl(this, dbHost, dbName = iterator.next());
                    if (StringUtils.isEmpty((String)jdbcUrl)) {
                        throw new IllegalStateException("dbHost:" + dbHost + ",dbName:" + dbName + " relevant jdbcUrl can not be empty");
                    }
                    ++hostCount;
                    fixedThreadPool.execute(() -> {
                        try {
                            if (connectionPool != null) {
                                JDBCConnection.connectionPool.set(connectionPool);
                            }
                            RobustReflectionConverter2.usedPluginInfo.set(pluginMetas);
                            fjdbcUrl.set(jdbcUrl);
                            urlProcess.visit(facade ? this.name : dbName, dbHost, jdbcUrl);
                        }
                        catch (Throwable e) {
                            exceptionCollect.set(e);
                        }
                        finally {
                            countDownLatch.countDown();
                            if (connectionPool != null) {
                                JDBCConnection.connectionPool.remove();
                            }
                            RobustReflectionConverter2.usedPluginInfo.remove();
                        }
                    });
                    if (!facade) continue;
                    break block13;
                }
            }
            try {
                if (!countDownLatch.await(expireSec, TimeUnit.SECONDS)) {
                    msgHandler.addErrorMessage(context, "\u8fde\u63a5" + expireSec + "\u79d2,\u8d85\u65f6:" + (String)fjdbcUrl.get());
                    boolean bl = false;
                    return bl;
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (exceptionCollect.get() != null) {
                throw new JDBCConnectionException((Throwable)exceptionCollect.get());
            }
            boolean bl = true;
            return bl;
        }
        finally {
            try {
                fixedThreadPool.shutdownNow();
            }
            catch (Exception e) {
                logger.warn(e.getMessage(), (Throwable)e);
            }
        }
    }

    private String getHostIpAddress(String ip) {
        return ip;
    }

    public String getDbType() {
        return this.dbType;
    }

    public void setDbType(String dbType) {
        this.dbType = dbType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @JSONField(serialize=false)
    public Map<String, List<String>> getDbEnum() {
        return this.dbEnum;
    }

    public void addDbName(String host, String dbname) {
        List<String> dbNames = this.dbEnum.get(host);
        if (dbNames == null) {
            dbNames = new ArrayList<String>();
            this.dbEnum.put(host, dbNames);
        }
        dbNames.add(dbname);
    }

    public static interface IDbUrlProcess {
        public void visit(String var1, String var2, String var3) throws Exception;
    }

    public static interface IProcess {
        public boolean visit(DBConfig var1, String var2, String var3, String var4) throws Exception;
    }

    public static class DBTable {
        public final String dbNanme;
        public final String jdbcUrl;
        private final ISelectedTab tab;

        public DBTable(String jdbcUrl, String dbNanme, ISelectedTab tab) {
            this.jdbcUrl = jdbcUrl;
            this.dbNanme = dbNanme;
            this.tab = tab;
        }

        public String getTabName() {
            return this.tab.getName();
        }
    }

    public static class HostDBs {
        public final List<HostDB> dbs;
        private final String host;

        public HostDBs(String host) {
            this.host = host;
            this.dbs = Lists.newArrayList();
        }

        public Stream<String> getDbStream() {
            return this.dbs.stream().map(db -> db.dbName);
        }

        public String[] getDataBases() {
            return (String[])this.getDbStream().toArray(String[]::new);
        }

        public String joinDataBases(String delimiter) {
            return this.getDbStream().collect(Collectors.joining(delimiter));
        }

        public void addDB(String jdbcUrl, String dbName) {
            this.dbs.add(new HostDB(jdbcUrl, dbName));
        }

        public Set<String> mapPhysicsTabs(Map<String, List<ISelectedTab>> db2tabs, Function<DBTable, Stream<String>> tabnameCreator) {
            return this.mapPhysicsTabs(db2tabs, tabnameCreator, true);
        }

        public Set<String> mapPhysicsTabs(Map<String, List<ISelectedTab>> db2tabs, Function<DBTable, Stream<String>> tabnameCreator, boolean validateRelevantTabsNull) {
            Set<String> tbs = this.dbs.stream().flatMap(db -> {
                List tabs = (List)db2tabs.get(db.dbName);
                if (tabs == null) {
                    if (validateRelevantTabsNull) {
                        throw new IllegalStateException("dbName:" + db.dbName + " relevant tabs can not be null");
                    }
                    tabs = Collections.emptyList();
                }
                return tabs.stream().flatMap(tab -> (Stream)tabnameCreator.apply(new DBTable(db.jdbcUrl, db.dbName, (ISelectedTab)tab)));
            }).collect(Collectors.toSet());
            return tbs;
        }
    }

    public static class HostDB {
        final String jdbcUrl;
        final String dbName;

        public HostDB(String jdbcUrl, String dbName) {
            this.jdbcUrl = Objects.requireNonNull(jdbcUrl, "jdbcUrl");
            this.dbName = Objects.requireNonNull(dbName, "dbName");
        }

        public String getJdbcUrl() {
            return this.jdbcUrl;
        }
    }
}

