/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.plugin.datax.transformer.impl;

import com.alibaba.citrus.turbine.Context;
import com.qlangtech.tis.extension.Descriptor;
import com.qlangtech.tis.extension.TISExtension;
import com.qlangtech.tis.plugin.annotation.FormField;
import com.qlangtech.tis.plugin.annotation.FormFieldType;
import com.qlangtech.tis.plugin.annotation.Validator;
import com.qlangtech.tis.plugin.datax.transformer.TargetColumn;
import com.qlangtech.tis.plugin.datax.transformer.UDFDesc;
import com.qlangtech.tis.runtime.module.misc.IFieldErrorHandler;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class VirtualTargetColumn
extends TargetColumn {
    @FormField(ordinal=1, identity=true, type=FormFieldType.INPUTTEXT, validate={Validator.require})
    public String name;

    @Override
    public boolean isVirtual() {
        return true;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String identityValue() {
        return this.getName();
    }

    @Override
    public List<UDFDesc> getLiteria() {
        return Collections.singletonList(new UDFDesc("col", this.name));
    }

    @TISExtension
    public static class VirtualTargetColumnDesc
    extends Descriptor<TargetColumn> {
        public boolean validateName(IFieldErrorHandler msgHandler, Context context, String fieldName, String value) {
            if (StringUtils.startsWith((String)value, (String)"$")) {
                value = StringUtils.substring((String)value, (int)1);
            }
            return Validator.db_col_name.getFieldValidator().validate(msgHandler, context, fieldName, value);
        }

        @Override
        public String getDisplayName() {
            return "Virtual Column";
        }
    }
}

