/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.plugin.datax.transformer;

import com.alibaba.datax.core.job.ITransformerBuildInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.qlangtech.tis.TIS;
import com.qlangtech.tis.datax.DataXName;
import com.qlangtech.tis.datax.IDataxProcessor;
import com.qlangtech.tis.datax.IDataxReader;
import com.qlangtech.tis.datax.impl.DataxProcessor;
import com.qlangtech.tis.extension.Describable;
import com.qlangtech.tis.extension.Descriptor;
import com.qlangtech.tis.extension.TISExtension;
import com.qlangtech.tis.plugin.KeyedPluginStore;
import com.qlangtech.tis.plugin.annotation.FormField;
import com.qlangtech.tis.plugin.annotation.FormFieldType;
import com.qlangtech.tis.plugin.datax.transformer.InParamer;
import com.qlangtech.tis.plugin.datax.transformer.OutputParameter;
import com.qlangtech.tis.plugin.datax.transformer.RecordTransformer;
import com.qlangtech.tis.plugin.datax.transformer.UDFDefinition;
import com.qlangtech.tis.plugin.ds.ContextParamConfig;
import com.qlangtech.tis.plugin.ds.DataSourceMeta;
import com.qlangtech.tis.plugin.ds.DataType;
import com.qlangtech.tis.plugin.ds.IColMetaGetter;
import com.qlangtech.tis.plugin.ds.ISelectedTab;
import com.qlangtech.tis.plugin.ds.RunningContext;
import com.qlangtech.tis.util.IPluginContext;
import com.qlangtech.tis.util.TransformerRuleKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class RecordTransformerRules
implements Describable<RecordTransformerRules> {
    @FormField(ordinal=1, type=FormFieldType.MULTI_SELECTABLE, validate={})
    public List<RecordTransformer> rules = Lists.newArrayList();
    public static Function<String, RecordTransformerRules> transformerRulesLoader4Test;

    public static void main(String[] args) {
        HashMap<String, Integer> test = new HashMap<String, Integer>();
        test.put("test1", 1);
        test.put("test2", 2);
        Iterator it = test.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry next = it.next();
            if (!"test1".equals(next.getKey())) continue;
            it.remove();
        }
        System.out.println(String.join((CharSequence)",", test.keySet()));
    }

    public static RecordTransformerRules create(UDFDefinition ... udfs) {
        RecordTransformerRules transformerRules = new RecordTransformerRules();
        ArrayList transformers = Lists.newArrayList();
        RecordTransformer transformer = null;
        for (UDFDefinition udf : udfs) {
            transformer = new RecordTransformer();
            transformer.setUdf(udf);
            transformers.add(transformer);
        }
        transformerRules.rules = transformers;
        return transformerRules;
    }

    public static int cleanPluginStoreCache(IPluginContext context, DataXName appName) {
        if (context == null) {
            return -1;
        }
        int clearCount = 0;
        Iterator<Map.Entry<KeyedPluginStore.Key, KeyedPluginStore>> storeIt = TIS.collectionPluginStore.getEntries().iterator();
        Map.Entry<KeyedPluginStore.Key, KeyedPluginStore> entry = null;
        TransformerRuleKey ruleKey = null;
        while (storeIt.hasNext()) {
            entry = storeIt.next();
            if (!(entry.getKey() instanceof TransformerRuleKey)) continue;
            ruleKey = (TransformerRuleKey)entry.getKey();
            if (!StringUtils.equals((CharSequence)ruleKey.keyVal.getVal(), (CharSequence)appName.getPipelineName()) || ruleKey.resourceType != appName.getType()) continue;
            storeIt.remove();
            ++clearCount;
        }
        return clearCount;
    }

    public List<UDFDefinition> getTransformerUDFs() {
        return this.rules.stream().map(t -> t.getUdf()).collect(Collectors.toList());
    }

    public ITransformerBuildInfo createTransformerBuildInfo(IPluginContext pluginContext, ISelectedTab tab) {
        DataXName dataX = pluginContext.getCollectionName();
        IDataxProcessor dataxProcessor = DataxProcessor.load(pluginContext, dataX);
        IDataxReader dataxReader = dataxProcessor.getReader(pluginContext, tab);
        return this.createTransformerBuildInfo(dataxReader);
    }

    public static Map<String, Map<String, Function<RunningContext, Object>>> contextParamValsGetterMapper(IDataxProcessor processor, IPluginContext pluginContext, IDataxReader dataxReader, List<ISelectedTab> tabs) {
        HashMap contextParamValsGetterMapper = Maps.newHashMap();
        Optional<RecordTransformerRules> transformerRules = null;
        for (ISelectedTab tab : tabs) {
            transformerRules = RecordTransformerRules.loadTransformerRules(pluginContext, processor, tab.getName());
            if (!transformerRules.isPresent()) continue;
            ITransformerBuildInfo transformerBuildInfo = transformerRules.get().createTransformerBuildInfo(Objects.requireNonNull(dataxReader, "dataxReader can not be null"));
            transformerBuildInfo.overwriteColsWithContextParams(tab.getCols());
            if (!transformerBuildInfo.containContextParams()) continue;
            contextParamValsGetterMapper.put(tab.getName(), transformerBuildInfo.contextParamValsGetter());
        }
        return contextParamValsGetterMapper;
    }

    public ITransformerBuildInfo createTransformerBuildInfo(final IDataxReader dataxReader) {
        if (dataxReader == null) {
            throw new IllegalArgumentException("param dataXReader can not be null");
        }
        final RecordTransformerRules transformers = this;
        if (CollectionUtils.isEmpty(transformers.rules)) {
            throw new IllegalStateException("transformer can not be empty");
        }
        return new ITransformerBuildInfo(){
            OverwriteColsWithContextParams overwriteColsWithContextParams;
            TransformerOverwriteCols<OutputParameter> transformerWithoutContextParams;

            public RecordTransformerRules getTransformersRules() {
                return transformers;
            }

            public boolean containContextParams() {
                return this.overwriteColsWithContextParams != null && CollectionUtils.isNotEmpty(this.overwriteColsWithContextParams.getContextParams());
            }

            public Map<String, Object> contextParamVals(RunningContext runningContext) {
                Map valsGetter = this.contextParamValsGetter();
                HashMap contextParamVals = Maps.newHashMap();
                valsGetter.forEach((key, getter) -> contextParamVals.put(key, getter.apply(runningContext)));
                return contextParamVals;
            }

            public <CONTEXT extends RunningContext> Map<String, Function<CONTEXT, Object>> contextParamValsGetter() {
                if (!this.containContextParams()) {
                    throw new IllegalStateException("must containContextParams");
                }
                HashMap contextParamVals = Maps.newHashMap();
                List<ContextParamConfig> contextParms = this.overwriteColsWithContextParams.getContextParams();
                for (ContextParamConfig contextParam : contextParms) {
                    ContextParamConfig.ContextParamValGetter valGetter = contextParam.valGetter();
                    contextParamVals.put(contextParam.getKeyName(), valGetter);
                }
                return contextParamVals;
            }

            public List<IColMetaGetter> originColsWithContextParams() {
                return Objects.requireNonNull(this.transformerWithoutContextParams, "please execute method overwriteColsWithContextParams first").appendSourceContextParams(dataxReader, true).originCols();
            }

            public List<OutputParameter> tranformerColsWithoutContextParams() {
                return Objects.requireNonNull(this.transformerWithoutContextParams, "please execute method overwriteColsWithContextParams first");
            }

            public <T extends IColMetaGetter> List<OutputParameter> overwriteColsWithContextParams(List<T> sourceCols) {
                this.transformerWithoutContextParams = transformers.overwriteCols(sourceCols);
                this.overwriteColsWithContextParams = this.transformerWithoutContextParams.appendSourceContextParams(dataxReader);
                return this.overwriteColsWithContextParams.getCols();
            }
        };
    }

    public static Optional<RecordTransformerRules> loadTransformerRules(IPluginContext pluginCtx, DataXName dataX, String tableName) {
        if (transformerRulesLoader4Test != null) {
            return Optional.ofNullable(transformerRulesLoader4Test.apply(tableName));
        }
        return RecordTransformerRules.loadTransformerRules(pluginCtx, DataxProcessor.load(pluginCtx, dataX), tableName);
    }

    public static Optional<RecordTransformerRules> loadTransformerRules(IPluginContext pluginCtx, IDataxProcessor dataxProcessor, String tableName) {
        if (StringUtils.isEmpty((CharSequence)tableName)) {
            throw new IllegalArgumentException("param tableName can not be empty");
        }
        if (transformerRulesLoader4Test != null) {
            return Optional.ofNullable(transformerRulesLoader4Test.apply(tableName));
        }
        Iterator iterator = ((List)dataxProcessor.getRecordTransformerRulesAndPluginStore(pluginCtx, tableName).getLeft()).iterator();
        if (iterator.hasNext()) {
            RecordTransformerRules trule = (RecordTransformerRules)iterator.next();
            return CollectionUtils.isEmpty(trule.rules) ? Optional.empty() : Optional.of(trule);
        }
        return Optional.empty();
    }

    public final List<String> relevantColKeys() {
        return this.relevantTypedOutterParamStream().map(tcol -> tcol.getName()).collect(Collectors.toList());
    }

    public final List<OutputParameter> relevantTypedOutterColKeys() {
        return this.relevantTypedOutterParamStream().collect(Collectors.toList());
    }

    public final Set<InParamer> relevantInColKeys() {
        return this.rules.stream().flatMap(r -> r.getUdf().inParameters().stream()).collect(Collectors.toSet());
    }

    private Stream<OutputParameter> relevantTypedOutterParamStream() {
        return this.rules.stream().flatMap(r -> r.getUdf().outParameters().stream());
    }

    public static List<RecordTransformer> getRules() {
        return Lists.newArrayList();
    }

    public <T extends IColMetaGetter> TransformerOverwriteCols<OutputParameter> overwriteCols(List<T> sourceCols) {
        TransformerOverwriteCols<OutputParameter> rewriterResult = new TransformerOverwriteCols<OutputParameter>();
        HashMap col2IdxBuilder = Maps.newHashMap();
        int idx = 0;
        for (IColMetaGetter col : sourceCols) {
            rewriterResult.add(OutputParameter.create((String)col.getName(), (boolean)false, (DataType)col.getType()));
            col2IdxBuilder.put(col.getName(), idx++);
        }
        for (OutputParameter colType : this.relevantTypedOutterColKeys()) {
            if (colType.isVirtual()) {
                RecordTransformerRules.getExistColIdx(true, colType, col2IdxBuilder);
                col2IdxBuilder.put(colType.getName(), idx++);
                rewriterResult.add(colType);
                continue;
            }
            Integer existIdx = RecordTransformerRules.getExistColIdx(false, colType, col2IdxBuilder);
            rewriterResult.set((int)existIdx, colType);
        }
        return rewriterResult;
    }

    private static Integer getExistColIdx(boolean mustBeNull, OutputParameter colType, Map<String, Integer> col2IdxBuilder) {
        Integer existIdx = col2IdxBuilder.get(colType.getName());
        if (mustBeNull) {
            if (existIdx != null) {
                throw new IllegalStateException("colName:" + colType.getName() + " relevant table col conf must be null");
            }
        } else if (existIdx == null) {
            throw new IllegalStateException("colName:" + colType.getName() + " relevant table col conf can not be null");
        }
        return existIdx;
    }

    @TISExtension
    public static class DefaultDescriptor
    extends Descriptor<RecordTransformerRules> {
    }

    public class OverwriteColsWithContextParams
    extends TransformerOverwriteCols {
        private final List<ContextParamConfig> contextParams;

        public OverwriteColsWithContextParams(List<IColMetaGetter> cols, List<ContextParamConfig> contextParams) {
            super(cols);
            this.contextParams = contextParams;
        }

        public List<ContextParamConfig> getContextParams() {
            return this.contextParams;
        }
    }

    public class TransformerOverwriteCols<T extends IColMetaGetter>
    extends ArrayList<T> {
        private ConcurrentMap<Integer, T> previous;

        public TransformerOverwriteCols() {
            this(Collections.emptyList());
        }

        public TransformerOverwriteCols(List<T> cols) {
            super(cols);
        }

        public List<T> getCols() {
            return this;
        }

        public List<IColMetaGetter> getColsWithoutVirtualInfo() {
            return this.stream().map(c -> c).collect(Collectors.toList());
        }

        private ConcurrentMap<Integer, T> getPrevious() {
            if (this.previous == null) {
                this.previous = Maps.newConcurrentMap();
            }
            return this.previous;
        }

        public List<IColMetaGetter> originCols() {
            ArrayList originCols = Lists.newArrayList();
            Object metaGetter = null;
            for (int idx = 0; idx < this.size(); ++idx) {
                metaGetter = this.getOrigin(idx);
                if (metaGetter != null) {
                    originCols.add(metaGetter);
                    continue;
                }
                originCols.add((IColMetaGetter)this.get(idx));
            }
            return originCols;
        }

        private T getOrigin(Integer idx) {
            return (T)((IColMetaGetter)this.getPrevious().get(idx));
        }

        @Override
        public T set(int index, T element) {
            IColMetaGetter previous = (IColMetaGetter)super.set(index, element);
            if (previous != null) {
                this.getPrevious().putIfAbsent(index, previous);
            }
            return (T)previous;
        }

        public OverwriteColsWithContextParams appendSourceContextParams(DataSourceMeta dsMeta) {
            return this.appendSourceContextParams(dsMeta, false);
        }

        public OverwriteColsWithContextParams appendSourceContextParams(DataSourceMeta dsMeta, boolean origin) {
            if (dsMeta == null) {
                throw new IllegalArgumentException("param dsMeta can not be null");
            }
            ArrayList rewriterResult = Lists.newArrayList((Iterable)(origin ? this.originCols() : this));
            Map<String, ContextParamConfig> dbContextParams = dsMeta.getDBContextParams();
            ArrayList contextParams = Lists.newArrayList();
            ContextParamConfig contextParam = null;
            for (InParamer inParamer : RecordTransformerRules.this.relevantInColKeys()) {
                if (!inParamer.isContextParams()) continue;
                contextParam = Objects.requireNonNull(dbContextParams.get(inParamer.getKey()), "inParamer:" + inParamer.getKey() + " relevant ContextParam can not be null");
                contextParams.add(contextParam);
                rewriterResult.add(OutputParameter.create((String)inParamer.getKey(), (boolean)false, (DataType)contextParam.getDataType()));
            }
            return new OverwriteColsWithContextParams(rewriterResult, contextParams);
        }
    }
}

