/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.plugin.datax.transformer;

import java.util.Objects;
import org.apache.commons.lang.StringUtils;

public abstract class InParamer {
    private final String paramKey;

    public InParamer(String paramKey) {
        this.paramKey = paramKey;
    }

    public String getKey() {
        return this.paramKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InParamer inParamer = (InParamer)o;
        return Objects.equals(this.paramKey, inParamer.paramKey);
    }

    public int hashCode() {
        return Objects.hashCode(this.paramKey);
    }

    public abstract boolean isContextParams();

    public static InParamer create(String paramKey) {
        if (StringUtils.isEmpty((String)paramKey)) {
            throw new IllegalArgumentException("param param key can not be empty");
        }
        if (StringUtils.startsWith((String)paramKey, (String)"$")) {
            return new ContextBindInParamer(paramKey);
        }
        return new RecordColRelevantInParamer(paramKey);
    }

    public static final class RecordColRelevantInParamer
    extends InParamer {
        public RecordColRelevantInParamer(String paramKey) {
            super(paramKey);
        }

        @Override
        public boolean isContextParams() {
            return false;
        }
    }

    private static final class ContextBindInParamer
    extends InParamer {
        public ContextBindInParamer(String paramKey) {
            super(paramKey);
        }

        @Override
        public boolean isContextParams() {
            return true;
        }
    }
}

