/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.plugin.datax.format.guesstype;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.qlangtech.tis.plugin.datax.format.guesstype.FocusWildcardTabName;
import com.qlangtech.tis.plugin.datax.format.guesstype.KafkaLogicalTableName;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class TargetTabsEntities
implements Serializable {
    private final List<FocusWildcardTabName> focusTabs;
    private final Map<FocusWildcardTabName, KafkaLogicalTableName> logical2PhyicalTabRegister = Maps.newHashMap();

    public TargetTabsEntities(String[] focusTabs) {
        this.focusTabs = Lists.newArrayList((Object[])focusTabs).stream().sorted(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o2.length() - o1.length();
            }
        }).map(FocusWildcardTabName::new).collect(Collectors.toList());
        int reduceSize = Sets.newHashSet(this.focusTabs).size();
        if (reduceSize < this.focusTabs.size()) {
            throw new IllegalStateException("reduced this.focusTabs size:" + reduceSize + " small than focusTabs size:" + this.focusTabs.size());
        }
    }

    public List<FocusWildcardTabName> getLogicalTableEntites() {
        return Collections.unmodifiableList(this.focusTabs);
    }

    public KafkaLogicalTableName parseLogicalTable(String physicalTableName) {
        for (FocusWildcardTabName tabName : this.focusTabs) {
            if (!tabName.isMatch(physicalTableName)) continue;
            KafkaLogicalTableName logicalTableName = this.logical2PhyicalTabRegister.get(tabName);
            if (logicalTableName == null) {
                logicalTableName = new KafkaLogicalTableName(tabName.getLogicalTableName());
                this.logical2PhyicalTabRegister.put(tabName, logicalTableName);
            }
            logicalTableName.addPhysicalTableName(physicalTableName);
            return logicalTableName;
        }
        throw new IllegalStateException("tabName:" + physicalTableName + " relevant kafkaLogicalTableName can not be null,this.focusTabs:" + this.focusTabs.stream().map(String::valueOf).collect(Collectors.joining(",")));
    }
}

