/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.plugin.datax.format.guesstype;

import com.google.common.collect.Maps;
import com.qlangtech.tis.plugin.datax.format.guesstype.KafkaLogicalTableName;
import com.qlangtech.tis.plugin.datax.format.guesstype.TargetTabsEntities;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;

public class PhysicsTable2LogicalTableMapper
implements Serializable {
    private final Map<String, KafkaLogicalTableName> physicsTable2LogicalTable = Maps.newHashMap();
    private final TargetTabsEntities targetTabsEntities;

    public PhysicsTable2LogicalTableMapper(TargetTabsEntities targetTabsEntities) {
        this.targetTabsEntities = Objects.requireNonNull(targetTabsEntities, "targetTabsEntities can not be null");
    }

    public KafkaLogicalTableName parseLogicalTableName(String tabName) {
        if (StringUtils.isEmpty((String)tabName)) {
            throw new IllegalArgumentException("param tableName can not be null");
        }
        KafkaLogicalTableName logicalTabName = this.physicsTable2LogicalTable.get(tabName);
        if (logicalTabName == null) {
            logicalTabName = Objects.requireNonNull(this.targetTabsEntities.parseLogicalTable(tabName), "logicalTabName can not be null");
            this.physicsTable2LogicalTable.put(tabName, logicalTabName);
        }
        return logicalTabName;
    }
}

