/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.plugin.datax.format.guesstype;

import java.io.Serializable;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;

public class FocusWildcardTabName
implements Serializable {
    public static final Pattern wildcardTabNamePattern = Pattern.compile("^([^\\s*]+)(\\*?)$");
    private final String logicalTableName;
    private final boolean wildcard;

    public FocusWildcardTabName(String wildcardTabName) {
        Matcher matcher = wildcardTabNamePattern.matcher(wildcardTabName);
        if (!matcher.matches()) {
            throw new IllegalStateException("illegal wildcardTabName:" + wildcardTabName + " must match pattern:" + wildcardTabNamePattern);
        }
        this.logicalTableName = StringUtils.lowerCase((String)matcher.group(1));
        this.wildcard = StringUtils.isNotEmpty((String)matcher.group(2));
    }

    public String getLogicalTableName() {
        return this.logicalTableName;
    }

    public boolean isMatch(String physicalTabName) {
        return this.wildcard ? FilenameUtils.wildcardMatch((String)StringUtils.lowerCase((String)physicalTabName), (String)(this.logicalTableName + "*")) : this.logicalTableName.equalsIgnoreCase(physicalTabName);
    }

    public String toString() {
        return "logicalTabName='" + this.logicalTableName + "', wildcard=" + this.wildcard;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FocusWildcardTabName that = (FocusWildcardTabName)o;
        return Objects.equals(this.logicalTableName, that.logicalTableName);
    }

    public int hashCode() {
        return Objects.hashCode(this.logicalTableName);
    }

    public static void main(String[] args) {
        FocusWildcardTabName wildcardTabName = new FocusWildcardTabName("test*");
        System.out.println(wildcardTabName.logicalTableName);
        System.out.println(wildcardTabName.wildcard);
    }
}

