/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.plugin.datax.common;

import com.qlangtech.tis.datax.IDataxProcessor;
import com.qlangtech.tis.datax.SourceColMetaGetter;
import com.qlangtech.tis.datax.impl.DataxWriter;
import com.qlangtech.tis.extension.Describable;
import com.qlangtech.tis.extension.Descriptor;
import com.qlangtech.tis.plugin.IEndTypeGetter;
import com.qlangtech.tis.plugin.annotation.FormField;
import com.qlangtech.tis.plugin.annotation.FormFieldType;
import com.qlangtech.tis.plugin.annotation.Validator;
import com.qlangtech.tis.plugin.datax.CreateTableSqlBuilder;
import com.qlangtech.tis.plugin.datax.common.AutoCreateTableColCommentSwitch;
import com.qlangtech.tis.plugin.datax.common.impl.NoneCreateTable;
import com.qlangtech.tis.plugin.datax.transformer.RecordTransformerRules;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public abstract class AutoCreateTable<COL_WRAPPER extends CreateTableSqlBuilder.ColWrapper>
implements Describable<AutoCreateTable<COL_WRAPPER>>,
Serializable {
    @FormField(ordinal=100, advance=true, type=FormFieldType.INPUTTEXT, validate={Validator.identity})
    public String aliasPrefix;

    public String appendTabPrefix(String rawTabName) {
        Optional<String> tabPrefix = this.getMapperTabPrefix();
        return tabPrefix.map(prefix -> prefix + rawTabName).orElse(rawTabName);
    }

    private Optional<String> getMapperTabPrefix() {
        return Optional.ofNullable(this.aliasPrefix);
    }

    public abstract AutoCreateTableColCommentSwitch getAddComment();

    public static List<BasicDescriptor> descFilter(List<BasicDescriptor> descs, String endType) {
        return AutoCreateTable.descFilter(descs, endType, null);
    }

    public static List<BasicDescriptor> descFilter(List<BasicDescriptor> descs, String endType, String compatibleModeEndType) {
        if (CollectionUtils.isEmpty(descs)) {
            return Collections.emptyList();
        }
        IEndTypeGetter.EndType targetEndType = IEndTypeGetter.EndType.parse(endType);
        Optional<IEndTypeGetter.EndType> compatibleModeEndTypeFilter = Optional.ofNullable(compatibleModeEndType).map(e -> IEndTypeGetter.EndType.parse(compatibleModeEndType));
        return descs.stream().filter(desc -> {
            boolean dsEndTypeMatch;
            boolean bl = dsEndTypeMatch = desc.getEndType() == null || targetEndType == desc.getEndType();
            if (dsEndTypeMatch && compatibleModeEndTypeFilter.isPresent()) {
                return desc.getCompatibleModeEndType().map(e -> e == compatibleModeEndTypeFilter.get()).orElse(false);
            }
            return dsEndTypeMatch;
        }).collect(Collectors.toList());
    }

    public static AutoCreateTable dft() {
        return new NoneCreateTable();
    }

    public abstract CreateTableSqlBuilder<COL_WRAPPER> createSQLDDLBuilder(DataxWriter var1, SourceColMetaGetter var2, IDataxProcessor.TableMap var3, Optional<RecordTransformerRules> var4);

    public abstract boolean enabled();

    public boolean enabledColumnComment() {
        return false;
    }

    @Override
    public Descriptor<AutoCreateTable<COL_WRAPPER>> getDescriptor() {
        Descriptor<AutoCreateTable<COL_WRAPPER>> desc = Describable.super.getDescriptor();
        if (!BasicDescriptor.class.isAssignableFrom(desc.getClass())) {
            throw new IllegalStateException("desc class:" + desc.getClass().getName() + " must be child of " + BasicDescriptor.class.getName());
        }
        return desc;
    }

    public static abstract class BasicDescriptor
    extends Descriptor<AutoCreateTable> {
        public abstract IEndTypeGetter.EndType getEndType();

        public Optional<IEndTypeGetter.EndType> getCompatibleModeEndType() {
            return Optional.empty();
        }
    }
}

