/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.plugin.datax;

import com.qlangtech.tis.datax.IDataxReader;
import com.qlangtech.tis.plugin.ds.CMeta;
import com.qlangtech.tis.plugin.ds.ColumnMetaData;
import com.qlangtech.tis.plugin.ds.ContextParamConfig;
import com.qlangtech.tis.sql.parser.tuple.creator.EntityName;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;

public class ThreadCacheTableCols {
    private final Function<EntityName, List<CMeta>> selectedColsSupplier;
    private List<CMeta> selectedCols;
    private final List<ColumnMetaData> selectableCols;
    private IDataxReader plugin;
    private final EntityName targetTable;

    public static ThreadCacheTableCols createEmptyTableCols() {
        List empt = Collections.emptyList();
        return new ThreadCacheTableCols(null, null, target -> Collections.emptyList(), empt){

            @Override
            public List<CMeta> getSelectedCols() {
                return Collections.emptyList();
            }

            @Override
            public Map<String, ContextParamConfig> getDBContextParams() {
                return ContextParamConfig.defaultContextParams();
            }

            @Override
            public Stream<ColumnMetaData> getStreamedSelectableCols(Function<List<ColumnMetaData>, Stream<ColumnMetaData>> selectableColsStreamFunc) {
                return Stream.empty();
            }
        };
    }

    public ThreadCacheTableCols(IDataxReader plugin, EntityName targetTable, Function<EntityName, List<CMeta>> selectedCols, List<ColumnMetaData> selectableCols) {
        this.selectedColsSupplier = selectedCols;
        this.selectableCols = selectableCols;
        this.plugin = plugin;
        this.targetTable = targetTable;
    }

    public Map<String, ContextParamConfig> getDBContextParams() {
        return this.plugin.getDBContextParams();
    }

    public List<CMeta> getSelectedCols() {
        if (this.selectedCols == null) {
            this.selectedCols = this.selectedColsSupplier.apply(Objects.requireNonNull(this.targetTable, "targetTable can not be null"));
        }
        return this.selectedCols;
    }

    public Stream<ColumnMetaData> getStreamedSelectableCols(Function<List<ColumnMetaData>, Stream<ColumnMetaData>> selectableColsStreamFunc) {
        return selectableColsStreamFunc.apply(this.selectableCols);
    }
}

