/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.plugin.datax;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.qlangtech.tis.TIS;
import com.qlangtech.tis.async.message.client.consumer.impl.MQListenerFactory;
import com.qlangtech.tis.datax.DataXName;
import com.qlangtech.tis.datax.StoreResourceType;
import com.qlangtech.tis.datax.impl.DataxReader;
import com.qlangtech.tis.datax.impl.DataxWriter;
import com.qlangtech.tis.extension.Describable;
import com.qlangtech.tis.extension.Descriptor;
import com.qlangtech.tis.extension.PluginFormProperties;
import com.qlangtech.tis.extension.SubFormFilter;
import com.qlangtech.tis.extension.TISExtension;
import com.qlangtech.tis.extension.impl.XmlFile;
import com.qlangtech.tis.plugin.IPluginStore;
import com.qlangtech.tis.plugin.IdentityName;
import com.qlangtech.tis.plugin.KeyedPluginStore;
import com.qlangtech.tis.plugin.PluginStore;
import com.qlangtech.tis.plugin.SetPluginsResult;
import com.qlangtech.tis.plugin.annotation.FormField;
import com.qlangtech.tis.plugin.annotation.FormFieldType;
import com.qlangtech.tis.plugin.annotation.Validator;
import com.qlangtech.tis.plugin.datax.SelectedTab;
import com.qlangtech.tis.plugin.ds.CMeta;
import com.qlangtech.tis.plugin.incr.TISSinkFactory;
import com.qlangtech.tis.util.HeteroEnum;
import com.qlangtech.tis.util.IPluginContext;
import com.qlangtech.tis.util.Memoizer;
import com.qlangtech.tis.util.Selectable;
import com.qlangtech.tis.util.UploadPluginMeta;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public abstract class SelectedTabExtend
implements Describable<SelectedTabExtend>,
IdentityName {
    public static final String HETERO_ENUM_IDENTITY = "incrSourceSelectedExtend";
    @FormField(identity=true, type=FormFieldType.INPUTTEXT, validate={Validator.require})
    public String tabName;
    @TISExtension
    public static final HeteroEnum<SelectedTabExtend> INCR_SELECTED_TAB_EXTEND = SelectedTabExtend.createTabExtendHetero((pluginContext, dataxName) -> SelectedTabExtend.getIncrPluginStore(pluginContext, dataxName));
    @TISExtension
    public static final HeteroEnum<SelectedTabExtend> BATCH_SOURCE_SELECTED_TAB_EXTEND = SelectedTabExtend.createTabExtendHetero((pluginContext, dataxName) -> SelectedTabExtend.getBatchPluginStore(pluginContext, dataxName));
    private static final transient Memoizer<KeyedPluginStore.AppKey, KeyedPluginStore<SelectedTabExtend>> pluginStore = new Memoizer<KeyedPluginStore.AppKey, KeyedPluginStore<SelectedTabExtend>>(){

        @Override
        public KeyedPluginStore<SelectedTabExtend> compute(KeyedPluginStore.AppKey key) {
            return new KeyedPluginStore<SelectedTabExtend>(key, new PluginStore.IPluginProcessCallback[0]);
        }
    };

    public abstract ExtendType getExtendType();

    public static IncrTabExtendSuit getIncrTabExtendSuit(boolean incrExtend, UploadPluginMeta pluginMeta) {
        IPluginContext pluginContext = pluginMeta.getPluginContext();
        if (incrExtend) {
            DataxWriter dataxWriter = null;
            Iterator<DataxWriter> iterator = HeteroEnum.DATAX_WRITER.getPlugins(pluginMeta.getPluginContext(), pluginMeta).iterator();
            if (iterator.hasNext()) {
                DataxWriter w;
                dataxWriter = w = iterator.next();
            }
            if (dataxWriter == null) {
                throw new IllegalStateException("appname:" + pluginContext.getCollectionName() + " relevant dataXWriter can not be null");
            }
        }
        Optional<Descriptor<SelectedTabExtend>> sourceBatchExtendDesc = Optional.empty();
        Optional<Descriptor<SelectedTabExtend>> sourceExtendDesc = Optional.empty();
        Optional<Descriptor<SelectedTabExtend>> sinkExtendDesc = Optional.empty();
        if (incrExtend) {
            DataXName dataX = pluginMeta.getDataXName();
            sourceExtendDesc = MQListenerFactory.getIncrSourceSelectedTabExtendDescriptor(dataX);
            sinkExtendDesc = TISSinkFactory.getIncrSinkSelectedTabExtendDescriptor(dataX.getPipelineName());
            if (!sourceExtendDesc.isPresent() && !sinkExtendDesc.isPresent()) {
                throw new IllegalStateException("neither selectedTableSourceExtendDesc nor selectedTabSinkExtendDesc is present");
            }
        } else {
            sourceBatchExtendDesc = DataxReader.getBatchSourceSelectedTabExtendDescriptor(pluginMeta);
        }
        return new IncrTabExtendSuit(sourceBatchExtendDesc, sourceExtendDesc, sinkExtendDesc);
    }

    public static Map<String, SelectedTab> getTabExtend(IPluginContext pluginContext, String appname, PluginStore.PluginsUpdateListener ... updateListener) {
        UploadPluginMeta extMeta = UploadPluginMeta.appnameMeta(pluginContext, appname);
        return SelectedTabExtend.getTabExtend(extMeta, updateListener);
    }

    public static void clearTabExtend(IPluginContext pluginContext, String appname) {
        UploadPluginMeta extMeta = UploadPluginMeta.appnameMeta(pluginContext, appname);
        SelectedTabExtend.getTabExtendPluginStore(extMeta, new PluginStore.PluginsUpdateListener[0]).forEach(pluginStore -> pluginStore.cleanPlugins());
    }

    private static Stream<PluginStore<SelectedTabExtend>> getTabExtendPluginStore(UploadPluginMeta uploadPluginMeta, PluginStore.PluginsUpdateListener ... updateListener) {
        PluginStore incrExtendStore = (PluginStore)INCR_SELECTED_TAB_EXTEND.getPluginStore(uploadPluginMeta.getPluginContext(), uploadPluginMeta);
        PluginStore batchExtendStore = (PluginStore)BATCH_SOURCE_SELECTED_TAB_EXTEND.getPluginStore(uploadPluginMeta.getPluginContext(), uploadPluginMeta);
        for (PluginStore.PluginsUpdateListener listener : updateListener) {
            incrExtendStore.addPluginsUpdateListener(listener);
        }
        Stream<PluginStore<SelectedTabExtend>> stream = Lists.newArrayList((Object[])new PluginStore[]{incrExtendStore, batchExtendStore}).stream();
        return stream;
    }

    public static Map<String, SelectedTab> getTabExtend(UploadPluginMeta uploadPluginMeta, PluginStore.PluginsUpdateListener ... updateListener) {
        Memoizer<String, SelectedTab> result = new Memoizer<String, SelectedTab>(){

            @Override
            public SelectedTab compute(String key) {
                try {
                    SelectedTab tabExtend = new SelectedTab();
                    tabExtend.name = key;
                    return tabExtend;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
        SelectedTabExtend.getTabExtendPluginStore(uploadPluginMeta, updateListener).flatMap(store -> store.getPlugins().stream()).forEach(ext -> {
            SelectedTab tab = (SelectedTab)result.get(ext.tabName);
            switch (ext.getExtendType()) {
                case INCR_SINK: {
                    tab.setIncrSinkProps((SelectedTabExtend)ext);
                    break;
                }
                case INCR_SOURCE: {
                    tab.setIncrSourceProps((SelectedTabExtend)ext);
                    break;
                }
                case BATCH_SOURCE: {
                    tab.setSourceProps((SelectedTabExtend)ext);
                    break;
                }
                default: {
                    throw new IllegalStateException("illegl extendType:" + ext.getExtendType());
                }
            }
        });
        return result.snapshot();
    }

    public String identityValue() {
        return this.tabName;
    }

    public void setName(String name) {
        this.tabName = name;
    }

    public static IPluginStore wrapSubFormStore(IPluginContext pluginContext, DataXName dataxName, final KeyedPluginStore<SelectedTab> subFormStore) {
        final KeyedPluginStore<SelectedTabExtend> tabExtendStore = SelectedTabExtend.getBatchPluginStore(pluginContext, dataxName);
        return new IPluginStore(){

            @Override
            public XmlFile getTargetFile() {
                return subFormStore.getTargetFile();
            }

            @Override
            public void copyConfigFromRemote() {
                subFormStore.copyConfigFromRemote();
                tabExtendStore.copyConfigFromRemote();
            }

            @Override
            public long getWriteLastModifyTimeStamp() {
                return subFormStore.getWriteLastModifyTimeStamp();
            }

            @Override
            public SetPluginsResult setPlugins(IPluginContext pluginContext, Optional optional, List dlist, boolean update) {
                List plugins = dlist;
                HashMap selectedExtendTabs = Maps.newHashMap();
                HashMap selectedTabs = Maps.newHashMap();
                for (Descriptor.ParseDescribable parseDescribable : plugins) {
                    for (Object p : parseDescribable.getSubFormInstances()) {
                        if (p instanceof SelectedTabExtend) {
                            SelectedTabExtend stExt = (SelectedTabExtend)p;
                            if (stExt.getExtendType() != ExtendType.BATCH_SOURCE) {
                                throw new IllegalStateException("tabExtend type must be :" + ExtendType.BATCH_SOURCE + " but now is:" + stExt.getExtendType());
                            }
                            selectedExtendTabs.put(stExt.tabName, stExt);
                            continue;
                        }
                        SelectedTab tab = (SelectedTab)p;
                        if (CollectionUtils.isNotEmpty(tab.primaryKeys)) {
                            CMeta col;
                            boolean primaryKeyInHeader = false;
                            Iterator<CMeta> iterator = tab.cols.iterator();
                            if (iterator.hasNext() && tab.primaryKeys.contains((col = iterator.next()).getName())) {
                                primaryKeyInHeader = true;
                            }
                            if (!primaryKeyInHeader) {
                                ArrayList reOrderCols = Lists.newArrayList();
                                ArrayList notPksCols = Lists.newArrayList();
                                for (CMeta col2 : tab.cols) {
                                    if (tab.primaryKeys.contains(col2.getName())) {
                                        reOrderCols.add(col2);
                                        continue;
                                    }
                                    notPksCols.add(col2);
                                }
                                reOrderCols.addAll(notPksCols);
                                tab.cols = reOrderCols;
                            }
                        }
                        selectedTabs.put(tab.getName(), tab);
                    }
                }
                if (MapUtils.isNotEmpty((Map)selectedExtendTabs)) {
                    for (Map.Entry entry : selectedExtendTabs.entrySet()) {
                        ((SelectedTab)selectedTabs.get(entry.getKey())).setSourceProps((SelectedTabExtend)entry.getValue());
                    }
                    tabExtendStore.setPlugins(pluginContext, optional, Collections.singletonList(new Descriptor.ParseDescribable(Lists.newArrayList(selectedExtendTabs.values()))), update);
                }
                if (MapUtils.isEmpty((Map)selectedTabs)) {
                    throw new IllegalStateException("selectedTabs can not be empty");
                }
                return subFormStore.setPlugins(pluginContext, optional, Collections.singletonList(new Descriptor.ParseDescribable(Lists.newArrayList(selectedTabs.values()))), update);
            }

            public Describable getPlugin() {
                return subFormStore.getPlugin();
            }

            public List getPlugins() {
                return subFormStore.getPlugins();
            }

            @Override
            public void cleanPlugins() {
                subFormStore.cleanPlugins();
                tabExtendStore.cleanPlugins();
            }

            public List<Descriptor> allDescriptor() {
                return subFormStore.allDescriptor().stream().map(desc -> desc).collect(Collectors.toList());
            }

            public Describable find(String name, boolean throwNotFoundErr) {
                return subFormStore.find(name, throwNotFoundErr);
            }
        };
    }

    private static HeteroEnum<SelectedTabExtend> createTabExtendHetero(final BiFunction<IPluginContext, DataXName, IPluginStore> storeCreator) {
        return new HeteroEnum<SelectedTabExtend>(SelectedTabExtend.class, HETERO_ENUM_IDENTITY, "Incr Source Selected Extend", Selectable.Multi, true){

            @Override
            public IPluginStore getPluginStore(IPluginContext pluginContext, UploadPluginMeta pluginMeta) {
                DataXName dataxName = pluginMeta.getDataXName();
                return (IPluginStore)storeCreator.apply(pluginContext, dataxName);
            }
        };
    }

    public static KeyedPluginStore<SelectedTabExtend> getIncrPluginStore(IPluginContext pluginContext, DataXName appname) {
        SelectedTabExtend.validateNotDataBaseType(appname);
        KeyedPluginStore.PluginClassCategory<SelectedTabExtend> pluginCategory = new KeyedPluginStore.PluginClassCategory<SelectedTabExtend>(SelectedTabExtend.class, "_incr");
        KeyedPluginStore.AppKey<SelectedTabExtend> key = new KeyedPluginStore.AppKey<SelectedTabExtend>(pluginContext, StoreResourceType.parse((boolean)false), appname.getPipelineName(), pluginCategory);
        return pluginStore.get(key);
    }

    public static KeyedPluginStore<SelectedTabExtend> getBatchPluginStore(IPluginContext pluginContext, DataXName appname) {
        SelectedTabExtend.validateNotDataBaseType(appname);
        KeyedPluginStore.AppKey<SelectedTabExtend> key = new KeyedPluginStore.AppKey<SelectedTabExtend>(pluginContext, StoreResourceType.parse((boolean)false), appname.getPipelineName(), new KeyedPluginStore.PluginClassCategory<SelectedTabExtend>(SelectedTabExtend.class, "_batch"));
        return pluginStore.get(key);
    }

    private static void validateNotDataBaseType(DataXName appname) {
        if (appname.getType() == StoreResourceType.DataBase) {
            throw new IllegalArgumentException("resType:" + appname.getType() + " can not be " + StoreResourceType.DataBase);
        }
    }

    @Override
    public Descriptor<SelectedTabExtend> getDescriptor() {
        Descriptor desc = TIS.get().getDescriptor(this.getClass());
        if (!BaseDescriptor.class.isAssignableFrom(desc.getClass())) {
            throw new IllegalStateException("desc class:" + desc.getClass() + " must be extend from " + BaseDescriptor.class.getName());
        }
        return desc;
    }

    protected static abstract class BaseDescriptor
    extends Descriptor<SelectedTabExtend> {
        protected BaseDescriptor() {
        }

        @Override
        public PluginFormProperties getPluginFormPropertyTypes(Optional<SubFormFilter> subFormFilter) {
            return super.getPluginFormPropertyTypes(Optional.empty());
        }
    }

    public static class IncrTabExtendSuit {
        final Optional<Descriptor<SelectedTabExtend>> sourceIncrExtendDesc;
        final Optional<Descriptor<SelectedTabExtend>> sinkExtendDesc;
        final Optional<Descriptor<SelectedTabExtend>> sourceBatchExtendDesc;

        public IncrTabExtendSuit(Optional<Descriptor<SelectedTabExtend>> sourceBatchExtendDesc, Optional<Descriptor<SelectedTabExtend>> sourceExtendDesc, Optional<Descriptor<SelectedTabExtend>> sinkExtendDesc) {
            if (sourceExtendDesc == null) {
                throw new IllegalArgumentException("param sourceExtendDesc can not be null");
            }
            if (sinkExtendDesc == null) {
                throw new IllegalArgumentException("param sinkExtendDesc can not be null");
            }
            this.sourceIncrExtendDesc = sourceExtendDesc;
            this.sinkExtendDesc = sinkExtendDesc;
            this.sourceBatchExtendDesc = Objects.requireNonNull(sourceBatchExtendDesc, "sourceBatchExtendDesc can not be null");
        }

        public List<Descriptor> getDescriptors() {
            List<Descriptor> descs = Lists.newArrayList((Object[])new Optional[]{this.sourceBatchExtendDesc, this.sourceIncrExtendDesc, this.sinkExtendDesc}).stream().filter(optDesc -> optDesc.isPresent()).map(optDesc -> (Descriptor)optDesc.get()).collect(Collectors.toList());
            return descs;
        }

        public List<Descriptor> getDescriptorsWithAppendDesc(Descriptor desc) {
            List<Descriptor> descs = this.getDescriptors();
            descs.add(desc);
            return descs;
        }
    }

    public static enum ExtendType {
        INCR_SOURCE,
        INCR_SINK,
        BATCH_SOURCE;

    }
}

