/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.plugin.datax;

import com.alibaba.citrus.turbine.Context;
import com.alibaba.datax.core.job.ITransformerBuildInfo;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.qlangtech.tis.datax.DataXName;
import com.qlangtech.tis.datax.IDataxReader;
import com.qlangtech.tis.datax.impl.DataxProcessor;
import com.qlangtech.tis.datax.impl.DataxReader;
import com.qlangtech.tis.extension.Describable;
import com.qlangtech.tis.extension.Descriptor;
import com.qlangtech.tis.extension.PluginFormProperties;
import com.qlangtech.tis.extension.SubFormFilter;
import com.qlangtech.tis.extension.TISExtension;
import com.qlangtech.tis.extension.impl.BaseSubFormProperties;
import com.qlangtech.tis.extension.impl.PropertyType;
import com.qlangtech.tis.extension.impl.SuFormProperties;
import com.qlangtech.tis.extension.impl.XmlFile;
import com.qlangtech.tis.manage.common.Option;
import com.qlangtech.tis.plugin.IPluginStore;
import com.qlangtech.tis.plugin.IPluginStoreSave;
import com.qlangtech.tis.plugin.IdentityName;
import com.qlangtech.tis.plugin.annotation.FormField;
import com.qlangtech.tis.plugin.annotation.FormFieldType;
import com.qlangtech.tis.plugin.annotation.SubForm;
import com.qlangtech.tis.plugin.annotation.Validator;
import com.qlangtech.tis.plugin.datax.SelectedTabExtend;
import com.qlangtech.tis.plugin.datax.ThreadCacheTableCols;
import com.qlangtech.tis.plugin.datax.transformer.RecordTransformerRules;
import com.qlangtech.tis.plugin.ds.CMeta;
import com.qlangtech.tis.plugin.ds.ColumnMetaData;
import com.qlangtech.tis.plugin.ds.IColMetaGetter;
import com.qlangtech.tis.plugin.ds.ISelectedTab;
import com.qlangtech.tis.runtime.module.misc.IControlMsgHandler;
import com.qlangtech.tis.runtime.module.misc.IFieldErrorHandler;
import com.qlangtech.tis.runtime.module.misc.IMessageHandler;
import com.qlangtech.tis.util.IPluginContext;
import com.qlangtech.tis.util.impl.AttrVals;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectedTab
implements Describable<SelectedTab>,
ISelectedTab,
IdentityName,
IPluginStore.AfterPluginVerified {
    public static final String KEY_TABLE_COLS = "tableRelevantCols";
    public static final String KEY_SOURCE_PROPS = "sourceProps";
    public static final String KEY_FIELD_COLS = "cols";
    public static final String KEY_FIELD_PRIMARY_KEYS = "primaryKeys";
    private static final Logger logger = LoggerFactory.getLogger(SelectedTab.class);
    private transient SelectedTabExtend incrSourceProps;
    private transient SelectedTabExtend incrSinkProps;
    public transient SelectedTabExtend sourceProps;
    @FormField(identity=true, ordinal=0, type=FormFieldType.INPUTTEXT, validate={Validator.require})
    public String name;
    @FormField(ordinal=3, type=FormFieldType.ENUM, validate={Validator.require})
    public List<String> primaryKeys;
    @FormField(ordinal=100, type=FormFieldType.INPUTTEXT)
    public String where;
    @FormField(ordinal=200, type=FormFieldType.MULTI_SELECTABLE, validate={Validator.require})
    public List<CMeta> cols = Lists.newArrayList();

    public List<IColMetaGetter> overwriteCols(IMessageHandler pluginCtx, boolean includeContextParams) {
        IPluginContext context = (IPluginContext)pluginCtx;
        DataXName dataX = context.getCollectionName();
        Optional<RecordTransformerRules> transformerRules = RecordTransformerRules.loadTransformerRules(context, DataxProcessor.load(context, dataX), this.getName());
        List<IColMetaGetter> cols = null;
        if (transformerRules.isPresent()) {
            ITransformerBuildInfo transformerBuilder = transformerRules.get().createTransformerBuildInfo((IPluginContext)pluginCtx, this);
            List overwriteColsWithContextParams = transformerBuilder.overwriteColsWithContextParams(this.getCols());
            List outParams = includeContextParams ? overwriteColsWithContextParams : transformerBuilder.tranformerColsWithoutContextParams();
            return outParams.stream().map(param -> param).collect(Collectors.toList());
        }
        cols = this.getCols().stream().collect(Collectors.toList());
        return cols;
    }

    public List<String> getPrimaryKeys() {
        return this.primaryKeys;
    }

    public List<String> getColKeys() {
        return this.getCols().stream().map(c -> c.getName()).collect(Collectors.toUnmodifiableList());
    }

    public final List<CMeta> getCols() {
        ArrayList result = Lists.newArrayList();
        for (CMeta cmeta : this.cols) {
            if (cmeta instanceof CMeta.INestCMetaGetter) {
                for (CMeta meta : ((CMeta.INestCMetaGetter)cmeta).nestCols()) {
                    if (meta.isDisable()) continue;
                    result.add(meta);
                }
            }
            if (cmeta.isDisable()) continue;
            result.add(cmeta);
        }
        return result;
    }

    public static List<CMeta> getColsCandidate() {
        List<CMeta> selectableCols = SelectedTab.getContextTableCols(cols -> cols.stream());
        return selectableCols;
    }

    public static List<CMeta> getSelectedCols() {
        return SelectedTab.getContextTableColsStream().getSelectedCols();
    }

    public SelectedTab(String name) {
        this.name = name;
    }

    public String identityValue() {
        return this.name;
    }

    public <T extends SelectedTabExtend> T getIncrSinkProps() {
        return (T)this.incrSinkProps;
    }

    public void setIncrSinkProps(SelectedTabExtend incrSinkProps) {
        this.incrSinkProps = incrSinkProps;
    }

    public SelectedTabExtend getSourceProps() {
        return this.sourceProps;
    }

    public void setSourceProps(SelectedTabExtend sourceProps) {
        this.sourceProps = sourceProps;
    }

    public <T extends SelectedTabExtend> T getIncrSourceProps() {
        return (T)this.incrSourceProps;
    }

    public <T extends SelectedTabExtend> List<T> getIncrExtProp() {
        ArrayList result = Lists.newArrayList();
        if (this.getIncrSourceProps() != null) {
            result.add(this.getIncrSourceProps());
        }
        if (this.getIncrSinkProps() != null) {
            result.add(this.getIncrSinkProps());
        }
        return result;
    }

    public void setIncrSourceProps(SelectedTabExtend incrProps) {
        this.incrSourceProps = incrProps;
    }

    public static List<String> getDftPks() {
        return SelectedTab.getContextTableCols(cols -> cols.stream().filter(col -> col.isPk())).stream().map(col -> col.getName()).collect(Collectors.toList());
    }

    public SelectedTab() {
    }

    public static String getDftTabName() {
        DataxReader dataXReader = DataxReader.getThreadBingDataXReader();
        if (dataXReader == null) {
            return "";
        }
        try {
            List selectedTabs = dataXReader.getSelectedTabs();
            if (CollectionUtils.isEmpty(selectedTabs)) {
                return "";
            }
            Iterator iterator = selectedTabs.iterator();
            if (iterator.hasNext()) {
                ISelectedTab tab = (ISelectedTab)iterator.next();
                return tab.getName();
            }
        }
        catch (Throwable e) {
            logger.warn(dataXReader.getDescriptor().getDisplayName() + e.getMessage());
        }
        return "";
    }

    public String getWhere() {
        return this.where;
    }

    public void setWhere(String where) {
        this.where = where;
    }

    public String getName() {
        return this.name;
    }

    public boolean isAllCols() {
        return this.cols.isEmpty();
    }

    public boolean containCol(String col) {
        if (CollectionUtils.isEmpty(this.cols)) {
            return false;
        }
        for (CMeta c : this.cols) {
            if (!StringUtils.equals((String)c.getName(), (String)col)) continue;
            return true;
        }
        return false;
    }

    public void setCols(List<String> cols) {
        throw new UnsupportedOperationException();
    }

    public static List<Option> getContextOpts(Function<List<ColumnMetaData>, Stream<ColumnMetaData>> func) {
        return SelectedTab.getContextTableColsStream().getStreamedSelectableCols(func).collect(Collectors.toList());
    }

    public static List<CMeta> getContextTableCols(Function<List<ColumnMetaData>, Stream<ColumnMetaData>> func) {
        return SelectedTab.getContextTableColsStream().getStreamedSelectableCols(func).map(ColumnMetaData::convert).collect(Collectors.toList());
    }

    public static ThreadCacheTableCols getContextTableColsStream() {
        SuFormProperties.SuFormGetterContext context = SuFormProperties.subFormGetterProcessThreadLocal.get();
        if (context == null || context.plugin == null) {
            return ThreadCacheTableCols.createEmptyTableCols();
        }
        IDataxReader plugin = Objects.requireNonNull(context.plugin, "context.plugin can not be null");
        return plugin.getContextTableColsStream(context);
    }

    public static SelectedTab loadFromTmp(IPluginStore store, String tabName) {
        try {
            XmlFile xml = SelectedTab.getTmpTableStoreFile(Objects.requireNonNull(store, "param store can not be null"), tabName);
            SelectedTab tab = new SelectedTab();
            xml.unmarshal(tab);
            return tab;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void afterVerified(IPluginStoreSave pluginStore) {
        try {
            XmlFile xml = SelectedTab.getTmpTableStoreFile(pluginStore, this.identityValue());
            SelectedTab tab = new SelectedTab();
            tab.name = this.name;
            tab.cols = this.cols;
            xml.write(tab, Collections.emptySet());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static XmlFile getTmpTableStoreFile(IPluginStoreSave pluginStore, String tabName) {
        String pluginFileName = Descriptor.getPluginFileName(tabName);
        File tabTmp = new File(pluginStore.getTargetFileParentDir(), ".tmp" + File.separator + "tabs" + File.separator + pluginFileName);
        XmlFile xml = new XmlFile(tabTmp, pluginFileName);
        return xml;
    }

    @TISExtension
    public static class DefaultDescriptor
    extends Descriptor<SelectedTab>
    implements SubForm.ISubFormItemValidate,
    FormFieldType.IMultiSelectValidator {
        @Override
        protected final boolean verify(IControlMsgHandler msgHandler, Context context, Descriptor.PostFormVals postFormVals) {
            return this.validateAll(msgHandler, context, postFormVals);
        }

        @Override
        public boolean validate(IFieldErrorHandler msgHandler, Optional<SubFormFilter> subFormFilter, Context context, String fieldName, List<FormFieldType.SelectedItem> items) {
            if (SelectedTab.KEY_FIELD_COLS.equals(fieldName)) {
                int selectCount = 0;
                for (FormFieldType.SelectedItem item : items) {
                    if (!item.isChecked()) continue;
                    ++selectCount;
                }
                if (selectCount < 1) {
                    msgHandler.addFieldError(context, fieldName, "\u8bf7\u9009\u62e9\u9700\u8981\u7684\u5217", new Object[0]);
                    return false;
                }
            }
            return true;
        }

        @Override
        protected final boolean validateAll(IControlMsgHandler msgHandler, Context context, Descriptor.PostFormVals postFormVals) {
            return this.validateAll(msgHandler, context, (SelectedTab)postFormVals.newInstance());
        }

        @Override
        public boolean validateSubFormItems(IControlMsgHandler msgHandler, Context context, BaseSubFormProperties props, SubFormFilter filter, AttrVals formData) {
            formData.vistAttrValMap((tab, item) -> {
                if (item instanceof JSONObject) {
                    msgHandler.addErrorMessage(context, "\u8bf7\u4e3a\u8868\u2018" + tab + "\u2019\u8bbe\u7f6e\u5fc5\u8981\u5c5e\u6027");
                }
            });
            if (context.hasErrors()) {
                return false;
            }
            Integer maxReaderTabCount = Integer.MAX_VALUE;
            try {
                maxReaderTabCount = Integer.parseInt(filter.uploadPluginMeta.getExtraParam("maxReaderTableCount"));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (formData.size() > maxReaderTabCount) {
                msgHandler.addErrorMessage(context, "\u5bfc\u5165\u8868\u4e0d\u80fd\u8d85\u8fc7" + maxReaderTabCount + "\u5f20");
                return false;
            }
            return true;
        }

        @Override
        public PluginFormProperties getPluginFormPropertyTypes(Optional<SubFormFilter> subFormFilter) {
            return super.getPluginFormPropertyTypes(subFormFilter);
        }

        @Override
        public final boolean validateSubForm(IControlMsgHandler msgHandler, Context context, SelectedTab tab) {
            return this.validateAll(msgHandler, context, tab);
        }

        protected boolean validateAll(IControlMsgHandler msgHandler, Context context, SelectedTab tab) {
            Descriptor tabDesc = tab.getDescriptor();
            tabDesc.getExtractProps();
            ArrayList lackPks = Lists.newArrayList();
            List<String> colKeys = tab.getColKeys();
            for (String pk : tab.primaryKeys) {
                if (colKeys.contains(pk)) continue;
                lackPks.add(pk);
            }
            if (lackPks.size() > 0) {
                PropertyType colProp = (PropertyType)tab.getDescriptor().getPropertyType(SelectedTab.KEY_FIELD_COLS);
                ArrayList fieldNames = Lists.newArrayList();
                colProp.multiSelectablePropProcess(viewType -> {
                    switch (viewType.viewType) {
                        case IdList: {
                            fieldNames.add(SelectedTab.KEY_FIELD_COLS);
                            break;
                        }
                        case TupleList: {
                            List<CMeta> tabCols = tab.cols;
                            AtomicInteger index = new AtomicInteger();
                            Map<String, Integer> colsIndex = tabCols.stream().collect(Collectors.toMap(c -> c.getName(), c -> index.getAndIncrement()));
                            for (String lackKey : lackPks) {
                                fieldNames.add(IFieldErrorHandler.joinField((String)SelectedTab.KEY_FIELD_COLS, (Object[])new Object[]{Collections.singletonList(colsIndex.get(lackKey)), "name"}));
                            }
                            break;
                        }
                        default: {
                            throw new IllegalStateException("unhandle view type:" + viewType);
                        }
                    }
                    return null;
                });
                for (String fieldName : fieldNames) {
                    msgHandler.addFieldError(context, fieldName, "\u7531\u4e8e" + String.join((CharSequence)",", lackPks) + "\u9009\u4e3a\u4e3b\u952e,\u56e0\u6b64\u9700\u8981\u5c06\u5b83\uff08\u4eec\uff09\u9009\u4e0a", new Object[0]);
                }
                return false;
            }
            return true;
        }
    }
}

