/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.plugin.datax;

import com.qlangtech.tis.manage.common.Option;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public interface IWriteModeSupport {
    public WriteMode getWriteMode();

    public static List<Option> supportModes() {
        return Arrays.stream(WriteMode.values()).filter(mode -> mode != WriteMode.Update).map(mode -> new Option(mode.name(), (Object)mode.token)).collect(Collectors.toList());
    }

    public static enum WriteMode {
        Insert("insert"),
        Replace("replace"),
        Update("update");

        private final String token;

        public static WriteMode parse(String token) {
            for (WriteMode mode : WriteMode.values()) {
                if (!mode.token.equals(token)) continue;
                return mode;
            }
            throw new IllegalStateException("token:" + token + " is illegal");
        }

        private WriteMode(String token) {
            this.token = token;
        }
    }
}

