/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.plugin.datax;

import com.qlangtech.tis.datax.IDataxProcessor;
import com.qlangtech.tis.plugin.datax.AbstractCreateTableSqlBuilder;
import com.qlangtech.tis.plugin.datax.transformer.RecordTransformerRules;
import com.qlangtech.tis.plugin.ds.DataSourceMeta;
import com.qlangtech.tis.plugin.ds.DataType;
import com.qlangtech.tis.plugin.ds.IColMetaGetter;
import com.qlangtech.tis.sql.parser.visitor.BlockScriptBuffer;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;

public abstract class CreateTableSqlBuilder<T extends ColWrapper>
extends AbstractCreateTableSqlBuilder<T> {
    public BlockScriptBuffer script = new BlockScriptBuffer();

    public CreateTableSqlBuilder(IDataxProcessor.TableMap tableMapper, DataSourceMeta dsMeta, Optional<RecordTransformerRules> transformers) {
        super(tableMapper, dsMeta, transformers);
    }

    protected void appendExtraColDef(List<String> pks) {
    }

    protected void appendTabMeta(List<String> pks) {
        this.script.append((Object)";");
    }

    @Override
    public AbstractCreateTableSqlBuilder.CreateDDL build() {
        CreateTableName tabNameBuilder = this.getCreateTableName();
        this.script.append((Object)tabNameBuilder.createTablePredicate()).append((Object)" ").append((Object)tabNameBuilder.getEntityName()).append((Object)"\n");
        this.script.append((Object)"(\n");
        int colSize = this.getCols().size();
        int colIndex = 0;
        for (ColWrapper col : this.preProcessCols(this.pks, this.getCols())) {
            this.script.append((Object)"    ");
            this.appendColName(col.getName());
            this.script.append((Object)col.getMapperType());
            col.appendExtraConstraint(this.script);
            if (++colIndex < colSize) {
                this.script.append((Object)",");
            }
            this.script.append((Object)"\n");
        }
        this.appendExtraColDef(this.pks);
        this.script.append((Object)")\n");
        this.appendTabMeta(this.pks);
        return new AbstractCreateTableSqlBuilder.CreateDDL(this.script.getContent(), this);
    }

    public void appendColName(String col) {
        this.script.append((Object)String.format("%-" + this.maxColNameLength + "s", this.dsMeta.getEscapedEntity(col)));
    }

    protected List<T> preProcessCols(List<String> pks, List<T> cols) {
        return cols;
    }

    public static class CreateTableName {
        private final String schema;
        private final String tabName;
        final AbstractCreateTableSqlBuilder sqlBuilder;
        private String createTablePredicate = "CREATE TABLE";

        public CreateTableName(String tabName, AbstractCreateTableSqlBuilder sqlBuilder) {
            this("", tabName, sqlBuilder);
        }

        public CreateTableName(String schema, String tabName, AbstractCreateTableSqlBuilder sqlBuilder) {
            if (StringUtils.isEmpty((String)tabName)) {
                throw new IllegalArgumentException("param tabName can not be empty");
            }
            this.schema = schema;
            this.tabName = tabName;
            this.sqlBuilder = sqlBuilder;
        }

        public String createTablePredicate() {
            return this.createTablePredicate;
        }

        public void setCreateTablePredicate(String createTablePredicate) {
            this.createTablePredicate = createTablePredicate;
        }

        public final String getEntityName() {
            StringBuffer entityName = new StringBuffer();
            if (StringUtils.isNotEmpty((String)this.schema)) {
                entityName.append(this.sqlBuilder.wrapWithEscape(this.schema)).append(".");
            }
            entityName.append(this.sqlBuilder.wrapWithEscape(this.tabName));
            return entityName.toString();
        }
    }

    public static abstract class ColWrapper
    implements IColMetaGetter {
        private final IColMetaGetter meta;
        private final List<String> pks;

        public ColWrapper(IColMetaGetter meta, List<String> pks) {
            this.meta = meta;
            this.pks = Objects.requireNonNull(pks, "param pks can not be null");
        }

        public boolean isPk() {
            return this.pks.contains(this.meta.getName());
        }

        public DataType getType() {
            return this.meta.getType();
        }

        public abstract String getMapperType();

        protected void appendExtraConstraint(BlockScriptBuffer ddlScript) {
        }

        public String getName() {
            return this.meta.getName();
        }
    }
}

