/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.plugin.datax;

import com.qlangtech.tis.datax.IDataxProcessor;
import com.qlangtech.tis.plugin.datax.CreateTableSqlBuilder;
import com.qlangtech.tis.plugin.datax.transformer.RecordTransformerRules;
import com.qlangtech.tis.plugin.ds.DataSourceMeta;
import com.qlangtech.tis.plugin.ds.IColMetaGetter;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractCreateTableSqlBuilder<T extends CreateTableSqlBuilder.ColWrapper> {
    static final Pattern PatternCreateTable = Pattern.compile("([cC][rR][eE][aA][tT][eE]\\s+[tT][aA][bB][lL][eE])\\s+?(\\S+)\\s*\\(");
    protected final String targetTableName;
    protected final List<T> cols;
    protected final List<String> pks;
    public int maxColNameLength;
    protected final DataSourceMeta dsMeta;
    private final Optional<RecordTransformerRules> transformers;

    public AbstractCreateTableSqlBuilder(IDataxProcessor.TableMap tableMapper, DataSourceMeta dsMeta, Optional<RecordTransformerRules> transformers) {
        this.targetTableName = this.createTargetTableName(tableMapper);
        this.transformers = Objects.requireNonNull(transformers, "param transformers can not be null");
        this.pks = tableMapper.getSourceTab().getPrimaryKeys();
        List<Object> sourceCols = tableMapper.getSourceCols().stream().map(c -> c).collect(Collectors.toList());
        if (transformers.isPresent()) {
            RecordTransformerRules transformerRules = transformers.get();
            sourceCols = transformerRules.overwriteCols(sourceCols).getColsWithoutVirtualInfo();
        }
        this.cols = Collections.unmodifiableList(sourceCols.stream().map(c -> this.createColWrapper((IColMetaGetter)c)).collect(Collectors.toList()));
        this.maxColNameLength = 0;
        for (CreateTableSqlBuilder.ColWrapper col : this.getCols()) {
            int m = StringUtils.length((String)col.getName());
            if (m <= this.maxColNameLength) continue;
            this.maxColNameLength = m;
        }
        this.maxColNameLength += 4;
        this.dsMeta = dsMeta;
    }

    protected String createTargetTableName(IDataxProcessor.TableMap tableMapper) {
        return tableMapper.getTo();
    }

    protected abstract T createColWrapper(IColMetaGetter var1);

    public abstract CreateDDL build();

    public CreateTableSqlBuilder.CreateTableName getCreateTableName() {
        return new CreateTableSqlBuilder.CreateTableName(this.targetTableName, this);
    }

    public final String wrapWithEscape(String val) {
        return this.dsMeta.getEscapedEntity(val);
    }

    public List<T> getCols() {
        return this.cols;
    }

    public static class CreateDDL {
        private final StringBuffer script;
        private final AbstractCreateTableSqlBuilder builder;

        public CreateDDL(StringBuffer script, AbstractCreateTableSqlBuilder builder) {
            this.script = script;
            this.builder = builder;
        }

        public static String replaceDDLTableName(String createTableDDL, String newTabName) {
            Matcher matcher = PatternCreateTable.matcher(createTableDDL);
            if (matcher.find()) {
                return matcher.replaceFirst("$1 " + newTabName + " (");
            }
            throw new IllegalStateException("createTableDDL is illegal:" + createTableDDL);
        }

        public StringBuffer getDDLScript() {
            return this.script;
        }

        public String toString() {
            return this.getDDLScript().toString();
        }

        public String getSelectAllScript() {
            List cols = this.builder.getCols();
            return "SELECT " + cols.stream().map(c -> this.builder.wrapWithEscape(c.getName())).collect(Collectors.joining(",")) + " FROM " + this.builder.getCreateTableName().getEntityName();
        }

        public String getCountSelectScript(Optional<String> whereCriteria) {
            return "SELECT count(1) FROM " + this.builder.getCreateTableName().getEntityName() + whereCriteria.map(where -> " WHERE " + where).orElse("");
        }
    }
}

