/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.plugin.credentials;

import com.alibaba.citrus.turbine.Context;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.qlangtech.tis.TIS;
import com.qlangtech.tis.config.ParamsConfig;
import com.qlangtech.tis.extension.Descriptor;
import com.qlangtech.tis.extension.DescriptorExtensionList;
import com.qlangtech.tis.extension.impl.XmlFile;
import com.qlangtech.tis.extension.util.PluginExtraProps;
import com.qlangtech.tis.manage.common.ILoginUser;
import com.qlangtech.tis.plugin.IPluginStore;
import com.qlangtech.tis.plugin.IRepositoryResource;
import com.qlangtech.tis.plugin.SetPluginsResult;
import com.qlangtech.tis.util.IPluginContext;
import com.qlangtech.tis.util.UploadPluginMeta;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class ParamsConfigPluginStore
implements IPluginStore<ParamsConfig> {
    private final File paramsCfgDir;
    private final String childContextDir;
    private final UploadPluginMeta pluginMeta;

    public static UploadPluginMeta createParamsConfigUserIsolation(String paramPluginCategory) {
        return ParamsConfigPluginStore.createParamsConfig(paramPluginCategory);
    }

    public static UploadPluginMeta createParamsConfig(PluginExtraProps.CandidatePlugin candidatePlugin) {
        return ParamsConfigPluginStore.createParamsConfig(candidatePlugin.getTargetItemDesc());
    }

    public static UploadPluginMeta createParamsConfig(String paramPluginCategory) {
        UploadPluginMeta pluginMeta = UploadPluginMeta.parse("params-cfg:require,targetItemDesc_" + paramPluginCategory);
        return pluginMeta;
    }

    public ParamsConfigPluginStore(UploadPluginMeta pluginMeta) {
        this(pluginMeta, Optional.empty());
    }

    public ParamsConfigPluginStore(UploadPluginMeta pluginMeta, Optional<ILoginUser> loginUser) {
        if (pluginMeta == null) {
            throw new IllegalArgumentException("param pluginMeta can not be null");
        }
        this.pluginMeta = pluginMeta;
        try {
            this.childContextDir = "params-cfg" + loginUser.map(user -> "-user-isolation" + File.separator + user.getName()).orElse("");
            this.paramsCfgDir = new File(TIS.pluginCfgRoot, this.childContextDir);
            FileUtils.forceMkdir((File)this.paramsCfgDir);
        }
        catch (IOException e) {
            throw new RuntimeException("can not create dir:params-cfg", e);
        }
    }

    @Override
    public List<IRepositoryResource> getAll() {
        DescriptorExtensionList descs = TIS.get().getDescriptorList(ParamsConfig.class);
        return descs.stream().map(desc -> ParamsConfig.getTargetPluginStore("params-cfg", desc.getDisplayName(), Optional.empty(), false)).filter(rr -> rr != null && rr.getTargetFile().exists()).collect(Collectors.toList());
    }

    @Override
    public List<ParamsConfig> getPlugins() {
        ArrayList plugins = Lists.newArrayList();
        UploadPluginMeta.TargetDesc targetDesc = this.pluginMeta.getTargetDesc();
        if (StringUtils.isEmpty((CharSequence)targetDesc.matchTargetPluginDescName)) {
            this.visitAllPluginStore(store -> {
                List<ParamsConfig> childs = ((IPluginStore)store.getRight()).getPlugins();
                this.add2Childs(childs, plugins);
                return null;
            });
        } else {
            IPluginStore<ParamsConfig> pluginStore = ParamsConfig.getChildPluginStore(this.childContextDir, targetDesc.pluginStoreGroupPath(this.pluginMeta));
            List<ParamsConfig> childs = pluginStore.getPlugins();
            this.add2Childs(childs, plugins);
        }
        return plugins;
    }

    private void add2Childs(List<ParamsConfig> childs, List<ParamsConfig> plugins) {
        childs.forEach(c -> {
            if (c.test(this.pluginMeta)) {
                plugins.add((ParamsConfig)c);
            }
        });
    }

    private <TT> TT visitAllPluginStore(Function<Pair<String, IPluginStore<ParamsConfig>>, TT> func) {
        String[] childFiles = this.paramsCfgDir.list();
        TT result = null;
        for (String childFile : childFiles) {
            IPluginStore<ParamsConfig> pluginStore = ParamsConfig.getChildPluginStore(this.childContextDir, childFile);
            result = func.apply((Pair<String, IPluginStore<ParamsConfig>>)Pair.of((Object)childFile, pluginStore));
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public ParamsConfig getPlugin() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void cleanPlugins() {
        this.visitAllPluginStore(ps -> {
            ((IPluginStore)ps.getRight()).cleanPlugins();
            return null;
        });
    }

    @Override
    public List<Descriptor<ParamsConfig>> allDescriptor() {
        IPluginStore childPluginStore = ParamsConfig.getTargetPluginStore(this.childContextDir, this.pluginMeta.getTargetDesc());
        List descriptors = childPluginStore.allDescriptor();
        ArrayList descs = Lists.newArrayList();
        for (Descriptor desc : descriptors) {
            if (!StringUtils.equals((CharSequence)((ParamsConfig.BasicParamsConfigDescriptor)desc).paramsConfigType(), (CharSequence)this.pluginMeta.getTargetDesc().matchTargetPluginDescName)) continue;
            descs.add(desc);
        }
        return descs;
    }

    @Override
    public ParamsConfig find(String name, boolean throwNotFoundErr) {
        ParamsConfig cfg = this.visitAllPluginStore(ps -> (ParamsConfig)((IPluginStore)ps.getRight()).find(name, throwNotFoundErr));
        return cfg;
    }

    @Override
    public SetPluginsResult setPlugins(IPluginContext pluginContext, Optional<Context> context, List<Descriptor.ParseDescribable<ParamsConfig>> dlist, boolean update) {
        HashMap desc2Plugin = Maps.newHashMap();
        String storeGroup = null;
        ParamsConfig paramCfg = null;
        List plugins = null;
        boolean cfgChanged = false;
        for (Descriptor.ParseDescribable<ParamsConfig> parseDescribable : dlist) {
            paramCfg = (ParamsConfig)parseDescribable.getInstance();
            storeGroup = paramCfg.getStoreGroup();
            plugins = (List)desc2Plugin.get(storeGroup);
            if (plugins == null) {
                plugins = Lists.newArrayList();
                desc2Plugin.put(storeGroup, plugins);
            }
            plugins.add(parseDescribable);
        }
        for (Map.Entry entry : desc2Plugin.entrySet()) {
            IPluginStore<ParamsConfig> childPluginStore = ParamsConfig.getChildPluginStore(this.childContextDir, (String)entry.getKey());
            if (!childPluginStore.setPlugins((IPluginContext)pluginContext, context, (List<Descriptor.ParseDescribable<ParamsConfig>>)((List)entry.getValue()), (boolean)true).cfgChanged) continue;
            cfgChanged = true;
        }
        return new SetPluginsResult(true, cfgChanged);
    }

    @Override
    public void copyConfigFromRemote() {
        IPluginStore childPluginStore = ParamsConfig.getTargetPluginStore(this.pluginMeta.getTargetDesc());
        childPluginStore.copyConfigFromRemote();
    }

    @Override
    public XmlFile getTargetFile() {
        IPluginStore childPluginStore = ParamsConfig.getTargetPluginStore(this.pluginMeta.getTargetDesc());
        return childPluginStore.getTargetFile();
    }

    @Override
    public long getWriteLastModifyTimeStamp() {
        IPluginStore childPluginStore = ParamsConfig.getTargetPluginStore(this.pluginMeta.getTargetDesc());
        return childPluginStore.getWriteLastModifyTimeStamp();
    }
}

