/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.plugin.annotation;

import com.alibaba.citrus.turbine.Context;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.qlangtech.tis.plugin.ValidatorCommons;
import com.qlangtech.tis.plugin.annotation.IFieldValidator;
import com.qlangtech.tis.runtime.module.misc.IControlMsgHandler;
import com.qlangtech.tis.runtime.module.misc.IFieldErrorHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public enum Validator {
    require((msgHandler, context, fieldKey, fieldData) -> {
        if (StringUtils.isBlank((String)fieldData)) {
            msgHandler.addFieldError(context, fieldKey, "\u5fc5\u987b\u586b\u5199", new Object[0]);
            return false;
        }
        return true;
    }),
    user_name((msgHandler, context, fieldKey, fieldData) -> Validator.validatePattern(msgHandler, context, Validator.rule(ValidatorCommons.pattern_user_name, "\u5fc5\u987b\u7531\u5c0f\u5199\u5b57\u6bcd\uff0c\u5927\u5199\u5b57\u6bcd\uff0c\u6570\u5b57\u3001\u4e0b\u5212\u7ebf\u3001\u70b9\u3001\u51cf\u53f7\u7ec4\u6210"), fieldKey, fieldData)),
    email((msgHandler, context, fieldKey, fieldData) -> Validator.validatePattern(msgHandler, context, Validator.rule(ValidatorCommons.EMAIL_PATTERN, ValidatorCommons.MSG_EMAIL_ERROR), fieldKey, fieldData)),
    mobile((msgHandler, context, fieldKey, fieldData) -> Validator.validatePattern(msgHandler, context, Validator.rule(ValidatorCommons.MOBILE_PATTERN, ValidatorCommons.MSG_MOBILE_ERROR), fieldKey, fieldData)),
    forbid_start_with_number((msgHandler, context, fieldKey, fieldData) -> Validator.validatePattern(msgHandler, context, Validator.rule(ValidatorCommons.PATTERN_FORBID_START_WITH_NUMBER, "\u4e0d\u80fd\u4ee5\u6570\u5b57\u5f00\u5934"), fieldKey, fieldData)),
    identity((msgHandler, context, fieldKey, fieldData) -> {
        boolean valid = Validator.validatePattern(msgHandler, context, Validator.rule(ValidatorCommons.pattern_identity, "\u5fc5\u987b\u7531\u5c0f\u5199\u5b57\u6bcd\uff0c\u5927\u5199\u5b57\u6bcd\uff0c\u6570\u5b57\u3001\u4e0b\u5212\u7ebf\u3001\u51cf\u53f7\u7ec4\u6210"), fieldKey, fieldData);
        if (valid) {
            return forbid_start_with_number.validate(msgHandler, context, fieldKey, fieldData);
        }
        return false;
    }),
    integer((msgHandler, context, fieldKey, fieldData) -> Validator.validatePattern(msgHandler, context, Validator.rule(ValidatorCommons.pattern_integer, "\u5fc5\u987b\u662f\u6574\u578b\u6570\u5b57"), fieldKey, fieldData)),
    host((msgHandler, context, fieldKey, fieldData) -> Validator.validatePattern(msgHandler, context, Validator.rule(ValidatorCommons.host_pattern, "\u5fc5\u987b\u7531IP\u3001HOST\u53ca\u7aef\u53e3\u53f7\u7ec4\u6210"), fieldKey, fieldData)),
    hostWithoutPort((msgHandler, context, fieldKey, fieldData) -> Validator.validatePattern(msgHandler, context, Validator.rule(ValidatorCommons.host_without_port_pattern, "\u5fc5\u987b\u7531IP\u6216\u8005HOST\u7ec4\u6210"), fieldKey, fieldData)),
    url((msgHandler, context, fieldKey, fieldData) -> Validator.validatePattern(msgHandler, context, Validator.rule(ValidatorCommons.PATTERN_URL, "\u4e0d\u7b26\u5408URL\u7684\u89c4\u8303"), fieldKey, fieldData)),
    db_col_name((msgHandler, context, fieldKey, fieldData) -> Validator.validatePattern(msgHandler, context, Validator.rule(ValidatorCommons.PATTERN_DB_COL_NAME, "\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u63d0\u793a:'\u9996\u4f4d\u53ef\u4ee5\u662f\u5b57\u6bcd\u6216\u4e0b\u5212\u7ebf\u3002\u9996\u4f4d\u4e4b\u540e\u53ef\u4ee5\u662f\u5b57\u6bcd\uff0c\u6570\u5b57\u4ee5\u53ca\u4e0b\u5212\u7ebf\u3002\u4e0b\u5212\u7ebf\u540e\u4e0d\u80fd\u63a5\u4e0b\u5212\u7ebf'"), fieldKey, fieldData)),
    relative_path((msgHandler, context, fieldKey, fieldData) -> Validator.validatePattern(msgHandler, context, Validator.rule(ValidatorCommons.PATTERN_RELATIVE_PATH, "\u4e0d\u7b26\u5408\u76f8\u5bf9\u8def\u5f84\u683c\u5f0f\u8981\u6c42"), fieldKey, fieldData)),
    absolute_path((msgHandler, context, fieldKey, fieldData) -> Validator.validatePattern(msgHandler, context, Validator.rule(ValidatorCommons.PATTERN_ABSOLUTE_PATH, "\u4e0d\u7b26\u5408\u7edd\u5bf9\u8def\u5f84\u683c\u5f0f\u8981\u6c42"), fieldKey, fieldData)),
    none_blank((msgHandler, context, fieldKey, fieldData) -> Validator.validatePattern(msgHandler, context, Validator.rule(ValidatorCommons.PATTERN_NONE_BLANK, "\u5185\u5bb9\u4e0d\u80fd\u5305\u542b\u7a7a\u683c"), fieldKey, fieldData));

    private final IFieldValidator fieldValidator;
    public static final String FORM_ERROR_SUMMARY = "\u63d0\u4ea4\u8868\u5355\u5185\u5bb9\u6709\u9519\u8bef";

    public static void main(String[] args) {
        int index = 1;
        for (Validator value : Validator.values()) {
            System.out.println(index++ + ". " + value);
        }
    }

    public static Validator parse(String token) {
        return Objects.requireNonNull(Validator.valueOf(token));
    }

    public static ValidateRule rule(Pattern p, String errMsg) {
        return new ValidateRule(p, errMsg);
    }

    public static boolean validatePattern(IFieldErrorHandler msgHandler, Context context, ValidateRule validateRule, String fieldKey, String fieldData) {
        if (StringUtils.isEmpty((String)fieldData)) {
            return true;
        }
        Matcher matcher = validateRule.pattern.matcher(fieldData);
        if (!matcher.matches()) {
            msgHandler.addFieldError(context, fieldKey, validateRule.errorMsg, new Object[0]);
            return false;
        }
        return true;
    }

    public IFieldValidator getFieldValidator() {
        return this.fieldValidator;
    }

    public boolean validate(IFieldErrorHandler msgHandler, Context context, String fieldKey, String fieldData) {
        return this.fieldValidator.validate(msgHandler, context, fieldKey, fieldData);
    }

    private static FieldValidatorResult validate(IControlMsgHandler handler, Context context, String fieldKey, FieldValidators fvalidator) {
        FieldValidatorResult fieldData = new FieldValidatorResult(handler.getString(fieldKey));
        for (IFieldValidator v : fvalidator.validators) {
            if (v.validate((IFieldErrorHandler)handler, context, fieldKey, fieldData.fieldData)) continue;
            return fieldData.faild();
        }
        fvalidator.setFieldVal(fieldData.fieldData);
        return fieldData.success();
    }

    public static Map<String, FieldValidators> fieldsValidator(Object ... p) {
        if (p.length < 1 || !(p[0] instanceof String)) {
            throw new IllegalArgumentException();
        }
        HashMap result = Maps.newHashMap();
        Validator.addValidateRule(result, p);
        return result;
    }

    public static void addValidateRule(Map<String, FieldValidators> result, Object[] p) {
        if (p == null || p.length < 1) {
            return;
        }
        String fieldName = null;
        ArrayList rules = null;
        for (int i = 0; i < p.length; ++i) {
            if (p[i] instanceof String) {
                if (fieldName != null) {
                    Validator.processPreFieldValidateRule(result, fieldName, rules);
                }
                fieldName = (String)p[i];
                rules = Lists.newArrayList();
                continue;
            }
            if (p[i].getClass().isArray()) {
                Object[] rparams = (Object[])p[i];
                if (rparams.length > 0) {
                    Validator.addValidateRule(result, rparams);
                }
                if (i + 1 >= p.length || p[i + 1] instanceof String) continue;
                throw new IllegalStateException("index:" + (i + 1) + ",element:" + p[i + 1] + " must be type of 'String'");
            }
            rules.add(p[i]);
        }
        Validator.processPreFieldValidateRule(result, fieldName, rules);
    }

    private static void processPreFieldValidateRule(Map<String, FieldValidators> result, String fieldName, List<Object> rules) {
        if (StringUtils.isEmpty((String)fieldName)) {
            throw new IllegalArgumentException("param fieldName can not be null");
        }
        if (CollectionUtils.isEmpty(rules)) {
            throw new IllegalArgumentException("param rules can not be empty");
        }
        List validatContainer = rules.stream().filter(r -> r instanceof FieldValidators).map(r -> (FieldValidators)r).collect(Collectors.toList());
        FieldValidators validator = null;
        int validatContainerSize = validatContainer.size();
        if (validatContainerSize == 1) {
            validator = (FieldValidators)validatContainer.stream().findFirst().get();
        } else if (validatContainerSize < 1) {
            validator = new FieldValidators(new Validator[0]){};
        } else {
            throw new IllegalStateException("field:" + fieldName + " relevant rules must contain one 'FieldValidators' but now the size is " + validatContainer.size());
        }
        List fieldValidators = rules.stream().filter(r -> {
            boolean isFieldValidator = false;
            isFieldValidator = r instanceof IFieldValidator;
            if (!isFieldValidator && !(r instanceof FieldValidators)) {
                throw new IllegalStateException("rule type:" + r.getClass() + " is not valid");
            }
            return isFieldValidator;
        }).map(r -> (IFieldValidator)r).collect(Collectors.toList());
        validator.validators.addAll(fieldValidators);
        result.put(fieldName, validator);
    }

    public static boolean validate(IControlMsgHandler handler, Context context, Map<String, FieldValidators> fieldsValidator) {
        boolean faild;
        handler.errorsPageShow(context);
        Object fieldKey = null;
        Object fvalidator = null;
        Object vresult = null;
        boolean bl = faild = Validator.validateAllFieldRules(handler, true, context, fieldsValidator) || Validator.validateAllFieldRules(handler, false, context, fieldsValidator);
        if (faild) {
            handler.addErrorMessage(context, FORM_ERROR_SUMMARY);
        }
        return !faild;
    }

    private static boolean validateAllFieldRules(IControlMsgHandler handler, boolean validateEmptyDependency, Context context, Map<String, FieldValidators> fieldsValidator) {
        boolean faild = false;
        for (Map.Entry entry : fieldsValidator.entrySet().stream().filter(e -> validateEmptyDependency == ((FieldValidators)e.getValue()).dependencyRules.isEmpty()).collect(Collectors.toList())) {
            String fieldKey = (String)entry.getKey();
            FieldValidators fvalidator = (FieldValidators)entry.getValue();
            FieldValidatorResult vresult = Validator.validate(handler, context, fieldKey, fvalidator);
            if (vresult.valid) continue;
            faild = true;
        }
        return faild;
    }

    private Validator(IFieldValidator fv) {
        this.fieldValidator = fv;
    }

    public static class FieldValidatorResult {
        public boolean valid;
        public final String fieldData;

        public FieldValidatorResult(String fieldData) {
            this.fieldData = fieldData;
        }

        public FieldValidatorResult faild() {
            this.valid = false;
            return this;
        }

        public FieldValidatorResult success() {
            this.valid = true;
            return this;
        }
    }

    public static abstract class FieldValidators {
        final List<IFieldValidator> validators = Lists.newArrayList();
        private final List<String> dependencyRules = Lists.newArrayList();

        public FieldValidators addDependency(String rule) {
            this.dependencyRules.add(rule);
            return this;
        }

        public FieldValidators(Validator ... validators) {
            for (Validator validator : validators) {
                this.validators.add(validator.fieldValidator);
            }
        }

        public void setFieldVal(String val) {
        }
    }

    private static class ValidateRule {
        private final Pattern pattern;
        private final String errorMsg;

        public ValidateRule(Pattern pattern, String errorMsg) {
            this.pattern = pattern;
            this.errorMsg = errorMsg;
        }
    }
}

