/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.plugin.annotation;

import com.qlangtech.tis.plugin.IRepositoryTargetFile;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;

public interface ITmpFileStore {
    public void setTmpeFile(TmpFile var1);

    public TmpFile getTmpeFile();

    public String getStoreFileName();

    default public TmpFile createTmpFile(IRepositoryTargetFile xmlFile, boolean saveable) {
        return new TmpFile(new File(xmlFile.getTargetFile().getFile().getParentFile(), this.getStoreFileName()), saveable);
    }

    public static class TmpFile {
        public final File tmp;
        private final boolean saveable;

        public TmpFile(File tmp) {
            this(tmp, true);
        }

        public TmpFile(File tmp, boolean saveable) {
            this.tmp = tmp;
            this.saveable = saveable;
        }

        public TmpFile saveToDir(File dir, String fileName) {
            if (!this.saveable) {
                return this;
            }
            if (StringUtils.isEmpty((String)fileName)) {
                throw new IllegalArgumentException("param fileName can not be empty");
            }
            File target = new File(dir, fileName);
            if (!this.tmp.exists()) {
                throw new IllegalStateException("tmp file is not exist,path:" + this.tmp.getAbsolutePath());
            }
            try {
                FileUtils.copyFile((File)this.tmp, (File)target);
                FileUtils.deleteQuietly((File)this.tmp);
            }
            catch (IOException e) {
                throw new RuntimeException(target.getAbsolutePath(), e);
            }
            return new TmpFile(target, false);
        }
    }
}

