/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.plugin.annotation;

import com.alibaba.citrus.turbine.Context;
import com.alibaba.fastjson.JSONObject;
import com.qlangtech.tis.datax.TimeFormat;
import com.qlangtech.tis.extension.SubFormFilter;
import com.qlangtech.tis.extension.impl.PropertyType;
import com.qlangtech.tis.manage.common.Option;
import com.qlangtech.tis.plugin.MemorySize;
import com.qlangtech.tis.plugin.annotation.ITmpFileStore;
import com.qlangtech.tis.plugin.ds.IMultiElement;
import com.qlangtech.tis.runtime.module.misc.IFieldErrorHandler;
import java.io.File;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.commons.lang.StringUtils;

public enum FormFieldType {
    MULTI_SELECTABLE(8),
    INPUTTEXT(1),
    SELECTABLE(6),
    PASSWORD(7),
    FILE(9, new IPropValProcessor(){

        @Override
        public Object processInput(Object instance, PropertyType.PropVal pval) throws Exception {
            String val = (String)pval.convertedVal();
            if (!(instance instanceof ITmpFileStore)) {
                throw new IllegalStateException("instance of " + instance.getClass() + " must be type of " + ITmpFileStore.class.getName());
            }
            String[] filePath = StringUtils.split((String)val, (String)";");
            if (filePath.length == 2) {
                File tmpPath = new File(filePath[0]);
                if (!tmpPath.exists()) {
                    throw new IllegalStateException("tmp path:" + tmpPath.getAbsolutePath() + " is not exist");
                }
                ((ITmpFileStore)instance).setTmpeFile(new ITmpFileStore.TmpFile(tmpPath));
                return filePath[1];
            }
            if (filePath.length == 1) {
                String fileName = filePath[0];
                return fileName;
            }
            throw new IllegalArgumentException("filePath.length must be 2: " + val);
        }
    }),
    TEXTAREA(2),
    DATE(3),
    JDBCColumn(11, new IPropValProcessor(){

        @Override
        public Object processInput(Object instance, PropertyType.PropVal val) throws Exception {
            return null;
        }

        @Override
        public Object serialize2Output(PropertyType pt, Object val) throws Exception {
            return null;
        }
    }),
    INT_NUMBER(4),
    ENUM(5, new IPropValProcessor(){

        @Override
        public Object processInput(Object instance, PropertyType.PropVal val) throws Exception {
            return IPropValProcessor.super.processInput(instance, val);
        }
    }),
    DateTime(10, new IPropValProcessor(){
        final DateTimeFormatter isoFormat = DateTimeFormatter.ISO_DATE_TIME;

        @Override
        public Object processInput(Object instance, PropertyType.PropVal val) throws Exception {
            LocalDateTime dateTime = LocalDateTime.parse((String)val.rawVal(), this.isoFormat);
            Instant ist = dateTime.atZone(ZoneOffset.UTC).toInstant();
            Class targetClazz = val.getTargetClazz();
            if (targetClazz == Long.class) {
                return ist.toEpochMilli();
            }
            if (targetClazz == Date.class) {
                return Date.from(ist);
            }
            throw new IllegalStateException("invalid target class:" + targetClazz);
        }

        @Override
        public Object serialize2Output(PropertyType pt, Object val) throws Exception {
            Class targetClazz = pt.fieldClazz;
            Instant ist = null;
            if (targetClazz == Long.class) {
                ist = Instant.ofEpochMilli((Long)val);
            } else if (targetClazz == Date.class) {
                ist = ((Date)val).toInstant();
            } else {
                throw new IllegalStateException("invalid target class:" + targetClazz);
            }
            return LocalDateTime.ofInstant(ist, TimeFormat.sysZoneId).format(this.isoFormat);
        }
    }),
    DECIMAL_NUMBER(4),
    DURATION_OF_SECOND(12, new DurationValProcessor(){

        @Override
        protected Duration deserialize(long val) {
            return Duration.ofSeconds(val);
        }

        @Override
        protected long serialize(Duration val) {
            return val.toSeconds();
        }
    }, fieldProps -> fieldProps.put("unit", (Object)"Second")),
    DURATION_OF_MINUTE(12, new DurationValProcessor(){

        @Override
        protected Duration deserialize(long val) {
            return Duration.ofMinutes(val);
        }

        @Override
        protected long serialize(Duration val) {
            return val.toMinutes();
        }
    }, fieldProps -> fieldProps.put("unit", (Object)"Minute")),
    DURATION_OF_HOUR(12, new DurationValProcessor(){

        @Override
        protected Duration deserialize(long val) {
            return Duration.ofHours(val);
        }

        @Override
        protected long serialize(Duration val) {
            return val.toHours();
        }
    }, fieldProps -> fieldProps.put("unit", (Object)"Hour")),
    MEMORY_SIZE_OF_BYTE(12, new MemorySizeValProcessor(){

        @Override
        protected MemorySize deserialize(long val) {
            return MemorySize.ofBytes(val);
        }

        @Override
        protected long serialize(MemorySize val) {
            return val.getBytes();
        }
    }, new MemoryAppendExternalProps(MemorySize.MemoryUnit.BYTES)),
    MEMORY_SIZE_OF_KIBI(12, new MemorySizeValProcessor(){

        @Override
        protected MemorySize deserialize(long val) {
            return MemorySize.ofKibiBytes(val);
        }

        @Override
        protected long serialize(MemorySize val) {
            return val.getKibiBytes();
        }
    }, new MemoryAppendExternalProps(MemorySize.MemoryUnit.KILO_BYTES)),
    MEMORY_SIZE_OF_MEGA(12, new MemorySizeValProcessor(){

        @Override
        protected MemorySize deserialize(long val) {
            return MemorySize.ofMebiBytes(val);
        }

        @Override
        protected long serialize(MemorySize val) {
            return val.getMebiBytes();
        }
    }, new MemoryAppendExternalProps(MemorySize.MemoryUnit.MEGA_BYTES));

    private final int identity;
    public final IPropValProcessor valProcessor;
    public final Consumer<JSONObject> appendExternalProps;

    public static void main(String[] args) throws Exception {
        int index = 1;
        for (FormFieldType type : FormFieldType.values()) {
            System.out.println(index++ + ". " + String.valueOf((Object)type));
        }
    }

    private FormFieldType(int val) {
        this(val, new IPropValProcessor(){}, fieldProps -> {});
    }

    private FormFieldType(int val, IPropValProcessor valProcessor) {
        this(val, valProcessor, fieldProps -> {});
    }

    private FormFieldType(int val, IPropValProcessor valProcessor, Consumer<JSONObject> appendExternalProps) {
        this.identity = val;
        this.valProcessor = valProcessor;
        this.appendExternalProps = appendExternalProps;
    }

    public int getIdentity() {
        return this.identity;
    }

    public static interface IPropValProcessor {
        default public Object processInput(Object instance, PropertyType.PropVal val) throws Exception {
            return val.convertedVal();
        }

        default public Object serialize2Output(PropertyType pt, Object val) throws Exception {
            return val;
        }
    }

    public static class SelectedItem
    extends Option {
        private boolean checked;
        private IMultiElement cmeta;

        public SelectedItem(String name, String value, boolean checked) {
            super(name, (Object)value);
            this.checked = checked;
        }

        public SelectedItem(IMultiElement cmeta) {
            this(cmeta.getName(), cmeta.getName(), true);
            this.cmeta = cmeta;
        }

        public IMultiElement getCmeta() {
            return this.cmeta;
        }

        public boolean isChecked() {
            return this.checked;
        }
    }

    public static interface IMultiSelectValidator {
        default public boolean validate(IFieldErrorHandler msgHandler, Optional<SubFormFilter> subFormFilter, Context context, String fieldName, List<SelectedItem> items) {
            int selectCount = 0;
            for (SelectedItem item : items) {
                if (!item.isChecked()) continue;
                ++selectCount;
            }
            if (selectCount < 1) {
                msgHandler.addFieldError(context, fieldName, "\u81f3\u5c11\u9009\u62e9\u4e00\u9879", new Object[0]);
                return false;
            }
            return true;
        }
    }

    private static abstract class DurationValProcessor
    implements IPropValProcessor {
        private DurationValProcessor() {
        }

        @Override
        public final Object processInput(Object instance, PropertyType.PropVal val) throws Exception {
            if (Duration.class != val.getTargetClazz()) {
                throw new IllegalStateException("field class must be type:" + Duration.class + " but now is " + val.getTargetClazz().getSimpleName());
            }
            Number rawVal = (Number)val.rawVal();
            return this.deserialize(rawVal.longValue());
        }

        protected abstract Duration deserialize(long var1);

        protected abstract long serialize(Duration var1);

        @Override
        public final Object serialize2Output(PropertyType pt, Object val) throws Exception {
            Class targetClazz = pt.fieldClazz;
            if (Duration.class != targetClazz) {
                throw new IllegalStateException("field class must be type:" + Duration.class + " but now is " + targetClazz.getSimpleName());
            }
            return this.serialize((Duration)val);
        }
    }

    private static abstract class MemorySizeValProcessor
    implements IPropValProcessor {
        private MemorySizeValProcessor() {
        }

        @Override
        public final Object processInput(Object instance, PropertyType.PropVal val) throws Exception {
            if (MemorySize.class != val.getTargetClazz()) {
                throw new IllegalStateException("field class must be type:" + Duration.class + " but now is " + val.getTargetClazz().getSimpleName());
            }
            Number rawVal = (Number)val.rawVal();
            return this.deserialize(rawVal.longValue());
        }

        @Override
        public final Object serialize2Output(PropertyType pt, Object val) throws Exception {
            Class targetClazz = pt.fieldClazz;
            if (MemorySize.class != targetClazz) {
                throw new IllegalStateException("field class must be type:" + Duration.class + " but now is " + targetClazz.getSimpleName());
            }
            return this.serialize((MemorySize)val);
        }

        protected abstract MemorySize deserialize(long var1);

        protected abstract long serialize(MemorySize var1);
    }

    private static class MemoryAppendExternalProps
    implements Consumer<JSONObject> {
        private final MemorySize.MemoryUnit memoryUnit;

        public MemoryAppendExternalProps(MemorySize.MemoryUnit memoryUnit) {
            this.memoryUnit = Objects.requireNonNull(memoryUnit, "memoryUnit can not be null");
        }

        @Override
        public void accept(JSONObject fieldProps) {
            fieldProps.put("unit", (Object)StringUtils.upperCase((String)this.memoryUnit.getUnits()[1]));
        }
    }
}

