/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.plugin.alert.impl;

import com.google.common.collect.Lists;
import com.qlangtech.tis.extension.TISExtension;
import com.qlangtech.tis.extension.impl.IOUtils;
import com.qlangtech.tis.manage.common.ConfigFileContext;
import com.qlangtech.tis.manage.common.HttpUtils;
import com.qlangtech.tis.plugin.IEndTypeGetter;
import com.qlangtech.tis.plugin.alert.AlertChannel;
import com.qlangtech.tis.plugin.alert.AlertTemplate;
import com.qlangtech.tis.plugin.annotation.FormField;
import com.qlangtech.tis.plugin.annotation.FormFieldType;
import com.qlangtech.tis.plugin.annotation.Validator;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpCallbackAlertChannel
extends AlertChannel {
    private static final Logger logger = LoggerFactory.getLogger(HttpCallbackAlertChannel.class);
    @FormField(ordinal=1, type=FormFieldType.INPUTTEXT, validate={Validator.require})
    public String callbackUrl;
    @FormField(ordinal=2, type=FormFieldType.TEXTAREA, validate={})
    public String headers;
    @FormField(ordinal=3, type=FormFieldType.ENUM, validate={})
    public Boolean sendAsJson = true;

    @Override
    public void send(AlertTemplate alertTemplate) {
        if (alertTemplate == null) {
            throw new IllegalArgumentException("alertTemplate can not be null");
        }
        try {
            ArrayList postParams = Lists.newArrayList();
            if (this.sendAsJson != null && this.sendAsJson.booleanValue()) {
                alertTemplate.visitAllProp((key, val) -> postParams.add(new HttpUtils.PostParam(key, val)));
            } else {
                String renderedContent = this.renderTemplate(alertTemplate);
                postParams.add(new HttpUtils.PostParam("content", (Object)renderedContent));
                postParams.add(new HttpUtils.PostParam("jobName", (Object)alertTemplate.getJobName()));
                postParams.add(new HttpUtils.PostParam("status", (Object)alertTemplate.getStatus()));
            }
            ArrayList headers = Lists.newArrayList();
            if (StringUtils.isNotEmpty((String)this.headers)) {
                String[] headerPairs;
                for (String headerPair : headerPairs = this.headers.split("\n")) {
                    String[] kv = headerPair.trim().split(":", 2);
                    if (kv.length != 2) continue;
                    headers.add(new ConfigFileContext.Header(kv[0].trim(), kv[1].trim()));
                }
            }
            this.sendHttpRequest(this.callbackUrl, postParams, headers);
            logger.info("HTTP callback alert sent successfully via channel [{}] to [{}]", (Object)this.name, (Object)this.callbackUrl);
        }
        catch (Exception e) {
            logger.error("Failed to send HTTP callback alert via channel [{}]", (Object)this.name, (Object)e);
            throw new RuntimeException("Failed to send HTTP callback alert: " + e.getMessage(), e);
        }
    }

    public static String loadDefaultTpl() {
        return IOUtils.loadResourceFromClasspath(HttpCallbackAlertChannel.class, (String)"httpcallback-alert-template.vm");
    }

    @TISExtension
    public static class DefaultDescriptor
    extends AlertChannel.AlertChannelDescDesc<HttpCallbackAlertChannel> {
        @Override
        public IEndTypeGetter.EndType getEndType() {
            return IEndTypeGetter.EndType.Http;
        }

        @Override
        protected String verifySuccessMessage(HttpCallbackAlertChannel alertChannel) {
            return "\u5df2\u7ecf\u6210\u529f\u8c03\u7528 Http URL\uff1a" + alertChannel.callbackUrl;
        }
    }
}

