/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.plugin.alert.impl;

import com.alibaba.citrus.turbine.Context;
import com.google.common.collect.Lists;
import com.qlangtech.tis.extension.TISExtension;
import com.qlangtech.tis.extension.impl.IOUtils;
import com.qlangtech.tis.manage.common.TisUTF8;
import com.qlangtech.tis.plugin.IEndTypeGetter;
import com.qlangtech.tis.plugin.alert.AlertChannel;
import com.qlangtech.tis.plugin.alert.AlertTemplate;
import com.qlangtech.tis.plugin.annotation.FormField;
import com.qlangtech.tis.plugin.annotation.FormFieldType;
import com.qlangtech.tis.plugin.annotation.Validator;
import com.qlangtech.tis.runtime.module.misc.IFieldErrorHandler;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.HtmlEmail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailAlertChannel
extends AlertChannel {
    private static final Logger logger = LoggerFactory.getLogger(EmailAlertChannel.class);
    @FormField(ordinal=1, type=FormFieldType.INPUTTEXT, validate={Validator.require, Validator.hostWithoutPort})
    public String smtpHost;
    @FormField(ordinal=2, type=FormFieldType.INT_NUMBER, validate={Validator.require, Validator.integer})
    public Integer smtpPort;
    @FormField(ordinal=3, type=FormFieldType.INPUTTEXT, validate={Validator.require, Validator.none_blank})
    public String userName;
    @FormField(ordinal=4, type=FormFieldType.PASSWORD, validate={Validator.require})
    public String password;
    @FormField(ordinal=5, type=FormFieldType.INPUTTEXT, validate={Validator.require, Validator.email})
    public String from;
    @FormField(ordinal=6, type=FormFieldType.INPUTTEXT, validate={Validator.require})
    public String to;
    @FormField(ordinal=7, type=FormFieldType.ENUM, validate={Validator.require})
    public Boolean ssl = false;

    public List<String> getRecipients() {
        return EmailAlertChannel.getRecipients(this.to);
    }

    private static List<String> getRecipients(String to) {
        String[] recipients;
        ArrayList result = Lists.newArrayList();
        for (String recipient : recipients = to.split(",")) {
            String trimmed = recipient.trim();
            if (!StringUtils.isNotEmpty((String)trimmed)) continue;
            result.add(trimmed);
        }
        return result;
    }

    @Override
    public void send(AlertTemplate alertTemplate) {
        if (alertTemplate == null) {
            throw new IllegalArgumentException("alertTemplate can not be null");
        }
        try {
            String[] recipients;
            String emailContent = this.renderTemplate(alertTemplate);
            HtmlEmail email = new HtmlEmail();
            email.setHostName(this.smtpHost);
            email.setSmtpPort(this.smtpPort.intValue());
            email.setAuthentication(this.userName, this.password);
            email.setSSLOnConnect(this.ssl != null && this.ssl != false);
            email.setCharset(TisUTF8.getName());
            email.setFrom(this.from);
            for (String recipient : recipients = this.to.split(",")) {
                String trimmed = recipient.trim();
                if (!StringUtils.isNotEmpty((String)trimmed)) continue;
                email.addTo(trimmed);
            }
            String subject = alertTemplate.getSubject();
            if (StringUtils.isEmpty((String)subject)) {
                subject = alertTemplate.getTitle();
            }
            if (StringUtils.isEmpty((String)subject)) {
                subject = "TIS Flink Job Alert";
            }
            email.setSubject(subject);
            email.setHtmlMsg(emailContent);
            String messageId = email.send();
            logger.info("Email alert sent successfully via channel [{}], messageId: {}", (Object)this.name, (Object)messageId);
        }
        catch (EmailException e) {
            logger.error("Failed to send email alert via channel [{}]", (Object)this.name, (Object)e);
            throw new RuntimeException("Failed to send email alert: " + e.getMessage(), e);
        }
    }

    public static String loadDefaultTpl() {
        return IOUtils.loadResourceFromClasspath(EmailAlertChannel.class, (String)"email-alert-template.vm");
    }

    @TISExtension
    public static class DefaultDescriptor
    extends AlertChannel.AlertChannelDescDesc<EmailAlertChannel> {
        public boolean validateTo(IFieldErrorHandler msgHandler, Context context, String fieldName, String value) {
            List<String> recipients = EmailAlertChannel.getRecipients(value);
            if (CollectionUtils.isEmpty(recipients)) {
                msgHandler.addFieldError(context, fieldName, "\u8bf7\u8bbe\u7f6e\u90ae\u4ef6\u63a5\u6536\u4eba", new Object[0]);
                return false;
            }
            for (String to : recipients) {
                if (Validator.email.validate(msgHandler, context, fieldName, to)) continue;
                return false;
            }
            return true;
        }

        @Override
        protected String verifySuccessMessage(EmailAlertChannel alertChannel) {
            return "\u5df2\u7ecf\u6210\u529f\u53d1\u9001\u4e00\u5c01\u90ae\u4ef6\u5230\uff1a" + String.join((CharSequence)",", alertChannel.getRecipients());
        }

        @Override
        public IEndTypeGetter.EndType getEndType() {
            return IEndTypeGetter.EndType.Email;
        }
    }
}

