/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.plugin.alert;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.function.BiConsumer;

public class AlertTemplate
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String title;
    private String subject;
    private String jobName;
    private String status;
    private Integer type;
    private String startTime;
    private String endTime;
    private String duration;
    private String link;
    private String cpFailureRateInterval;
    private Integer cpMaxFailureInterval;
    private Boolean restart;
    private Integer restartIndex;
    private Integer totalRestart;
    private boolean atAll;
    private Integer allJobs;
    private Integer affectedJobs;
    private String user;
    private Integer probeJobs;
    private Integer failedJobs;
    private Integer lostJobs;
    private Integer cancelledJobs;

    public static AlertTemplate createDefault() {
        Date now = new Date();
        Date startTime = new Date(now.getTime() - 3600000L);
        return AlertTemplate.builder().title("\u3010TIS\u62a5\u8b66\u6d4b\u8bd5\u3011Flink\u4efb\u52a1\u72b6\u6001\u5f02\u5e38").subject("\u6570\u636e\u540c\u6b65\u4efb\u52a1\u6267\u884c\u5931\u8d25\u544a\u8b66[\u6d4b\u8bd5]").jobName("mysql-to-doris-sync-job").status("FAILED").type(1).startTime(startTime).endTime(now).duration(startTime, now).link("http://localhost:8081/#/job/running").cpFailureRateInterval("5min").cpMaxFailureInterval(3).restart(true, 3).restartIndex(2).totalRestart(3).atAll(false).allJobs(10).affectedJobs(1).failedJobs(1).lostJobs(0).cancelledJobs(0).probeJobs(10).user("admin").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public void visitAllProp(BiConsumer<String, Object> propConsumer) {
        Field[] fields;
        for (Field field : fields = AlertTemplate.class.getDeclaredFields()) {
            try {
                field.setAccessible(true);
                Object value = field.get(this);
                if (value == null) continue;
                propConsumer.accept(field.getName(), value);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public String getDuration() {
        return this.duration;
    }

    public void setDuration(String duration) {
        this.duration = duration;
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public String getCpFailureRateInterval() {
        return this.cpFailureRateInterval;
    }

    public void setCpFailureRateInterval(String cpFailureRateInterval) {
        this.cpFailureRateInterval = cpFailureRateInterval;
    }

    public Integer getCpMaxFailureInterval() {
        return this.cpMaxFailureInterval;
    }

    public void setCpMaxFailureInterval(Integer cpMaxFailureInterval) {
        this.cpMaxFailureInterval = cpMaxFailureInterval;
    }

    public Boolean getRestart() {
        return this.restart;
    }

    public void setRestart(Boolean restart) {
        this.restart = restart;
    }

    public Integer getRestartIndex() {
        return this.restartIndex;
    }

    public void setRestartIndex(Integer restartIndex) {
        this.restartIndex = restartIndex;
    }

    public Integer getTotalRestart() {
        return this.totalRestart;
    }

    public void setTotalRestart(Integer totalRestart) {
        this.totalRestart = totalRestart;
    }

    public boolean isAtAll() {
        return this.atAll;
    }

    public void setAtAll(boolean atAll) {
        this.atAll = atAll;
    }

    public Integer getAllJobs() {
        return this.allJobs;
    }

    public void setAllJobs(Integer allJobs) {
        this.allJobs = allJobs;
    }

    public Integer getAffectedJobs() {
        return this.affectedJobs;
    }

    public void setAffectedJobs(Integer affectedJobs) {
        this.affectedJobs = affectedJobs;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public Integer getProbeJobs() {
        return this.probeJobs;
    }

    public void setProbeJobs(Integer probeJobs) {
        this.probeJobs = probeJobs;
    }

    public Integer getFailedJobs() {
        return this.failedJobs;
    }

    public void setFailedJobs(Integer failedJobs) {
        this.failedJobs = failedJobs;
    }

    public Integer getLostJobs() {
        return this.lostJobs;
    }

    public void setLostJobs(Integer lostJobs) {
        this.lostJobs = lostJobs;
    }

    public Integer getCancelledJobs() {
        return this.cancelledJobs;
    }

    public void setCancelledJobs(Integer cancelledJobs) {
        this.cancelledJobs = cancelledJobs;
    }

    public static class Builder {
        private AlertTemplate template = new AlertTemplate();

        public Builder title(String title) {
            this.template.title = title;
            return this;
        }

        public Builder subject(String subject) {
            this.template.subject = subject;
            return this;
        }

        public Builder jobName(String jobName) {
            this.template.jobName = jobName;
            return this;
        }

        public Builder status(String status) {
            this.template.status = status;
            return this;
        }

        public Builder type(Integer type) {
            this.template.type = type;
            return this;
        }

        public Builder startTime(Date startTime) {
            this.template.startTime = this.formatDate(startTime);
            return this;
        }

        public Builder endTime(Date endTime) {
            this.template.endTime = this.formatDate(endTime == null ? new Date() : endTime);
            return this;
        }

        public Builder duration(Date start, Date end) {
            long durationMillis = start == null ? 0L : (end == null ? System.currentTimeMillis() - start.getTime() : end.getTime() - start.getTime());
            this.template.duration = this.formatDuration(durationMillis);
            return this;
        }

        public Builder link(String link) {
            this.template.link = link;
            return this;
        }

        public Builder cpFailureRateInterval(String cpFailureRateInterval) {
            this.template.cpFailureRateInterval = cpFailureRateInterval;
            return this;
        }

        public Builder cpMaxFailureInterval(Integer cpMaxFailureInterval) {
            this.template.cpMaxFailureInterval = cpMaxFailureInterval;
            return this;
        }

        public Builder restart(Boolean restart, Integer totalRestart) {
            this.template.restart = restart != false && totalRestart != null && totalRestart > 0;
            this.template.totalRestart = totalRestart;
            return this;
        }

        public Builder restartIndex(Integer restartIndex) {
            this.template.restartIndex = restartIndex;
            return this;
        }

        public Builder totalRestart(Integer totalRestart) {
            this.template.totalRestart = totalRestart;
            return this;
        }

        public Builder atAll(boolean atAll) {
            this.template.atAll = atAll;
            return this;
        }

        public Builder allJobs(Integer allJobs) {
            this.template.allJobs = allJobs;
            return this;
        }

        public Builder affectedJobs(Integer affectedJobs) {
            this.template.affectedJobs = affectedJobs;
            return this;
        }

        public Builder user(String user) {
            this.template.user = user;
            return this;
        }

        public Builder probeJobs(Integer probeJobs) {
            this.template.probeJobs = probeJobs;
            return this;
        }

        public Builder failedJobs(Integer failedJobs) {
            this.template.failedJobs = failedJobs;
            return this;
        }

        public Builder lostJobs(Integer lostJobs) {
            this.template.lostJobs = lostJobs;
            return this;
        }

        public Builder cancelledJobs(Integer cancelledJobs) {
            this.template.cancelledJobs = cancelledJobs;
            return this;
        }

        public AlertTemplate build() {
            return this.template;
        }

        private String formatDate(Date date) {
            if (date == null) {
                return null;
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return sdf.format(date);
        }

        private String formatDuration(long millis) {
            long seconds = millis / 1000L;
            long minutes = seconds / 60L;
            long hours = minutes / 60L;
            long days = hours / 24L;
            if (days > 0L) {
                return String.format("%dd %dh %dm", days, hours % 24L, minutes % 60L);
            }
            if (hours > 0L) {
                return String.format("%dh %dm %ds", hours, minutes % 60L, seconds % 60L);
            }
            if (minutes > 0L) {
                return String.format("%dm %ds", minutes, seconds % 60L);
            }
            return String.format("%ds", seconds);
        }
    }
}

