/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.plugin.alert;

import com.alibaba.citrus.turbine.Context;
import com.google.common.collect.Lists;
import com.qlangtech.tis.config.ParamsConfig;
import com.qlangtech.tis.datax.impl.DataXCfgGenerator;
import com.qlangtech.tis.extension.Descriptor;
import com.qlangtech.tis.manage.common.ConfigFileContext;
import com.qlangtech.tis.manage.common.HttpUtils;
import com.qlangtech.tis.manage.common.PostFormStreamProcess;
import com.qlangtech.tis.manage.common.TisUTF8;
import com.qlangtech.tis.plugin.IEndTypeGetter;
import com.qlangtech.tis.plugin.alert.AlertTemplate;
import com.qlangtech.tis.plugin.annotation.FormField;
import com.qlangtech.tis.plugin.annotation.FormFieldType;
import com.qlangtech.tis.plugin.annotation.Validator;
import com.qlangtech.tis.runtime.module.misc.IControlMsgHandler;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.VelocityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AlertChannel
extends ParamsConfig {
    public static final String KEY_CATEGORY = "AlertChannel";
    private static final Logger logger = LoggerFactory.getLogger(AlertChannel.class);
    @FormField(identity=true, type=FormFieldType.INPUTTEXT, ordinal=0, validate={Validator.require, Validator.identity})
    public String name;
    @FormField(type=FormFieldType.TEXTAREA, advance=false, ordinal=999, validate={Validator.require})
    public String alertTpl;

    public static List<AlertChannel> load(Set<String> alertChannelNames) {
        if (CollectionUtils.isEmpty(alertChannelNames)) {
            throw new IllegalArgumentException("param alertChannelName can not be empty");
        }
        return ParamsConfig.getItems(KEY_CATEGORY, Optional.empty(), p -> alertChannelNames.contains(p.identityValue()));
    }

    public AlertChannel createConfigInstance() {
        return this;
    }

    protected static List<String> getMobile(String value) {
        if (StringUtils.isNotEmpty((String)value)) {
            Object[] mobiles = value.split(",");
            return Lists.newArrayList((Object[])mobiles);
        }
        return Collections.emptyList();
    }

    public abstract void send(AlertTemplate var1);

    protected void sendHttpRequest(String urlString, List<HttpUtils.PostParam> postParams) {
        this.sendHttpRequest(urlString, postParams, Collections.emptyList());
    }

    protected void sendHttpRequest(String urlString, List<HttpUtils.PostParam> postParams, List<ConfigFileContext.Header> appendHeaders) {
        if (CollectionUtils.isEmpty(postParams)) {
            throw new IllegalArgumentException("param postParams can not be empty");
        }
        try {
            URL url = new URL(urlString);
            HttpUtils.post((URL)url, postParams, (PostFormStreamProcess)new PostFormStreamProcess<Void>(appendHeaders){

                public PostFormStreamProcess.ContentType getContentType() {
                    return PostFormStreamProcess.ContentType.JSON;
                }

                public Void p(int status, InputStream stream, Map headerFields) throws IOException {
                    logger.info(IOUtils.toString((InputStream)stream, (Charset)TisUTF8.get()));
                    return null;
                }
            });
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public void sendAlert() {
    }

    protected String renderTemplate(AlertTemplate alertTemplate) {
        if (StringUtils.isEmpty((String)this.alertTpl)) {
            throw new IllegalStateException("alertTpl can not be empty");
        }
        VelocityContext context = new VelocityContext();
        alertTemplate.visitAllProp((arg_0, arg_1) -> ((VelocityContext)context).put(arg_0, arg_1));
        return DataXCfgGenerator.evaluateTemplate(context, this.alertTpl);
    }

    public final String identityValue() {
        return this.name;
    }

    protected final Class<AlertChannelDescDesc> getBasicParamsConfigDescriptorClass() {
        return AlertChannelDescDesc.class;
    }

    public static abstract class AlertChannelDescDesc<T extends AlertChannel>
    extends ParamsConfig.BasicParamsConfigDescriptor
    implements IEndTypeGetter {
        public AlertChannelDescDesc() {
            super(AlertChannel.KEY_CATEGORY);
        }

        @Override
        protected final boolean verify(IControlMsgHandler msgHandler, Context context, Descriptor.PostFormVals postFormVals) {
            AlertChannel alertChannel = (AlertChannel)postFormVals.newInstance();
            alertChannel.send(AlertTemplate.createDefault());
            msgHandler.addActionMessage(context, this.verifySuccessMessage(alertChannel));
            return true;
        }

        protected abstract String verifySuccessMessage(T var1);

        @Override
        public final String getDisplayName() {
            return String.valueOf(this.getEndType()) + "_Chan";
        }
    }
}

