/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.plugin;

import com.alibaba.citrus.turbine.Context;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.qlangtech.tis.TIS;
import com.qlangtech.tis.extension.Describable;
import com.qlangtech.tis.extension.Descriptor;
import com.qlangtech.tis.extension.impl.XmlFile;
import com.qlangtech.tis.manage.common.CenterResource;
import com.qlangtech.tis.manage.common.TisUTF8;
import com.qlangtech.tis.order.center.IParamContext;
import com.qlangtech.tis.plugin.ComponentMeta;
import com.qlangtech.tis.plugin.IPluginStore;
import com.qlangtech.tis.plugin.IdentityName;
import com.qlangtech.tis.plugin.SetPluginsResult;
import com.qlangtech.tis.util.IPluginContext;
import com.qlangtech.tis.util.PluginMeta;
import com.qlangtech.tis.util.RobustReflectionConverter2;
import com.thoughtworks.xstream.converters.DataHolder;
import com.thoughtworks.xstream.core.MapBackedDataHolder;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginStore<T extends Describable>
implements IPluginStore<T> {
    private static final Logger logger = LoggerFactory.getLogger(PluginStore.class);
    private final transient Class<T> pluginClass;
    private List<T> plugins = Lists.newArrayList();
    private transient Set<PluginMeta> pluginMetas;
    private final transient IPluginProcessCallback<T>[] pluginCreateCallback;
    private final transient List<PluginsUpdateListener> pluginsUpdateListeners = Lists.newArrayList();
    private final transient XmlFile file;
    private transient boolean loaded = false;

    public PluginStore(Class<T> pluginClass, IPluginProcessCallback<T> ... pluginCreateCallback) {
        this(pluginClass, Descriptor.getConfigFile(pluginClass.getName()), pluginCreateCallback);
    }

    public PluginStore(Class<T> pluginClass, XmlFile file, IPluginProcessCallback<T> ... pluginCreateCallback) {
        this.pluginClass = pluginClass;
        this.file = file;
        this.pluginCreateCallback = pluginCreateCallback;
    }

    @Override
    public void cleanPlugins() {
        this.plugins.clear();
        this.loaded = false;
    }

    @Override
    public void copyConfigFromRemote() {
        CenterResource.copyFromRemote2Local((String)("tis_plugin_config/" + Descriptor.getPluginFileName(this.getSerializeFileName())), (boolean)true);
    }

    @Override
    public XmlFile getTargetFile() {
        return this.file;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PluginStore that = (PluginStore)o;
        return this.hashCode() == that.hashCode();
    }

    public final int hashCode() {
        return Objects.hash(this.file.getFile().getAbsolutePath());
    }

    @Override
    public List<T> getPlugins() {
        this.load();
        RobustReflectionConverter2.PluginMetas metas = null;
        metas = RobustReflectionConverter2.usedPluginInfo.get();
        if (!metas.isCacheable()) {
            metas.addAll(this.pluginMetas, this);
        }
        return this.plugins;
    }

    @Override
    public T find(String name) {
        return this.find(name, true);
    }

    @Override
    public T find(String name, boolean throwNotFoundErr) {
        if (StringUtils.isEmpty((String)name)) {
            throw new IllegalArgumentException("param of name can not be empty");
        }
        List<T> plugins = this.getPlugins();
        for (Describable item : plugins) {
            if (!(item instanceof IdentityName)) {
                throw new IllegalStateException("item of " + item.getClass().getSimpleName() + " must be type of " + IdentityName.class.getSimpleName());
            }
            if (!StringUtils.equals((String)name, (String)((IdentityName)item).identityValue())) continue;
            return (T)item;
        }
        if (throwNotFoundErr) {
            String instanceName = this.pluginClass.getSimpleName();
            throw new IllegalStateException(instanceName + " has not be initialized,name:" + name + " can not find relevant '" + instanceName + "' in [" + plugins.stream().map(r -> ((IdentityName)r).identityValue()).collect(Collectors.joining(",")) + "]");
        }
        return null;
    }

    @Override
    public List<Descriptor<T>> allDescriptor() {
        return TIS.get().getDescriptorList(this.pluginClass);
    }

    @Override
    public T getPlugin() {
        if (this.getPlugins().size() > 1) {
            throw new IllegalStateException("plugin size can not much than 1");
        }
        Iterator<T> iterator = this.getPlugins().iterator();
        if (iterator.hasNext()) {
            Describable plugin = (Describable)iterator.next();
            return (T)plugin;
        }
        return null;
    }

    public synchronized void copyFrom(IPluginContext pluginContext, PluginStore<T> other) {
        if (this.getPlugin() != null) {
            throw new IllegalStateException("destination plugin store have saved ,can not copy from other");
        }
        if (other.getPlugin() == null) {
            throw new IllegalStateException("from plugin store have not initialized");
        }
        List<Descriptor.ParseDescribable<T>> dlist = Collections.singletonList(PluginStore.getDescribablesWithMeta(other, other.getPlugin()));
        this.setPlugins(pluginContext, Optional.empty(), dlist);
    }

    public static <TT extends Describable> Descriptor.ParseDescribable<TT> getDescribablesWithMeta(IPluginStore<TT> other, TT plugin) {
        Descriptor.ParseDescribable<TT> parseDescribable = new Descriptor.ParseDescribable<TT>(plugin);
        ComponentMeta cmetas = new ComponentMeta(other);
        parseDescribable.extraPluginMetas.addAll(cmetas.loadPluginMeta());
        return parseDescribable;
    }

    @Override
    public synchronized SetPluginsResult setPlugins(IPluginContext pluginContext, Optional<Context> context, List<Descriptor.ParseDescribable<T>> dlist) {
        return this.setPlugins(pluginContext, context, dlist, false);
    }

    public void addPluginsUpdateListener(PluginsUpdateListener consumer) {
        Objects.requireNonNull(consumer, "param consumer can not be null");
        this.pluginsUpdateListeners.add(consumer);
    }

    @Override
    public synchronized SetPluginsResult setPlugins(IPluginContext pluginContext, Optional<Context> context, List<Descriptor.ParseDescribable<T>> dlist, boolean update) {
        try {
            HashSet pluginsMeta = Sets.newHashSet();
            List collect = dlist.stream().flatMap(r -> {
                pluginsMeta.addAll(r.extraPluginMetas);
                if (!r.subFormFields) {
                    Describable instance = (Describable)r.getInstance();
                    if (!this.pluginClass.isAssignableFrom(instance.getClass())) {
                        throw new IllegalStateException("plugin must be type of " + this.pluginClass.getName() + ", but now is " + instance.getClass().getName());
                    }
                    for (IPluginProcessCallback<Describable> iPluginProcessCallback : this.pluginCreateCallback) {
                        iPluginProcessCallback.afterDeserialize(this, instance);
                    }
                }
                return r.getSubFormInstances().stream();
            }).collect(Collectors.toList());
            HashMap beforeUpdateIds = Maps.newHashMap();
            if (this.plugins != null) {
                this.plugins.forEach(plugin -> {
                    if (plugin instanceof IPluginStore.RecyclableController) {
                        ((IPluginStore.RecyclableController)((Object)plugin)).signDirty();
                    }
                    if (plugin instanceof IdentityName && plugin instanceof IPluginStore.AfterPluginDeleted) {
                        beforeUpdateIds.put(((IdentityName)plugin).identityValue(), Pair.of((Object)((IPluginStore.AfterPluginDeleted)((Object)plugin)), (Object)true));
                    }
                });
            }
            this.plugins = collect;
            if (this.plugins != null) {
                this.plugins.forEach(plugin -> {
                    Pair old;
                    if (plugin instanceof IPluginStore.BeforePluginSaved) {
                        ((IPluginStore.BeforePluginSaved)((Object)plugin)).beforeSaved(pluginContext, context);
                    }
                    if (plugin instanceof IdentityName && plugin instanceof IPluginStore.AfterPluginDeleted && (old = (Pair)beforeUpdateIds.get(((IdentityName)plugin).identityValue())) != null) {
                        old.setValue((Object)false);
                    }
                });
            }
            boolean changed = this.file.write(this, pluginsMeta);
            this.loaded = true;
            long lastModifyTimestamp = -1L;
            if (changed) {
                lastModifyTimestamp = this.writeLastModifyTimeStamp();
                if (this.plugins != null) {
                    this.plugins.forEach(plugin -> {
                        if (plugin instanceof IPluginStore.AfterPluginSaved) {
                            ((IPluginStore.AfterPluginSaved)((Object)plugin)).afterSaved(pluginContext, context);
                        }
                    });
                }
            }
            for (Map.Entry entry : beforeUpdateIds.entrySet()) {
                Pair old = (Pair)entry.getValue();
                if (!((Boolean)old.getValue()).booleanValue()) continue;
                ((IPluginStore.AfterPluginDeleted)old.getKey()).afterDeleted(pluginContext, context);
            }
            if (CollectionUtils.isNotEmpty(this.pluginsUpdateListeners)) {
                Iterator<PluginsUpdateListener> it = this.pluginsUpdateListeners.iterator();
                PluginsUpdateListener next = null;
                while (it.hasNext()) {
                    next = it.next();
                    if (next.isDirty()) {
                        it.remove();
                        logger.info("dirty instance:" + next.identity + " will remove from watch listeners");
                        continue;
                    }
                    next.accept(this);
                }
                logger.info("notify pluginsUpdateListeners size:" + this.pluginsUpdateListeners.size());
            }
            SetPluginsResult pluginsResult = new SetPluginsResult(true, changed);
            if (changed) {
                pluginsResult.lastModifyTimeStamp = lastModifyTimestamp;
            }
            return pluginsResult;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public long writeLastModifyTimeStamp() {
        File timestamp = PluginStore.getLastModifyTimeStampFile(this.file.getFile());
        return this.writeLastModifyTimeStamp(timestamp);
    }

    protected long writeLastModifyTimeStamp(File timestamp) {
        try {
            String millisecTimeStamp = IParamContext.getCurrentMillisecTimeStamp();
            FileUtils.writeStringToFile((File)timestamp, (String)millisecTimeStamp, (Charset)TisUTF8.get());
            return Long.parseLong(millisecTimeStamp);
        }
        catch (IOException e) {
            throw new RuntimeException(timestamp.getAbsolutePath(), e);
        }
    }

    @Override
    public final long getWriteLastModifyTimeStamp() {
        try {
            File timestamp = PluginStore.getLastModifyTimeStampFile(this.file.getFile());
            if (!timestamp.exists()) {
                File cfg = this.file.getFile();
                if (!cfg.exists()) {
                    return -1L;
                }
                return this.writeLastModifyTimeStamp();
            }
            return Long.parseLong(FileUtils.readFileToString((File)timestamp, (Charset)TisUTF8.get()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public File getLastModifyTimeStampFile() {
        return PluginStore.getLastModifyTimeStampFile(this.file.getFile());
    }

    public static File getLastModifyTimeStampFile(File cfg) {
        return new File(cfg.getParentFile(), cfg.getName() + ".lastmodified");
    }

    protected String getSerializeFileName() {
        return this.pluginClass.getName();
    }

    private synchronized void load() {
        RobustReflectionConverter2.PluginMetas metasCollector = RobustReflectionConverter2.usedPluginInfo.get();
        if (metasCollector.isCacheable() && this.loaded) {
            return;
        }
        logger.debug("load:" + this.file.getFile().getAbsolutePath() + ",this.loaded:" + this.loaded);
        HashSet pluginMetas = Sets.newHashSet();
        XmlFile.DefaultDataHolder dataHolder = new XmlFile.DefaultDataHolder(pluginMetas, this.file);
        try {
            if (!this.file.exists()) {
                logger.warn("target xstream file is not exist:" + this.file.getFile().getAbsolutePath());
                return;
            }
            this.file.unmarshal(this, (DataHolder)dataHolder);
            if (this.plugins != null) {
                this.plugins.forEach(p -> {
                    for (IPluginProcessCallback<Describable> iPluginProcessCallback : this.pluginCreateCallback) {
                        iPluginProcessCallback.afterDeserialize(this, (Describable)p);
                    }
                });
            }
            this.loaded = true;
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
        PluginStore.processError(dataHolder, e -> this.file.getFile().getAbsolutePath() + "\n" + TIS.get().getPluginManager().getFaildPluginsDesc());
        this.pluginMetas = pluginMetas;
    }

    public static void processError(MapBackedDataHolder dataHolder) {
        PluginStore.processError(dataHolder, err -> err.getMessage());
    }

    private static void processError(MapBackedDataHolder dataHolder, Function<Throwable, String> errMsgCreator) {
        Iterator iterator;
        ArrayList errors = (ArrayList)dataHolder.get((Object)"ReadError");
        if (CollectionUtils.isNotEmpty((Collection)errors) && (iterator = errors.iterator()).hasNext()) {
            Throwable t = (Throwable)iterator.next();
            throw new RuntimeException(errMsgCreator.apply(t), t);
        }
    }

    public static abstract class PluginsUpdateListener
    implements Consumer<PluginStore<Describable>>,
    IPluginStore.Recyclable {
        private final IPluginStore.Recyclable recyclable;
        public final String identity;
        static final AtomicInteger ver = new AtomicInteger();

        public PluginsUpdateListener(String identity, IPluginStore.Recyclable recyclable) {
            this.recyclable = recyclable;
            this.identity = identity + "@ver" + ver.incrementAndGet();
        }

        @Override
        public boolean isDirty() {
            return this.recyclable.isDirty();
        }
    }

    public static interface IPluginProcessCallback<T extends Describable> {
        public void afterDeserialize(PluginStore<T> var1, T var2);
    }
}

