/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.plugin;

import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.qlangtech.tis.TIS;
import com.qlangtech.tis.async.message.client.consumer.IFlinkColCreator;
import com.qlangtech.tis.async.message.client.consumer.impl.MQListenerFactory;
import com.qlangtech.tis.config.flink.IFlinkCluster;
import com.qlangtech.tis.coredefine.module.action.TargetResName;
import com.qlangtech.tis.datax.DataXName;
import com.qlangtech.tis.datax.IDataxProcessor;
import com.qlangtech.tis.datax.StoreResourceType;
import com.qlangtech.tis.datax.impl.DataxProcessor;
import com.qlangtech.tis.extension.ExtensionList;
import com.qlangtech.tis.extension.PluginManager;
import com.qlangtech.tis.extension.PluginWrapper;
import com.qlangtech.tis.extension.impl.PluginManifest;
import com.qlangtech.tis.manage.common.CenterResource;
import com.qlangtech.tis.manage.common.Config;
import com.qlangtech.tis.manage.common.ConfigFileContext;
import com.qlangtech.tis.manage.common.HttpUtils;
import com.qlangtech.tis.manage.common.TisUTF8;
import com.qlangtech.tis.maven.plugins.tpi.PluginClassifier;
import com.qlangtech.tis.plugin.ComponentMeta;
import com.qlangtech.tis.plugin.IPluginMetasInfo;
import com.qlangtech.tis.plugin.IRepositoryResource;
import com.qlangtech.tis.plugin.KeyedPluginStore;
import com.qlangtech.tis.plugin.PluginAndCfgsSnapshotUtils;
import com.qlangtech.tis.plugin.PluginStore;
import com.qlangtech.tis.plugin.datax.transformer.RecordTransformerRules;
import com.qlangtech.tis.plugin.ds.IColMetaGetter;
import com.qlangtech.tis.plugin.incr.TISSinkFactory;
import com.qlangtech.tis.plugin.license.TISLicense;
import com.qlangtech.tis.trigger.util.JsonUtil;
import com.qlangtech.tis.util.HeteroEnum;
import com.qlangtech.tis.util.IPluginContext;
import com.qlangtech.tis.util.PluginMeta;
import com.qlangtech.tis.util.RobustReflectionConverter2;
import com.qlangtech.tis.util.UploadPluginMeta;
import com.qlangtech.tis.web.start.TisSubModule;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginAndCfgsSnapshot {
    public static final String TIS_APP_NAME = "tis_app_name";
    private static final Logger logger = LoggerFactory.getLogger(PluginAndCfgsSnapshot.class);
    private static PluginAndCfgsSnapshot pluginAndCfgsSnapshot;
    private final TargetResName collection;
    private final StoreResourceType resType;
    public final Map<String, Long> globalPluginStoreLastModify;
    public final Set<PluginMeta> pluginMetas;
    private final Set<IRepositoryResource> repoRes;
    public final Long appLastModifyTimestamp;
    private final Optional<KeyedPluginStore.PluginMetas> appMetas;

    public static String getTaskEntryName() {
        return "task_xxxx";
    }

    public static PluginAndCfgsSnapshot getRepositoryCfgsSnapshot(String resName, StoreResourceType resourceType, InputStream manifestJar) throws IOException {
        return PluginAndCfgsSnapshot.getRepositoryCfgsSnapshot(resName, Objects.requireNonNull(resourceType), manifestJar, true);
    }

    public static PluginAndCfgsSnapshot getRepositoryCfgsSnapshot(String resName, StoreResourceType resourceType, InputStream manifestJar, boolean resetConfigWithSysProps) throws IOException {
        PluginAndCfgsSnapshot pluginAndCfgsSnapshot = null;
        String appName = null;
        JarInputStream jarReader = new JarInputStream(manifestJar);
        Manifest manifest = jarReader.getManifest();
        appName = PluginAndCfgsSnapshot.getRepositoryCfgsSnapshot(resName, manifest);
        pluginAndCfgsSnapshot = PluginAndCfgsSnapshot.setLocalPluginAndCfgsSnapshot(PluginAndCfgsSnapshot.deserializePluginAndCfgsSnapshot(new TargetResName(appName), resourceType, manifest));
        Attributes sysProps = manifest.getAttributes("env_props");
        if (resetConfigWithSysProps) {
            Config.setConfig(null);
            System.setProperty("env_props", String.valueOf(true));
            StringBuffer sysPropsDesc = new StringBuffer();
            for (Map.Entry<Object, Object> pluginDesc : sysProps.entrySet()) {
                Attributes.Name name = (Attributes.Name)pluginDesc.getKey();
                String val = (String)pluginDesc.getValue();
                String key = PluginAndCfgsSnapshot.convertCfgPropertyKey(name.toString(), false);
                System.setProperty(key, val);
                sysPropsDesc.append("\n").append(key).append("->").append(val);
            }
            logger.info("sysProps details:" + sysPropsDesc.toString());
        }
        TisSubModule.TIS_CONSOLE.getLaunchPort();
        Config.getInstance();
        if (pluginAndCfgsSnapshot == null) {
            throw new IllegalStateException("param appName can not be null,in res name:" + resName);
        }
        return pluginAndCfgsSnapshot;
    }

    public static String getRepositoryCfgsSnapshot(String resName, Manifest manifest) {
        String appName;
        block1: {
            Attributes tisAppName = manifest.getAttributes(TIS_APP_NAME);
            appName = null;
            if (tisAppName == null) {
                throw new IllegalStateException("tisAppName can not be empty in lib:" + resName);
            }
            Iterator<Map.Entry<Object, Object>> iterator = tisAppName.entrySet().iterator();
            if (!iterator.hasNext()) break block1;
            Map.Entry<Object, Object> pluginDesc = iterator.next();
            Attributes.Name name = (Attributes.Name)pluginDesc.getKey();
            String val = (String)pluginDesc.getValue();
            appName = name.toString();
        }
        return appName;
    }

    public static String convertCfgPropertyKey(String key, boolean serialize) {
        return serialize ? org.apache.commons.lang3.StringUtils.replace((String)key, (String)".", (String)"_") : org.apache.commons.lang3.StringUtils.replace((String)key, (String)"_", (String)".");
    }

    public static PluginAndCfgsSnapshot setLocalPluginAndCfgsSnapshot(PluginAndCfgsSnapshot snapshot) {
        pluginAndCfgsSnapshot = snapshot;
        return pluginAndCfgsSnapshot;
    }

    public PluginAndCfgsSnapshot(TargetResName collection, StoreResourceType resType, Map<String, Long> globalPluginStoreLastModify, IPluginMetasInfo metasInfo, Long appLastModifyTimestamp, KeyedPluginStore.PluginMetas appMetas) {
        this.globalPluginStoreLastModify = globalPluginStoreLastModify;
        this.pluginMetas = metasInfo.getMetas();
        this.repoRes = metasInfo.getRepoResources();
        this.appLastModifyTimestamp = appLastModifyTimestamp;
        this.collection = collection;
        this.resType = Objects.requireNonNull(resType, "resType can not be null");
        this.appMetas = Optional.ofNullable(appMetas);
    }

    public static void createManifestCfgAttrs2File(File manifestJar, StoreResourceType resourceType, TargetResName collection, long timestamp, Optional<Predicate<PluginMeta>> pluginMetasFilter) throws Exception {
        PluginAndCfgsSnapshot.createManifestCfgAttrs2File(manifestJar, resourceType, collection, timestamp, pluginMetasFilter, Collections.emptyMap());
    }

    public static Manifest createDataBatchJobManifestCfgAttrs(TargetResName collection) throws Exception {
        IDataxProcessor processor = DataxProcessor.load(null, StoreResourceType.DataApp, collection.getName());
        return PluginAndCfgsSnapshot.createDataBatchJobManifestCfgAttrs(processor);
    }

    public static Manifest createDataBatchJobManifestCfgAttrs(IDataxProcessor processor) throws Exception {
        Map<String, String> extraEnvProps = Collections.emptyMap();
        Optional<Predicate<PluginMeta>> pluginMetasFilter = Optional.empty();
        return PluginAndCfgsSnapshot.createDataBatchJobManifestCfgAttrs(processor, extraEnvProps, pluginMetasFilter);
    }

    public static Manifest createDataBatchJobManifestCfgAttrs(IDataxProcessor processor, Map<String, String> extraEnvProps, Optional<Predicate<PluginMeta>> pluginMetasFilter) throws Exception {
        if (processor.getResType() != StoreResourceType.DataApp && processor.getResType() != StoreResourceType.DataFlow) {
            throw new IllegalArgumentException("resType must be " + StoreResourceType.DataApp + " or " + StoreResourceType.DataFlow + " but now is " + processor.getResType());
        }
        RobustReflectionConverter2.PluginMetas pluginMetas = RobustReflectionConverter2.PluginMetas.collectMetas(metas -> {
            TISLicense.load(false);
            IDataxProcessor dataxProcessor = DataxProcessor.load(null, processor.getResType(), processor.identityValue());
            dataxProcessor.getReaders(null).forEach(reader -> {
                reader.startScanDependency();
                RecordTransformerRules.contextParamValsGetterMapper(processor, IPluginContext.namedContext(new DataXName(processor.identityValue(), processor.getResType())), reader, reader.getSelectedTabs());
            });
            dataxProcessor.getWriter(null).startScanDependency();
        });
        TargetResName resName = new TargetResName(processor.identityValue());
        return (Manifest)PluginAndCfgsSnapshot.createManifestCfgAttrs(resName, processor.getResType(), System.currentTimeMillis(), extraEnvProps, () -> {
            KeyedPluginStore.PluginMetas metas = KeyedPluginStore.getAppAwarePluginMetas(processor.getResType(), resName.getName(), false);
            ComponentMeta dataxComponentMeta = new ComponentMeta(Lists.newArrayList(pluginMetas.getRepoResources()));
            Map<String, Long> globalPluginStoreLastModify = ComponentMeta.getGlobalPluginStoreLastModifyTimestamp(dataxComponentMeta);
            PluginMetaSet collector = new PluginMetaSet(Optional.empty());
            for (PluginMeta meta : pluginMetas.getMetas()) {
                PluginAndCfgsSnapshot.collectAllPluginMeta(meta, collector);
            }
            return new PluginAndCfgsSnapshot(resName, processor.getResType(), globalPluginStoreLastModify, collector, metas.lastModifyTimestamp, metas);
        }).getValue();
    }

    public static Manifest createFlinkIncrJobManifestCfgAttrs(TargetResName collection, long timestamp) throws Exception {
        StoreResourceType resourceType = StoreResourceType.DataApp;
        RobustReflectionConverter2.PluginMetas pluginMetas = RobustReflectionConverter2.PluginMetas.collectMetas(metas -> {
            TISLicense.load(false);
            MQListenerFactory sourceFactory = HeteroEnum.getIncrSourceListenerFactory(DataXName.createDataXPipeline((String)collection.getName()));
            sourceFactory.create();
            IDataxProcessor processor = DataxProcessor.load(null, resourceType, collection.getName());
            TISSinkFactory incrSinKFactory = TISSinkFactory.getIncrSinKFactory(new DataXName(collection.getName(), resourceType));
            incrSinKFactory.createSinkFunction(processor, new IFlinkColCreator(){

                public Object build(IColMetaGetter meta, int colIndex) {
                    return null;
                }
            });
        });
        return PluginAndCfgsSnapshot.createFlinkIncrJobManifestCfgAttrs(resourceType, collection, timestamp, pluginMetas);
    }

    public static Pair<PluginAndCfgsSnapshot, Manifest> createManifestCfgAttrs2File(File manifestJar, StoreResourceType resourceType, TargetResName collection, long timestamp, Optional<Predicate<PluginMeta>> pluginMetasFilter, Map<String, String> extraEnvProps) throws Exception {
        Pair<PluginAndCfgsSnapshot, Manifest> manifestCfgAttrs = PluginAndCfgsSnapshot.createManifestCfgAttrs(resourceType, collection, timestamp, extraEnvProps, pluginMetasFilter, new IPluginMetasInfo(){});
        PluginAndCfgsSnapshotUtils.writeManifest2Jar(manifestJar, (Manifest)manifestCfgAttrs.getRight());
        return manifestCfgAttrs;
    }

    public static Manifest createFlinkIncrJobManifestCfgAttrs(StoreResourceType resourceType, final TargetResName collection, long timestamp, final IPluginMetasInfo appendPluginMeta) throws Exception {
        return PluginAndCfgsSnapshot.createManifestCfgAttrs(resourceType, collection, timestamp, Optional.empty(), new IPluginMetasInfo(){

            @Override
            public Set<PluginMeta> getMetas() {
                return Sets.union(appendPluginMeta.getMetas(), Collections.singleton(new PluginMeta("flink/" + collection.getName(), Config.getMetaProps().getVersion(), Optional.empty())));
            }

            @Override
            public Set<IRepositoryResource> getRepoResources() {
                return appendPluginMeta.getRepoResources();
            }
        });
    }

    public static Manifest createManifestCfgAttrs(StoreResourceType resourceType, TargetResName collection, long timestamp, Optional<Predicate<PluginMeta>> pluginMetasFilter, IPluginMetasInfo appendPluginMeta) throws Exception {
        return (Manifest)PluginAndCfgsSnapshot.createManifestCfgAttrs(resourceType, collection, timestamp, Collections.emptyMap(), pluginMetasFilter, appendPluginMeta).getRight();
    }

    public static Pair<PluginAndCfgsSnapshot, Manifest> createManifestCfgAttrs(StoreResourceType resourceType, TargetResName collection, long timestamp, Map<String, String> extraEnvProps, Optional<Predicate<PluginMeta>> pluginMetasFilter, IPluginMetasInfo appendPluginMeta) throws Exception {
        return PluginAndCfgsSnapshot.createManifestCfgAttrs(collection, resourceType, timestamp, extraEnvProps, () -> {
            PluginAndCfgsSnapshot localSnapshot = PluginAndCfgsSnapshot.getLocalPluginAndCfgsSnapshot(resourceType, collection, pluginMetasFilter, appendPluginMeta);
            return localSnapshot;
        });
    }

    public static Pair<PluginAndCfgsSnapshot, Manifest> createManifestCfgAttrs(TargetResName collection, StoreResourceType resourceType, long timestamp, Map<String, String> extraEnvProps, Supplier<PluginAndCfgsSnapshot> localPluginAndCfgsSnapshotCreator) throws Exception {
        if (!CenterResource.notFetchFromCenterRepository()) {
            throw new IllegalStateException("must not fetchFromCenterRepository");
        }
        Manifest manifest = new Manifest();
        Map<String, Attributes> entries = manifest.getEntries();
        Attributes attrs = new Attributes();
        attrs.put(new Attributes.Name(collection.getName()), String.valueOf(timestamp));
        attrs.put(new Attributes.Name("storeResType"), Objects.requireNonNull(resourceType, "resourceType can not be null").getType());
        entries.put(TIS_APP_NAME, attrs);
        Attributes cfgAttrs = new Attributes();
        Config.getInstance().visitKeyValPair(e -> {
            if ("tis.host".equals(e.getKey())) {
                return;
            }
            PluginAndCfgsSnapshot.addCfgAttrs(cfgAttrs, e);
        });
        for (Map.Entry<String, String> e2 : extraEnvProps.entrySet()) {
            PluginAndCfgsSnapshot.addCfgAttrs(cfgAttrs, e2);
        }
        cfgAttrs.put(new Attributes.Name(PluginAndCfgsSnapshot.convertCfgPropertyKey("tis.host", true)), Config.getTisHost());
        entries.put("env_props", cfgAttrs);
        PluginAndCfgsSnapshot localSnapshot = localPluginAndCfgsSnapshotCreator.get();
        localSnapshot.attachPluginCfgSnapshot2Manifest(manifest);
        return ImmutablePair.of((Object)localSnapshot, (Object)manifest);
    }

    private static void addCfgAttrs(Attributes cfgAttrs, Map.Entry<String, String> e) {
        cfgAttrs.put(new Attributes.Name(PluginAndCfgsSnapshot.convertCfgPropertyKey(e.getKey(), true)), e.getValue());
    }

    private static void collectAllPluginMeta(PluginMeta meta, PluginMetaSet collector) {
        collector.add(meta);
        List<PluginMeta> dpts = meta.getMetaDependencies();
        collector.addAll(dpts);
        for (PluginMeta m : dpts) {
            PluginAndCfgsSnapshot.collectAllPluginMeta(m, collector);
        }
    }

    public Set<String> getPluginNames() {
        return this.pluginMetas.stream().map(m -> m.getPluginName()).collect(Collectors.toSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void synchronizTpisAndConfs(PluginAndCfgsSnapshot localSnaphsot, Optional<PluginAndCfgsSnapshot> cacheSnaphsot) throws Exception {
        Class<TIS> clazz = TIS.class;
        synchronized (TIS.class) {
            logger.info("start synchronizTpisAndConfs,cacheSnaphsot.isPresent():" + cacheSnaphsot.isPresent() + ",TIS.initialized:" + TIS.initialized);
            this.synchronizTpisAndConfs(localSnaphsot);
            if (cacheSnaphsot.isPresent() && TIS.initialized) {
                this.updatePluginManager(cacheSnaphsot.get());
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    private void synchronizTpisAndConfs(PluginAndCfgsSnapshot localSnaphsot) throws Exception {
        if (!localSnaphsot.appMetas.isPresent()) {
            throw new IllegalArgumentException("localSnaphsot.appMetas must be present");
        }
        final StringBuffer updateTpisLogger = new StringBuffer("\nplugin synchronizTpisAndConfs------------------------------\n");
        Pair cfg = null;
        updateTpisLogger.append(">>global cfg compare:\n");
        for (Map.Entry<String, Long> entry : this.globalPluginStoreLastModify.entrySet()) {
            Long localTimestamp = localSnaphsot.globalPluginStoreLastModify.get(entry.getKey());
            if (localTimestamp != null && entry.getValue() <= localTimestamp) continue;
            cfg = CenterResource.copyFromRemote2Local((String)("tis_plugin_config/" + entry.getKey()), (boolean)true);
            FileUtils.writeStringToFile((File)PluginStore.getLastModifyTimeStampFile((File)cfg.getRight()), (String)String.valueOf(entry.getValue()), (Charset)TisUTF8.get());
            updateTpisLogger.append(entry.getKey()).append(localTimestamp == null ? "[" + entry.getValue() + "] local is none" : " center ver:" + entry.getValue() + " > local ver:" + localTimestamp).append((String)((Boolean)cfg.getKey() != false ? ",copy to " + ((File)cfg.getValue()).getAbsolutePath() : " skip to copy")).append("\n");
        }
        updateTpisLogger.append(">>app cfg compare:\n");
        updateTpisLogger.append("center:").append(this.appLastModifyTimestamp).append(this.appLastModifyTimestamp > localSnaphsot.appLastModifyTimestamp ? " > " : " <= ").append("local:").append(localSnaphsot.appLastModifyTimestamp).append("\n");
        if (this.appLastModifyTimestamp > localSnaphsot.appLastModifyTimestamp) {
            KeyedPluginStore.AppKey appKey = new KeyedPluginStore.AppKey(null, this.resType, this.collection.getName(), (KeyedPluginStore.PluginClassCategory)null);
            URL appCfgUrl = CenterResource.getPathURL((String)"cfg_repo", (String)("tis_plugin_config/" + appKey.getSubDirPath()));
            updateTpisLogger.append("app cfg url:" + appCfgUrl + " config file enum:");
            final KeyedPluginStore.PluginMetas appMetas = localSnaphsot.appMetas.get();
            HttpUtils.get((URL)appCfgUrl, (ConfigFileContext.StreamProcess)new ConfigFileContext.StreamProcess<Void>(){

                public Void p(int status, InputStream stream, Map<String, List<String>> headerFields) {
                    try {
                        FileUtils.deleteQuietly((File)appMetas.appDir);
                        ZipInputStream zipInput = new ZipInputStream(stream);
                        ZipEntry entry = null;
                        while ((entry = zipInput.getNextEntry()) != null) {
                            try (FileOutputStream output = FileUtils.openOutputStream((File)new File(appMetas.appDir, entry.getName()));){
                                updateTpisLogger.append(entry.getName()).append(",");
                                IOUtils.copy((InputStream)zipInput, (OutputStream)output);
                            }
                            zipInput.closeEntry();
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    return null;
                }
            });
            updateTpisLogger.append("\n");
        }
        Set<PluginMeta> result = this.getShallUpdatePluginMeta(localSnaphsot, updateTpisLogger);
        int copyCount = 0;
        for (PluginMeta update : result) {
            if (!update.copyFromRemote(Collections.emptyList(), true, true)) continue;
            ++copyCount;
        }
        updateTpisLogger.append("success synchronized files count:" + copyCount).append("\n");
        logger.info(updateTpisLogger.append("\n------------------------------").toString());
    }

    private void updatePluginManager(PluginAndCfgsSnapshot localCacheSnaphsot) throws Exception {
        StringBuffer updateTpisLogger = new StringBuffer("\nplugin updatePluginManager synchronize------------------------------\n");
        Set<PluginMeta> result = this.getShallUpdatePluginMeta(localCacheSnaphsot, updateTpisLogger);
        try {
            TIS tis = TIS.get();
            PluginManager pluginManager = tis.getPluginManager();
            HashSet loaded = Sets.newHashSet();
            PluginWrapperList batch = new PluginWrapperList();
            for (PluginMeta update : result) {
                this.dynamicLoad(pluginManager, update, batch, result, loaded);
            }
            if (batch.size() > 0) {
                pluginManager.start(batch);
                updateTpisLogger.append("\ndynamic reload plugins:" + batch.getBatchNames());
                Thread.sleep(3000L);
                TIS.cleanPluginStore();
                tis.cleanExtensionCache();
            }
        }
        catch (Exception e) {
            logger.error(updateTpisLogger.append("\n------------------------------").toString());
            throw e;
        }
        logger.info(updateTpisLogger.append("\n------------------------------").toString());
    }

    private Set<PluginMeta> getShallUpdatePluginMeta(PluginAndCfgsSnapshot localSnaphsot, StringBuffer updateTpisLogger) {
        HashSet<PluginMeta> result = new HashSet<PluginMeta>();
        updateTpisLogger.append(">>center repository:").append(this.pluginMetas.stream().map(meta -> meta.toString()).collect(Collectors.joining(",")));
        updateTpisLogger.append("\n>>local:").append(localSnaphsot.pluginMetas.stream().map(meta -> meta.toString()).collect(Collectors.joining(","))).append("\n");
        updateTpisLogger.append(">>compare result\n");
        Map<String, PluginMeta> locals = localSnaphsot.pluginMetas.stream().collect(Collectors.toMap(m -> m.getKey(), m -> m));
        PluginMeta m2 = null;
        for (PluginMeta meta2 : this.pluginMetas) {
            if (IFlinkCluster.SKIP_PLUGIN_NAMES.contains(meta2.getPluginName()) || (m2 = locals.get(meta2.getKey())) != null && meta2.getLastModifyTimeStamp() <= m2.getLastModifyTimeStamp()) continue;
            result.add(meta2);
            updateTpisLogger.append(meta2.getKey()).append((String)(m2 == null ? " local is none" : " center repository ver:" + meta2.getLastModifyTimeStamp() + " > local ver:" + m2.getLastModifyTimeStamp())).append("\n");
        }
        return result;
    }

    private void dynamicLoad(PluginManager pluginManager, PluginMeta update, PluginWrapperList batch, Set<PluginMeta> shallUpdate, Set<PluginMeta> loaded) {
        try {
            for (PluginMeta dpt : update.getMetaDependencies()) {
                this.dynamicLoad(pluginManager, dpt, batch, shallUpdate, loaded);
            }
            if (shallUpdate.contains(update) && loaded.add(update)) {
                pluginManager.dynamicLoad(update.getPluginPackageFile(), true, batch);
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public TargetResName getAppName() {
        return this.collection;
    }

    public static PluginAndCfgsSnapshot deserializePluginAndCfgsSnapshot(TargetResName app, StoreResourceType resourceType, Manifest manifest) {
        HashMap globalPluginStoreLastModify = Maps.newHashMap();
        Attributes pluginMetas = manifest.getAttributes("pluginMetas");
        String[] globalPluginStoreSeri = StringUtils.split((String)pluginMetas.getValue("globalPluginStore"), (String)",");
        String[] file2timestamp = null;
        for (String p : globalPluginStoreSeri) {
            file2timestamp = StringUtils.split((String)p, (String)"@");
            if (file2timestamp.length != 2) {
                throw new IllegalStateException("file2timestamp length must be 2,val:" + p);
            }
            globalPluginStoreLastModify.put(file2timestamp[0], Long.parseLong(file2timestamp[1]));
        }
        JSONArray ms = null;
        String metsAttr = null;
        try {
            metsAttr = pluginMetas.getValue("pluginMetas");
            ms = JSONArray.parseArray((String)metsAttr);
        }
        catch (Exception e) {
            throw new RuntimeException("illegal metaAttr:" + metsAttr, e);
        }
        final List<PluginMeta> metas = PluginMeta.parse((String[])JsonUtil.toArray(String.class, (JSONArray)ms));
        metas.forEach(meta -> {
            if (meta.isLastModifyTimeStampNull()) {
                throw new IllegalStateException("pluginMeta:" + meta.getKey() + " relevant LastModify timestamp can not be null");
            }
        });
        return new PluginAndCfgsSnapshot(app, resourceType, globalPluginStoreLastModify, new IPluginMetasInfo(){

            @Override
            public Set<PluginMeta> getMetas() {
                return Sets.newHashSet((Iterable)metas);
            }
        }, Long.parseLong(pluginMetas.getValue("appLastModifyTimestamp")), null);
    }

    public static PluginAndCfgsSnapshot getWorkerPluginAndCfgsSnapshot(StoreResourceType resourceType, TargetResName collection, Set<PluginMeta> appendPluginMeta) {
        return PluginAndCfgsSnapshot.getLocalPluginAndCfgsSnapshot(resourceType, collection, (pluginMetas, dataxComponentMeta) -> {
            PluginMetaSet collector = new PluginMetaSet(Optional.empty());
            File pluginDir = PluginAndCfgsSnapshot.getPluginRootDir();
            Collection tpis = FileUtils.listFiles((File)pluginDir, (String[])new String[]{"tpi"}, (boolean)false);
            tpis.forEach(tpi -> {
                PluginManifest manifest = PluginManifest.create(tpi);
                if (manifest != null) {
                    collector.add(manifest.getPluginMeta());
                }
            });
            for (PluginMeta m : appendPluginMeta) {
                PluginAndCfgsSnapshot.collectAllPluginMeta(m, collector);
            }
            return collector;
        });
    }

    public static File getPluginRootDir() {
        return new File(Config.getLibDir(), "plugins");
    }

    private static PluginAndCfgsSnapshot getLocalPluginAndCfgsSnapshot(StoreResourceType resourceType, TargetResName collection, Optional<Predicate<PluginMeta>> pluginMetasFilter, IPluginMetasInfo appendPluginMeta) {
        return PluginAndCfgsSnapshot.getLocalPluginAndCfgsSnapshot(resourceType, collection, (pluginMetas, dataxComponentMeta) -> {
            appendPluginMeta.getRepoResources().forEach(res -> dataxComponentMeta.addResource((IRepositoryResource)res));
            PluginMetaSet collector = new PluginMetaSet(pluginMetasFilter);
            for (PluginMeta m : pluginMetas.metas) {
                PluginAndCfgsSnapshot.collectAllPluginMeta(m, collector);
            }
            Set<PluginMeta> globalPluginMetas = dataxComponentMeta.loadPluginMeta();
            for (PluginMeta m : globalPluginMetas) {
                PluginAndCfgsSnapshot.collectAllPluginMeta(m, collector);
            }
            for (PluginMeta m : appendPluginMeta.getMetas()) {
                PluginAndCfgsSnapshot.collectAllPluginMeta(m, collector);
            }
            return collector;
        });
    }

    private static PluginAndCfgsSnapshot getLocalPluginAndCfgsSnapshot(StoreResourceType resourceType, TargetResName collection, MetaSetProductor metaSetProductor) {
        KeyedPluginStore.PluginMetas pluginMetas = KeyedPluginStore.getAppAwarePluginMetas(resourceType, collection.getName());
        Map<String, Long> gPluginStoreLastModify = Collections.emptyMap();
        UploadPluginMeta upm = UploadPluginMeta.parse("x:require", true);
        TIS tis = TIS.get();
        List<IRepositoryResource> keyedPluginStores = Collections.emptyList();
        if (tis != null) {
            ExtensionList<HeteroEnum> hlist = TIS.get().getExtensionList(HeteroEnum.class);
            keyedPluginStores = hlist.stream().filter(e -> !e.isAppNameAware() && e != HeteroEnum.PARAMS_CONFIG_USER_ISOLATION).flatMap(e -> e.getPluginStore(null, upm).getAll().stream()).collect(Collectors.toList());
        }
        ComponentMeta dataxComponentMeta = new ComponentMeta(keyedPluginStores);
        PluginMetaSet pluginMetaSet = metaSetProductor.call(pluginMetas, dataxComponentMeta);
        gPluginStoreLastModify = ComponentMeta.getGlobalPluginStoreLastModifyTimestamp(dataxComponentMeta);
        try {
            return new PluginAndCfgsSnapshot(collection, resourceType, gPluginStoreLastModify, pluginMetaSet, pluginMetas.lastModifyTimestamp, pluginMetas);
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    public void attachPluginCfgSnapshot2Manifest(Manifest manifest) {
        Map<String, Attributes> entries = manifest.getEntries();
        StringBuffer globalPluginStore = new StringBuffer();
        for (Map.Entry<String, Long> e : this.globalPluginStoreLastModify.entrySet()) {
            globalPluginStore.append(e.getKey()).append("@").append(e.getValue()).append(",");
        }
        Attributes pmetas = new Attributes();
        pmetas.put(new Attributes.Name("globalPluginStore"), String.valueOf(globalPluginStore));
        PluginManager pluginManager = TIS.get().getPluginManager();
        Map<String, PluginWrapper> plugins = pluginManager.getActivePluginsMap();
        JSONArray jarray = new JSONArray();
        this.pluginMetas.forEach(meta -> {
            Optional<PluginClassifier> classifier;
            meta.getLastModifyTimeStamp();
            PluginWrapper plugin = (PluginWrapper)plugins.get(meta.getPluginName());
            if (plugin != null && (classifier = plugin.getClassifier()).isPresent()) {
                meta.setClassifier(classifier.get());
            }
            jarray.add((Object)meta.toString());
        });
        String pluginMetas = jarray.toJSONString();
        logger.info("collected pluginMetas:" + pluginMetas);
        pmetas.put(new Attributes.Name("pluginMetas"), pluginMetas);
        pmetas.put(new Attributes.Name("appLastModifyTimestamp"), String.valueOf(this.appLastModifyTimestamp));
        entries.put("pluginMetas", pmetas);
    }

    private static class PluginMetaSet
    implements IPluginMetasInfo {
        private HashSet<PluginMeta> metas = Sets.newHashSet();
        private Set<IRepositoryResource> repoRes = Sets.newHashSet();
        final Optional<Predicate<PluginMeta>> pluginMetasFilter;

        public PluginMetaSet(Optional<Predicate<PluginMeta>> pluginMetasFilter) {
            this.pluginMetasFilter = pluginMetasFilter;
        }

        @Override
        public Set<PluginMeta> getMetas() {
            return this.pluginMetasFilter.isPresent() ? this.metas.stream().filter(this.pluginMetasFilter.get()).collect(Collectors.toSet()) : this.metas;
        }

        @Override
        public Set<IRepositoryResource> getRepoResources() {
            return this.repoRes;
        }

        public boolean add(PluginMeta meta) {
            Iterator<PluginMeta> it = this.metas.iterator();
            PluginMeta m = null;
            while (it.hasNext()) {
                m = it.next();
                if (!StringUtils.equals((String)meta.getPluginName(), (String)m.getPluginName())) continue;
                if (meta.ver.compareTo(m.ver) > 0) {
                    it.remove();
                    return this.metas.add(meta);
                }
                return false;
            }
            return this.metas.add(meta);
        }

        public boolean addAll(Collection<PluginMeta> c) {
            for (PluginMeta m : c) {
                this.add(m);
            }
            return true;
        }
    }

    static interface MetaSetProductor {
        public PluginMetaSet call(KeyedPluginStore.PluginMetas var1, ComponentMeta var2);
    }

    public static class PluginWrapperList {
        List<PluginWrapper> batch = Lists.newArrayList();
        Set<String> addPluginNams = Sets.newHashSet();

        public PluginWrapperList() {
        }

        public PluginWrapperList(PluginWrapper pluginWrapper) {
            this.add(pluginWrapper);
        }

        public PluginWrapperList(List<PluginWrapper> plugins) {
            plugins.forEach(p -> this.add((PluginWrapper)p));
        }

        public void add(PluginWrapper plugin) {
            if (this.addPluginNams.add(plugin.getShortName())) {
                this.batch.add(plugin);
            }
        }

        public List<PluginWrapper> getPlugins() {
            return this.batch;
        }

        public Map<String, PluginWrapper> getPluginsByName() {
            return this.batch.stream().collect(Collectors.toMap(PluginWrapper::getShortName, p -> p));
        }

        public Set<ClassLoader> getLoaders() {
            return this.batch.stream().map(p -> p.classLoader).collect(Collectors.toSet());
        }

        public int size() {
            return this.batch.size();
        }

        public String getBatchNames() {
            return this.batch.stream().map(p -> p.getShortName()).collect(Collectors.joining(","));
        }

        public boolean contains(PluginWrapper depender) {
            for (PluginWrapper wrapper : this.batch) {
                if (!StringUtils.equals((String)wrapper.getShortName(), (String)depender.getShortName())) continue;
                return true;
            }
            return false;
        }
    }
}

