/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.plugin;

import com.qlangtech.tis.coredefine.module.action.TargetResName;
import com.qlangtech.tis.fullbuild.phasestatus.PhaseStatusCollection;
import com.qlangtech.tis.plugin.PluginAndCfgsSnapshot;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;

public class PluginAndCfgSnapshotLocalCache {
    private final Map<String, PluginAndCfgsSnapshot> localCache;
    private final Map<Integer, PhaseStatusCollection> taskPreviousStatusCache = new WeakHashMap<Integer, PhaseStatusCollection>();

    public PluginAndCfgSnapshotLocalCache() {
        this.localCache = new ConcurrentHashMap<String, PluginAndCfgsSnapshot>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PhaseStatusCollection getPreviousStatus(Integer currentTaskId, Supplier<PhaseStatusCollection> statSupplier) {
        Map<Integer, PhaseStatusCollection> map = this.taskPreviousStatusCache;
        synchronized (map) {
            PhaseStatusCollection status = this.taskPreviousStatusCache.get(currentTaskId);
            if (status == null && (status = statSupplier.get()) != null) {
                this.taskPreviousStatusCache.put(currentTaskId, status);
            }
            return status;
        }
    }

    public void processLocalCache(TargetResName appName, Function<Optional<PluginAndCfgsSnapshot>, PluginAndCfgsSnapshot> snapshotProcessor) {
        PluginAndCfgsSnapshot snapshot = snapshotProcessor.apply(Optional.ofNullable(this.localCache.get(appName.getName())));
        this.localCache.put(appName.getName(), snapshot);
    }
}

