/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.plugin;

import com.alibaba.citrus.turbine.Context;
import com.google.common.collect.Lists;
import com.qlangtech.tis.TIS;
import com.qlangtech.tis.datax.StoreResourceType;
import com.qlangtech.tis.datax.impl.DataxReader;
import com.qlangtech.tis.extension.Describable;
import com.qlangtech.tis.extension.Descriptor;
import com.qlangtech.tis.extension.impl.XmlFile;
import com.qlangtech.tis.manage.common.TisUTF8;
import com.qlangtech.tis.plugin.ComponentMeta;
import com.qlangtech.tis.plugin.PluginStore;
import com.qlangtech.tis.plugin.SetPluginsResult;
import com.qlangtech.tis.util.IPluginContext;
import com.qlangtech.tis.util.PluginMeta;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;

public class KeyedPluginStore<T extends Describable>
extends PluginStore<T> {
    public static final String TMP_DIR_NAME = ".tmp/";
    public static final String KEY_EXEC_ID = "execId";
    private static final Pattern DATAX_UPDATE_PATH = Pattern.compile("\\?execId=.+?");
    public final transient Key key;

    public static void main(String[] args) {
        Matcher matcher = DATAX_UPDATE_PATH.matcher("/offline/wf_profile_update/update?execId=e5bad69e-d519-5799-c798-f593eb0555f2#writer");
        System.out.println(matcher.find());
    }

    public static <TT extends Describable> KeyedPluginStore<TT> getPluginStore(DataxReader.SubFieldFormAppKey<TT> subFieldFormKey) {
        return TIS.dataXReaderSubFormPluginStore.get(subFieldFormKey);
    }

    static File getLastModifyToken(Key appKey) {
        File appDir = KeyedPluginStore.getSubPathDir(appKey);
        File lastModify = new File(appDir, ".lastmodified");
        return lastModify;
    }

    public static PluginMetas getAppAwarePluginMetas(boolean isDB, String name) {
        return KeyedPluginStore.getAppAwarePluginMetas(StoreResourceType.parse((boolean)isDB), name);
    }

    public static PluginMetas getAppAwarePluginMetas(StoreResourceType resourceType, String name) {
        return KeyedPluginStore.getAppAwarePluginMetas(resourceType, name, true);
    }

    public static PluginMetas getAppAwarePluginMetas(StoreResourceType resourceType, String name, boolean resolveMeta) {
        AppKey appKey = new AppKey(null, resourceType, name, (PluginClassCategory)null);
        File appDir = KeyedPluginStore.getSubPathDir(appKey);
        File lastModify = KeyedPluginStore.getLastModifyToken(appKey);
        long lastModfiyTimeStamp = -1L;
        Set<PluginMeta> metas = Collections.emptySet();
        try {
            if (appDir.exists()) {
                if (lastModify.exists()) {
                    lastModfiyTimeStamp = Long.parseLong(FileUtils.readFileToString((File)lastModify, (Charset)TisUTF8.get()));
                }
                if (resolveMeta) {
                    Iterator files = FileUtils.iterateFiles((File)appDir, (String[])new String[]{"xml"}, (boolean)true);
                    metas = ComponentMeta.loadPluginMeta(() -> Lists.newArrayList((Iterator)files));
                }
            }
            return new PluginMetas(appDir, metas, lastModfiyTimeStamp);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static File getSubPathDir(Key appKey) {
        return new File(TIS.pluginCfgRoot, appKey.getSubDirPath());
    }

    public KeyedPluginStore(Key key, PluginStore.IPluginProcessCallback<T> ... pluginCreateCallback) {
        super(key.pluginClass.getClazz(), key.getSotreFile(), pluginCreateCallback);
        this.key = key;
    }

    @Override
    public List<T> getPlugins() {
        List plugins = super.getPlugins();
        for (Describable plugin : plugins) {
            if (!(plugin instanceof IPluginKeyAware)) continue;
            ((IPluginKeyAware)((Object)plugin)).setKey(this.key);
        }
        return plugins;
    }

    @Override
    public synchronized SetPluginsResult setPlugins(IPluginContext pluginContext, Optional<Context> context, List<Descriptor.ParseDescribable<T>> dlist, boolean update) {
        SetPluginsResult updateResult = super.setPlugins(pluginContext, context, dlist, update);
        if (updateResult.success && updateResult.cfgChanged) {
            updateResult.lastModifyTimeStamp = this.writeLastModifyTimeStamp();
        }
        return updateResult;
    }

    @Override
    public long writeLastModifyTimeStamp() {
        return this.writeLastModifyTimeStamp(KeyedPluginStore.getLastModifyToken(this.key));
    }

    @Override
    public File getLastModifyTimeStampFile() {
        return new File(KeyedPluginStore.getSubPathDir(this.key), ".lastmodified");
    }

    @Override
    protected String getSerializeFileName() {
        return this.key.getSerializeFileName();
    }

    public static class AppKey<TT extends Describable>
    extends Key<TT> {
        public final StoreResourceType resourceType;

        public AppKey(IPluginContext pluginContext, StoreResourceType resourceType, String appname, Class<TT> clazz) {
            this(pluginContext, resourceType, appname, new PluginClassCategory<TT>(clazz));
        }

        public AppKey(IPluginContext pluginContext, StoreResourceType resourceType, String appname, PluginClassCategory<TT> clazz) {
            this(AppKey.calAppName(pluginContext, appname), resourceType, clazz);
        }

        public AppKey(KeyVal keyVal, StoreResourceType resourceType, PluginClassCategory<TT> clazz) {
            super(resourceType.getType(), keyVal, clazz, resourceType.useMetaCfgDir);
            this.resourceType = resourceType;
        }

        public boolean isDB() {
            return this.resourceType == StoreResourceType.DataBase;
        }

        public static KeyVal calAppName(IPluginContext pluginContext, String appname) {
            return AppKey.calAppName(pluginContext, appname, Optional.empty());
        }

        public static KeyVal calAppName(IPluginContext pluginContext, String appname, Optional<String> subPath) {
            return AppKey.calAppName(pluginContext, appname, subPath, true);
        }

        public static KeyVal calAppName(IPluginContext pluginContext, String appname, Optional<String> subPath, boolean updateAware) {
            if (pluginContext == null) {
                return new KeyVal(appname, Objects.requireNonNull(subPath, "subPath can not be null"));
            }
            String referer = StringUtils.trimToEmpty((String)pluginContext.getRequestHeader("Referer"));
            Matcher configPathMatcher = DATAX_UPDATE_PATH.matcher(referer);
            boolean inUpdateProcess = configPathMatcher.find();
            if (inUpdateProcess && !pluginContext.isCollectionAware()) {
                throw new IllegalStateException("pluginContext.isCollectionAware() must be true");
            }
            return updateAware && pluginContext != null && inUpdateProcess ? new KeyVal(appname, pluginContext.getExecId(), subPath) : new KeyVal(appname, subPath);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.keyVal.getKeyVal(), this.resourceType.getType(), this.pluginClass);
        }
    }

    public static class KeyVal {
        private final String val;
        protected final String suffix;
        protected final Optional<String> subPath;

        public KeyVal(String val, String suffix) {
            this(val, suffix, Optional.empty());
        }

        public KeyVal(String val, String suffix, Optional<String> subPath) {
            if (StringUtils.isEmpty((String)val)) {
                throw new IllegalArgumentException("param 'key' can not be null");
            }
            this.val = val;
            this.suffix = suffix;
            this.subPath = subPath;
        }

        public KeyVal(String val) {
            this(val, Optional.empty());
        }

        public KeyVal(String val, Optional<String> subPath) {
            this(val, "", subPath);
        }

        public String toString() {
            return this.getKeyVal();
        }

        public String getKeyVal() {
            StringBuffer keyVal = new StringBuffer((String)(StringUtils.isBlank((String)this.suffix) ? this.getVal() : KeyedPluginStore.TMP_DIR_NAME + this.getVal() + "-" + this.suffix));
            this.subPath.ifPresent(sub -> keyVal.append(File.separator).append((String)sub));
            return keyVal.toString();
        }

        public String getVal() {
            return this.val;
        }

        public String getSuffix() {
            return this.suffix;
        }
    }

    public static class PluginClassCategory<T> {
        private final Class<T> pluginClass;
        private final Optional<String> suffix;

        public PluginClassCategory(Class<T> pluginClass) {
            this(pluginClass, Optional.empty());
        }

        public PluginClassCategory(Class<T> pluginClass, String suffix) {
            this(pluginClass, Optional.of(suffix));
        }

        private PluginClassCategory(Class<T> pluginClass, Optional<String> suffix) {
            this.pluginClass = pluginClass;
            this.suffix = suffix;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PluginClassCategory that = (PluginClassCategory)o;
            return Objects.equals(this.hashCode(), that.hashCode());
        }

        public int hashCode() {
            if (this.suffix.isPresent()) {
                return Objects.hash(this.pluginClass, this.suffix.get());
            }
            return Objects.hash(this.pluginClass);
        }

        public String getName() {
            return this.pluginClass.getName() + this.suffix.orElse("");
        }

        public Class<T> getClazz() {
            return this.pluginClass;
        }
    }

    public static class Key<T extends Describable> {
        public final KeyVal keyVal;
        protected final String groupName;
        private final boolean metaCfgDir;
        public final PluginClassCategory<T> pluginClass;

        public Key(String groupName, String keyVal, Class<T> pluginClass) {
            this(groupName, new KeyVal(keyVal), pluginClass, false);
        }

        public Key(String groupName, KeyVal keyVal, Class<T> pluginClass) {
            this(groupName, keyVal, pluginClass, false);
        }

        public Key(String groupName, KeyVal keyVal, Class<T> pluginClass, boolean metaCfgDir) {
            this(groupName, keyVal, new PluginClassCategory<T>(pluginClass), metaCfgDir);
        }

        public Key(String groupName, KeyVal keyVal, PluginClassCategory<T> pluginClass, boolean metaCfgDir) {
            Objects.requireNonNull(keyVal, "keyVal can not be null");
            this.keyVal = keyVal;
            this.pluginClass = pluginClass;
            this.groupName = groupName;
            this.metaCfgDir = metaCfgDir;
        }

        public String getSerializeFileName() {
            return this.getSubDirPath() + File.separator + this.pluginClass.getName();
        }

        public final String getSubDirPath() {
            return this.groupName + File.separator + this.keyVal.getKeyVal();
        }

        public XmlFile getSotreFile() {
            return Descriptor.getConfigFile(this.getSerializeFileName(), this.metaCfgDir);
        }

        public final boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return this.hashCode() == key.hashCode();
        }

        public int hashCode() {
            return Objects.hash(this.keyVal.getKeyVal(), this.pluginClass.hashCode());
        }
    }

    public static interface IPluginKeyAware {
        public void setKey(Key var1);
    }

    public static class PluginMetas {
        public static final String KEY_GLOBAL_PLUGIN_STORE = "globalPluginStore";
        public static final String KEY_PLUGIN_META = "pluginMetas";
        public static final String KEY_APP_LAST_MODIFY_TIMESTAMP = "appLastModifyTimestamp";
        public final Set<PluginMeta> metas;
        public final long lastModifyTimestamp;
        public final File appDir;

        public PluginMetas(File appDir, Set<PluginMeta> metas, long lastModifyTimestamp) {
            this.metas = metas;
            this.lastModifyTimestamp = lastModifyTimestamp;
            this.appDir = appDir;
        }
    }
}

