/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.plugin;

import com.alibaba.fastjson.JSONObject;
import com.qlangtech.tis.extension.impl.IOUtils;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public interface IEndTypeGetter {
    default public PluginVender getVender() {
        return PluginVender.TIS;
    }

    public static void main(String[] args) {
        for (EndType value : EndType.values()) {
            System.out.print(value.val + ",");
        }
    }

    default public EndType getEndType() {
        return EndType.Blank;
    }

    public static class DefaultIconReference
    implements Icon,
    IconReference {
        private final EndType endType;

        public DefaultIconReference(EndType endType) {
            this.endType = endType;
        }

        @Override
        public EndType endType() {
            return this.endType;
        }

        @Override
        public boolean setRes(JSONObject icon, boolean fillStyle) {
            icon.put("ref", (Object)this.endType.getVal());
            return true;
        }

        @Override
        public String fillType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String outlineType() {
            throw new UnsupportedOperationException();
        }
    }

    public static interface IconReference {
        public static final String KEY_RESOURCE_REFERENCE = "ref";

        public EndType endType();
    }

    public static interface Icon {
        public String fillType();

        public String outlineType();

        public boolean setRes(JSONObject var1, boolean var2);
    }

    public static enum EndType implements IEndType
    {
        MySQL("mysql", EndTypeCategory.Data, true, Optional.of("\u5f00\u6e90\u5173\u7cfb\u578b\u6570\u636e\u5e93\uff0c\u5b98\u7f51\uff1ahttps://www.mysql.com/")),
        OceanBase("oceanbase", EndTypeCategory.Data, true, Optional.of("\u963f\u91cc\u5df4\u5df4\u81ea\u7814\u5206\u5e03\u5f0f\u6570\u636e\u5e93\uff0c\u5b98\u7f51\uff1ahttps://www.oceanbase.com/")),
        Paimon("paimon", EndTypeCategory.Data, true, Optional.of("Apache\u6d41\u6279\u7edf\u4e00\u5b58\u50a8\uff0c\u5b98\u7f51\uff1ahttps://paimon.apache.org/")),
        MariaDB("mariaDB", EndTypeCategory.Data, true, Optional.of("MySQL\u793e\u533a\u5206\u652f\uff0c\u5b98\u7f51\uff1ahttps://mariadb.org/")),
        Postgres("pg", EndTypeCategory.Data, true, Optional.of("PostgreSQL\u5bf9\u8c61\u5173\u7cfb\u578b\u6570\u636e\u5e93\uff0c\u5b98\u7f51\uff1ahttps://www.postgresql.org/")),
        Oracle("oracle", EndTypeCategory.Data, true, Optional.of("\u7532\u9aa8\u6587\u516c\u53f8\u5546\u4e1a\u6570\u636e\u5e93\uff0c\u5b98\u7f51\uff1ahttps://www.oracle.com/database/")),
        ElasticSearch("es", EndTypeCategory.Data, true, Optional.of("Elastic\u641c\u7d22\u5206\u6790\u5f15\u64ce\uff0c\u5b98\u7f51\uff1ahttps://www.elastic.co/")),
        MongoDB("mongoDB", EndTypeCategory.Data, true, Optional.of("\u6587\u6863\u578bNoSQL\u6570\u636e\u5e93\uff0c\u5b98\u7f51\uff1ahttps://www.mongodb.com/")),
        StarRocks("starRocks", EndTypeCategory.Data, true, Optional.of("\u6781\u901fMPP\u5206\u6790\u6570\u636e\u5e93\uff0c\u5b98\u7f51\uff1ahttps://www.starrocks.io/")),
        Doris("doris", EndTypeCategory.Data, true, Optional.of("Apache\u5b9e\u65f6\u5206\u6790\u6570\u636e\u5e93\uff0c\u5b98\u7f51\uff1ahttps://doris.apache.org/")),
        KingBase("kingbase", EndTypeCategory.Data, true, Optional.of("\u4eba\u5927\u91d1\u4ed3\u56fd\u4ea7\u6570\u636e\u5e93\uff0c\u5b98\u7f51\uff1ahttps://www.kingbase.com.cn/")),
        Clickhouse("clickhouse", EndTypeCategory.Data, true, Optional.of("Yandex\u5217\u5f0f\u5206\u6790\u6570\u636e\u5e93\uff0c\u5b98\u7f51\uff1ahttps://clickhouse.com/")),
        Hudi("hudi", EndTypeCategory.Data, true, Optional.of("Apache\u589e\u91cf\u6570\u636e\u6e56\uff0c\u5b98\u7f51\uff1ahttps://hudi.apache.org/")),
        TDFS("t-dfs", EndTypeCategory.Data, true, Optional.of("\u672c\u5730\u6587\u672c\u3001\u963f\u91cc\u4e91OSS\u3001HDFS\u3001FTP\u6570\u636e\uff08\u652f\u6301text\uff0ccsv\u7b49\u683c\u5f0f\uff09")),
        SqlServer("sqlServer", EndTypeCategory.Data, true, Optional.of("\u5fae\u8f6f\u5173\u7cfb\u578b\u6570\u636e\u5e93\uff0c\u5b98\u7f51\uff1ahttps://www.microsoft.com/sql-server/")),
        TiDB("TiDB", EndTypeCategory.Data, true, Optional.of("PingCAP NewSQL\u6570\u636e\u5e93\uff0c\u5b98\u7f51\uff1ahttps://www.pingcap.com/")),
        RocketMQ("rocketMq", EndTypeCategory.Data, true, Optional.of("Apache\u5206\u5e03\u5f0f\u6d88\u606f\u7cfb\u7edf\uff0c\u5b98\u7f51\uff1ahttps://rocketmq.apache.org/")),
        Kafka("kafka", EndTypeCategory.Data, true, Optional.of("Apache\u6d41\u5904\u7406\u5e73\u53f0\uff0c\u5b98\u7f51\uff1ahttps://kafka.apache.org/")),
        DaMeng("daMeng", EndTypeCategory.Data, true, Optional.of("\u8fbe\u68a6\u6570\u636e\u5e93\uff0chttps://www.dameng.com/")),
        AliyunODPS("aliyunOdps", EndTypeCategory.Data, true, Optional.of("\u963f\u91cc\u4e91MaxCompute\uff0c\u5b98\u7f51\uff1ahttps://www.aliyun.com/product/odps")),
        HiveMetaStore("hms", EndTypeCategory.Data, true, Optional.of("Hive\u5143\u6570\u636e\u670d\u52a1\uff0c\u5b98\u7f51\uff1ahttps://hive.apache.org/")),
        Spark("spark", EndTypeCategory.Data, true, Optional.of("Apache\u7edf\u4e00\u5206\u6790\u5f15\u64ce\uff0c\u5b98\u7f51\uff1ahttps://spark.apache.org/")),
        RabbitMQ("rabbitmq", EndTypeCategory.Data, true, Optional.of("Erlang\u6d88\u606f\u961f\u5217\uff0c\u5b98\u7f51\uff1ahttps://www.rabbitmq.com/")),
        PowerJob("powerjob", EndTypeCategory.Assist, true),
        Flink("flink", EndTypeCategory.Assist, true),
        RateController("rate-controller", EndTypeCategory.Assist, true),
        Docker("docker", EndTypeCategory.Assist, true),
        K8S("k8s", EndTypeCategory.Assist, true),
        Dolphinscheduler("ds", EndTypeCategory.Assist, true),
        Deepseek("deepseek", EndTypeCategory.Assist, true),
        QWen("qwen", EndTypeCategory.Assist, true),
        UserProfile("user-profile", EndTypeCategory.Assist, true),
        Pipeline("pipeline", EndTypeCategory.Assist, true),
        Workflow("workflow", EndTypeCategory.Assist, true),
        DingTalk("dingding", EndTypeCategory.Alert, true),
        WeCom("weCom", EndTypeCategory.Alert, true),
        Lark("lark", EndTypeCategory.Alert, true),
        Email("email", EndTypeCategory.Alert, true),
        Http("http", EndTypeCategory.Alert, true),
        Alert("tis-alert", EndTypeCategory.Alert, true),
        HttpProxy("http-proxy", EndTypeCategory.Assist, true),
        Aliyun("aliyun", EndTypeCategory.Assist, true),
        UnKnowStoreType("unknowStoreType", EndTypeCategory.Icon, true),
        BatchComputing("batch-computing", EndTypeCategory.Icon, true),
        StreamComputing("stream-computing", EndTypeCategory.Icon, true),
        BliBli("blibli", EndTypeCategory.Icon, true),
        Hand("hand", EndTypeCategory.Icon, true),
        Preview("preview", EndTypeCategory.Icon, true),
        Clone("clone", EndTypeCategory.Icon, true),
        Blank("blank", EndTypeCategory.Icon, true),
        Stop("tis-stop", EndTypeCategory.Icon, true),
        Link("tis-link", EndTypeCategory.Icon, true),
        Replace("replace", EndTypeCategory.Transformer, true),
        Concat("concat", EndTypeCategory.Transformer, true),
        Mask("mask", EndTypeCategory.Transformer, true),
        Splitter("splitter", EndTypeCategory.Transformer, true),
        SubString("substr", EndTypeCategory.Transformer, true),
        AutoGen("auto-generate", EndTypeCategory.Transformer, true),
        Copy("clone", EndTypeCategory.Transformer, true),
        Constant("constant", EndTypeCategory.Transformer, true),
        License("license", EndTypeCategory.Icon, true);

        private final String val;
        private final boolean containICON;
        public final EndTypeCategory category;
        private final Optional<String> desc;
        private static final DefaultIconReference unknowStorageType;
        public static String KEY_END_TYPE;
        public static String KEY_END_TYPE_DESC;
        public static String KEY_SUPPORT_ICON;
        private static Set<EndType> _dataEnds;
        private static Set<EndType> _assistTypes;
        private static Set<EndType> _transformerTypes;
        private static Set<EndType> _alertTypes;
        private Icon icon;

        public static EndType parse(String endType) {
            return EndType.parse(endType, true, true);
        }

        public static EndType parse(String endType, boolean compareByVal, boolean validateNull) {
            for (EndType end : EndType.values()) {
                if (!(compareByVal ? end.val : String.valueOf(end)).equals(endType)) continue;
                return end;
            }
            if (validateNull) {
                throw new IllegalStateException("illegal endType:" + endType);
            }
            return null;
        }

        public static Set<EndType> getDataEnds() {
            if (_dataEnds == null) {
                _dataEnds = EndType.filterTypes2Set(EndTypeCategory.Data);
            }
            return _dataEnds;
        }

        private static Set<EndType> filterTypes2Set(EndTypeCategory data) {
            return Arrays.stream(EndType.values()).filter(end -> end.category == data).collect(Collectors.toSet());
        }

        @Override
        public Optional<String> getDesc() {
            return Objects.requireNonNull(this.desc, "desc can not be null");
        }

        public static Set<EndType> getAssistTypes() {
            if (_assistTypes == null) {
                _assistTypes = EndType.filterTypes2Set(EndTypeCategory.Assist);
            }
            return _assistTypes;
        }

        public static Set<EndType> getAlertTypes() {
            if (_alertTypes == null) {
                _alertTypes = EndType.filterTypes2Set(EndTypeCategory.Alert);
            }
            return _alertTypes;
        }

        public static Set<EndType> getTransformerTypes() {
            if (_transformerTypes == null) {
                _transformerTypes = EndType.filterTypes2Set(EndTypeCategory.Transformer);
            }
            return _transformerTypes;
        }

        private EndType(String val, EndTypeCategory category) {
            this(val, category, false, Optional.empty());
        }

        private EndType(String val, EndTypeCategory category, boolean containICON) {
            this(val, category, containICON, Optional.empty());
        }

        private EndType(String val, EndTypeCategory category, boolean containICON, Optional<String> desc) {
            this.val = val;
            this.containICON = containICON;
            this.category = category;
            this.desc = desc;
        }

        @Override
        public String getVal() {
            return this.val;
        }

        @Override
        public Icon getIcon() {
            if (this.icon == null) {
                if (!this.containICON) {
                    this.icon = unknowStorageType;
                    return this.icon;
                }
                this.icon = new Icon(){

                    private String loadIconWithSuffix(String theme, boolean throwErr) {
                        return IOUtils.loadResourceFromClasspath(IEndTypeGetter.class, (String)("endtype/icon/" + val + "/" + theme + ".svg"), (boolean)throwErr);
                    }

                    @Override
                    public boolean setRes(JSONObject icon, boolean fillStyle) {
                        String iconContent = fillStyle ? this.fillType() : this.outlineType();
                        icon.put("icon", (Object)iconContent);
                        return StringUtils.isNotEmpty((CharSequence)iconContent);
                    }

                    @Override
                    public String fillType() {
                        return this.loadIconWithSuffix("fill", true);
                    }

                    @Override
                    public String outlineType() {
                        return this.loadIconWithSuffix("outline", false);
                    }
                };
            }
            return this.icon;
        }

        public boolean containIn(Set<String> endTypes) {
            return endTypes.contains(this.getVal());
        }

        static {
            unknowStorageType = new DefaultIconReference(UnKnowStoreType);
            KEY_END_TYPE = "endType";
            KEY_END_TYPE_DESC = "endTypeDesc";
            KEY_SUPPORT_ICON = "supportIcon";
        }
    }

    public static enum EndTypeCategory {
        Data,
        Assist,
        Alert,
        Transformer,
        Icon;

    }

    public static interface IEndType {
        public String getVal();

        public Optional<String> getDesc();

        public Icon getIcon();
    }

    public static enum PluginVender {
        FLINK_CDC("FlinkCDC", "flink-cdc", "https://ververica.github.io/flink-cdc-connectors"),
        CHUNJUN("Chunjun", "chunjun", "https://dtstack.github.io/chunjun"),
        TIS("TIS", "tis", "https://github.com/qlangtech/tis"),
        DATAX("DataX", "datax", "https://github.com/alibaba/DataX");

        final String name;
        final String tokenId;
        final String url;

        private PluginVender(String name, String tokenId, String url) {
            this.name = name;
            this.tokenId = tokenId;
            this.url = url;
        }

        public String getTokenId() {
            return this.tokenId;
        }

        public String getName() {
            return this.name;
        }

        public String getUrl() {
            return this.url;
        }
    }
}

