/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.plugin;

import com.google.common.collect.Lists;
import com.qlangtech.tis.TIS;
import com.qlangtech.tis.extension.impl.XmlFile;
import com.qlangtech.tis.plugin.IRepositoryResource;
import com.qlangtech.tis.util.PluginMeta;
import com.qlangtech.tis.util.RobustReflectionConverter2;
import com.qlangtech.tis.util.XStream2PluginInfoReader;
import com.thoughtworks.xstream.converters.DataHolder;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentMeta {
    private static final Logger logger = LoggerFactory.getLogger(ComponentMeta.class);
    public final Set<IRepositoryResource> resources;

    public static Map<String, Long> getGlobalPluginStoreLastModifyTimestamp(ComponentMeta meta) {
        return meta.resources.stream().collect(Collectors.toMap(r -> r.getTargetFile().relativePath, r -> r.getWriteLastModifyTimeStamp()));
    }

    public ComponentMeta(List<IRepositoryResource> resources) {
        this.resources = resources.stream().filter(res -> res.getTargetFile() != null).collect(Collectors.toSet());
    }

    public ComponentMeta(IRepositoryResource resource) {
        this(Collections.singletonList(resource));
    }

    public void addResource(IRepositoryResource rr) {
        this.resources.add(rr);
    }

    public void downloaConfig() {
        this.resources.forEach(r -> r.copyConfigFromRemote());
    }

    public Set<PluginMeta> loadPluginMeta() {
        return ComponentMeta.loadPluginMeta(() -> {
            ArrayList cfgs = Lists.newArrayList();
            XmlFile xmlFile = null;
            for (IRepositoryResource res : this.resources) {
                File targetFile;
                xmlFile = res.getTargetFile();
                if (xmlFile == null || !(targetFile = xmlFile.getFile()).exists()) continue;
                cfgs.add(targetFile);
            }
            return cfgs;
        });
    }

    public static Set<PluginMeta> loadPluginMeta(Callable<List<File>> xstreamFilesProvider) {
        return RobustReflectionConverter2.PluginMetas.collectMetas(metas -> {
            try {
                XStream2PluginInfoReader reader = new XStream2PluginInfoReader(XmlFile.DEFAULT_DRIVER);
                List cfgs = (List)xstreamFilesProvider.call();
                for (File targetFile : cfgs) {
                    XmlFile xmlFile = new XmlFile(reader, targetFile);
                    xmlFile.unmarshal(null, (DataHolder)new XmlFile.DefaultDataHolder((Set<PluginMeta>)metas, xmlFile));
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).getMetas();
    }

    public void synchronizePluginsFromRemoteRepository() {
        try {
            this.downloaConfig();
            this.synchronizePluginsPackageFromRemote();
        }
        finally {
            TIS.permitInitialize = true;
        }
        if (TIS.initialized) {
            throw new IllegalStateException("make sure TIS plugin have not be initialized");
        }
    }

    public List<PluginMeta> synchronizePluginsPackageFromRemote() {
        ArrayList updateTpiPkgs = Lists.newArrayList();
        Set<PluginMeta> pluginMetas = this.loadPluginMeta();
        try {
            for (PluginMeta m2 : pluginMetas) {
                ArrayList pluginFileCollector;
                if (!m2.copyFromRemote(pluginFileCollector = Lists.newArrayList())) continue;
                updateTpiPkgs.add(m2);
                if (!TIS.permitInitialize) continue;
                for (File f : pluginFileCollector) {
                    TIS.get().getPluginManager().dynamicLoad(f, true, null);
                }
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        logger.info("download plugin from remote repository:" + updateTpiPkgs.stream().map(m -> m.toString()).collect(Collectors.joining(",")));
        return updateTpiPkgs;
    }
}

