/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.manage.common;

import com.alibaba.citrus.turbine.Context;
import com.qlangtech.tis.aiagent.llm.LLMProvider;
import com.qlangtech.tis.config.ParamsConfig;
import com.qlangtech.tis.extension.Descriptor;
import com.qlangtech.tis.extension.TISExtension;
import com.qlangtech.tis.plugin.IEndTypeGetter;
import com.qlangtech.tis.plugin.IPluginStore;
import com.qlangtech.tis.plugin.annotation.FormField;
import com.qlangtech.tis.plugin.annotation.FormFieldType;
import com.qlangtech.tis.plugin.annotation.Validator;
import com.qlangtech.tis.plugin.credentials.ParamsConfigPluginStore;
import com.qlangtech.tis.util.HeteroEnum;
import com.qlangtech.tis.util.IPluginContext;
import com.qlangtech.tis.util.UploadPluginMeta;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class UserProfile
extends ParamsConfig
implements IPluginStore.BeforePluginSaved {
    public static final String KEY_DISPLAY_NAME = "UserProfile";
    private static final String KEY_FIELD_LLM_NAME = "llm";
    @FormField(identity=true, type=FormFieldType.INPUTTEXT, ordinal=0, validate={Validator.identity, Validator.require})
    public String name;
    @FormField(type=FormFieldType.SELECTABLE, ordinal=1, validate={Validator.identity})
    public String llm;
    @FormField(type=FormFieldType.INPUTTEXT, ordinal=2, validate={Validator.email})
    public String email;

    public static UserProfile load(IPluginContext pluginContext, boolean validateNull) {
        UploadPluginMeta pluginMeta = ParamsConfigPluginStore.createParamsConfigUserIsolation(KEY_DISPLAY_NAME);
        List<ParamsConfig> users = HeteroEnum.PARAMS_CONFIG_USER_ISOLATION.getPlugins(pluginContext, pluginMeta);
        Iterator<ParamsConfig> iterator = users.iterator();
        if (iterator.hasNext()) {
            ParamsConfig user = iterator.next();
            return (UserProfile)user;
        }
        if (validateNull) {
            throw new IllegalStateException("can not find userProfile instance with user:" + pluginContext.getLoginUser().getName());
        }
        return null;
    }

    public static void update(IPluginContext pluginContext, UserProfile profile) {
        UploadPluginMeta pluginMeta = ParamsConfigPluginStore.createParamsConfigUserIsolation(KEY_DISPLAY_NAME);
        IPluginStore pluginStore = HeteroEnum.PARAMS_CONFIG_USER_ISOLATION.getPluginStore(pluginContext, pluginMeta);
        pluginStore.setPlugins(pluginContext, Optional.empty(), Collections.singletonList(new Descriptor.ParseDescribable<UserProfile>(profile)));
    }

    public LLMProvider getLlmProvider() {
        return LLMProvider.load(Objects.requireNonNull(IPluginContext.getThreadLocalInstance()), this.llm);
    }

    public UserProfile createConfigInstance() {
        return this;
    }

    public String identityValue() {
        return this.name;
    }

    @Override
    public void beforeSaved(IPluginContext pluginContext, Optional<Context> context) {
        this.name = pluginContext.getLoginUser().getName();
    }

    @TISExtension
    public static final class DftDescriptor
    extends ParamsConfig.BasicParamsConfigDescriptor
    implements IEndTypeGetter {
        public DftDescriptor() {
            super(UserProfile.KEY_DISPLAY_NAME);
            this.registerSelectOptions(UserProfile.KEY_FIELD_LLM_NAME, LLMProvider::getExistProviders);
        }

        @Override
        public String getDisplayName() {
            return UserProfile.KEY_DISPLAY_NAME;
        }

        @Override
        public IEndTypeGetter.EndType getEndType() {
            return IEndTypeGetter.EndType.UserProfile;
        }
    }
}

