/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.manage.common;

import com.google.common.collect.Lists;
import com.qlangtech.tis.ajax.AjaxResult;
import com.qlangtech.tis.assemble.ExecResult;
import com.qlangtech.tis.datax.DataXName;
import com.qlangtech.tis.exec.IExecChainContext;
import com.qlangtech.tis.lang.TisException;
import com.qlangtech.tis.manage.common.Config;
import com.qlangtech.tis.manage.common.CreateNewTaskResult;
import com.qlangtech.tis.manage.common.HttpUtils;
import com.qlangtech.tis.realtime.yarn.rpc.IncrRateControllerCfgDTO;
import com.qlangtech.tis.workflow.pojo.WorkFlowBuildHistory;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskSoapUtils {
    private static final Logger logger = LoggerFactory.getLogger(TaskSoapUtils.class);
    public static final MessageFormat WORKFLOW_CONFIG_URL_FORMAT = new MessageFormat(Config.getConfigRepositoryHost() + "/config/config.ajax?action={0}&event_submit_{1}=true&handler={2}{3}");

    public static IncrRateControllerCfgDTO getIncrRateLimitCfg(DataXName dataXName, Long lastModified) {
        String url = TaskSoapUtils.createFullbuild_workflow_actionURL("do_get_rate_controller");
        ArrayList params = Lists.newArrayList();
        params.add(new HttpUtils.PostParam("pipeline", (Object)dataXName.getPipelineName()));
        params.add(new HttpUtils.PostParam("lastModified", (Object)lastModified));
        AjaxResult result = null;
        try {
            result = HttpUtils.soapRemote((String)url, (List)params, IncrRateControllerCfgDTO.class, (boolean)false);
        }
        catch (TisException e) {
            logger.warn(e.getMessage());
            return null;
        }
        if (result == null || !result.isSuccess()) {
            return null;
        }
        return (IncrRateControllerCfgDTO)result.getBizresult();
    }

    public static void feedbackAsynTaskStatus(int taskid, String subTaskName, boolean success) {
        String url = TaskSoapUtils.createFullbuild_workflow_actionURL("do_feedback_asyn_task_status");
        ArrayList params = Lists.newArrayList();
        params.add(new HttpUtils.PostParam("disableTransaction", (Object)true));
        params.add(new HttpUtils.PostParam("taskid", (Object)taskid));
        params.add(new HttpUtils.PostParam("asynJobName", (Object)subTaskName));
        params.add(new HttpUtils.PostParam("success", (Object)success));
        HttpUtils.soapRemote((String)url, (List)params, CreateNewTaskResult.class, (boolean)false);
    }

    private static String createFullbuild_workflow_actionURL(String methodName) {
        return WORKFLOW_CONFIG_URL_FORMAT.format(new Object[]{"fullbuild_workflow_action", methodName, "", ""});
    }

    public static void createTaskComplete(int taskid, IExecChainContext chainContext, ExecResult execResult) {
        if (execResult == null) {
            throw new IllegalArgumentException("param execResult can not be null");
        }
        String url = TaskSoapUtils.createFullbuild_workflow_actionURL("do_task_complete");
        ArrayList params = Lists.newArrayList((Object[])new HttpUtils.PostParam[]{new HttpUtils.PostParam("execresult", (Object)String.valueOf(execResult.getValue())), new HttpUtils.PostParam("taskid", (Object)String.valueOf(taskid))});
        if (chainContext.containAsynJob()) {
            for (IExecChainContext.AsynSubJob asynJob : chainContext.getAsynSubJobs()) {
                params.add(new HttpUtils.PostParam("asynJobName", (Object)asynJob.jobName));
            }
        }
        HttpUtils.soapRemote((String)url, (List)params, CreateNewTaskResult.class);
    }

    public static WorkFlowBuildHistory getWFStatus(Integer taskId) {
        if (taskId == null || taskId < 1) {
            throw new IllegalArgumentException("param taskId can not be empty");
        }
        String url = TaskSoapUtils.createFullbuild_workflow_actionURL("do_get_wf");
        ArrayList params = Lists.newArrayList();
        params.add(new HttpUtils.PostParam("taskid", (Object)taskId));
        AjaxResult result = HttpUtils.soapRemote((String)url, (List)params, WorkFlowBuildHistory.class, (boolean)true);
        return (WorkFlowBuildHistory)result.getBizresult();
    }
}

