/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.manage;

import com.alibaba.citrus.turbine.Context;
import com.qlangtech.tis.TIS;
import com.qlangtech.tis.annotation.Public;
import com.qlangtech.tis.datax.DataXName;
import com.qlangtech.tis.datax.StoreResourceType;
import com.qlangtech.tis.datax.impl.DataxReader;
import com.qlangtech.tis.datax.impl.DataxWriter;
import com.qlangtech.tis.extension.Describable;
import com.qlangtech.tis.extension.Descriptor;
import com.qlangtech.tis.plugin.IdentityName;
import com.qlangtech.tis.plugin.KeyedPluginStore;
import com.qlangtech.tis.plugin.PluginStore;
import com.qlangtech.tis.plugin.StoreResourceTypeGetter;
import com.qlangtech.tis.plugin.datax.transformer.RecordTransformerRules;
import com.qlangtech.tis.util.IPluginContext;
import java.util.Collections;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;

@Public
public interface IAppSource
extends Describable<IAppSource>,
StoreResourceTypeGetter,
IdentityName {
    public static <T extends IAppSource> KeyedPluginStore<T> getPluginStore(IPluginContext context, String appName) {
        return IAppSource.getPluginStore(context, StoreResourceType.DataApp, appName);
    }

    public static <T extends IAppSource> KeyedPluginStore<T> getPluginStore(IPluginContext context, StoreResourceType resType, String appName) {
        return TIS.appSourcePluginStore.get(IAppSource.createAppSourceKey(context, resType, appName));
    }

    public static KeyedPluginStore.AppKey createAppSourceKey(IPluginContext context, String appName) {
        return new KeyedPluginStore.AppKey<IAppSource>(context, StoreResourceType.DataApp, appName, IAppSource.class);
    }

    public static KeyedPluginStore.AppKey createAppSourceKey(IPluginContext context, StoreResourceType resType, String appName) {
        if (StringUtils.isEmpty((String)appName)) {
            throw new IllegalArgumentException("param appName can not be empty");
        }
        return new KeyedPluginStore.AppKey<IAppSource>(context, resType, appName, IAppSource.class);
    }

    public static void cleanPluginStoreCache(IPluginContext context, DataXName appName) {
        TIS.appSourcePluginStore.clear(IAppSource.createAppSourceKey(context, appName.getType(), appName.getPipelineName()));
    }

    public static void cleanAppSourcePluginStoreCache(IPluginContext context, DataXName appName) {
        IAppSource.cleanPluginStoreCache(context, appName);
        DataxReader.cleanPluginStoreCache(context, false, appName.getPipelineName());
        DataxWriter.cleanPluginStoreCache(context, appName);
        RecordTransformerRules.cleanPluginStoreCache(context, appName);
    }

    public static <T extends IAppSource> Optional<T> loadNullable(IPluginContext context, DataXName appName) {
        return IAppSource.loadNullable(context, appName.getType(), appName.getPipelineName());
    }

    public static <T extends IAppSource> Optional<T> loadNullable(IPluginContext context, StoreResourceType resType, String appName) {
        KeyedPluginStore<T> pluginStore = IAppSource.getPluginStore(context, resType, appName);
        IAppSource appSource = (IAppSource)pluginStore.getPlugin();
        return Optional.ofNullable(appSource);
    }

    public static <T extends IAppSource> T load(String appName) {
        return IAppSource.load(null, DataXName.createDataXPipeline((String)appName));
    }

    public static void save(IPluginContext pluginContext, String appname, IAppSource appSource) {
        KeyedPluginStore pluginStore = IAppSource.getPluginStore(pluginContext, appname);
        Optional<Context> context = Optional.empty();
        pluginStore.setPlugins(pluginContext, context, Collections.singletonList(new Descriptor.ParseDescribable<IAppSource>(appSource)));
    }

    public static <T extends IAppSource> T load(IPluginContext pluginContext, DataXName appName) {
        Optional<T> iAppSource = IAppSource.loadNullable(pluginContext, appName);
        if (!iAppSource.isPresent()) {
            throw new IllegalStateException("appName:" + appName + " relevant appSource can not be null");
        }
        return (T)((IAppSource)iAppSource.get());
    }

    @Override
    default public Descriptor<IAppSource> getDescriptor() {
        return TIS.get().getDescriptor(this.getClass());
    }

    default public DataXName getDataXName() {
        return new DataXName(this.identityValue(), this.getResType());
    }

    default public void copy(String newIdentityVal) {
        throw new UnsupportedOperationException();
    }

    public void setPluginStore(PluginStore<IAppSource> var1);
}

