/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.install;

import com.qlangtech.tis.TIS;
import com.qlangtech.tis.extension.model.UpdateCenter;
import com.qlangtech.tis.extension.util.VersionNumber;
import com.qlangtech.tis.install.InstallState;
import com.qlangtech.tis.install.InstallStateFilter;
import com.qlangtech.tis.manage.common.Config;
import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Provider;
import org.apache.commons.io.FileUtils;

public class InstallUtil {
    private static final Logger LOGGER = Logger.getLogger(InstallUtil.class.getName());
    public static final VersionNumber NEW_INSTALL_VERSION = new VersionNumber("1.0");
    private static final VersionNumber FORCE_NEW_INSTALL_VERSION = new VersionNumber("0.0");

    public static void proceedToNextStateFrom(InstallState prior) {
        InstallState next = InstallUtil.getNextInstallState(prior);
        if (next != null) {
            TIS.get().setInstallState(next);
        }
    }

    static InstallState getNextInstallState(InstallState current) {
        ArrayList<Function<Provider, InstallState>> installStateFilterChain = new ArrayList<Function<Provider, InstallState>>();
        for (InstallStateFilter setupExtension : InstallStateFilter.all()) {
            installStateFilterChain.add(next -> setupExtension.getNextInstallState(current, (Provider<InstallState>)next));
        }
        installStateFilterChain.add(input -> {
            if (current == null || InstallState.UNKNOWN.equals(current)) {
                return InstallUtil.getDefaultInstallState();
            }
            HashMap<InstallState, InstallState> states = new HashMap<InstallState, InstallState>();
            states.put(InstallState.CONFIGURE_INSTANCE, InstallState.INITIAL_SETUP_COMPLETED);
            states.put(InstallState.CREATE_ADMIN_USER, InstallState.CONFIGURE_INSTANCE);
            states.put(InstallState.INITIAL_PLUGINS_INSTALLING, InstallState.CREATE_ADMIN_USER);
            states.put(InstallState.INITIAL_SECURITY_SETUP, InstallState.NEW);
            states.put(InstallState.RESTART, InstallState.RUNNING);
            states.put(InstallState.UPGRADE, InstallState.INITIAL_SETUP_COMPLETED);
            states.put(InstallState.DOWNGRADE, InstallState.INITIAL_SETUP_COMPLETED);
            states.put(InstallState.INITIAL_SETUP_COMPLETED, InstallState.RUNNING);
            return (InstallState)states.get(current);
        });
        ProviderChain chain = new ProviderChain(installStateFilterChain.iterator());
        return (InstallState)chain.get();
    }

    private static InstallState getDefaultInstallState() {
        String stateOverride = System.getProperty("jenkins.install.state", System.getenv("jenkins.install.state"));
        if (stateOverride != null) {
            try {
                return InstallState.valueOf(stateOverride.toUpperCase());
            }
            catch (RuntimeException e) {
                throw new IllegalStateException("Unknown install state override specified on the commandline: '" + stateOverride + "'.");
            }
        }
        VersionNumber lastRunVersion = null;
        TIS j = TIS.get();
        VersionNumber currentRunVersion = new VersionNumber(InstallUtil.getCurrentExecVersion());
        if (lastRunVersion.isOlderThan(currentRunVersion)) {
            return InstallState.UPGRADE;
        }
        if (lastRunVersion.isNewerThan(currentRunVersion)) {
            return InstallState.DOWNGRADE;
        }
        return InstallState.RESTART;
    }

    static File getInstallingPluginsFile() {
        return new File(Config.getDataDir(), "jenkins.install.InstallUtil.installingPlugins");
    }

    private static String getCurrentExecVersion() {
        if (TIS.VERSION.equals("?")) {
            throw new IllegalStateException("Unexpected call to InstallUtil.getCurrentExecVersion(). Jenkins.VERSION has not been initialized. Call computeVersion() first.");
        }
        return TIS.VERSION;
    }

    public static synchronized Map<String, String> getPersistedInstallStatus() {
        File installingPluginsFile = InstallUtil.getInstallingPluginsFile();
        if (installingPluginsFile == null || !installingPluginsFile.exists()) {
            return null;
        }
        return (Map)new XStream().fromXML(installingPluginsFile);
    }

    public static synchronized void persistInstallStatus(List<UpdateCenter.UpdateCenterJob> installingPlugins) {
        File installingPluginsFile = InstallUtil.getInstallingPluginsFile();
        if (installingPlugins == null || installingPlugins.isEmpty()) {
            installingPluginsFile.delete();
            return;
        }
        LOGGER.fine("Writing install state to: " + installingPluginsFile.getAbsolutePath());
        HashMap<String, String> statuses = new HashMap<String, String>();
        for (UpdateCenter.UpdateCenterJob j : installingPlugins) {
            if (!(j instanceof UpdateCenter.InstallationJob) || j.getCorrelationId() == null) continue;
            UpdateCenter.InstallationJob ij = (UpdateCenter.InstallationJob)j;
            UpdateCenter.DownloadJob.InstallationStatus status = ij.status;
            String statusText = status.getType();
            if (status instanceof UpdateCenter.DownloadJob.Installing) {
                statusText = "Pending";
            }
            statuses.put(ij.plugin.name, statusText);
        }
        try {
            String installingPluginXml = new XStream().toXML(statuses);
            FileUtils.write((File)installingPluginsFile, (CharSequence)installingPluginXml);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Failed to save " + installingPluginsFile.getAbsolutePath(), e);
        }
    }

    public static void clearInstallStatus() {
        InstallUtil.persistInstallStatus(null);
    }

    private static class ProviderChain<T>
    implements Provider<T> {
        private final Iterator<Function<Provider<T>, T>> functions;

        ProviderChain(Iterator<Function<Provider<T>, T>> functions) {
            this.functions = functions;
        }

        public T get() {
            return this.functions.next().apply(this);
        }
    }
}

