/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.install;

import com.qlangtech.tis.extension.ExtensionList;
import com.qlangtech.tis.extension.TISExtension;
import com.qlangtech.tis.install.InstallUtil;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

public class InstallState {
    @Deprecated
    private static final InstallState[] UNUSED_INNER_CLASSES = new InstallState[]{new InstallState("UNKNOWN", false){}, new InstallState("INITIAL_SETUP_COMPLETED", false){}, new InstallState("CREATE_ADMIN_USER", false){}, new InstallState("INITIAL_SECURITY_SETUP", false){}, new InstallState("RESTART", false){}, new InstallState("DOWNGRADE", false){}};
    @TISExtension
    public static final InstallState UNKNOWN = new Unknown();
    @TISExtension
    public static final InstallState RUNNING = new InstallState("RUNNING", true);
    @TISExtension
    public static final InstallState INITIAL_SETUP_COMPLETED = new InitialSetupCompleted();
    @TISExtension
    public static final InstallState CREATE_ADMIN_USER = new CreateAdminUser();
    @TISExtension
    public static final InstallState CONFIGURE_INSTANCE = new ConfigureInstance();
    @TISExtension
    public static final InstallState INITIAL_PLUGINS_INSTALLING = new InstallState("INITIAL_PLUGINS_INSTALLING", false);
    @TISExtension
    public static final InstallState INITIAL_SECURITY_SETUP = new InitialSecuritySetup();
    @TISExtension
    public static final InstallState NEW = new InstallState("NEW", false);
    @TISExtension
    public static final InstallState RESTART = new Restart();
    @TISExtension
    public static final InstallState UPGRADE = new Upgrade();
    @TISExtension
    public static final InstallState DOWNGRADE = new Downgrade();
    private static final Logger LOGGER = Logger.getLogger(InstallState.class.getName());
    public static final InstallState TEST = new InstallState("TEST", true);
    public static final InstallState DEVELOPMENT = new InstallState("DEVELOPMENT", true);
    private final transient boolean isSetupComplete;
    private final String name;

    private static void reloadUpdateSiteData() {
    }

    public InstallState(String name, boolean isSetupComplete) {
        this.name = name;
        this.isSetupComplete = isSetupComplete;
    }

    public void initializeState() {
    }

    @Deprecated
    protected Object readResolve() {
        if (StringUtils.isBlank((String)this.name)) {
            LOGGER.log(Level.WARNING, "Read install state with blank name: ''{0}''. It will be ignored", this.name);
            return UNKNOWN;
        }
        InstallState state = InstallState.valueOf(this.name);
        if (state == null) {
            LOGGER.log(Level.WARNING, "Cannot locate an extension point for the state ''{0}''. It will be ignored", this.name);
            return UNKNOWN;
        }
        return state;
    }

    public boolean isSetupComplete() {
        return this.isSetupComplete;
    }

    public String name() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof InstallState) {
            return this.name.equals(((InstallState)obj).name());
        }
        return false;
    }

    public String toString() {
        return "InstallState (" + this.name + ")";
    }

    public static InstallState valueOf(String name) {
        for (InstallState state : InstallState.all()) {
            if (!name.equals(state.name)) continue;
            return state;
        }
        return null;
    }

    static ExtensionList<InstallState> all() {
        return ExtensionList.lookup(InstallState.class);
    }

    private static final class Downgrade
    extends InstallState {
        Downgrade() {
            super("DOWNGRADE", true);
        }

        @Override
        public void initializeState() {
            InstallState.reloadUpdateSiteData();
        }
    }

    private static final class Upgrade
    extends InstallState {
        Upgrade() {
            super("UPGRADE", true);
        }

        @Override
        public void initializeState() {
            this.applyForcedChanges();
            InstallState.reloadUpdateSiteData();
        }

        private void applyForcedChanges() {
        }
    }

    private static final class Restart
    extends InstallState {
        Restart() {
            super("RESTART", true);
        }

        @Override
        public void initializeState() {
        }
    }

    private static final class InitialSecuritySetup
    extends InstallState {
        InitialSecuritySetup() {
            super("INITIAL_SECURITY_SETUP", false);
        }

        @Override
        public void initializeState() {
        }
    }

    private static final class ConfigureInstance
    extends InstallState {
        ConfigureInstance() {
            super("CONFIGURE_INSTANCE", false);
        }

        @Override
        public void initializeState() {
        }
    }

    private static final class CreateAdminUser
    extends InstallState {
        CreateAdminUser() {
            super("CREATE_ADMIN_USER", false);
        }

        @Override
        public void initializeState() {
        }
    }

    private static final class InitialSetupCompleted
    extends InstallState {
        InitialSetupCompleted() {
            super("INITIAL_SETUP_COMPLETED", true);
        }

        @Override
        public void initializeState() {
        }
    }

    private static class Unknown
    extends InstallState {
        Unknown() {
            super("UNKNOWN", true);
        }

        @Override
        public void initializeState() {
            InstallUtil.proceedToNextStateFrom(this);
        }
    }
}

