/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.extension.util;

import com.qlangtech.tis.manage.common.TisUTF8;
import com.qlangtech.tis.util.AtomicFileWriter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Iterator;
import org.apache.commons.io.FileUtils;

public class TextFile {
    public final File file;

    public TextFile(File file) {
        this.file = file;
    }

    public boolean exists() {
        return this.file.exists();
    }

    public void delete() {
        FileUtils.deleteQuietly((File)this.file);
    }

    public String read() throws IOException {
        return FileUtils.readFileToString((File)this.file, (Charset)TisUTF8.get());
    }

    public Iterator<String> lines() throws Exception {
        return FileUtils.lineIterator((File)this.file, (String)TisUTF8.getName());
    }

    public void write(String text) throws IOException {
        this.file.getParentFile().mkdirs();
        try (AtomicFileWriter w = new AtomicFileWriter(this.file);){
            try {
                w.write(text);
                w.commit();
            }
            finally {
                w.abort();
            }
        }
    }

    public String head(int numChars) throws IOException {
        char[] buf = new char[numChars];
        try (FileReader r = new FileReader(this.file);){
            int read;
            int d;
            for (read = 0; read < numChars && (d = ((Reader)r).read(buf, read, buf.length - read)) >= 0; read += d) {
            }
            String string = new String(buf, 0, read);
            return string;
        }
    }

    public String fastTail(int numChars, Charset cs) throws IOException {
        try (RandomAccessFile raf = new RandomAccessFile(this.file, "r");){
            long len = raf.length();
            long pos = Math.max(0L, len - (long)(numChars * 4 + 1024));
            raf.seek(pos);
            byte[] tail = new byte[(int)(len - pos)];
            raf.readFully(tail);
            String tails = cs.decode(ByteBuffer.wrap(tail)).toString();
            String string = tails.substring(Math.max(0, tails.length() - numChars));
            return string;
        }
    }

    public String fastTail(int numChars) throws IOException {
        return this.fastTail(numChars, Charset.defaultCharset());
    }

    public String readTrim() throws IOException {
        return this.read().trim();
    }

    public String toString() {
        return this.file.toString();
    }
}

