/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.extension.util;

import com.alibaba.citrus.turbine.Context;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.qlangtech.tis.IPluginEnum;
import com.qlangtech.tis.extension.Descriptor;
import com.qlangtech.tis.extension.ElementPluginDesc;
import com.qlangtech.tis.extension.impl.IOUtils;
import com.qlangtech.tis.extension.impl.PropertyType;
import com.qlangtech.tis.extension.util.AbstractPropAssist;
import com.qlangtech.tis.manage.common.Option;
import com.qlangtech.tis.manage.common.TisUTF8;
import com.qlangtech.tis.plugin.IEndTypeGetter;
import com.qlangtech.tis.plugin.IdentityName;
import com.qlangtech.tis.plugin.annotation.FormFieldType;
import com.qlangtech.tis.plugin.annotation.Validator;
import com.qlangtech.tis.runtime.module.misc.IControlMsgHandler;
import com.qlangtech.tis.util.HeteroEnum;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginExtraProps
extends HashMap<String, Props> {
    private static final Logger logger = LoggerFactory.getLogger(PluginExtraProps.class);
    public static final String KEY_DFTVAL_PROP = "dftVal";
    public static final String KEY_READONLY = "readonly";
    public static final String KEY_PLACEHOLDER_PROP = "placeholder";
    public static final String KEY_DATETIME_FORMAT = "dateTimeFormat";
    public static final String KEY_DISABLE = "disable";
    public static final String KEY_CREATOR = "creator";
    public static final String KEY_PLUGIN = "plugin";
    public static final String KEY_CREATOR_HETERO = "hetero";
    public static final String KEY_DESC_NAME = "descName";
    public static final String KEY_ROUTER_LINK = "routerLink";
    public static final String KEY_ENUM_FILTER = "subDescEnumFilter";
    public static final String KEY_CREATOR_ASSIST_TYPE = "assistType";

    private static Optional<PluginExtraProps> parseExtraProps(Class<?> pluginClazz) {
        return PluginExtraProps.parseExtraProps(pluginClazz, Optional.empty());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Optional<PluginExtraProps> parseExtraProps(Class<?> pluginClazz, Optional<Field> subFormField) {
        Object subformFieldName = "";
        if (subFormField.isPresent()) {
            subformFieldName = "." + subFormField.get().getName();
        }
        String mdRes = pluginClazz.getSimpleName() + (String)subformFieldName + ".md";
        String shortMdRes = pluginClazz.getSimpleName() + (String)subformFieldName + "-short.md";
        HashMap asynPropHelps = Maps.newHashMap();
        PluginExtraProps.createAsynPropHelps(pluginClazz, mdRes, (fieldKey, propHelp) -> {
            if (asynPropHelps.put(fieldKey, new AsynPropHelp((StringBuffer)propHelp)) != null) {
                throw new IllegalStateException("field:" + fieldKey + " relevant propHelp can not be add twice");
            }
        });
        PluginExtraProps.createAsynPropHelps(pluginClazz, shortMdRes, (fieldKey, propHelp) -> {
            AsynPropHelp asynHelp = (AsynPropHelp)asynPropHelps.get(fieldKey);
            if (asynHelp == null) {
                throw new IllegalStateException("field:" + fieldKey + " relevant propHelp can not be null,must contain field in " + mdRes + " ahead, class:" + pluginClazz.getName());
            }
            asynHelp.setAbstracted((StringBuffer)propHelp);
        });
        String resourceName = pluginClazz.getSimpleName() + (String)subformFieldName + ".json";
        try (InputStream i = pluginClazz.getResourceAsStream(resourceName);){
            if (i == null) {
                Optional<PluginExtraProps> optional2 = Optional.empty();
                return optional2;
            }
            JSONObject o = (JSONObject)JSON.parseObject((InputStream)i, (Charset)TisUTF8.get(), JSONObject.class, (Feature[])new Feature[0]);
            PluginExtraProps props = new PluginExtraProps();
            Props pps = null;
            for (String propKey : o.keySet()) {
                pps = new Props(o.getJSONObject(propKey));
                AsynPropHelp asynHelp = null;
                asynHelp = (AsynPropHelp)asynPropHelps.get(propKey);
                if (asynHelp != null) {
                    pps.tagAsynHelp(new AbstractPropAssist.MarkdownHelperContent(asynHelp));
                }
                props.put(propKey, pps);
            }
            Optional<PluginExtraProps> optional = Optional.of(props);
            return optional;
        }
        catch (Exception e) {
            throw new RuntimeException("resourceName:" + resourceName, e);
        }
    }

    private static void createAsynPropHelps(Class<?> pluginClazz, String mdRes, BiConsumer<String, StringBuffer> asynPropHelps) {
        IOUtils.loadResourceFromClasspath(pluginClazz, (String)mdRes, (boolean)false, input -> {
            LineIterator lines = org.apache.commons.io.IOUtils.lineIterator((InputStream)input, (Charset)TisUTF8.get());
            String line = null;
            StringBuffer propHelp = null;
            boolean firstLine = false;
            while (lines.hasNext()) {
                line = lines.nextLine();
                int indexOf = StringUtils.indexOf((String)line, (String)"##");
                if (indexOf > -1) {
                    propHelp = new StringBuffer();
                    String fieldKey = StringUtils.trimToNull((String)StringUtils.substring((String)line, (int)(indexOf + 2)));
                    firstLine = true;
                    asynPropHelps.accept(fieldKey, propHelp);
                    continue;
                }
                Objects.requireNonNull(propHelp, "propHelp can not be null,file:" + mdRes);
                if (!firstLine) {
                    propHelp.append("\n");
                }
                propHelp.append(line);
                firstLine = false;
            }
            return null;
        });
    }

    public static Optional<PluginExtraProps> load(Class<?> clazz) {
        return PluginExtraProps.load(Optional.empty(), clazz);
    }

    public static Optional<PluginExtraProps> load(Optional<ElementPluginDesc> desc, Class<?> clazz) {
        PluginExtraProps ep = PluginExtraProps.visitAncestorsClass(clazz, (c, extraProps, finalChild) -> {
            Optional<PluginExtraProps> nxtExtraProps = PluginExtraProps.parseExtraProps(c);
            if (nxtExtraProps.isPresent()) {
                if (extraProps == null) {
                    extraProps = nxtExtraProps.get();
                } else {
                    extraProps.mergeProps(nxtExtraProps.get());
                }
            }
            if (finalChild && extraProps != null) {
                extraProps.forEach((k, prop) -> {});
            }
            return extraProps;
        });
        if (ep != null) {
            String resourceName = clazz.getSimpleName() + ".json";
            for (Map.Entry entry : ep.entrySet()) {
                Optional<FieldRefCreateor> refCreator = ((Props)entry.getValue()).getRefCreator();
                refCreator.ifPresent(createor -> Props.validate(createor, (String)entry.getKey(), clazz, resourceName, true));
            }
        }
        PluginExtraProps e = null;
        if (desc.isPresent() && MapUtils.isNotEmpty((Map)(e = desc.get().getFieldExtraDescs()))) {
            if (ep != null) {
                ep.mergeProps(e, desc);
            } else {
                ep = e;
            }
        }
        return Optional.ofNullable(ep);
    }

    public static <T> T visitAncestorsClass(Class<?> clazz, IClassVisitor<T> clazzVisitor) {
        ArrayList allSuperclasses = Lists.newArrayList((Object[])new Class[]{clazz});
        allSuperclasses.addAll(ClassUtils.getAllSuperclasses(clazz));
        Object extraProps = null;
        Class targetClass = null;
        for (int i = allSuperclasses.size() - 2; i >= 0; --i) {
            targetClass = (Class)allSuperclasses.get(i);
            extraProps = clazzVisitor.process(targetClass, extraProps, i == 0);
        }
        return extraProps;
    }

    private static String createErrorMsg(String propKey, Class<?> pluginClazz, String resourceName) {
        return String.format("propKey:%s,package:%s,propKey:%s", propKey, pluginClazz.getPackage().getName(), resourceName);
    }

    public Props getProp(String key) {
        Props props = (Props)this.get(key);
        if (props == null) {
            return null;
        }
        return props;
    }

    public void mergeProps(PluginExtraProps props) {
        this.mergeProps(props, Optional.empty());
    }

    public void mergeProps(PluginExtraProps props, Optional<ElementPluginDesc> desc) {
        if (props == null) {
            throw new IllegalArgumentException("param props can not be null");
        }
        Props p = null;
        AtomicReference ppRef = new AtomicReference();
        for (Map.Entry entry : props.entrySet()) {
            ElementPluginDesc elmtDesc;
            Map pp;
            p = (Props)this.get(entry.getKey());
            if (p != null) {
                p.merge((Props)entry.getValue());
                continue;
            }
            if (desc.isPresent() && !(pp = (Map)ppRef.updateAndGet(arg_0 -> PluginExtraProps.lambda$mergeProps$6(elmtDesc = desc.get(), arg_0))).containsKey(entry.getKey())) {
                throw new IllegalStateException("prop key:" + (String)entry.getKey() + " relevant prop must exist , exist props keys:" + pp.keySet().stream().collect(Collectors.joining(",")));
            }
            this.put((String)entry.getKey(), (Props)entry.getValue());
        }
    }

    private static /* synthetic */ Map lambda$mergeProps$6(ElementPluginDesc elmtDesc, Map pre) {
        return pre == null ? PropertyType.buildPropertyTypes(Optional.empty(), elmtDesc.getElementDesc().clazz) : pre;
    }

    public static class AsynPropHelp {
        private final StringBuffer detailed;
        private StringBuffer abstracted;

        public static AsynPropHelp create(String detailed) {
            return new AsynPropHelp(new StringBuffer(detailed));
        }

        public AsynPropHelp(StringBuffer detailed) {
            this.detailed = Objects.requireNonNull(detailed, "detailed can not be null");
        }

        public String getDetailed() {
            return this.detailed.toString();
        }

        public StringBuffer getAbstracted() {
            return this.abstracted;
        }

        public void setAbstracted(StringBuffer abstracted) {
            this.abstracted = abstracted;
        }
    }

    public static class Props {
        public static final String KEY_HELP = "help";
        public static final String KEY_VALIDATOR = "validators";
        public static final String KEY_VIEW_TYPE = "viewtype";
        public static final String KEY_ASYNC_HELP = "asyncHelp";
        private final JSONObject props;
        private AbstractPropAssist.MarkdownHelperContent asynHelp;
        private Optional<FieldRefCreateor> _fieldRefCreateor;
        private SimpleDateFormat dateFormat;
        private static final Pattern PATTERN_PARENT = Pattern.compile("(.+?)\\-parent");

        public Props(JSONObject props) {
            this.props = props;
        }

        private static FieldRefCreateor createFieldRefCreateor(JSONObject props) {
            FieldRefCreateor createor = null;
            Object creator = props.get((Object)PluginExtraProps.KEY_CREATOR);
            if (creator != null) {
                if (!(creator instanceof JSONObject)) {
                    throw new IllegalStateException("prop creator must be type of JSONObject,but is " + creator.getClass());
                }
                createor = new FieldRefCreateor();
                JSONObject creatorJ = (JSONObject)creator;
                createor.setLabel(creatorJ.getString("label"));
                JSONObject pmeta = null;
                JSONArray plugins = creatorJ.getJSONArray(PluginExtraProps.KEY_PLUGIN);
                boolean assistTypeEmpty = StringUtils.isEmpty((String)creatorJ.getString(PluginExtraProps.KEY_CREATOR_ASSIST_TYPE));
                if (plugins != null) {
                    for (int i = 0; i < plugins.size(); ++i) {
                        String hetero;
                        pmeta = plugins.getJSONObject(i);
                        if (assistTypeEmpty && StringUtils.isNotEmpty((String)(hetero = pmeta.getString(PluginExtraProps.KEY_CREATOR_HETERO))) && !HeteroEnum.DATASOURCE.identity.equals(hetero)) {
                            creatorJ.put(PluginExtraProps.KEY_CREATOR_ASSIST_TYPE, (Object)RouterAssistType.paramCfg.token);
                            assistTypeEmpty = false;
                        }
                        createor.addCandidatePlugin(new CandidatePlugin(pmeta.getString(PluginExtraProps.KEY_DESC_NAME), Optional.ofNullable(pmeta.getString("targetItemDesc")), pmeta.getString(PluginExtraProps.KEY_CREATOR_HETERO)));
                    }
                }
                if (assistTypeEmpty && StringUtils.isNotEmpty((String)creatorJ.getString(PluginExtraProps.KEY_ROUTER_LINK))) {
                    creatorJ.put(PluginExtraProps.KEY_CREATOR_ASSIST_TYPE, (Object)RouterAssistType.hyperlink.token);
                }
                createor.setAssistType(RouterAssistType.parse(creatorJ.getString(PluginExtraProps.KEY_CREATOR_ASSIST_TYPE)));
                createor.setSelectableOpts(() -> {
                    JSONArray enums = props.getJSONArray("enum");
                    JSONObject option = null;
                    if (CollectionUtils.isEmpty((Collection)enums)) {
                        return Collections.emptyList();
                    }
                    ArrayList opts = Lists.newArrayList();
                    for (int idx = 0; idx < enums.size(); ++idx) {
                        option = enums.getJSONObject(idx);
                        opts.add(Option.create((JSONObject)option));
                    }
                    return opts;
                });
                if (props.containsKey((Object)PluginExtraProps.KEY_DFTVAL_PROP)) {
                    createor.setDftValGetter(() -> props.get((Object)PluginExtraProps.KEY_DFTVAL_PROP));
                }
            }
            return createor;
        }

        public static void validate(FieldRefCreateor creatorJ, String propKey, Class<?> pluginClazz, String resourceName, boolean finalValidate) {
            String errDesc = PluginExtraProps.createErrorMsg(propKey, pluginClazz, resourceName);
            if (finalValidate) {
                Objects.requireNonNull(creatorJ.getLabel(), errDesc);
                List<CandidatePlugin> plugins = creatorJ.getCandidatePlugins();
                for (CandidatePlugin plugin : plugins) {
                    plugin.validate(errDesc, pluginClazz);
                }
                Objects.requireNonNull(creatorJ.getAssistType(), errDesc);
            }
        }

        @JSONField(serialize=false)
        public Optional<FieldRefCreateor> getRefCreator() {
            if (this._fieldRefCreateor == null) {
                this._fieldRefCreateor = Optional.ofNullable(Props.createFieldRefCreateor(this.props));
            }
            return this._fieldRefCreateor;
        }

        @JSONField(serialize=false)
        public String getAsynHelp() {
            if (this.asynHelp == null) {
                return null;
            }
            return this.asynHelp.getContent().toString();
        }

        @JSONField(serialize=false)
        public AbstractPropAssist.MarkdownHelperContent asynHelp() {
            return this.asynHelp;
        }

        @JSONField(serialize=false)
        public String getLable() {
            return (String)this.props.get((Object)"label");
        }

        @JSONField(serialize=false)
        public String getHelpUrl() {
            return (String)this.props.get((Object)"helpUrl");
        }

        @JSONField(serialize=false)
        public String getHelpContent() {
            return (String)this.props.get((Object)KEY_HELP);
        }

        @JSONField(serialize=false)
        public List<ValidatorCfg> getExtraValidators() {
            Object v = this.props.get((Object)KEY_VALIDATOR);
            if (v == null) {
                return Collections.emptyList();
            }
            if (v instanceof String) {
                return Collections.singletonList(ValidatorCfg.parse((String)v));
            }
            if (v instanceof JSONArray) {
                ArrayList result = Lists.newArrayList();
                for (Object validator : (JSONArray)v) {
                    result.add(ValidatorCfg.parse(String.valueOf(validator)));
                }
                return result;
            }
            throw new IllegalStateException("validate:" + v);
        }

        public boolean isAdvance() {
            return this.props.getBooleanValue("advance");
        }

        @JSONField(serialize=false)
        public SimpleDateFormat getDateTimeFormat() {
            if (this.dateFormat == null) {
                Object p = this.props.get((Object)PluginExtraProps.KEY_DATETIME_FORMAT);
                if (p != null) {
                    this.dateFormat = new SimpleDateFormat(String.valueOf(p));
                } else {
                    throw new IllegalStateException("key:dateTimeFormat can not be null");
                }
            }
            return this.dateFormat;
        }

        @JSONField(serialize=false)
        public String getPlaceholder() {
            Object p = this.props.get((Object)PluginExtraProps.KEY_PLACEHOLDER_PROP);
            if (p != null) {
                return String.valueOf(p);
            }
            return null;
        }

        @JSONField(serialize=false)
        public Object getDftVal() {
            Object o = this.props.get((Object)PluginExtraProps.KEY_DFTVAL_PROP);
            return o == null ? null : o;
        }

        public void tagAsynHelp(AbstractPropAssist.MarkdownHelperContent asynHelp) {
            this.props.put(KEY_ASYNC_HELP, (Object)true);
            this.props.remove((Object)KEY_HELP);
            this.asynHelp = asynHelp;
        }

        public boolean isAsynHelp() {
            return this.props.getBooleanValue(KEY_ASYNC_HELP);
        }

        public boolean getBoolean(String key) {
            return this.props.getBooleanValue(key);
        }

        public JSONObject getProps() {
            return this.props;
        }

        public void merge(Props p) {
            this.jsonMerge(this.props, p.props);
            if (p.isAsynHelp()) {
                AbstractPropAssist.MarkdownHelperContent tpl = this.asynHelp;
                this.asynHelp = new AbstractPropAssist.MarkdownHelperContent(p.asynHelp);
                if (tpl != null) {
                    this.asynHelp = this.asynHelp.append(tpl);
                }
            }
        }

        private void jsonMerge(JSONObject to, JSONObject from) {
            HashMap parentMap = Maps.newHashMap();
            HashSet removeKeys = Sets.newHashSet();
            to.forEach((key, val) -> {
                Matcher matcher = PATTERN_PARENT.matcher((CharSequence)key);
                if (!matcher.matches()) {
                    return;
                }
                removeKeys.add(key);
                String parentKey = matcher.group(1);
                if (!(val instanceof JSONObject)) {
                    throw new IllegalStateException("key:" + key + " relevant val must be 'JSONObject'");
                }
                parentMap.put(parentKey, (JSONObject)val);
            });
            removeKeys.forEach(removeKey -> to.remove(removeKey));
            from.forEach((key, val) -> {
                if (val instanceof JSONObject) {
                    Object toProp = to.get(key);
                    if (toProp != null && toProp instanceof JSONObject) {
                        this.jsonMerge((JSONObject)toProp, (JSONObject)val);
                    } else {
                        to.put(key, val);
                    }
                } else if (val instanceof JSONArray) {
                    JSONArray arys = (JSONArray)val;
                    JSONObject pval = (JSONObject)parentMap.get(key);
                    if (pval != null) {
                        JSONArray narys = new JSONArray();
                        JSONObject o = null;
                        for (int i = 0; i < arys.size(); ++i) {
                            o = (JSONObject)pval.clone();
                            this.jsonMerge(o, arys.getJSONObject(i));
                            narys.add((Object)o);
                        }
                        arys = narys;
                    }
                    to.put(key, (Object)arys);
                } else {
                    to.put(key, val);
                }
            });
        }

        public static class ValidatorCfg {
            public final Validator validator;
            public final boolean disable;

            private static ValidatorCfg parse(String token) {
                String[] split = StringUtils.split((String)token, (String)":");
                if (split.length == 1) {
                    return new ValidatorCfg(Validator.parse(String.valueOf(split[0])));
                }
                if (split.length == 2) {
                    return new ValidatorCfg(Validator.parse(String.valueOf(split[0])), PluginExtraProps.KEY_DISABLE.equalsIgnoreCase(split[1]));
                }
                throw new IllegalStateException("in validate token:" + token);
            }

            public ValidatorCfg(Validator validator) {
                this(validator, false);
            }

            public ValidatorCfg(Validator validator, boolean disable) {
                this.validator = validator;
                this.disable = disable;
            }
        }
    }

    public static class CandidatePlugin {
        protected static final String KEY_DISABLE_PLUGIN_INSTALL = "disablePluginInstall";
        protected static final String KEY_INSTALLED = "installed";
        private final String displayName;
        private String description;
        private String hetero;
        private final Optional<String> targetItemDesc;
        private Optional<Descriptor> descriptor;

        public CandidatePlugin(String displayName, Optional<String> targetItemDesc, String hetero) {
            if (StringUtils.isEmpty((String)displayName)) {
                throw new IllegalArgumentException("displayName can not be empty");
            }
            this.displayName = displayName;
            this.targetItemDesc = Objects.requireNonNull(targetItemDesc, "targetItemDesc can not be null");
            this.hetero = hetero;
        }

        public void setExtraProps(Optional<IEndTypeGetter.EndType> endType, JSONObject option) {
            option.put(KEY_DISABLE_PLUGIN_INSTALL, (Object)false);
            option.put("extendpoint", (Object)this.getHetero().getExtensionPoint().getName());
            endType.ifPresent(et -> option.put(IEndTypeGetter.EndType.KEY_END_TYPE, (Object)et.getVal()));
            option.put(KEY_INSTALLED, (Object)(this.getInstalledPluginDescriptor() != null ? 1 : 0));
            Descriptor installedDesc = this.getInstalledPluginDescriptor();
            if (installedDesc != null) {
                option.put("version", (Object)installedDesc.getId());
            }
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public static JSONArray convertOptionsArray(Optional<IEndTypeGetter.EndType> endType, List<CandidatePlugin> candidatePlugins) {
            JSONArray optionsArray = new JSONArray();
            for (int i = 0; i < candidatePlugins.size(); ++i) {
                CandidatePlugin candidate = candidatePlugins.get(i);
                JSONObject option = new JSONObject();
                option.put("index", (Object)i);
                option.put("name", (Object)candidate.getDisplayName());
                option.put("description", (Object)candidate.getDescription());
                candidate.setExtraProps(endType, option);
                optionsArray.add((Object)option);
            }
            return optionsArray;
        }

        public void validate(String errDesc, Class<?> pluginClazz) {
            if (StringUtils.isBlank((String)this.hetero) || StringUtils.isBlank((String)this.displayName)) {
                throw new IllegalStateException("pmeta is illegal,hetero:" + this.hetero + ",displayName:" + this.displayName + ",pluginClazz:" + pluginClazz.getName() + ",errDesc:" + errDesc);
            }
        }

        public String getTargetItemDesc() {
            return this.targetItemDesc.orElse(this.getDisplayName());
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public <T extends IdentityName> IdentityName createNewPrimaryFieldValue(List<T> existOpts) {
            return IdentityName.createNewPrimaryFieldValue((String)this.getDisplayName(), existOpts);
        }

        public Descriptor getInstalledPluginDescriptor() {
            return this.getInstalledPluginDescriptor(false);
        }

        public Descriptor getInstalledPluginDescriptor(boolean useFresh) {
            if (useFresh || this.descriptor == null) {
                IPluginEnum hetero = this.getHetero();
                List descriptors = hetero.descriptors();
                for (Descriptor d : descriptors) {
                    if (!this.getDisplayName().equals(d.getDisplayName())) continue;
                    this.descriptor = Optional.of(d);
                    return d;
                }
                this.descriptor = Optional.empty();
            }
            return this.descriptor.orElse(null);
        }

        public IPluginEnum getHetero() {
            return HeteroEnum.of(this.hetero);
        }

        public String toString() {
            return "displayName='" + this.displayName + "', hetero='" + this.hetero + "'";
        }
    }

    public static class FieldRefCreateor {
        String label;
        RouterAssistType assistType = null;
        private Supplier<List<Option>> selectableOpts = () -> Collections.emptyList();
        private Supplier<Object> dftValGetter = () -> null;
        List<CandidatePlugin> candidatePlugins = Lists.newArrayList();

        public String getLabel() {
            return this.label;
        }

        public List<Option> getValOptions() {
            return this.selectableOpts.get();
        }

        public void setSelectableOpts(Supplier<List<Option>> selectableOpts) {
            this.selectableOpts = selectableOpts;
        }

        public List<CandidatePlugin> getCandidatePlugins() {
            return this.candidatePlugins;
        }

        public void addCandidatePlugin(CandidatePlugin candidate) {
            this.candidatePlugins.add(candidate);
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public Object getDftValue() {
            return this.dftValGetter.get();
        }

        public void setDftValGetter(Supplier<Object> dftValGetter) {
            this.dftValGetter = dftValGetter;
        }

        public RouterAssistType getAssistType() {
            return this.assistType;
        }

        public void setAssistType(RouterAssistType assistType) {
            this.assistType = assistType;
        }
    }

    public static interface IPostSelectedItemsGetter {
        public List<FormFieldType.SelectedItem> apply(PropertyType var1, IControlMsgHandler var2, Context var3, JSONObject var4);
    }

    public static interface IClassVisitor<T> {
        public T process(Class<?> var1, T var2, boolean var3);
    }

    public static enum RouterAssistType {
        hyperlink("hyperlink"),
        dbQuickManager("dbQuickManager"),
        paramCfg("paramCfg");

        private final String token;

        public static RouterAssistType parse(String token) {
            if (StringUtils.isEmpty((String)token)) {
                throw new IllegalArgumentException("param 'assistType' can not be empty");
            }
            for (RouterAssistType assistType : RouterAssistType.values()) {
                if (!assistType.token.equals(token)) continue;
                return assistType;
            }
            throw new IllegalStateException("illegal routerAssistType:" + token);
        }

        private RouterAssistType(String token) {
            this.token = token;
        }
    }
}

