/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.extension.util;

import com.alibaba.citrus.turbine.Context;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.qlangtech.tis.TIS;
import com.qlangtech.tis.extension.IPropertyType;
import com.qlangtech.tis.extension.impl.PropertyType;
import com.qlangtech.tis.extension.util.PluginExtraProps;
import com.qlangtech.tis.plugin.annotation.FormFieldType;
import com.qlangtech.tis.plugin.ds.CMeta;
import com.qlangtech.tis.plugin.ds.DataTypeMeta;
import com.qlangtech.tis.plugin.ds.ElementCreatorFactory;
import com.qlangtech.tis.plugin.ds.IMultiElement;
import com.qlangtech.tis.plugin.ds.IdlistElementCreatorFactory;
import com.qlangtech.tis.plugin.ds.ViewContent;
import com.qlangtech.tis.runtime.module.misc.IControlMsgHandler;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.BeanUtilsBean2;
import org.apache.commons.lang.StringUtils;

public class MultiItemsViewType
implements DataTypeMeta.IMultiItemsView {
    public static final String keyColsMeta = "colsMeta";
    public final ViewFormatType viewType;
    public final ElementCreatorFactory tupleFactory;
    private final PropertyType propertyType;
    private List<String> elementPropertyKeys;

    private static String getStrProp(PluginExtraProps.Props props, String key) {
        return props.getProps().getString(key);
    }

    public static MultiItemsViewType createMultiItemsViewType(PropertyType propertyType) {
        return MultiItemsViewType.createMultiItemsViewType(propertyType, Objects.requireNonNull(propertyType.extraProp, "propertyType.extraProp can not be null"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MultiItemsViewType createMultiItemsViewType(PropertyType propertyType, PluginExtraProps.Props props) {
        IdlistElementCreatorFactory elementCreator = null;
        ViewFormatType formatType = ViewFormatType.parse(MultiItemsViewType.getStrProp(Objects.requireNonNull(props, "props can not be null"), "viewtype"));
        try {
            String selectElementCreator = MultiItemsViewType.getStrProp(props, "elementCreator");
            if (StringUtils.isEmpty((String)selectElementCreator)) {
                if (formatType != ViewFormatType.IdList) throw new IllegalStateException("param elementCreator can not be empty,formatType:" + formatType + ",property:" + propertyType.f);
                elementCreator = new IdlistElementCreatorFactory();
                return new MultiItemsViewType(propertyType, formatType, elementCreator);
            } else {
                elementCreator = (ElementCreatorFactory)TIS.get().getPluginManager().uberClassLoader.loadClass(selectElementCreator).newInstance();
            }
            return new MultiItemsViewType(propertyType, formatType, elementCreator);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public final String getViewTypeToken() {
        return this.viewType.token;
    }

    public MultiItemsViewType(PropertyType propertyType, ViewFormatType viewType, ElementCreatorFactory tupleFactory) {
        this.viewType = viewType;
        this.tupleFactory = Objects.requireNonNull(tupleFactory, "tupleFactory can not be null");
        this.propertyType = propertyType;
    }

    public List<FormFieldType.SelectedItem> getPostSelectedItems(PropertyType attrDesc, IControlMsgHandler msgHandler, Context context, JSONObject eprops) {
        return this.viewType.getPostSelectedItems(attrDesc, msgHandler, context, eprops);
    }

    public void appendExternalJsonProp(JSONObject biz) {
        this.tupleFactory.appendExternalJsonProp((IPropertyType)this.propertyType, biz);
    }

    public List<String> getElementPropertyKeys() {
        if (this.elementPropertyKeys == null) {
            try {
                PropertyDescriptor[] propertyDescs = BeanUtilsBean2.getInstance().getPropertyUtils().getPropertyDescriptors((Object)this.tupleFactory.createDefault(new JSONObject()));
                this.elementPropertyKeys = Lists.newArrayList();
                for (PropertyDescriptor desc : propertyDescs) {
                    this.elementPropertyKeys.add(desc.getName());
                }
                this.elementPropertyKeys = Collections.unmodifiableList(this.elementPropertyKeys);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.elementPropertyKeys;
    }

    public ViewContent getViewContent() {
        return this.tupleFactory.getViewContentType();
    }

    public List<?> serialize2Frontend(Object bizInstance) {
        return this.viewType.serialize2Frontend(bizInstance);
    }

    public String toString() {
        return "{viewType=" + this.viewType + ", tupleFactory=" + this.tupleFactory.getClass().getSimpleName() + "}";
    }

    public static enum ViewFormatType {
        IdList("idlist", (attrDesc, msgHandler, context, eprops) -> {
            String keyChecked = "checked";
            JSONArray enums = eprops.getJSONArray("enum");
            if (enums == null) {
                enums = new JSONArray();
            }
            JSONObject select = null;
            int selected = 0;
            ArrayList selectedItems = Lists.newArrayList();
            FormFieldType.SelectedItem item = null;
            Object val = null;
            for (int i = 0; i < enums.size(); ++i) {
                select = enums.getJSONObject(i);
                val = select.get((Object)"val");
                if (val.getClass() != String.class) {
                    throw new IllegalStateException("val:" + val + " must be type of String,but now is " + val.getClass());
                }
                item = new FormFieldType.SelectedItem(select.getString("label"), String.valueOf(val), select.containsKey((Object)"checked") && select.getBoolean("checked") != false);
                if (item.isChecked()) {
                    ++selected;
                }
                selectedItems.add(item);
            }
            return selectedItems;
        }, obj -> {
            List mulitOpt = (List)obj;
            return mulitOpt.stream().map(c -> c.getName()).collect(Collectors.toList());
        }),
        TupleList("tuplelist", (attrDesc, msgHandler, context, eprops) -> {
            ElementCreatorFactory elementCreator = attrDesc.getCMetaCreator();
            JSONArray mcols = Objects.requireNonNull(eprops, "eprops can not be null").getJSONObject("enum").getJSONArray("_mcols");
            CMeta.ParsePostMCols parsePostMCols = elementCreator.parsePostMCols((IPropertyType)attrDesc, msgHandler, context, attrDesc.f.getName(), mcols);
            if (parsePostMCols.validateFaild) {
                return Collections.emptyList();
            }
            return parsePostMCols.writerCols.stream().map(cmeta -> new FormFieldType.SelectedItem((IMultiElement)cmeta)).collect(Collectors.toList());
        }, obj -> (List)obj);

        private final String token;
        private final PluginExtraProps.IPostSelectedItemsGetter postSelectedItemsGetter;
        private final Function<Object, List<?>> bizSerializeFrontend;

        private ViewFormatType(String token, PluginExtraProps.IPostSelectedItemsGetter postSelectedItemsGetter, Function<Object, List<?>> bizSerializeFrontend) {
            this.token = token;
            this.postSelectedItemsGetter = postSelectedItemsGetter;
            this.bizSerializeFrontend = bizSerializeFrontend;
        }

        public static ViewFormatType parse(String token) {
            if (StringUtils.isEmpty((String)token)) {
                return IdList;
            }
            for (ViewFormatType t : ViewFormatType.values()) {
                if (!t.token.equalsIgnoreCase(token)) continue;
                return t;
            }
            throw new IllegalStateException("token value:" + token + " is invalid");
        }

        public List<?> serialize2Frontend(Object bizInstance) {
            return this.bizSerializeFrontend.apply(bizInstance);
        }

        public List<FormFieldType.SelectedItem> getPostSelectedItems(PropertyType attrDesc, IControlMsgHandler msgHandler, Context context, JSONObject eprops) {
            return this.postSelectedItemsGetter.apply(attrDesc, msgHandler, context, eprops);
        }
    }
}

