/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.extension.util;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.qlangtech.tis.extension.Describable;
import com.qlangtech.tis.extension.Descriptor;
import com.qlangtech.tis.extension.util.CustomerGroovyClassLoader;
import com.qlangtech.tis.extension.util.GroovyShellFactory;
import com.qlangtech.tis.extension.util.impl.DefaultGroovyShellFactory;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;

public class GroovyShellUtil {
    public static final ThreadLocal<Descriptor> descriptorThreadLocal = new ThreadLocal();
    public static final ThreadLocal<Map<Class<? extends Descriptor>, Describable>> pluginThreadLocal = new ThreadLocal<Map<Class<? extends Descriptor>, Describable>>(){

        @Override
        protected Map<Class<? extends Descriptor>, Describable> initialValue() {
            return new ConcurrentHashMap<Class<? extends Descriptor>, Describable>();
        }
    };
    private static CustomerGroovyClassLoader loader;
    private static GroovyShell shell;
    private static LoadingCache<String, Script> scriptCache;
    private static GroovyShellFactory shellFactory;

    public static void loadMyClass(String className, String script) {
        try {
            GroovyShellUtil.getGroovyLoader().loadMyClass(className, script);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LoadingCache<String, Script> getScriptCache() {
        if (scriptCache != null) return scriptCache;
        Class<GroovyShellUtil> clazz = GroovyShellUtil.class;
        synchronized (GroovyShellUtil.class) {
            if (scriptCache != null) return scriptCache;
            scriptCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, Script>(){

                public Script load(String key) throws Exception {
                    Script parse = GroovyShellUtil.getGroovyShell().parse(key);
                    return parse;
                }
            });
            // ** MonitorExit[var0] (shouldn't be in output)
            return scriptCache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static GroovyShell getGroovyShell() {
        if (shell != null) return shell;
        Class<GroovyShellUtil> clazz = GroovyShellUtil.class;
        synchronized (GroovyShellUtil.class) {
            if (shell != null) return shell;
            shell = GroovyShellUtil.getGroovyShellFactory().createGroovyShell();
            // ** MonitorExit[var0] (shouldn't be in output)
            return shell;
        }
    }

    public static GroovyShellFactory getGroovyShellFactory() {
        if (shellFactory == null) {
            ServiceLoader<GroovyShellFactory> shellFactoryLoader = ServiceLoader.load(GroovyShellFactory.class);
            Iterator<GroovyShellFactory> iterator = shellFactoryLoader.iterator();
            if (iterator.hasNext()) {
                GroovyShellFactory f;
                shellFactory = f = iterator.next();
                return shellFactory;
            }
            shellFactory = new DefaultGroovyShellFactory();
            return shellFactory;
        }
        return shellFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static CustomerGroovyClassLoader getGroovyLoader() {
        if (loader != null) return loader;
        Class<GroovyShellUtil> clazz = GroovyShellUtil.class;
        synchronized (GroovyShellUtil.class) {
            if (loader != null) return loader;
            loader = GroovyShellUtil.getGroovyShellFactory().createGroovyLoader();
            // ** MonitorExit[var0] (shouldn't be in output)
            return loader;
        }
    }

    public static Class<?> loadClass(String pkg, String className) {
        try {
            return GroovyShellUtil.getGroovyLoader().loadClass(pkg + "." + className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

