/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.extension.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.SubBuildListener;
import org.apache.tools.ant.launch.Locator;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.CollectionUtils;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.JavaEnvUtils;
import org.apache.tools.ant.util.LoaderUtils;
import org.apache.tools.ant.util.ReflectUtil;
import org.apache.tools.ant.util.VectorSet;

public class AntClassLoader
extends ClassLoader
implements SubBuildListener {
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();
    private static final int BUFFER_SIZE = 8192;
    private static final int NUMBER_OF_STRINGS = 256;
    private Vector pathComponents = new VectorSet();
    private Project project;
    private boolean parentFirst = true;
    private Vector systemPackages = new Vector();
    private Vector loaderPackages = new Vector();
    private boolean ignoreBase = false;
    private ClassLoader parent = null;
    private Hashtable jarFiles = new Hashtable();
    private static Map pathMap = Collections.synchronizedMap(new HashMap());
    private ClassLoader savedContextLoader = null;
    private boolean isContextLoaderSaved = false;
    private static Class subClassToLoad = null;
    private static final Class[] CONSTRUCTOR_ARGS = new Class[]{ClassLoader.class, Project.class, Path.class, Boolean.TYPE};

    public AntClassLoader(ClassLoader parent, Project project, Path classpath) {
        super(parent);
        this.setParent(parent);
        this.setClassPath(classpath);
        this.setProject(project);
    }

    public AntClassLoader() {
        this.setParent(null);
    }

    public AntClassLoader(Project project, Path classpath) {
        this.setParent(null);
        this.setProject(project);
        this.setClassPath(classpath);
    }

    public AntClassLoader(ClassLoader parent, Project project, Path classpath, boolean parentFirst) {
        this(project, classpath);
        if (parent != null) {
            this.setParent(parent);
        }
        this.setParentFirst(parentFirst);
        this.addJavaLibraries();
    }

    public AntClassLoader(Project project, Path classpath, boolean parentFirst) {
        this(null, project, classpath, parentFirst);
    }

    public AntClassLoader(ClassLoader parent, boolean parentFirst) {
        super(parent);
        this.setParent(parent);
        this.project = null;
        this.parentFirst = parentFirst;
    }

    public void setProject(Project project) {
        this.project = project;
        if (project != null) {
            project.addBuildListener((BuildListener)this);
        }
    }

    public void setClassPath(Path classpath) {
        this.pathComponents.removeAllElements();
        if (classpath != null) {
            Path actualClasspath = classpath.concatSystemClasspath("ignore");
            String[] pathElements = actualClasspath.list();
            for (int i = 0; i < pathElements.length; ++i) {
                try {
                    this.addPathElement(pathElements[i]);
                    continue;
                }
                catch (BuildException buildException) {
                    // empty catch block
                }
            }
        }
    }

    public void setParent(ClassLoader parent) {
        this.parent = parent == null ? AntClassLoader.class.getClassLoader() : parent;
    }

    public void setParentFirst(boolean parentFirst) {
        this.parentFirst = parentFirst;
    }

    protected void log(String message, int priority) {
        if (this.project != null) {
            this.project.log(message, priority);
        }
    }

    public void setThreadContextLoader() {
        if (this.isContextLoaderSaved) {
            throw new BuildException("Context loader has not been reset");
        }
        if (LoaderUtils.isContextLoaderAvailable()) {
            this.savedContextLoader = LoaderUtils.getContextClassLoader();
            ClassLoader loader = this;
            if (this.project != null && "only".equals(this.project.getProperty("build.sysclasspath"))) {
                loader = this.getClass().getClassLoader();
            }
            LoaderUtils.setContextClassLoader((ClassLoader)loader);
            this.isContextLoaderSaved = true;
        }
    }

    public void resetThreadContextLoader() {
        if (LoaderUtils.isContextLoaderAvailable() && this.isContextLoaderSaved) {
            LoaderUtils.setContextClassLoader((ClassLoader)this.savedContextLoader);
            this.savedContextLoader = null;
            this.isContextLoaderSaved = false;
        }
    }

    public void addPathElement(String pathElement) throws BuildException {
        File pathComponent = this.project != null ? this.project.resolveFile(pathElement) : new File(pathElement);
        try {
            this.addPathFile(pathComponent);
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    public void addPathComponent(File file) {
        if (this.pathComponents.contains(file)) {
            return;
        }
        this.pathComponents.addElement(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addPathFile(File pathComponent) throws IOException {
        if (!this.pathComponents.contains(pathComponent)) {
            this.pathComponents.addElement(pathComponent);
        }
        if (pathComponent.isDirectory()) {
            return;
        }
        String absPathPlusTimeAndLength = pathComponent.getAbsolutePath() + pathComponent.lastModified() + "-" + pathComponent.length();
        String classpath = (String)pathMap.get(absPathPlusTimeAndLength);
        if (classpath == null) {
            try (JarFile jarFile = null;){
                jarFile = new JarFile(pathComponent);
                Manifest manifest = jarFile.getManifest();
                if (manifest == null) {
                    return;
                }
                classpath = manifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
            }
            if (classpath == null) {
                classpath = "";
            }
            pathMap.put(absPathPlusTimeAndLength, classpath);
        }
        if (!"".equals(classpath)) {
            URL baseURL = FILE_UTILS.getFileURL(pathComponent);
            StringTokenizer st = new StringTokenizer(classpath);
            while (st.hasMoreTokens()) {
                String classpathElement = st.nextToken();
                URL libraryURL = new URL(baseURL, classpathElement);
                if (!libraryURL.getProtocol().equals("file")) {
                    this.log("Skipping jar library " + classpathElement + " since only relative URLs are supported by this loader", 3);
                    continue;
                }
                String decodedPath = Locator.decodeUri((String)libraryURL.getFile());
                File libraryFile = new File(decodedPath);
                if (!libraryFile.exists() || this.isInPath(libraryFile)) continue;
                this.addPathFile(libraryFile);
            }
        }
    }

    public String getClasspath() {
        StringBuffer sb = new StringBuffer();
        boolean firstPass = true;
        Enumeration componentEnum = this.pathComponents.elements();
        while (componentEnum.hasMoreElements()) {
            if (!firstPass) {
                sb.append(System.getProperty("path.separator"));
            } else {
                firstPass = false;
            }
            sb.append(((File)componentEnum.nextElement()).getAbsolutePath());
        }
        return sb.toString();
    }

    public synchronized void setIsolated(boolean isolated) {
        this.ignoreBase = isolated;
    }

    @Deprecated
    public static void initializeClass(Class theClass) {
        Constructor<?>[] cons = theClass.getDeclaredConstructors();
        if (cons != null && cons.length > 0 && cons[0] != null) {
            Object[] strs = new String[256];
            try {
                cons[0].newInstance(strs);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void addSystemPackageRoot(String packageRoot) {
        this.systemPackages.addElement(packageRoot + (packageRoot.endsWith(".") ? "" : "."));
    }

    public void addLoaderPackageRoot(String packageRoot) {
        this.loaderPackages.addElement(packageRoot + (packageRoot.endsWith(".") ? "" : "."));
    }

    public Class forceLoadClass(String classname) throws ClassNotFoundException {
        this.log("force loading " + classname, 4);
        Class theClass = this.findLoadedClass(classname);
        if (theClass == null) {
            theClass = this.findClass(classname);
        }
        return theClass;
    }

    public Class forceLoadSystemClass(String classname) throws ClassNotFoundException {
        this.log("force system loading " + classname, 4);
        Class theClass = this.findLoadedClass(classname);
        if (theClass == null) {
            theClass = this.findBaseClass(classname);
        }
        return theClass;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        InputStream resourceStream = null;
        if (this.isParentFirst(name)) {
            resourceStream = this.loadBaseResource(name);
        }
        if (resourceStream != null) {
            this.log("ResourceStream for " + name + " loaded from parent loader", 4);
        } else {
            resourceStream = this.loadResource(name);
            if (resourceStream != null) {
                this.log("ResourceStream for " + name + " loaded from ant loader", 4);
            }
        }
        if (resourceStream == null && !this.isParentFirst(name) && (resourceStream = this.ignoreBase ? (this.getRootLoader() == null ? null : this.getRootLoader().getResourceAsStream(name)) : this.loadBaseResource(name)) != null) {
            this.log("ResourceStream for " + name + " loaded from parent loader", 4);
        }
        if (resourceStream == null) {
            this.log("Couldn't load ResourceStream for " + name, 4);
        }
        return resourceStream;
    }

    private InputStream loadResource(String name) {
        InputStream stream = null;
        Enumeration e = this.pathComponents.elements();
        while (e.hasMoreElements() && stream == null) {
            File pathComponent = (File)e.nextElement();
            stream = this.getResourceStream(pathComponent, name);
        }
        return stream;
    }

    private InputStream loadBaseResource(String name) {
        return this.parent == null ? super.getResourceAsStream(name) : this.parent.getResourceAsStream(name);
    }

    private InputStream getResourceStream(File file, String resourceName) {
        try {
            JarFile jarFile = (JarFile)this.jarFiles.get(file);
            if (jarFile == null && file.isDirectory()) {
                File resource = new File(file, resourceName);
                if (resource.exists()) {
                    return new FileInputStream(resource);
                }
            } else {
                JarEntry entry;
                if (jarFile == null) {
                    if (!file.exists()) {
                        return null;
                    }
                    jarFile = new JarFile(file);
                    this.jarFiles.put(file, jarFile);
                    jarFile = (JarFile)this.jarFiles.get(file);
                }
                if ((entry = jarFile.getJarEntry(resourceName)) != null) {
                    return jarFile.getInputStream(entry);
                }
            }
        }
        catch (Exception e) {
            this.log("Ignoring Exception " + e.getClass().getName() + ": " + e.getMessage() + " reading resource " + resourceName + " from " + file, 3);
        }
        return null;
    }

    private boolean isParentFirst(String resourceName) {
        String packageName;
        boolean useParentFirst = this.parentFirst;
        Enumeration e = this.systemPackages.elements();
        while (e.hasMoreElements()) {
            packageName = (String)e.nextElement();
            if (!resourceName.startsWith(packageName)) continue;
            useParentFirst = true;
            break;
        }
        e = this.loaderPackages.elements();
        while (e.hasMoreElements()) {
            packageName = (String)e.nextElement();
            if (!resourceName.startsWith(packageName)) continue;
            useParentFirst = false;
            break;
        }
        return useParentFirst;
    }

    private ClassLoader getRootLoader() {
        ClassLoader ret;
        for (ret = this.getClass().getClassLoader(); ret != null && ret.getParent() != null; ret = ret.getParent()) {
        }
        return ret;
    }

    @Override
    public URL getResource(String name) {
        URL url = null;
        if (this.isParentFirst(name)) {
            URL uRL = url = this.parent == null ? super.getResource(name) : this.parent.getResource(name);
        }
        if (url != null) {
            this.log("Resource " + name + " loaded from parent loader", 4);
        } else {
            Enumeration e = this.pathComponents.elements();
            while (e.hasMoreElements() && url == null) {
                File pathComponent = (File)e.nextElement();
                url = this.getResourceURL(pathComponent, name);
                if (url == null) continue;
                this.log("Resource " + name + " loaded from ant loader", 4);
            }
        }
        if (url == null && !this.isParentFirst(name)) {
            if (this.ignoreBase) {
                url = this.getRootLoader() == null ? null : this.getRootLoader().getResource(name);
            } else {
                URL uRL = url = this.parent == null ? super.getResource(name) : this.parent.getResource(name);
            }
            if (url != null) {
                this.log("Resource " + name + " loaded from parent loader", 4);
            }
        }
        if (url == null) {
            this.log("Couldn't load Resource " + name, 4);
        }
        return url;
    }

    public Enumeration getNamedResources(String name) throws IOException {
        return this.findResources(name, false);
    }

    protected Enumeration findResources(String name) throws IOException {
        return this.findResources(name, true);
    }

    protected Enumeration findResources(String name, boolean parentHasBeenSearched) throws IOException {
        ResourceEnumeration mine = new ResourceEnumeration(name);
        Object base = this.parent != null && (!parentHasBeenSearched || this.parent != this.getParent()) ? this.parent.getResources(name) : new CollectionUtils.EmptyEnumeration();
        if (this.isParentFirst(name)) {
            return CollectionUtils.append((Enumeration)base, (Enumeration)mine);
        }
        if (this.ignoreBase) {
            return this.getRootLoader() == null ? mine : CollectionUtils.append((Enumeration)mine, this.getRootLoader().getResources(name));
        }
        return CollectionUtils.append((Enumeration)mine, (Enumeration)base);
    }

    protected URL getResourceURL(File file, String resourceName) {
        try {
            JarFile jarFile = (JarFile)this.jarFiles.get(file);
            if (jarFile == null && file.isDirectory()) {
                File resource = new File(file, resourceName);
                if (resource.exists()) {
                    try {
                        return FILE_UTILS.getFileURL(resource);
                    }
                    catch (MalformedURLException ex) {
                        return null;
                    }
                }
            } else {
                JarEntry entry;
                if (jarFile == null) {
                    if (!file.exists()) {
                        return null;
                    }
                    jarFile = new JarFile(file);
                    this.jarFiles.put(file, jarFile);
                    jarFile = (JarFile)this.jarFiles.get(file);
                }
                if ((entry = jarFile.getJarEntry(resourceName)) != null) {
                    try {
                        return new URL("jar:" + FILE_UTILS.getFileURL(file) + "!/" + entry);
                    }
                    catch (MalformedURLException ex) {
                        return null;
                    }
                }
            }
        }
        catch (Exception e) {
            String msg = "Unable to obtain resource from " + file + ": ";
            this.log(msg + e, 1);
            System.err.println(msg);
            e.printStackTrace();
        }
        return null;
    }

    protected synchronized Class loadClass(String classname, boolean resolve) throws ClassNotFoundException {
        Class theClass = this.findLoadedClass(classname);
        if (theClass != null) {
            return theClass;
        }
        if (this.isParentFirst(classname)) {
            try {
                theClass = this.findBaseClass(classname);
                this.log("Class " + classname + " loaded from parent loader (parentFirst)", 4);
            }
            catch (ClassNotFoundException cnfe) {
                theClass = this.findClass(classname);
                this.log("Class " + classname + " loaded from ant loader (parentFirst)", 4);
            }
        } else {
            try {
                theClass = this.findClass(classname);
                this.log("Class " + classname + " loaded from ant loader", 4);
            }
            catch (ClassNotFoundException cnfe) {
                if (this.ignoreBase) {
                    throw cnfe;
                }
                theClass = this.findBaseClass(classname);
                this.log("Class " + classname + " loaded from parent loader", 4);
            }
        }
        if (resolve) {
            this.resolveClass(theClass);
        }
        return theClass;
    }

    private String getClassFilename(String classname) {
        return classname.replace('.', '/') + ".class";
    }

    protected Class defineClassFromData(File container, byte[] classData, String classname) throws IOException {
        this.definePackage(container, classname);
        ProtectionDomain currentPd = Project.class.getProtectionDomain();
        String classResource = this.getClassFilename(classname);
        CodeSource src = new CodeSource(FILE_UTILS.getFileURL(container), this.getCertificates(container, classResource));
        ProtectionDomain classesPd = new ProtectionDomain(src, currentPd.getPermissions(), this, currentPd.getPrincipals());
        return this.defineClass(classname, classData, 0, classData.length, classesPd);
    }

    protected void definePackage(File container, String className) throws IOException {
        int classIndex = className.lastIndexOf(46);
        if (classIndex == -1) {
            return;
        }
        String packageName = className.substring(0, classIndex);
        if (this.getPackage(packageName) != null) {
            return;
        }
        Manifest manifest = this.getJarManifest(container);
        if (manifest == null) {
            this.definePackage(packageName, null, null, null, null, null, null, null);
        } else {
            this.definePackage(container, packageName, manifest);
        }
    }

    private Manifest getJarManifest(File container) throws IOException {
        if (container.isDirectory()) {
            return null;
        }
        JarFile jarFile = (JarFile)this.jarFiles.get(container);
        if (jarFile == null) {
            return null;
        }
        return jarFile.getManifest();
    }

    private Certificate[] getCertificates(File container, String entry) throws IOException {
        if (container.isDirectory()) {
            return null;
        }
        JarFile jarFile = (JarFile)this.jarFiles.get(container);
        if (jarFile == null) {
            return null;
        }
        JarEntry ent = jarFile.getJarEntry(entry);
        return ent == null ? null : ent.getCertificates();
    }

    protected void definePackage(File container, String packageName, Manifest manifest) {
        Attributes mainAttributes;
        String sectionName = packageName.replace('.', '/') + "/";
        String specificationTitle = null;
        String specificationVendor = null;
        String specificationVersion = null;
        String implementationTitle = null;
        String implementationVendor = null;
        String implementationVersion = null;
        String sealedString = null;
        URL sealBase = null;
        Attributes sectionAttributes = manifest.getAttributes(sectionName);
        if (sectionAttributes != null) {
            specificationTitle = sectionAttributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
            specificationVendor = sectionAttributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            specificationVersion = sectionAttributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
            implementationTitle = sectionAttributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            implementationVendor = sectionAttributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            implementationVersion = sectionAttributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            sealedString = sectionAttributes.getValue(Attributes.Name.SEALED);
        }
        if ((mainAttributes = manifest.getMainAttributes()) != null) {
            if (specificationTitle == null) {
                specificationTitle = mainAttributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
            }
            if (specificationVendor == null) {
                specificationVendor = mainAttributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            }
            if (specificationVersion == null) {
                specificationVersion = mainAttributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
            }
            if (implementationTitle == null) {
                implementationTitle = mainAttributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            }
            if (implementationVendor == null) {
                implementationVendor = mainAttributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            }
            if (implementationVersion == null) {
                implementationVersion = mainAttributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            }
            if (sealedString == null) {
                sealedString = mainAttributes.getValue(Attributes.Name.SEALED);
            }
        }
        if (sealedString != null && sealedString.equalsIgnoreCase("true")) {
            try {
                sealBase = new URL(FileUtils.getFileUtils().toURI(container.getAbsolutePath()));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        this.definePackage(packageName, specificationTitle, specificationVersion, specificationVendor, implementationTitle, implementationVersion, implementationVendor, sealBase);
    }

    private Class getClassFromStream(InputStream stream, String classname, File container) throws IOException, SecurityException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int bytesRead = -1;
        byte[] buffer = new byte[8192];
        while ((bytesRead = stream.read(buffer, 0, 8192)) != -1) {
            baos.write(buffer, 0, bytesRead);
        }
        byte[] classData = baos.toByteArray();
        return this.defineClassFromData(container, classData, classname);
    }

    public Class findClass(String name) throws ClassNotFoundException {
        this.log("Finding class " + name, 4);
        return this.findClassInComponents(name);
    }

    protected boolean isInPath(File component) {
        return this.pathComponents.contains(component);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Class findClassInComponents(String name) throws ClassNotFoundException {
        Class clazz;
        InputStream stream;
        block7: {
            stream = null;
            String classFilename = this.getClassFilename(name);
            try {
                Enumeration e = this.pathComponents.elements();
                while (e.hasMoreElements()) {
                    File pathComponent = (File)e.nextElement();
                    try {
                        stream = this.getResourceStream(pathComponent, classFilename);
                        if (stream == null) continue;
                        this.log("Loaded from " + pathComponent + " " + classFilename, 4);
                        clazz = this.getClassFromStream(stream, name, pathComponent);
                        break block7;
                    }
                    catch (SecurityException se) {
                        throw se;
                    }
                    catch (IOException ioe) {
                        this.log("Exception reading component " + pathComponent + " (reason: " + ioe.getMessage() + ")", 3);
                    }
                }
                throw new ClassNotFoundException(name);
            }
            catch (Throwable throwable) {
                FileUtils.close(stream);
                throw throwable;
            }
        }
        FileUtils.close((InputStream)stream);
        return clazz;
    }

    private Class findBaseClass(String name) throws ClassNotFoundException {
        return this.parent == null ? this.findSystemClass(name) : this.parent.loadClass(name);
    }

    public synchronized void cleanup() {
        Enumeration e = this.jarFiles.elements();
        while (e.hasMoreElements()) {
            JarFile jarFile = (JarFile)e.nextElement();
            try {
                jarFile.close();
            }
            catch (IOException iOException) {}
        }
        this.jarFiles = new Hashtable();
        if (this.project != null) {
            this.project.removeBuildListener((BuildListener)this);
        }
        this.project = null;
    }

    public ClassLoader getConfiguredParent() {
        return this.parent;
    }

    public void buildStarted(BuildEvent event) {
    }

    public void buildFinished(BuildEvent event) {
        this.cleanup();
    }

    public void subBuildFinished(BuildEvent event) {
        if (event.getProject() == this.project) {
            this.cleanup();
        }
    }

    public void subBuildStarted(BuildEvent event) {
    }

    public void targetStarted(BuildEvent event) {
    }

    public void targetFinished(BuildEvent event) {
    }

    public void taskStarted(BuildEvent event) {
    }

    public void taskFinished(BuildEvent event) {
    }

    public void messageLogged(BuildEvent event) {
    }

    public void addJavaLibraries() {
        Vector packages = JavaEnvUtils.getJrePackages();
        Enumeration e = packages.elements();
        while (e.hasMoreElements()) {
            String packageName = (String)e.nextElement();
            this.addSystemPackageRoot(packageName);
        }
    }

    public String toString() {
        return "AntClassLoader[" + this.getClasspath() + "]";
    }

    public static AntClassLoader newAntClassLoader(ClassLoader parent, Project project, Path path, boolean parentFirst) {
        if (subClassToLoad != null) {
            return (AntClassLoader)ReflectUtil.newInstance((Class)subClassToLoad, (Class[])CONSTRUCTOR_ARGS, (Object[])new Object[]{parent, project, path, parentFirst});
        }
        return new AntClassLoader(parent, project, path, parentFirst);
    }

    static {
        if (JavaEnvUtils.isAtLeastJavaVersion((String)"1.5")) {
            try {
                subClassToLoad = Class.forName("org.apache.tools.ant.loader.AntClassLoader5");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    private class ResourceEnumeration
    implements Enumeration {
        private String resourceName;
        private int pathElementsIndex;
        private URL nextResource;

        ResourceEnumeration(String name) {
            this.resourceName = name;
            this.pathElementsIndex = 0;
            this.findNextResource();
        }

        @Override
        public boolean hasMoreElements() {
            return this.nextResource != null;
        }

        public Object nextElement() {
            URL ret = this.nextResource;
            if (ret == null) {
                throw new NoSuchElementException();
            }
            this.findNextResource();
            return ret;
        }

        private void findNextResource() {
            URL url = null;
            while (this.pathElementsIndex < AntClassLoader.this.pathComponents.size() && url == null) {
                try {
                    File pathComponent = (File)AntClassLoader.this.pathComponents.elementAt(this.pathElementsIndex);
                    url = AntClassLoader.this.getResourceURL(pathComponent, this.resourceName);
                    ++this.pathElementsIndex;
                }
                catch (BuildException buildException) {}
            }
            this.nextResource = url;
        }
    }
}

