/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.extension.util;

import com.google.common.collect.Lists;
import com.qlangtech.tis.extension.Describable;
import com.qlangtech.tis.extension.Descriptor;
import com.qlangtech.tis.extension.IPropertyType;
import com.qlangtech.tis.extension.impl.PropertyType;
import com.qlangtech.tis.extension.util.OverwriteProps;
import com.qlangtech.tis.extension.util.PluginExtraProps;
import com.qlangtech.tis.extension.util.PropAssistFieldTriple;
import com.qlangtech.tis.extension.util.PropValFilter;
import com.qlangtech.tis.manage.common.Option;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractPropAssist<T extends Describable, FIELD> {
    private Descriptor<T> descriptor;
    private Map<String, IPropertyType> props;

    protected AbstractPropAssist(Descriptor<T> descriptor) {
        this.descriptor = descriptor;
    }

    private Map<String, IPropertyType> getProps() {
        if (this.props == null) {
            this.props = this.descriptor.getPropertyTypes(false);
        }
        return this.props;
    }

    protected Options createOptions() {
        return new Options(this);
    }

    protected abstract MarkdownHelperContent getDescription(FIELD var1);

    protected abstract Object getDefaultValue(FIELD var1);

    protected abstract List<Option> getOptEnums(FIELD var1);

    protected abstract String getDisplayName(FIELD var1);

    protected final void addFieldDescriptor(String fieldName, FIELD configOption, OverwriteProps overwriteProps) {
        MarkdownHelperContent desc = this.getDescription(configOption);
        Object dftVal = overwriteProps.processDftVal(this.getDefaultValue(configOption));
        PropertyType propertyType = Objects.requireNonNull((PropertyType)this.getProps().get(fieldName), "fieldName:" + fieldName + " relevant propertyType can not be null");
        dftVal = propertyType.serialize2FrontendOutput(dftVal);
        List<Option> opts = this.getOptEnums(configOption);
        this.descriptor.addFieldDescriptor(fieldName, dftVal, overwriteProps.labelRewrite.apply(this.getDisplayName(configOption)), desc.append(overwriteProps), overwriteProps.opts.isPresent() ? overwriteProps.opts : Optional.ofNullable(opts));
    }

    public static class MarkdownHelperContent {
        private final StringBuffer content = new StringBuffer();
        int lastLineEmptyCount = 0;
        boolean hasAddLine = false;
        private final PluginExtraProps.AsynPropHelp asynProp;

        public MarkdownHelperContent(PluginExtraProps.AsynPropHelp content) {
            this.appendContent(Objects.requireNonNull(content, "content can not be null").getDetailed());
            this.asynProp = content;
        }

        public MarkdownHelperContent(MarkdownHelperContent content) {
            this(new PluginExtraProps.AsynPropHelp(content.getContent()));
        }

        private MarkdownHelperContent appendContent(String content) {
            try (BufferedReader reader = new BufferedReader(new StringReader(content));){
                String line = null;
                while ((line = reader.readLine()) != null) {
                    this.lastLineEmptyCount = StringUtils.isEmpty((String)line) ? ++this.lastLineEmptyCount : 0;
                    if (this.lastLineEmptyCount > 1) continue;
                    if (this.hasAddLine) {
                        this.content.append("\n");
                    }
                    this.content.append(line);
                    this.hasAddLine = true;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        public MarkdownHelperContent append(OverwriteProps overwriteProps) {
            if (overwriteProps.appendHelper.isPresent()) {
                this.appendContent("\n\n" + overwriteProps.appendHelper.get());
            }
            return this;
        }

        public MarkdownHelperContent append(MarkdownHelperContent content) {
            if (content.isNotEmpty()) {
                this.appendContent("\n\n" + content.content.toString());
            }
            return this;
        }

        public StringBuffer getContent() {
            return this.content;
        }

        public StringBuffer getContentForAI() {
            StringBuffer shortContent = null;
            shortContent = this.asynProp.getAbstracted();
            if (shortContent != null) {
                return shortContent;
            }
            return this.getContent();
        }

        public boolean isNotEmpty() {
            return StringUtils.isNotEmpty((String)this.content.toString());
        }
    }

    public static class TISAssistProp<FIELD> {
        OverwriteProps overwriteProp = new OverwriteProps();
        private final FIELD configOption;
        boolean hasSetOverWrite = false;

        public static <FIELD> TISAssistProp<FIELD> create(FIELD configOption) {
            return new TISAssistProp<FIELD>(configOption);
        }

        public FIELD getConfigOption() {
            return this.configOption;
        }

        public static void set(TISAssistProp assistProp, List<Option> enumOpts, Object dftVal) {
            if (!assistProp.hasSetOverWrite) {
                OverwriteProps overwriteProp = new OverwriteProps();
                overwriteProp.setEnumOpts(enumOpts);
                overwriteProp.setDftVal(dftVal);
                assistProp.setOverwriteProp(overwriteProp);
            } else {
                assistProp.overwriteProp.setEnumOpts(enumOpts);
                assistProp.overwriteProp.setDftVal(dftVal);
            }
        }

        private TISAssistProp(FIELD configOption) {
            this.configOption = configOption;
        }

        public TISAssistProp overwriteDft(Object dftVal) {
            return this.setOverwriteProp(OverwriteProps.dft(dftVal));
        }

        public TISAssistProp overwriteBooleanEnums() {
            OverwriteProps booleanEnums = OverwriteProps.createBooleanEnums();
            this.overwriteProp.setEnumOpts(booleanEnums.opts.get());
            this.overwriteProp.dftValConvert = booleanEnums.dftValConvert;
            return this;
        }

        public TISAssistProp overwritePlaceholder(Object placeholder) {
            return this.setOverwriteProp(OverwriteProps.placeholder(placeholder));
        }

        public TISAssistProp overwriteLabel(String label) {
            return this.setOverwriteProp(OverwriteProps.label(label));
        }

        public TISAssistProp overwriteLabel(Function<String, String> labelRewrite) {
            return this.setOverwriteProp(OverwriteProps.label(labelRewrite));
        }

        public TISAssistProp setOverwriteProp(OverwriteProps overwriteProp) {
            if (this.hasSetOverWrite) {
                throw new IllegalStateException("overwriteProp has been setted ,can not be writen twice");
            }
            this.overwriteProp = overwriteProp;
            this.hasSetOverWrite = true;
            return this;
        }
    }

    public static class Options<T extends Describable, FIELD> {
        private final List<PropAssistFieldTriple<FIELD>> opts = Lists.newArrayList();
        private final AbstractPropAssist<T, FIELD> propsAssist;

        public Options(AbstractPropAssist<T, FIELD> propsAssist) {
            this.propsAssist = propsAssist;
        }

        public void add(String fieldName, FIELD configOption) {
            this.add(fieldName, TISAssistProp.create(configOption));
        }

        public void add(String fieldName, FIELD configOption, OverwriteProps overwriteProps) {
            TISAssistProp<FIELD> assistProp = TISAssistProp.create(configOption);
            this.add(fieldName, assistProp.setOverwriteProp(overwriteProps), (PropValFilter)null);
        }

        private void addFieldDescriptor(String fieldName, FIELD configOption, OverwriteProps overwriteProps) {
            this.propsAssist.addFieldDescriptor(fieldName, configOption, overwriteProps);
        }

        public void add(String fieldName, TISAssistProp<FIELD> option, PropValFilter propValFilter) {
            if (StringUtils.isNotEmpty((String)fieldName)) {
                this.addFieldDescriptor(fieldName, option.configOption, option.overwriteProp);
            }
            this.opts.add(PropAssistFieldTriple.of(fieldName, option.configOption, propValFilter));
        }

        public void add(String fieldName, TISAssistProp option) {
            this.add(fieldName, option, (PropValFilter)null);
        }

        public void add(FIELD option, PropValFilter propValFilter) {
            this.add(null, TISAssistProp.create(option), propValFilter);
        }

        public void setTarget(BiConsumer<FIELD, Object> targetPropSetter, T instance) {
            PropertyType property = null;
            PropValFilter propValFilter = null;
            Object val = null;
            for (PropAssistFieldTriple<FIELD> opt : this.opts) {
                propValFilter = opt.getPropValFilter();
                if (StringUtils.isEmpty((String)opt.getFieldName())) {
                    throw new IllegalStateException("fieldKey can not be empty");
                }
                property = Objects.requireNonNull((PropertyType)this.getProps().get(opt.getFieldName()), "key:" + opt.getFieldName() + " relevant props can not be null");
                val = property.getVal(false, instance);
                if (val == null) {
                    if (!property.isInputRequired()) continue;
                    throw new IllegalStateException("property:" + property.displayName + " is required but now is null");
                }
                if (propValFilter != null) {
                    val = propValFilter.apply(val);
                }
                targetPropSetter.accept(opt.getField(), val);
            }
        }

        public Map<String, IPropertyType> getProps() {
            return this.propsAssist.getProps();
        }
    }
}

