/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.extension.plugins;

import com.google.common.annotations.VisibleForTesting;
import com.qlangtech.tis.extension.PluginWrapper;
import com.qlangtech.tis.extension.util.JavaSpecificationVersion;
import com.qlangtech.tis.extension.util.VersionNumber;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;

public class DetachedPluginsUtil {
    private static final Logger LOGGER = Logger.getLogger(DetachedPluginsUtil.class.getName());
    @VisibleForTesting
    static final List<DetachedPlugin> DETACHED_LIST = Collections.emptyList();
    private static final Set<String> BREAK_CYCLES = Collections.emptySet();

    private DetachedPluginsUtil() {
    }

    public static List<PluginWrapper.Dependency> getImpliedDependencies(String pluginName, String jenkinsVersion) {
        ArrayList<PluginWrapper.Dependency> out = new ArrayList<PluginWrapper.Dependency>();
        for (DetachedPlugin detached : DetachedPluginsUtil.getDetachedPlugins()) {
            if (detached.shortName.equals(pluginName)) continue;
            if (BREAK_CYCLES.contains(pluginName + " " + detached.shortName)) {
                LOGGER.log(Level.FINE, "skipping implicit dependency {0} \u2192 {1}", new Object[]{pluginName, detached.shortName});
                continue;
            }
            if (jenkinsVersion != null && !jenkinsVersion.equals("null") && new VersionNumber(jenkinsVersion).compareTo(detached.splitWhen) > 0) continue;
            out.add(PluginWrapper.Dependency.parse(detached.shortName + ":" + detached.requiredVersion + ";resolution:=optional"));
            LOGGER.log(Level.FINE, "adding implicit dependency {0} \u2192 {1} because of {2}", new Object[]{pluginName, detached.shortName, jenkinsVersion});
        }
        return out;
    }

    public static List<DetachedPlugin> getDetachedPlugins() {
        return Collections.emptyList();
    }

    public static List<DetachedPlugin> getDetachedPlugins(VersionNumber since) {
        return DetachedPluginsUtil.getDetachedPlugins().stream().filter(detachedPlugin -> !detachedPlugin.getSplitWhen().isOlderThan(since)).collect(Collectors.toList());
    }

    public static boolean isDetachedPlugin(String pluginId) {
        for (DetachedPlugin detachedPlugin : DetachedPluginsUtil.getDetachedPlugins()) {
            if (!detachedPlugin.getShortName().equals(pluginId)) continue;
            return true;
        }
        return false;
    }

    private static Stream<String> configLines(InputStream is) throws IOException {
        return IOUtils.readLines((InputStream)is, (Charset)StandardCharsets.UTF_8).stream().filter(line -> !line.matches("#.*|\\s*"));
    }

    public static final class DetachedPlugin {
        private final String shortName;
        private final VersionNumber splitWhen;
        private final String requiredVersion;
        private final JavaSpecificationVersion minJavaVersion;

        private DetachedPlugin(String shortName, String splitWhen, String requiredVersion, String minJavaVersion) {
            this.shortName = shortName;
            this.splitWhen = new VersionNumber(splitWhen);
            this.requiredVersion = requiredVersion;
            this.minJavaVersion = new JavaSpecificationVersion(minJavaVersion);
        }

        public String getShortName() {
            return this.shortName;
        }

        public VersionNumber getSplitWhen() {
            return this.splitWhen;
        }

        public VersionNumber getRequiredVersion() {
            return new VersionNumber(this.requiredVersion);
        }

        public String toString() {
            return this.shortName + " " + this.splitWhen.toString().replace(".*", "") + " " + this.requiredVersion;
        }

        public JavaSpecificationVersion getMinimumJavaVersion() {
            return this.minJavaVersion;
        }
    }
}

