/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.extension.model;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.qlangtech.tis.TIS;
import com.qlangtech.tis.extension.ITPIArtifact;
import com.qlangtech.tis.extension.ITPIArtifactMatch;
import com.qlangtech.tis.extension.PluginManager;
import com.qlangtech.tis.extension.PluginWrapper;
import com.qlangtech.tis.extension.model.FormValidation;
import com.qlangtech.tis.extension.model.IPluginCoord;
import com.qlangtech.tis.extension.model.UpdateCenter;
import com.qlangtech.tis.extension.model.UpdateCenterResource;
import com.qlangtech.tis.extension.plugins.DetachedPluginsUtil;
import com.qlangtech.tis.extension.util.TextFile;
import com.qlangtech.tis.extension.util.VersionNumber;
import com.qlangtech.tis.lang.ErrorValue;
import com.qlangtech.tis.lang.TisException;
import com.qlangtech.tis.manage.common.ConfigFileContext;
import com.qlangtech.tis.manage.common.HttpUtils;
import com.qlangtech.tis.manage.common.Option;
import com.qlangtech.tis.manage.common.TisUTF8;
import com.qlangtech.tis.maven.plugins.tpi.PluginClassifier;
import com.qlangtech.tis.plugin.IEndTypeGetter;
import com.qlangtech.tis.plugin.IPluginTaggable;
import com.qlangtech.tis.plugin.license.TISLicense;
import com.qlangtech.tis.trigger.util.JsonUtil;
import com.qlangtech.tis.util.MemoryReductionUtil;
import com.qlangtech.tis.util.Util;
import com.qlangtech.tis.utils.TisMetaProps;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateSite {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpdateSite.class);
    private volatile transient long dataTimestamp;
    private volatile transient long lastAttempt;
    private volatile transient long retryWindow;
    private transient Data data;
    private final String id;
    private final String url;
    static final Predicate<Object> IS_DEP_PREDICATE = x -> x instanceof JSONObject && UpdateSite.get((JSONObject)x, "name") != null;
    static final Predicate<Object> IS_NOT_OPTIONAL = x -> "false".equals(UpdateSite.get((JSONObject)x, "optional"));
    public static ThreadLocal<ConcurrentHashMap<String, List<IPluginCoord>>> pluginArtsThreadlocal = new ThreadLocal<ConcurrentHashMap<String, List<IPluginCoord>>>(){

        @Override
        protected ConcurrentHashMap<String, List<IPluginCoord>> initialValue() {
            return new ConcurrentHashMap<String, List<IPluginCoord>>();
        }
    };

    public static UpdateSite tisDftUpdateSite() {
        return UpdateSite.tisDftUpdateSite(TisMetaProps.getInstance().getVersion());
    }

    public static UpdateSite tisDftUpdateSite(String tisVersion) {
        return new UpdateSite("default", UpdateCenterResource.UPDATE_CENTER_URL + "default.json");
    }

    public UpdateSite(String id, String url) {
        this.id = id;
        this.url = url;
    }

    public Future<FormValidation> updateDirectly() {
        return this.updateDirectly(false);
    }

    public Future<FormValidation> updateDirectly(final boolean signatureCheck) {
        if (!this.getDataFile().exists() || this.isDue()) {
            return UpdateCenter.updateService.submit(new Callable<FormValidation>(){

                @Override
                public FormValidation call() throws Exception {
                    TextFile faildSignal = UpdateSite.this.getDataLoadFaildFile();
                    boolean faild = false;
                    try {
                        FormValidation formValidation = UpdateSite.this.updateDirectlyNow(signatureCheck);
                        return formValidation;
                    }
                    catch (Exception e) {
                        faild = true;
                        faildSignal.write(e.getMessage());
                        throw e;
                    }
                    finally {
                        if (!faild) {
                            try {
                                faildSignal.delete();
                            }
                            catch (Throwable throwable) {}
                        }
                    }
                }
            });
        }
        return null;
    }

    public Plugin getPlugin(String artifactId) {
        Data dt = this.getData();
        if (dt == null) {
            return null;
        }
        return dt.plugins.get(artifactId);
    }

    public String getUrl() {
        return this.url;
    }

    private FormValidation updateDirectlyNow(boolean signatureCheck) throws IOException {
        String siteCfgUrl = this.getUrl() + "?id=" + URLEncoder.encode(this.getId(), "UTF-8") + "&version=" + URLEncoder.encode(TIS.VERSION, "UTF-8");
        LOGGER.info("siteCfgUrl:{}", (Object)siteCfgUrl);
        return this.updateData((String)HttpUtils.get((URL)new URL(siteCfgUrl), (ConfigFileContext.StreamProcess)new ConfigFileContext.StreamProcess<String>(){

            public String p(int status, InputStream stream, Map<String, List<String>> headerFields) {
                try {
                    return IOUtils.toString((InputStream)stream, (Charset)TisUTF8.get());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }), signatureCheck);
    }

    private FormValidation updateData(String json, boolean signatureCheck) throws IOException {
        this.dataTimestamp = System.currentTimeMillis();
        JSONObject o = JSONObject.parseObject((String)json);
        try {
            int v = o.getIntValue("updateCenterVersion");
            if (v != 1) {
                throw new IllegalArgumentException("Unrecognized update center version: " + v);
            }
        }
        catch (JSONException x) {
            throw new IllegalArgumentException("Could not find (numeric) updateCenterVersion in " + json, x);
        }
        if (signatureCheck) {
            // empty if block
        }
        LOGGER.info("Obtained the latest update center data file for UpdateSource " + this.id);
        this.retryWindow = 0L;
        this.getDataFile().write(json);
        this.data = new Data(o);
        return FormValidation.ok();
    }

    public synchronized boolean isDue() {
        return false;
    }

    public String getId() {
        return this.id;
    }

    public String getConnectionCheckUrl() {
        Data dt = this.getData();
        if (dt == null) {
            return "http://www.google.com/";
        }
        return dt.connectionCheckUrl;
    }

    protected UpdateCenter.InstallationJob createInstallationJob(Plugin plugin, IPluginCoord coord, UpdateCenter uc, boolean dynamicLoad) {
        UpdateCenter updateCenter = uc;
        Objects.requireNonNull(updateCenter);
        return updateCenter.new UpdateCenter.InstallationJob(plugin, coord, this, dynamicLoad);
    }

    private static String get(JSONObject o, String prop) {
        return o.getString(prop);
    }

    public Plugin createPlugin(String sourceId, boolean supportMultiClassifier, JSONObject pluginMeta, List<DftCoord> classifiers) {
        if (supportMultiClassifier) {
            return new MultiClassifierPlugin(sourceId, classifiers, pluginMeta);
        }
        return new NoneClassifierPlugin(sourceId, pluginMeta);
    }

    private TextFile getDataFile() {
        return new TextFile(UpdateSite.getFile(this.getId() + ".json"));
    }

    private static File getFile(String name) {
        return new File(TIS.pluginCfgRoot, "updates/" + name);
    }

    public TextFile getDataLoadFaildFile() {
        return new TextFile(UpdateSite.getFile(this.getId() + ".error"));
    }

    public boolean existLocal() {
        return this.getDataFile().exists();
    }

    public JSONObject getJSONObject() {
        TextFile df = this.getDataFile();
        if (df.exists()) {
            long start = System.nanoTime();
            try {
                JSONObject o = JSONObject.parseObject((String)df.read());
                LOGGER.info(String.format("Loaded and parsed %s in %.01fs", df, (double)(System.nanoTime() - start) / 1.0E9));
                return o;
            }
            catch (JSONException | IOException e) {
                LOGGER.error("Failed to parse " + df, e);
                df.delete();
                return null;
            }
        }
        return null;
    }

    public Data getData() {
        JSONObject o;
        if (this.data == null && (o = this.getJSONObject()) != null) {
            this.data = new Data(o);
        }
        return this.data;
    }

    public List<Plugin> getAvailables() {
        return this.getPlugins(p -> p.getInstalled() == null);
    }

    public List<Plugin> getAllPlugins() {
        return this.getPlugins(p -> true);
    }

    public List<Plugin> getPlugins(Predicate<Plugin> predicate) {
        ArrayList<Plugin> r = new ArrayList<Plugin>();
        Data data = this.getData();
        if (data == null) {
            return Collections.emptyList();
        }
        for (Plugin p : data.plugins.values()) {
            if (!predicate.test(p)) continue;
            r.add(p);
        }
        r.sort((plugin, t1) -> {
            int pop = t1.popularity.compareTo(plugin.popularity);
            if (pop != 0) {
                return pop;
            }
            return plugin.getDisplayName().compareTo(t1.getDisplayName());
        });
        return r;
    }

    public boolean isLegacyDefault() {
        return true;
    }

    public static final class Deprecation {
        public final String url;

        public Deprecation(String url) {
            this.url = url;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Deprecation that = (Deprecation)o;
            return Objects.equals(this.url, that.url);
        }

        public int hashCode() {
            return Objects.hash(this.url);
        }
    }

    public static final class Warning {
        public Type type;
        public final String id;
        public final String component;
        public final String message;
        public final String url;
        public final List<WarningVersionRange> versionRanges;

        public Warning(JSONObject o) {
            try {
                this.type = Type.valueOf(o.getString("type").toUpperCase(Locale.US));
            }
            catch (IllegalArgumentException ex) {
                this.type = Type.UNKNOWN;
            }
            this.id = o.getString("id");
            this.component = Util.intern(o.getString("name"));
            this.message = o.getString("message");
            this.url = o.getString("url");
            JSONArray versions = o.getJSONArray("versions");
            if (versions != null) {
                ArrayList<WarningVersionRange> ranges = new ArrayList<WarningVersionRange>(versions.size());
                for (int i = 0; i < versions.size(); ++i) {
                    WarningVersionRange range = new WarningVersionRange(versions.getJSONObject(i));
                    ranges.add(range);
                }
                this.versionRanges = Collections.unmodifiableList(ranges);
            } else {
                this.versionRanges = Collections.emptyList();
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Warning)) {
                return false;
            }
            Warning warning = (Warning)o;
            return this.id.equals(warning.id);
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public boolean isPluginWarning(String pluginName) {
            return this.type == Type.PLUGIN && pluginName.equals(this.component);
        }

        public boolean isRelevant() {
            switch (this.type) {
                case CORE: {
                    VersionNumber current = TIS.getVersion();
                    return this.isRelevantToVersion(current);
                }
                case PLUGIN: {
                    PluginWrapper plugin = TIS.get().getPluginManager().getPlugin(ITPIArtifact.create(this.component));
                    if (plugin == null) {
                        return false;
                    }
                    VersionNumber currentCore = plugin.getVersionNumber();
                    return this.isRelevantToVersion(currentCore);
                }
            }
            return false;
        }

        public boolean isRelevantToVersion(VersionNumber version) {
            if (this.versionRanges.isEmpty()) {
                return true;
            }
            for (WarningVersionRange range : this.versionRanges) {
                if (!range.includes(version)) continue;
                return true;
            }
            return false;
        }

        public static enum Type {
            CORE,
            PLUGIN,
            UNKNOWN;

        }
    }

    public final class Data {
        public final String sourceId;
        public final Entry core;
        public final Map<String, Plugin> plugins = new TreeMap<String, Plugin>(String.CASE_INSENSITIVE_ORDER);
        private final Set<Warning> warnings = new HashSet<Warning>();
        private final Map<String, Deprecation> deprecations = new HashMap<String, Deprecation>();
        public final String connectionCheckUrl;

        Data(JSONObject o) {
            JSONObject deprecations;
            this.sourceId = Util.intern((String)o.get((Object)"id"));
            JSONObject c = o.getJSONObject("core");
            this.core = c != null ? new Entry(this.sourceId, c, UpdateSite.this.url) : null;
            JSONArray w = o.getJSONArray("warnings");
            if (w != null) {
                for (int i2 = 0; i2 < w.size(); ++i2) {
                    try {
                        this.warnings.add(new Warning(w.getJSONObject(i2)));
                        continue;
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Failed to parse JSON for warning", (Throwable)ex);
                    }
                }
            }
            if ((deprecations = o.getJSONObject("deprecations")) != null) {
                for (String pluginId : deprecations.keySet()) {
                    try {
                        String referenceUrl;
                        JSONObject entry = deprecations.getJSONObject(pluginId);
                        if (entry == null || (referenceUrl = entry.getString("url")) == null) continue;
                        this.deprecations.put(pluginId, new Deprecation(referenceUrl));
                    }
                    catch (RuntimeException ex) {
                        LOGGER.info("Failed to parse JSON for deprecation", (Throwable)ex);
                    }
                }
            }
            JSONObject plugins = o.getJSONObject("plugins");
            JSONObject pluginMeta = null;
            List<Object> classifiers = null;
            for (Map.Entry e : plugins.entrySet()) {
                pluginMeta = (JSONObject)e.getValue();
                classifiers = Lists.newArrayList();
                boolean supportMultiClassifier = pluginMeta.getBooleanValue("supportMultiClassifier");
                JSONArray classifierInfo = pluginMeta.getJSONArray("classifier");
                if (supportMultiClassifier && classifierInfo != null && classifierInfo.size() > 0) {
                    classifiers = classifierInfo.stream().map(i -> new DftCoord((String)e.getKey(), (JSONObject)i)).collect(Collectors.toList());
                }
                Plugin p = UpdateSite.this.createPlugin(this.sourceId, supportMultiClassifier, pluginMeta, classifiers);
                List<PluginWrapper.Dependency> implicitDeps = DetachedPluginsUtil.getImpliedDependencies(p.name, p.requiredCore);
                if (!implicitDeps.isEmpty()) {
                    for (PluginWrapper.Dependency dep : implicitDeps) {
                        if (p.dependencies.containsKey(dep.shortName)) continue;
                        p.dependencies.put(dep.shortName, dep.version);
                    }
                }
                this.plugins.put(Util.intern((String)e.getKey()), p);
                if (!p.hasCategory("deprecated") || this.deprecations.containsKey(p.name)) continue;
                this.deprecations.put(p.name, new Deprecation(p.wiki));
            }
            this.connectionCheckUrl = (String)o.get((Object)"connectionCheckUrl");
        }

        public Set<Warning> getWarnings() {
            return this.warnings;
        }

        public Map<String, Deprecation> getDeprecations() {
            return this.deprecations;
        }

        public boolean hasCoreUpdates() {
            return this.core != null && this.core.isNewerThan(TIS.VERSION);
        }

        public boolean canUpgrade() {
            return true;
        }
    }

    private class MultiClassifierPlugin
    extends Plugin {
        private final List<DftCoord> coords;

        public MultiClassifierPlugin(String sourceId, List<DftCoord> coords, JSONObject o) {
            super(sourceId, o);
            if (CollectionUtils.isEmpty(coords)) {
                throw new IllegalArgumentException("param coords can not be empty");
            }
            this.coords = coords;
        }

        @Override
        public boolean isMultiClassifier() {
            return true;
        }

        private List<IPluginCoord> createPluginCoords() {
            Object plugin = null;
            ArrayList installCoords = Lists.newArrayList();
            this.getDepInstallCoords(installCoords, this);
            Optional<ITPIArtifact> containClassifier = installCoords.stream().filter(c -> c.getClassifier().isPresent()).findAny();
            if (CollectionUtils.isEmpty((Collection)installCoords) || !containClassifier.isPresent()) {
                return this.coords.stream().collect(Collectors.toList());
            }
            String id = "merge";
            Optional<PluginClassifier> depClassifier = null;
            PluginClassifier c2 = null;
            final HashMap dimension = Maps.newHashMap();
            for (ITPIArtifact dep : installCoords) {
                depClassifier = dep.getClassifier();
                if (!depClassifier.isPresent()) continue;
                c2 = depClassifier.get();
                dimension.putAll(c2.dimensionMap());
            }
            PluginClassifier.validateDimension((Map)dimension);
            ITPIArtifact merge = new ITPIArtifact(){

                @Override
                public String getIdentityName() {
                    return "merge";
                }

                @Override
                public Optional<PluginClassifier> getClassifier() {
                    return Optional.of(new PluginClassifier(dimension));
                }
            };
            return this.coords.stream().filter(coord -> {
                ITPIArtifactMatch matchh = ITPIArtifact.matchh(this.getDisplayName(), coord.getClassifier());
                matchh.setIdentityName("merge");
                return ITPIArtifact.isEquals(merge, matchh);
            }).collect(Collectors.toList());
        }

        @Override
        @JSONField(serialize=true)
        public List<IPluginCoord> getArts() {
            ConcurrentHashMap<String, List<IPluginCoord>> pluginArts = pluginArtsThreadlocal.get();
            List<IPluginCoord> pluginCoords = pluginArts.get(this.getDisplayName());
            if (pluginCoords == null) {
                pluginCoords = this.createPluginCoords();
                pluginArts.put(this.getDisplayName(), pluginCoords);
            }
            return pluginCoords;
        }

        private void getDepInstallCoords(List<ITPIArtifact> installCoords, Plugin p) {
            Plugin plugin = null;
            for (Pair<Plugin, VersionNumber> depPlugin : p.getDependencyPlugins()) {
                plugin = (Plugin)depPlugin.getLeft();
                if (!plugin.needInstall((VersionNumber)depPlugin.getRight())) {
                    installCoords.add(plugin.getInstalled());
                }
                this.getDepInstallCoords(installCoords, plugin);
            }
        }
    }

    private class NoneClassifierPlugin
    extends Plugin
    implements IPluginCoord {
        public final URL url;
        String sha1;
        String sha256;
        String sha512;
        public final String sizeLiteral;
        public final long size;

        public NoneClassifierPlugin(String sourceId, JSONObject o) {
            super(sourceId, o);
            String baseURL = UpdateSite.this.url;
            this.sha1 = Util.fixEmptyAndTrim(o.getString("sha1"));
            this.sha256 = Util.fixEmptyAndTrim(o.getString("sha256"));
            this.sha512 = Util.fixEmptyAndTrim(o.getString("sha512"));
            try {
                this.url = new URL(o.getString("url"));
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            this.size = o.getLongValue("size");
            this.sizeLiteral = FileUtils.byteCountToDisplaySize((long)this.size);
        }

        @Override
        @JSONField(serialize=false)
        public List<IPluginCoord> getArts() {
            return Collections.singletonList(this);
        }

        @Override
        public boolean isMultiClassifier() {
            return false;
        }

        @Override
        public String getIdentityName() {
            return this.name;
        }

        public URL getDownloadUrl() throws MalformedURLException {
            return this.url;
        }

        public String getSha1() throws IOException {
            return this.sha1;
        }

        public String getSha256() throws IOException {
            return this.sha256;
        }

        public long getSize() throws IOException {
            return this.size;
        }

        public String getGav() {
            return null;
        }
    }

    private static class DftCoord
    implements IPluginCoord {
        private final URL downloadUrl;
        private final String sha1;
        private final String sha256;
        private final long size;
        private final PluginClassifier classifier;
        private final String pluginName;
        private final String sizeLiteral;

        public DftCoord(String pluginName, JSONObject meta) {
            this.pluginName = pluginName;
            this.classifier = PluginClassifier.create((String)meta.getString("classifier"));
            this.sha1 = meta.getString("sha1");
            this.sha256 = meta.getString("sha256");
            this.size = meta.getLongValue("size");
            this.sizeLiteral = FileUtils.byteCountToDisplaySize((long)this.size);
            try {
                this.downloadUrl = new URL(meta.getString("downloadUrl"));
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }

        public String getSizeLiteral() {
            return this.sizeLiteral;
        }

        @Override
        @JSONField(serialize=false)
        public String getIdentityName() {
            return this.pluginName;
        }

        @Override
        @JSONField(serialize=false)
        public Optional<PluginClassifier> getClassifier() {
            return Optional.of(this.classifier);
        }

        public String getClassifierName() {
            return this.classifier.getClassifier();
        }

        public URL getDownloadUrl() throws MalformedURLException {
            return this.downloadUrl;
        }

        public String getSha1() throws IOException {
            return this.sha1;
        }

        public String getSha256() throws IOException {
            return this.sha256;
        }

        public long getSize() throws IOException {
            return this.size;
        }

        public String getGav() {
            return this.getClassifierName();
        }
    }

    public abstract class Plugin
    extends Entry {
        public final String wiki;
        @JSONField(name="communityVIP")
        public final boolean communityVIP;
        public final String title;
        public final String excerpt;
        public final String compatibleSinceVersion;
        public final String requiredCore;
        public final String minimumJavaVersion;
        public final String[] categories;
        private final Map<String, String> dependencies;
        public final Map<String, String> optionalDependencies;
        private Set<Plugin> incompatibleParentPlugins;
        public final long releaseTimestamp;
        public final Double popularity;
        public final Map<String, List<String>> extendPoints;
        public final Set<String> endTypes;
        public final Set<IPluginTaggable.PluginTag> pluginTags;
        public String latest;

        public void validateLicense() {
            try {
                TISLicense tisLicense = TISLicense.load(false);
                if (this.communityVIP) {
                    if (tisLicense == null) {
                        throw TisException.create((ErrorValue)ErrorValue.create((TisException.ErrorCode)TisException.ErrorCode.LICENSE_INVALID, new HashMap()), (String)("\u5b89\u88c5\u4f9d\u8d56\u7684\u63d2\u4ef6\uff1a" + this.getDisplayName() + "\u662f\u793e\u533a\u534f\u4f5c\u7248\uff0c\u9700\u8981\u6709\u6548\u7684License"));
                    }
                    TISLicense.HasExpire hasExpire = tisLicense.hasExpire();
                    if (!hasExpire.hasNotExpire) {
                        throw TisException.create((ErrorValue)ErrorValue.create((TisException.ErrorCode)TisException.ErrorCode.LICENSE_INVALID, new HashMap()), (String)("License period of validity till:" + hasExpire.expireDate));
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public List<Option> getDependencies() {
            Option opt = null;
            ArrayList opts = Lists.newArrayList();
            for (Map.Entry<String, String> entry : this.dependencies.entrySet()) {
                opt = new Option(entry.getKey(), (Object)entry.getValue());
                opts.add(opt);
            }
            return opts;
        }

        public abstract boolean isMultiClassifier();

        public abstract List<IPluginCoord> getArts();

        public Plugin(String sourceId, JSONObject o) {
            super(sourceId, o, UpdateSite.this.url);
            this.communityVIP = o.getBooleanValue("communityVIP");
            this.wiki = UpdateSite.get(o, "wiki");
            this.title = UpdateSite.get(o, "title");
            this.excerpt = StringUtils.trimToNull((String)UpdateSite.get(o, "excerpt"));
            this.compatibleSinceVersion = Util.intern(UpdateSite.get(o, "compatibleSinceVersion"));
            this.minimumJavaVersion = Util.intern(UpdateSite.get(o, "minimumJavaVersion"));
            this.latest = UpdateSite.get(o, "latest");
            this.requiredCore = Util.intern(UpdateSite.get(o, "requiredCore"));
            this.releaseTimestamp = o.getLongValue("buildDate");
            JSONArray pluginTags = o.getJSONArray("pluginTags");
            if (pluginTags == null) {
                throw new IllegalStateException(JsonUtil.toString((Object)o) + " lack relevant property pluginTags");
            }
            this.pluginTags = pluginTags.stream().map(t -> IPluginTaggable.PluginTag.parse((String)t)).collect(Collectors.toSet());
            JSONArray endTypes = o.getJSONArray("endTypes");
            if (endTypes == null) {
                throw new IllegalStateException(JsonUtil.toString((Object)o) + " lack relevant property endTypes");
            }
            this.endTypes = endTypes.stream().map(e -> (String)e).collect(Collectors.toSet());
            JSONObject extendPoints = o.getJSONObject("extendPoints");
            this.extendPoints = Maps.newHashMap();
            if (extendPoints != null) {
                extendPoints.forEach((key, val) -> {
                    String extendpoint = key;
                    JSONArray impls = (JSONArray)val;
                    List implTokens = impls.toJavaList(String.class);
                    this.extendPoints.put(extendpoint, implTokens);
                });
            }
            String popularityFromJson = UpdateSite.get(o, "popularity");
            Double popularity = 0.0;
            if (popularityFromJson != null) {
                try {
                    popularity = Double.parseDouble(popularityFromJson);
                }
                catch (NumberFormatException nfe) {
                    LOGGER.info("Failed to parse popularity: '" + popularityFromJson + "' for plugin " + this.title);
                }
            }
            this.popularity = popularity;
            JSONArray labels = o.getJSONArray("labels");
            this.categories = labels != null ? MemoryReductionUtil.internInPlace((String[])labels.toArray((Object[])MemoryReductionUtil.EMPTY_STRING_ARRAY)) : null;
            JSONArray ja = o.getJSONArray("dependencies");
            int depCount = (int)ja.stream().filter(IS_DEP_PREDICATE.and(IS_NOT_OPTIONAL)).count();
            int optionalDepCount = (int)ja.stream().filter(IS_DEP_PREDICATE.and(IS_NOT_OPTIONAL.negate())).count();
            this.dependencies = MemoryReductionUtil.getPresizedMutableMap(depCount);
            this.optionalDependencies = MemoryReductionUtil.getPresizedMutableMap(optionalDepCount);
            for (Object jo : ja) {
                JSONObject depObj = (JSONObject)jo;
                String depName = Util.intern(UpdateSite.get(depObj, "name"));
                if (depName == null) continue;
                if (UpdateSite.get(depObj, "optional").equals("false")) {
                    this.dependencies.put(depName, Util.intern(UpdateSite.get(depObj, "version")));
                    continue;
                }
                this.optionalDependencies.put(depName, Util.intern(UpdateSite.get(depObj, "version")));
            }
        }

        public List<String> getEndTypeIcons() {
            ArrayList types = Lists.newArrayList();
            for (String endtype : this.endTypes) {
                IEndTypeGetter.EndType type = IEndTypeGetter.EndType.parse(endtype);
                IEndTypeGetter.Icon icon = type.getIcon();
                if (icon == null) continue;
                types.add(type.getVal());
            }
            return types;
        }

        public String toString() {
            return "{title='" + this.title + "'}";
        }

        public Future<UpdateCenter.UpdateCenterJob> deploy(Optional<PluginClassifier> classifier) {
            return this.deploy(false, classifier);
        }

        public Future<UpdateCenter.UpdateCenterJob> deploy(boolean dynamicLoad, Optional<PluginClassifier> classifier) {
            return this.deploy(dynamicLoad, null, classifier, null);
        }

        public Future<UpdateCenter.UpdateCenterJob> deploy(boolean dynamicLoad, UUID correlationId, Optional<PluginClassifier> classifier, List<PluginWrapper> batch) {
            UpdateCenter.InstallationJob job;
            for (Plugin plugin : this.getNeededDependencies()) {
                plugin.validateLicense();
            }
            UpdateCenter uc = TIS.get().getUpdateCenter();
            for (Plugin dep : this.getNeededDependencies()) {
                job = uc.getJob(dep);
                if (job == null || job.status instanceof UpdateCenter.DownloadJob.Failure) {
                    LOGGER.info("Adding dependent install of " + dep.name + " for plugin " + this.name);
                    dep.deploy(dynamicLoad, null, classifier, batch);
                    continue;
                }
                LOGGER.info("Dependent install of {} for plugin {} already added, skipping", (Object)dep.name, (Object)this.name);
            }
            IPluginCoord iPluginCoord = this.getTargetCoord(classifier);
            PluginWrapper pw = this.getInstalled();
            if (pw != null) {
                Future<UpdateCenter.UpdateCenterJob> enableJob = null;
                if (!pw.isEnabled()) {
                    UpdateCenter updateCenter = uc;
                    Objects.requireNonNull(updateCenter);
                    UpdateCenter.EnableJob job2 = updateCenter.new UpdateCenter.EnableJob(UpdateSite.this, this, iPluginCoord, dynamicLoad);
                    job2.setCorrelationId(correlationId);
                    enableJob = uc.addJob(job2);
                }
                if (pw.getVersionNumber().equals(new VersionNumber(this.version))) {
                    Future<UpdateCenter.UpdateCenterJob> future;
                    if (enableJob != null) {
                        future = enableJob;
                    } else {
                        UpdateCenter updateCenter = uc;
                        Objects.requireNonNull(updateCenter);
                        future = uc.addJob(updateCenter.new UpdateCenter.NoOpJob(UpdateSite.this, this, iPluginCoord));
                    }
                    return future;
                }
            }
            job = UpdateSite.this.createInstallationJob(this, iPluginCoord, uc, dynamicLoad);
            job.setCorrelationId(correlationId);
            job.setBatch(batch);
            return uc.addJob(job);
        }

        @JSONField(serialize=false)
        public List<Pair<Plugin, VersionNumber>> getDependencyPlugins() {
            ArrayList<Pair<Plugin, VersionNumber>> deps = new ArrayList<Pair<Plugin, VersionNumber>>();
            for (Map.Entry<String, String> e : this.dependencies.entrySet()) {
                VersionNumber requiredVersion = e.getValue() != null ? new VersionNumber(e.getValue()) : null;
                Plugin depPlugin = TIS.get().getUpdateCenter().getPlugin(e.getKey(), requiredVersion);
                if (depPlugin == null) {
                    LOGGER.warn("Could not find dependency {} of {}", (Object)e.getKey(), (Object)this.name);
                    continue;
                }
                deps.add((Pair<Plugin, VersionNumber>)Pair.of((Object)depPlugin, (Object)requiredVersion));
            }
            return deps;
        }

        public List<Plugin> getNeededDependencies() {
            ArrayList<Plugin> deps = new ArrayList<Plugin>();
            for (Pair<Plugin, VersionNumber> pair : this.getDependencyPlugins()) {
                if (!((Plugin)pair.getLeft()).needInstall((VersionNumber)pair.getRight())) continue;
                deps.add((Plugin)pair.getLeft());
            }
            for (Map.Entry entry : this.optionalDependencies.entrySet()) {
                PluginWrapper current;
                VersionNumber requiredVersion;
                VersionNumber versionNumber = requiredVersion = entry.getValue() != null ? new VersionNumber((String)entry.getValue()) : null;
                Plugin depPlugin = TIS.get().getUpdateCenter().getPlugin((String)entry.getKey(), requiredVersion);
                if (depPlugin == null || (current = depPlugin.getInstalled()) == null || !current.isOlderThan(requiredVersion)) continue;
                deps.add(depPlugin);
            }
            return deps;
        }

        public boolean hasCategory(String category) {
            if (this.categories == null) {
                return false;
            }
            return Arrays.asList(this.categories).contains(category);
        }

        @JSONField(serialize=false)
        public PluginWrapper getInstalled() {
            PluginManager pm = TIS.get().getPluginManager();
            PluginWrapper plugin = null;
            for (ITPIArtifact iTPIArtifact : this.getArts()) {
                plugin = pm.getPlugin(ITPIArtifact.matchh(iTPIArtifact));
                if (plugin == null) continue;
                return plugin;
            }
            return null;
        }

        private boolean needInstall(VersionNumber requiredVersion) {
            PluginWrapper current = this.getInstalled();
            if (current == null) {
                return true;
            }
            if (current.isOlderThan(requiredVersion)) {
                return true;
            }
            return !current.isEnabled();
        }

        public String getDisplayName() {
            String displayName = this.title != null ? this.title : this.name;
            return StringUtils.removeStart((String)displayName, (String)"TIS ");
        }

        public IPluginCoord getTargetCoord(Optional<PluginClassifier> classifier) {
            List<IPluginCoord> arts = this.getArts();
            IPluginCoord coord = null;
            if (classifier.isPresent()) {
                ITPIArtifactMatch match = ITPIArtifact.matchh(this.getDisplayName(), classifier);
                match.setIdentityName(this.getDisplayName());
                for (IPluginCoord c : arts) {
                    if (!ITPIArtifact.isEquals(c, match)) continue;
                    coord = c;
                    break;
                }
            } else {
                Iterator<IPluginCoord> iterator = arts.iterator();
                if (iterator.hasNext()) {
                    IPluginCoord c;
                    coord = c = iterator.next();
                }
            }
            Objects.requireNonNull(coord, "plugin:" + this.getDisplayName() + (String)(classifier.isPresent() ? ",for classifier:" + classifier.get().getClassifier() : "") + ",coord can not be null");
            return coord;
        }
    }

    public static final class WarningVersionRange {
        public final String name;
        public final String firstVersion;
        public final String lastVersion;
        private final Pattern pattern;

        public WarningVersionRange(JSONObject o) {
            Pattern p;
            this.name = Util.fixEmpty(o.getString("name"));
            this.firstVersion = Util.intern(Util.fixEmpty(o.getString("firstVersion")));
            this.lastVersion = Util.intern(Util.fixEmpty(o.getString("lastVersion")));
            try {
                p = Pattern.compile(o.getString("pattern"));
            }
            catch (PatternSyntaxException ex) {
                LOGGER.info("Failed to compile pattern '" + o.getString("pattern") + "', using '.*' instead", (Throwable)ex);
                p = Pattern.compile(".*");
            }
            this.pattern = p;
        }

        public boolean includes(VersionNumber number) {
            return this.pattern.matcher(number.toString()).matches();
        }
    }

    public static class Entry {
        public final String sourceId;
        public final String name;
        public final String version;

        Entry(String sourceId, JSONObject o, String baseURL) {
            this.sourceId = sourceId;
            this.name = Util.intern(o.getString("name"));
            this.version = Util.intern(o.getString("version"));
        }

        public boolean isNewerThan(String currentVersion) {
            try {
                return new VersionNumber(currentVersion).compareTo(new VersionNumber(this.version)) < 0;
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
    }
}

