/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.extension.model;

import com.alibaba.fastjson.annotation.JSONField;
import com.google.common.collect.Lists;
import com.qlangtech.tis.TIS;
import com.qlangtech.tis.extension.Descriptor;
import com.qlangtech.tis.extension.PluginManager;
import com.qlangtech.tis.extension.PluginWrapper;
import com.qlangtech.tis.extension.RestartRequiredException;
import com.qlangtech.tis.extension.Saveable;
import com.qlangtech.tis.extension.impl.MissingDependencyException;
import com.qlangtech.tis.extension.impl.XmlFile;
import com.qlangtech.tis.extension.model.FormValidation;
import com.qlangtech.tis.extension.model.IPluginCoord;
import com.qlangtech.tis.extension.model.UpdateCenterResource;
import com.qlangtech.tis.extension.model.UpdateSite;
import com.qlangtech.tis.extension.util.VersionNumber;
import com.qlangtech.tis.install.InstallUtil;
import com.qlangtech.tis.manage.common.ConfigFileContext;
import com.qlangtech.tis.manage.common.HttpUtils;
import com.qlangtech.tis.maven.plugins.tpi.PluginClassifier;
import com.qlangtech.tis.plugin.PluginAndCfgsSnapshot;
import com.qlangtech.tis.plugin.license.TISLicense;
import com.qlangtech.tis.util.PersistedList;
import com.qlangtech.tis.util.Util;
import com.qlangtech.tis.util.exec.AtmostOneThreadExecutor;
import com.qlangtech.tis.util.exec.DaemonThreadFactory;
import com.qlangtech.tis.util.exec.NamingThreadFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpRetryException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.OpenOption;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.CountingInputStream;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateCenter
implements Saveable {
    public static final String PLUGIN_CATEGORIES_FILENAME = "plugin-categories.json";
    private static final Logger logger = LoggerFactory.getLogger(UpdateCenter.class);
    public static final String ID_UPLOAD = "_upload";
    protected static final ExecutorService updateService = Executors.newCachedThreadPool(new NamingThreadFactory(new DaemonThreadFactory(), "Update site data downloader"));
    private static final int PLUGIN_DOWNLOAD_READ_TIMEOUT = (int)TimeUnit.SECONDS.toMillis(Integer.parseInt(System.getProperty(UpdateCenterResource.class.getName() + ".pluginDownloadReadTimeoutSeconds", "60")));
    public static final String ID_DEFAULT = System.getProperty(UpdateCenterResource.class.getName() + ".defaultUpdateSiteId", "default");
    private static final Logger LOGGER = LoggerFactory.getLogger(UpdateCenterResource.class);
    private final Set<UpdateSite> sourcesUsed = new HashSet<UpdateSite>();
    private final PersistedList<UpdateSite> sites = new PersistedList(this);
    private volatile transient boolean siteDataLoading;
    private UpdateCenterConfiguration config;
    private final Vector<UpdateCenterJob> jobs = new Vector();
    private final ExecutorService installerService = new AtmostOneThreadExecutor(new NamingThreadFactory(new DaemonThreadFactory(), "Update center installer thread"));
    private boolean requiresRestart;
    private static final AtomicInteger iota = new AtomicInteger();

    public static void main(String[] args) {
        long total = 688877996L;
        long count = 46847443L;
        int percentage = (int)((double)count / (double)total * 100.0);
        System.out.println(percentage);
        System.out.println(percentage);
    }

    public UpdateCenter() {
        this.configure(new UpdateCenterConfiguration());
    }

    public static void copyDataTarToLocal(File tmpDataDir, Optional<File> dataDirOpt) throws IOException {
        String dataPkgName = "tis-data.tar.gz";
        UpdateCenter.copyTarToLocal("tis-data.tar.gz", tmpDataDir, dataDirOpt);
    }

    public static void copyTarToLocal(String dataPkgName, final File tmpDataDir, Optional<File> dataDirOpt) throws IOException {
        URL dataPkg = UpdateCenterResource.getTISTarPkg((String)dataPkgName);
        HttpUtils.get((URL)dataPkg, (ConfigFileContext.StreamProcess)new ConfigFileContext.StreamProcess<Void>(){

            public Void p(int status, InputStream stream, Map<String, List<String>> headerFields) throws IOException {
                try (GZIPInputStream gis = new GZIPInputStream(stream);){
                    Void void_;
                    try (TarInputStream tis = new TarInputStream((InputStream)gis);){
                        TarEntry entry = null;
                        while ((entry = tis.getNextEntry()) != null) {
                            if (entry.isDirectory()) {
                                File dir = new File(tmpDataDir, entry.getName());
                                if (dir.exists() || dir.mkdirs()) continue;
                                throw new IOException("Failed to create directory: " + dir.getAbsolutePath());
                            }
                            File file = new File(tmpDataDir, entry.getName());
                            FileUtils.copyToFile((InputStream)tis, (File)file);
                            logger.info("write file:{}", (Object)file.getAbsolutePath());
                        }
                        void_ = null;
                    }
                    return void_;
                }
            }
        });
        if (dataDirOpt.isPresent()) {
            File dataDir = dataDirOpt.get();
            File tmp = new File(tmpDataDir, "data");
            logger.info("move to:{} from:{}", (Object)dataDir.getAbsolutePath(), (Object)tmp);
            for (String c : tmp.list()) {
                File child = new File(tmp, c);
                File dest = new File(dataDir, c);
                if (dest.exists()) {
                    logger.info("dest :{} is already exist ,skip it", (Object)dest.getAbsolutePath());
                    continue;
                }
                if (child.isFile()) {
                    FileUtils.moveFile((File)child, (File)dest);
                } else {
                    FileUtils.moveDirectory((File)child, (File)dest);
                }
                logger.info("successful move {} to dest :{}", (Object)child.getAbsolutePath(), (Object)dest.getAbsolutePath());
            }
        }
    }

    public PersistedList<UpdateSite> getSites() {
        return this.sites;
    }

    public static UpdateCenter createUpdateCenter(UpdateCenterConfiguration config) {
        return new UpdateCenter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<UpdateCenterJob> getJobs() {
        Vector<UpdateCenterJob> vector = this.jobs;
        synchronized (vector) {
            return new ArrayList<UpdateCenterJob>(this.jobs);
        }
    }

    public void configure(UpdateCenterConfiguration config) {
        if (config != null) {
            this.config = config;
        }
    }

    public List<UpdateSite> getSiteList() {
        return this.sites.toList();
    }

    public synchronized Future<UpdateCenterJob> addJob(UpdateCenterJob job) {
        if (job.site != null) {
            this.addConnectionCheckJob(job.site);
        }
        return job.submit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConnectionCheckJob getConnectionCheckJob(UpdateSite site) {
        Vector<UpdateCenterJob> vector = this.jobs;
        synchronized (vector) {
            for (UpdateCenterJob job : this.jobs) {
                if (!(job instanceof ConnectionCheckJob) || job.site == null || !job.site.getId().equals(site.getId())) continue;
                return (ConnectionCheckJob)job;
            }
        }
        return null;
    }

    public synchronized void persistInstallStatus() {
        List<UpdateCenterJob> jobs = this.getJobs();
        boolean activeInstalls = false;
        for (UpdateCenterJob job : jobs) {
            if (!(job instanceof InstallationJob)) continue;
            InstallationJob installationJob = (InstallationJob)job;
            if (installationJob.status.isSuccess()) continue;
            activeInstalls = true;
        }
        if (activeInstalls) {
            InstallUtil.persistInstallStatus(jobs);
        } else {
            InstallUtil.clearInstallStatus();
        }
    }

    private ConnectionCheckJob addConnectionCheckJob(UpdateSite site) {
        if (this.sourcesUsed.add(site)) {
            ConnectionCheckJob connectionCheckJob = this.newConnectionCheckJob(site);
            connectionCheckJob.submit();
            return connectionCheckJob;
        }
        ConnectionCheckJob connectionCheckJob = this.getConnectionCheckJob(site);
        if (connectionCheckJob != null) {
            return connectionCheckJob;
        }
        throw new IllegalStateException("Illegal addition of an UpdateCenter job without calling UpdateCenter.addJob. No ConnectionCheckJob found for the site.");
    }

    ConnectionCheckJob newConnectionCheckJob(UpdateSite site) {
        return new ConnectionCheckJob(site);
    }

    public List<UpdateSite.Plugin> getAvailables() {
        return this.getPlugins(site -> site.getAvailables());
    }

    public List<UpdateSite.Plugin> getPlugins(Function<UpdateSite, List<UpdateSite.Plugin>> pluginsCreator) {
        LinkedHashMap<Object, UpdateSite.Plugin> pluginMap = new LinkedHashMap<Object, UpdateSite.Plugin>();
        for (UpdateSite site : this.sites) {
            for (UpdateSite.Plugin plugin : pluginsCreator.apply(site)) {
                String altKey;
                UpdateSite.Plugin existing = (UpdateSite.Plugin)pluginMap.get(plugin.name);
                if (existing == null) {
                    pluginMap.put(plugin.name, plugin);
                    continue;
                }
                if (existing.version.equals(plugin.version) || pluginMap.containsKey(altKey = plugin.name + ":" + plugin.version)) continue;
                pluginMap.put(altKey, plugin);
            }
        }
        return Lists.newArrayList(pluginMap.values());
    }

    public InstallationJob getJob(UpdateSite.Plugin plugin) {
        List<UpdateCenterJob> jobList = this.getJobs();
        Collections.reverse(jobList);
        for (UpdateCenterJob job : jobList) {
            if (!(job instanceof InstallationJob)) continue;
            InstallationJob ij = (InstallationJob)job;
            if (!ij.plugin.name.equals(plugin.name) || !ij.plugin.sourceId.equals(plugin.sourceId)) continue;
            return ij;
        }
        return null;
    }

    public synchronized void load() throws IOException {
        XmlFile file = this.getConfigFile();
        if (file.exists()) {
            try {
                this.sites.replaceBy(((PersistedList)file.unmarshal(this.sites)).toList());
            }
            catch (IOException e) {
                LOGGER.warn("Failed to load " + file, (Throwable)e);
            }
            boolean defaultSiteExists = false;
            for (UpdateSite site : this.sites) {
                if (site.isLegacyDefault()) {
                    this.sites.remove(site);
                    continue;
                }
                if (!ID_DEFAULT.equals(site.getId())) continue;
                defaultSiteExists = true;
            }
            if (!defaultSiteExists) {
                this.sites.add(this.createDefaultUpdateSite());
            }
        } else if (this.sites.isEmpty()) {
            this.sites.add(this.createDefaultUpdateSite());
        }
        this.siteDataLoading = false;
    }

    public List<FormValidation> updateAllSites() throws InterruptedException, ExecutionException {
        ArrayList<Future<FormValidation>> futures = new ArrayList<Future<FormValidation>>();
        for (UpdateSite site : this.getSites()) {
            Future<FormValidation> future = site.updateDirectly();
            if (future == null) continue;
            futures.add(future);
        }
        ArrayList<FormValidation> results = new ArrayList<FormValidation>();
        for (Future future : futures) {
            results.add((FormValidation)future.get());
        }
        return results;
    }

    protected UpdateSite createDefaultUpdateSite() {
        UpdateSite dftUpdateSite = UpdateSite.tisDftUpdateSite();
        return dftUpdateSite;
    }

    @Override
    public synchronized void save() {
    }

    public UpdateSite.Plugin getPlugin(String artifactId, VersionNumber minVersion) {
        if (minVersion == null) {
            return this.getPlugin(artifactId);
        }
        for (UpdateSite s : this.sites) {
            UpdateSite.Plugin p = s.getPlugin(artifactId);
            if (!this.checkMinVersion(p, minVersion)) continue;
            return p;
        }
        return null;
    }

    private boolean checkMinVersion(UpdateSite.Plugin p, VersionNumber minVersion) {
        return p != null && (minVersion == null || !minVersion.isNewerThan(new VersionNumber(p.version)));
    }

    public UpdateSite.Plugin getPlugin(String artifactId) {
        for (UpdateSite s : this.sites) {
            UpdateSite.Plugin p = s.getPlugin(artifactId);
            if (p == null) continue;
            return p;
        }
        return null;
    }

    private XmlFile getConfigFile() {
        return Descriptor.getConfigFile(UpdateCenterResource.class.getName());
    }

    public UpdateSite getCoreSource() {
        for (UpdateSite s : this.sites) {
            UpdateSite.Data data = s.getData();
            if (data == null || data.core == null) continue;
            return s;
        }
        return null;
    }

    static void verifyChecksums(WithComputedChecksums job, UpdateSite.Entry entry, File file) throws IOException {
    }

    public final class ConnectionCheckJob
    extends UpdateCenterJob {
        private final Vector<String> statuses;
        final Map<String, ConnectionStatus> connectionStates;

        public ConnectionCheckJob(UpdateSite site) {
            super(site);
            this.statuses = new Vector();
            this.connectionStates = new ConcurrentHashMap<String, ConnectionStatus>();
            this.connectionStates.put("internet", ConnectionStatus.PRECHECK);
            this.connectionStates.put("updatesite", ConnectionStatus.PRECHECK);
        }

        @Override
        public void run() {
            this.connectionStates.put("internet", ConnectionStatus.UNCHECKED);
            this.connectionStates.put("updatesite", ConnectionStatus.UNCHECKED);
            if (this.site == null || UpdateCenter.ID_UPLOAD.equals(this.site.getId())) {
                return;
            }
            LOGGER.info("Doing a connectivity check");
            Future<?> internetCheck = null;
            try {
                final String connectionCheckUrl = this.site.getConnectionCheckUrl();
                if (connectionCheckUrl != null) {
                    this.connectionStates.put("internet", ConnectionStatus.CHECKING);
                    this.statuses.add("CheckingInternet");
                    internetCheck = updateService.submit(new Runnable(){

                        @Override
                        public void run() {
                            block2: {
                                try {
                                    UpdateCenter.this.config.checkConnection(ConnectionCheckJob.this, connectionCheckUrl);
                                }
                                catch (Exception e) {
                                    if (!e.getMessage().contains("Connection timed out")) break block2;
                                    ConnectionCheckJob.this.connectionStates.put("internet", ConnectionStatus.FAILED);
                                    ConnectionCheckJob.this.statuses.add("ConnectionFailed:" + connectionCheckUrl);
                                    return;
                                }
                            }
                            ConnectionCheckJob.this.connectionStates.put("internet", ConnectionStatus.OK);
                        }
                    });
                } else {
                    LOGGER.info("Update site ''{}'' does not declare the connection check URL. Skipping the network availability check.", (Object)this.site.getId());
                    this.connectionStates.put("internet", ConnectionStatus.SKIPPED);
                }
                this.connectionStates.put("updatesite", ConnectionStatus.CHECKING);
                this.statuses.add("CheckingJavaNet");
                UpdateCenter.this.config.checkUpdateCenter(this, this.site.getUrl());
                this.connectionStates.put("updatesite", ConnectionStatus.OK);
                this.statuses.add("Status_Success");
            }
            catch (UnknownHostException e) {
                this.connectionStates.put("updatesite", ConnectionStatus.FAILED);
                this.statuses.add("UnknownHostException:" + e.getMessage());
                this.addStatus(e);
                this.error = e;
            }
            catch (Exception e) {
                this.connectionStates.put("updatesite", ConnectionStatus.FAILED);
                this.addStatus(e);
                this.error = e;
            }
            if (internetCheck != null) {
                try {
                    internetCheck.get();
                }
                catch (Exception e) {
                    LOGGER.info("Error completing internet connectivity check: " + e.getMessage(), (Throwable)e);
                }
            }
        }

        private void addStatus(Throwable e) {
            this.statuses.add(ExceptionUtils.getRootCauseMessage((Throwable)e));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String[] getStatuses() {
            Vector<String> vector = this.statuses;
            synchronized (vector) {
                return this.statuses.toArray(new String[this.statuses.size()]);
            }
        }
    }

    static enum ConnectionStatus {
        PRECHECK,
        SKIPPED,
        CHECKING,
        UNCHECKED,
        OK,
        FAILED;

        static final String INTERNET = "internet";
        static final String UPDATE_SITE = "updatesite";
    }

    public class NoOpJob
    extends EnableJob {
        public NoOpJob(UpdateSite site, UpdateSite.Plugin plugin, IPluginCoord coord) {
            super(site, plugin, coord, false);
        }

        @Override
        public void run() {
            this.status = new DownloadJob.Success();
        }
    }

    public class EnableJob
    extends InstallationJob {
        public EnableJob(UpdateSite site, UpdateSite.Plugin plugin, IPluginCoord coord, boolean dynamicLoad) {
            super(plugin, coord, site, dynamicLoad);
        }

        public UpdateSite.Plugin getPlugin() {
            return this.plugin;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                PluginWrapper installed;
                PluginWrapper pluginWrapper = installed = this.plugin.getInstalled();
                synchronized (pluginWrapper) {
                    if (!installed.isEnabled()) {
                        try {
                            installed.enable();
                        }
                        catch (IOException e) {
                            LOGGER.error("Failed to enable " + this.plugin.getDisplayName(), (Throwable)e);
                            this.error = e;
                            this.status = new DownloadJob.Failure((Throwable)e);
                        }
                        if (this.dynamicLoad) {
                            try {
                                this.pm.dynamicLoad(this.getDestination(), true, null);
                            }
                            catch (Exception e) {
                                LOGGER.error("Failed to dynamically load " + this.plugin.getDisplayName(), (Throwable)e);
                                this.error = e;
                                UpdateCenter.this.requiresRestart = true;
                                this.status = new DownloadJob.Failure((Throwable)e);
                            }
                        } else {
                            UpdateCenter.this.requiresRestart = true;
                        }
                    }
                }
            }
            catch (Throwable e) {
                LOGGER.error("An unexpected error occurred while attempting to enable " + this.plugin.getDisplayName(), e);
                this.error = e;
                UpdateCenter.this.requiresRestart = true;
                this.status = new DownloadJob.Failure(e);
            }
            if (this.status instanceof DownloadJob.Pending) {
                this.status = new DownloadJob.Success();
            }
        }
    }

    public final class CompleteBatchJob
    extends UpdateCenterJob {
        private final List<PluginWrapper> batch;
        private final long start;
        public volatile CompleteBatchJobStatus status;

        public CompleteBatchJob(List<PluginWrapper> batch, long start, UUID correlationId) {
            super(UpdateCenter.this.getCoreSource());
            this.status = new Pending();
            this.batch = batch;
            this.start = start;
            this.setCorrelationId(correlationId);
        }

        @Override
        public void run() {
            LOGGER.info("Completing installing of plugin batch\u2026");
            this.status = new Running();
            try {
                TIS.get().getPluginManager().start(new PluginAndCfgsSnapshot.PluginWrapperList(this.batch));
                this.status = new Success();
            }
            catch (Exception x) {
                this.status = new Failure(x);
                LOGGER.warn("Failed to start some plugins", (Throwable)x);
            }
            LOGGER.info("Completed installation of {} plugins in {}ms", (Object)this.batch.size(), (Object)(System.currentTimeMillis() - this.start));
        }

        public class Failure
        extends CompleteBatchJobStatus {
            public final Throwable problemStackTrace;

            Failure(Throwable problemStackTrace) {
                this.problemStackTrace = problemStackTrace;
            }
        }

        public class Success
        extends CompleteBatchJobStatus {
        }

        public class Running
        extends CompleteBatchJobStatus {
        }

        public class Pending
        extends CompleteBatchJobStatus {
        }

        public abstract class CompleteBatchJobStatus {
            public final int id = iota.incrementAndGet();
        }
    }

    public class InstallationJob
    extends DownloadJob {
        @JSONField(serialize=false)
        public final UpdateSite.Plugin plugin;
        private final IPluginCoord coord;
        protected final PluginManager pm;
        protected final boolean dynamicLoad;
        List<PluginWrapper> batch;

        @Override
        public final long getSize() {
            try {
                return this.coord.getSize();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public InstallationJob(UpdateSite.Plugin plugin, IPluginCoord coord, UpdateSite site) {
            this(plugin, coord, site, false);
        }

        public InstallationJob(UpdateSite.Plugin plugin, IPluginCoord coord, UpdateSite site, boolean dynamicLoad) {
            super(site);
            this.pm = TIS.get().getPluginManager();
            this.plugin = plugin;
            this.dynamicLoad = dynamicLoad;
            this.coord = coord;
        }

        public boolean isContainClassifier() {
            return this.plugin.isMultiClassifier();
        }

        public String getClassifier() {
            return this.coord.getGav();
        }

        @Override
        protected URL getURL() throws MalformedURLException {
            return this.coord.getDownloadUrl();
        }

        @Override
        protected File getDestination() {
            File baseDir = this.pm.rootDir;
            Optional classifier = this.coord.getClassifier();
            Object tpiName = this.plugin.name + ".tpi";
            if (classifier.isPresent()) {
                tpiName = ((PluginClassifier)classifier.get()).getTPIPluginName(this.plugin.name, ".tpi");
            }
            return new File(baseDir, (String)tpiName);
        }

        @Override
        public String getName() {
            return this.plugin.name;
        }

        @Override
        public String getDisplayName() {
            return this.plugin.getDisplayName();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void _run() throws IOException, DownloadJob.InstallationStatus {
            block14: {
                if (this.wasInstalled()) {
                    LOGGER.info("Skipping duplicate install of: " + this.plugin.getDisplayName() + "@" + this.plugin.version);
                    return;
                }
                try {
                    super._run();
                    if (this.dynamicLoad) {
                        try {
                            this.pm.dynamicLoad(this.getDestination(), false, new PluginAndCfgsSnapshot.PluginWrapperList(this.batch));
                            break block14;
                        }
                        catch (RestartRequiredException e) {
                            throw new DownloadJob.SuccessButRequiresRestart(e.getMessage());
                        }
                        catch (Exception e) {
                            throw new IOException("Failed to dynamically deploy this plugin", e);
                        }
                    }
                    throw new DownloadJob.SuccessButRequiresRestart("_UpdateCenter_DownloadButNotActivated");
                }
                finally {
                    InstallationJob installationJob = this;
                    synchronized (installationJob) {
                        LOGGER.info("Install complete for: " + this.plugin.getDisplayName() + "@" + this.plugin.version);
                        this.status = new DownloadJob.Skipped();
                        this.notifyAll();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean wasInstalled() {
            UpdateCenter updateCenter = UpdateCenter.this;
            synchronized (updateCenter) {
                for (UpdateCenterJob job : UpdateCenter.this.getJobs()) {
                    if (job == this) {
                        return false;
                    }
                    if (!(job instanceof InstallationJob)) continue;
                    InstallationJob ij = (InstallationJob)job;
                    if (!ij.plugin.equals(this.plugin) || !ij.plugin.version.equals(this.plugin.version)) continue;
                    InstallationJob installationJob = ij;
                    synchronized (installationJob) {
                        if (ij.status instanceof DownloadJob.Installing || ij.status instanceof DownloadJob.Pending) {
                            try {
                                LOGGER.info("Waiting for other plugin install of: " + this.plugin.getDisplayName() + "@" + this.plugin.version);
                                ij.wait();
                            }
                            catch (InterruptedException e) {
                                throw new RuntimeException(e);
                            }
                        }
                        if (ij.status instanceof DownloadJob.Success) {
                            return true;
                        }
                    }
                }
                return false;
            }
        }

        @Override
        protected void onSuccess() {
            this.pm.pluginUploaded = true;
        }

        public String toString() {
            return super.toString() + "[plugin=" + this.plugin.title + "]";
        }

        @Override
        protected void replace(File dst, File src) throws IOException {
            if (this.site == null || !this.site.getId().equals(UpdateCenter.ID_UPLOAD)) {
                UpdateCenter.verifyChecksums(this, this.plugin, src);
            }
            File bak = Util.changeExtension(dst, ".bak");
            bak.delete();
            if (dst.exists() && !dst.renameTo(bak)) {
                dst.delete();
            }
            if (!src.renameTo(dst)) {
                throw new IOException("Failed to rename " + src + " to " + dst);
            }
        }

        void setBatch(List<PluginWrapper> batch) {
            this.batch = batch;
        }
    }

    public abstract class DownloadJob
    extends UpdateCenterJob
    implements WithComputedChecksums {
        public volatile InstallationStatus status;
        private String computedSHA1;
        private String computedSHA256;
        private String computedSHA512;

        protected abstract URL getURL() throws MalformedURLException;

        protected abstract File getDestination();

        public abstract String getName();

        public abstract long getSize();

        public String getDisplayName() {
            return this.getName();
        }

        protected abstract void onSuccess();

        @Override
        public String getComputedSHA1() {
            return this.computedSHA1;
        }

        @Override
        public String getComputedSHA256() {
            return this.computedSHA256;
        }

        @Override
        public String getComputedSHA512() {
            return this.computedSHA512;
        }

        protected DownloadJob(UpdateSite site) {
            super(site);
            this.status = new Pending();
        }

        @Override
        public void run() {
            try {
                LOGGER.info("Starting the installation of " + this.getName());
                this._run();
                LOGGER.info("Installation successful: " + this.getName());
                this.status = new Success();
                this.onSuccess();
            }
            catch (InstallationStatus e) {
                this.status = e;
                if (this.status.isSuccess()) {
                    this.onSuccess();
                }
                UpdateCenter.this.requiresRestart |= this.status.requiresRestart();
            }
            catch (MissingDependencyException e) {
                LOGGER.error("Failed to install {}: {}", (Object)this.getName(), (Object)e.getMessage());
                this.status = new Failure((Throwable)e);
                this.error = e;
            }
            catch (Throwable e) {
                LOGGER.error("Failed to install " + this.getName(), e);
                this.status = new Failure(e);
                this.error = e;
            }
        }

        protected void _run() throws IOException, InstallationStatus {
            URL src = this.getURL();
            UpdateCenter.this.config.preValidate(this, src);
            File dst = this.getDestination();
            File tmp = UpdateCenter.this.config.download(this, src);
            UpdateCenter.this.config.postValidate(this, tmp);
            UpdateCenter.this.config.install(this, tmp, dst);
        }

        protected void replace(File dst, File src) throws IOException {
            File bak = Util.changeExtension(dst, ".bak");
            bak.delete();
            dst.renameTo(bak);
            dst.delete();
            if (!src.renameTo(dst)) {
                throw new IOException("Failed to rename " + src + " to " + dst);
            }
        }

        public class Installing
        extends InstallationStatus {
            public final int percentage;
            private final long downloadSize;

            public Installing(int percentage, long downloadSize) {
                this.percentage = percentage;
                this.downloadSize = downloadSize;
            }

            public String getDownload() {
                return FileUtils.byteCountToDisplaySize((long)this.downloadSize);
            }
        }

        public class Pending
        extends InstallationStatus {
        }

        public class Skipped
        extends InstallationStatus {
            @Override
            public boolean isSuccess() {
                return true;
            }
        }

        public class Success
        extends InstallationStatus {
            @Override
            public boolean isSuccess() {
                return true;
            }
        }

        public class SuccessButRequiresRestart
        extends Success {
            private final String message;

            public SuccessButRequiresRestart(String message) {
                this.message = message;
            }

            @Override
            public String getMessage() {
                return this.message;
            }

            @Override
            public boolean requiresRestart() {
                return true;
            }
        }

        public class Failure
        extends InstallationStatus {
            public final Throwable problem;

            public Failure(Throwable problem) {
                this.problem = problem;
            }

            public String getProblemStackTrace() {
                return ExceptionUtils.getRootCauseMessage((Throwable)this.problem);
            }
        }

        public abstract class InstallationStatus
        extends Throwable {
            public final int id = iota.incrementAndGet();
            private final AtomicBoolean used = new AtomicBoolean(false);

            public void setUsed() {
                this.used.set(true);
            }

            public boolean isSuccess() {
                return false;
            }

            public final String getType() {
                return this.getClass().getSimpleName();
            }

            @Override
            @JSONField(serialize=false)
            public StackTraceElement[] getStackTrace() {
                return super.getStackTrace();
            }

            public boolean requiresRestart() {
                return false;
            }
        }
    }

    static interface WithComputedChecksums {
        public String getComputedSHA1();

        public String getComputedSHA256();

        public String getComputedSHA512();
    }

    public abstract class UpdateCenterJob
    implements Runnable {
        public final int id = iota.incrementAndGet();
        @JSONField(serialize=false)
        public final UpdateSite site;
        private UUID correlationId = null;
        protected Throwable error;

        protected UpdateCenterJob(UpdateSite site) {
            this.site = site;
        }

        public UUID getCorrelationId() {
            return this.correlationId;
        }

        public void setCorrelationId(UUID correlationId) {
            if (this.correlationId != null) {
                throw new IllegalStateException("Illegal call to set the 'correlationId'. Already set.");
            }
            this.correlationId = correlationId;
        }

        @Deprecated
        public void schedule() {
            this.submit();
        }

        public String getType() {
            return this.getClass().getSimpleName();
        }

        public Future<UpdateCenterJob> submit() {
            LOGGER.info("Scheduling " + this + " to installerService");
            UpdateCenter.this.jobs.add(this);
            return UpdateCenter.this.installerService.submit(this, this);
        }

        public String getErrorMessage() {
            return this.error != null ? this.error.getMessage() : null;
        }

        public Throwable getError() {
            return this.error;
        }
    }

    public static class UpdateCenterConfiguration {
        public void checkConnection(ConnectionCheckJob job, String connectionCheckUrl) throws IOException {
            this.testConnection(new URL(connectionCheckUrl));
        }

        public void checkUpdateCenter(ConnectionCheckJob job, String updateCenterUrl) throws IOException {
            this.testConnection(UpdateCenterConfiguration.toUpdateCenterCheckUrl(updateCenterUrl));
        }

        static URL toUpdateCenterCheckUrl(String updateCenterUrl) throws MalformedURLException {
            URL url = updateCenterUrl.startsWith("http://") || updateCenterUrl.startsWith("https://") ? new URL(updateCenterUrl + (updateCenterUrl.indexOf(63) == -1 ? "?uctest" : "&uctest")) : new URL(updateCenterUrl);
            return url;
        }

        public void preValidate(DownloadJob job, URL src) throws IOException {
        }

        public void postValidate(DownloadJob job, File src) throws IOException {
        }

        private static MessageDigest getDigest(String algorithm) {
            try {
                return MessageDigest.getInstance(algorithm);
            }
            catch (NoSuchAlgorithmException e) {
                LOGGER.info("Failed to instantiate message digest algorithm, may only have weak or no verification of downloaded file", (Object)algorithm);
                return null;
            }
        }

        public File download(final DownloadJob job, final URL src) throws IOException {
            byte[] digest;
            final MessageDigest sha1 = UpdateCenterConfiguration.getDigest("SHA-1");
            final MessageDigest sha256 = UpdateCenterConfiguration.getDigest("SHA-256");
            final MessageDigest sha512 = UpdateCenterConfiguration.getDigest("SHA-512");
            File dst = job.getDestination();
            final File tmp = new File(dst.getPath() + ".tmp");
            final long total = job.getSize();
            if (total < 1L) {
                throw new IllegalStateException("Inconsistent file length: expected " + total);
            }
            final TISLicense license = TISLicense.load(false);
            HttpUtils.get((URL)src, (ConfigFileContext.StreamProcess)new ConfigFileContext.StreamProcess<Void>(){

                public List<ConfigFileContext.Header> getHeaders() {
                    List headers = super.getHeaders();
                    if (license != null) {
                        headers = Lists.newArrayList((Iterable)headers);
                        headers.add(new ConfigFileContext.Header("tis-license-id", license.licenseId));
                        headers.add(new ConfigFileContext.Header("email", license.email));
                    }
                    return headers;
                }

                public Void p(HttpURLConnection con, InputStream stream) throws IOException {
                    byte[] buf = new byte[8192];
                    LOGGER.info("Downloading " + job.getName());
                    try {
                        Thread t = Thread.currentThread();
                        String oldName = t.getName();
                        t.setName(oldName + ": " + src);
                        try (OutputStream _out = Files.newOutputStream(tmp.toPath(), new OpenOption[0]);
                             OutputStream out = sha1 != null ? new DigestOutputStream(sha256 != null ? new DigestOutputStream(sha512 != null ? new DigestOutputStream(_out, sha512) : _out, sha256) : _out, sha1) : _out;
                             CountingInputStream cin = new CountingInputStream(stream);){
                            int len;
                            while ((len = cin.read(buf)) >= 0) {
                                out.write(buf, 0, len);
                                if (job.status != null && !job.status.used.get()) continue;
                                int percentage = (int)((double)cin.getByteCount() / (double)total * 100.0);
                                DownloadJob downloadJob = job;
                                Objects.requireNonNull(downloadJob);
                                job.status = downloadJob.new DownloadJob.Installing(percentage, cin.getByteCount());
                            }
                        }
                        catch (IOException | InvalidPathException e) {
                            throw new IOException("Failed to load " + src + " to " + tmp, e);
                        }
                        finally {
                            t.setName(oldName);
                        }
                    }
                    catch (IOException e) {
                        Object extraMessage = "";
                        if (con != null && con.getURL() != null && !src.toString().equals(con.getURL().toString())) {
                            extraMessage = " (redirected to: " + con.getURL() + ")";
                        }
                        throw new RuntimeException("Failed to download from " + src + (String)extraMessage, e);
                    }
                    return null;
                }

                public Void p(int status, InputStream stream, Map<String, List<String>> headerFields) {
                    throw new UnsupportedOperationException();
                }
            });
            if (sha1 != null) {
                digest = sha1.digest();
                job.computedSHA1 = Base64.getEncoder().encodeToString(digest);
            }
            if (sha256 != null) {
                digest = sha256.digest();
                job.computedSHA256 = Base64.getEncoder().encodeToString(digest);
            }
            if (sha512 != null) {
                digest = sha512.digest();
                job.computedSHA512 = Base64.getEncoder().encodeToString(digest);
            }
            return tmp;
        }

        public void install(DownloadJob job, File src, File dst) throws IOException {
            job.replace(dst, src);
        }

        public void upgrade(DownloadJob job, File src, File dst) throws IOException {
            job.replace(dst, src);
        }

        @Deprecated
        public String getConnectionCheckUrl() {
            return "http://www.baidu.com";
        }

        @Deprecated
        public String getUpdateCenterUrl() {
            return UpdateCenterResource.UPDATE_CENTER_URL;
        }

        @Deprecated
        public String getPluginRepositoryBaseUrl() {
            return "http://jenkins-ci.org/";
        }

        private void testConnection(final URL url) throws IOException {
            HttpUtils.get((URL)url, (ConfigFileContext.StreamProcess)new ConfigFileContext.StreamProcess<Void>(){

                public void error(int status, InputStream errstream, IOException e) throws Exception {
                    throw new HttpRetryException("Invalid response code (" + status + ") from URL: " + url, status);
                }

                public Void p(int status, InputStream stream, Map<String, List<String>> headerFields) {
                    try {
                        IOUtils.copy((InputStream)stream, (OutputStream)NullOutputStream.NULL_OUTPUT_STREAM);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    return null;
                }
            });
        }
    }
}

