/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.extension.init;

import com.qlangtech.tis.extension.PluginManager;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jvnet.hudson.reactor.Task;

public class InitStrategy {
    public List<File> listPluginArchives(PluginManager pm) throws IOException {
        ArrayList<File> r = new ArrayList<File>();
        this.getBundledPluginsFromProperty(r);
        this.listPluginFiles(pm, ".tpi", r);
        this.listPluginFiles(pm, ".hpl", r);
        return r;
    }

    private void listPluginFiles(PluginManager pm, String extension, Collection<File> all) throws IOException {
        File[] files = pm.rootDir.listFiles(new FilterByExtension(extension));
        if (files == null) {
            throw new IOException("tis is unable to create " + pm.rootDir + "\nPerhaps its security privilege is insufficient");
        }
        all.addAll(Arrays.asList(files));
    }

    protected void getBundledPluginsFromProperty(List<File> r) {
    }

    public boolean skipInitTask(Task task) {
        return false;
    }

    public static InitStrategy get(ClassLoader cl) {
        return new InitStrategy();
    }

    private static class FilterByExtension
    implements FilenameFilter {
        private final List<String> extensions;

        public FilterByExtension(String ... extensions) {
            this.extensions = Arrays.asList(extensions);
        }

        @Override
        public boolean accept(File dir, String name) {
            for (String extension : this.extensions) {
                if (!name.endsWith(extension)) continue;
                return true;
            }
            return false;
        }
    }
}

