/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.extension.init;

import com.qlangtech.tis.extension.init.InitMilestone;
import com.qlangtech.tis.util.exec.DaemonThreadFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jvnet.hudson.reactor.Milestone;
import org.jvnet.hudson.reactor.Reactor;
import org.jvnet.hudson.reactor.ReactorException;
import org.jvnet.hudson.reactor.ReactorListener;
import org.jvnet.hudson.reactor.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitReactorRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)InitReactorRunner.class.getName());

    public void run(Reactor reactor) throws InterruptedException, ReactorException, IOException {
        reactor.addAll(InitMilestone.ordering().discoverTasks(reactor));
        ExecutorService es = Executors.newSingleThreadExecutor(new DaemonThreadFactory());
        try {
            reactor.execute((Executor)es, this.buildReactorListener());
        }
        finally {
            es.shutdownNow();
        }
    }

    private ReactorListener buildReactorListener() throws IOException {
        ArrayList<1> r = new ArrayList<1>();
        r.add(new ReactorListener(){

            public void onTaskStarted(Task t) {
                LOGGER.debug("Started " + t.getDisplayName());
            }

            public void onTaskCompleted(Task t) {
                LOGGER.debug("Completed " + t.getDisplayName());
            }

            public void onTaskFailed(Task t, Throwable err, boolean fatal) {
                LOGGER.error("Failed " + t.getDisplayName(), err);
            }

            public void onAttained(Milestone milestone) {
                Object s = "Attained " + milestone.toString();
                if (milestone instanceof InitMilestone) {
                    InitReactorRunner.this.onInitMilestoneAttained((InitMilestone)milestone);
                    s = milestone.toString();
                }
                LOGGER.info((String)s);
            }
        });
        return new ReactorListener.Aggregator(r);
    }

    protected void onInitMilestoneAttained(InitMilestone milestone) {
    }
}

