/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.extension.impl;

import com.qlangtech.tis.TIS;
import com.qlangtech.tis.util.AtomicFileWriter;
import com.qlangtech.tis.util.PluginMeta;
import com.qlangtech.tis.util.XStream2;
import com.qlangtech.tis.utils.MD5Utils;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.DataHolder;
import com.thoughtworks.xstream.core.MapBackedDataHolder;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.StreamException;
import com.thoughtworks.xstream.io.xml.XppDriver;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public final class XmlFile {
    private final XStream2 xs;
    private final File file;
    public final String relativePath;
    private boolean xsSecurityInitialized = false;
    private static final Logger LOGGER = Logger.getLogger(XmlFile.class.getName());
    private static final SAXParserFactory JAXP = SAXParserFactory.newInstance();
    public static final XppDriver DEFAULT_DRIVER = new XppDriver();
    public static final XStream2 DEFAULT_XSTREAM = new XStream2(DEFAULT_DRIVER);

    public XmlFile(File file) {
        this(DEFAULT_XSTREAM, file);
    }

    public XmlFile(File file, String relativePath) {
        this(DEFAULT_XSTREAM, file, relativePath);
    }

    public XmlFile(XStream2 xs, File file) {
        this(xs, file, TIS.pluginCfgRoot.toPath().relativize(file.toPath()).toString());
    }

    public XmlFile(XStream2 xs, File file, String relativePath) {
        this.xs = xs;
        this.file = file;
        this.relativePath = relativePath;
    }

    public File getFile() {
        return this.file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XStream getXStream() {
        if (!this.xsSecurityInitialized) {
            XmlFile xmlFile = this;
            synchronized (xmlFile) {
                if (!this.xsSecurityInitialized) {
                    this.xs.allowTypesByWildcard(new String[]{"com.qlangtech.tis.**"});
                    this.xs.denyTypes(new Class[]{System.class, ProcessBuilder.class, Runtime.class});
                    this.xsSecurityInitialized = true;
                }
            }
        }
        return this.xs;
    }

    public Object read() throws IOException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Reading " + this.file);
        }
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(this.file));){
            Object object = this.xs.fromXML(in);
            return object;
        }
    }

    public Object unmarshal(Object o) throws IOException {
        return this.unmarshal(o, null);
    }

    public Object unmarshal(Object o, DataHolder dataHolder) throws IOException {
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(this.file));){
            Object object = this.xs.unmarshal(DEFAULT_DRIVER.createReader((InputStream)in), o, dataHolder);
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean write(Object o, Set<PluginMeta> pluginsMeta) throws IOException {
        this.mkdirs();
        String preMd5 = null;
        boolean preFileExist = this.file.exists();
        if (preFileExist) {
            preMd5 = MD5Utils.md5file((File)this.file);
        }
        AtomicFileWriter w = new AtomicFileWriter(this.file);
        try {
            w.write("<?xml version='1.0' encoding='UTF-8'?>\n");
            DefaultDataHolder dataHolder = new DefaultDataHolder(pluginsMeta, this);
            HierarchicalStreamWriter writer = this.xs.createHierarchicalStreamWriter(w);
            try {
                this.xs.marshal(o, writer, (DataHolder)dataHolder);
            }
            finally {
                writer.flush();
            }
            w.commit();
            boolean bl = !preFileExist || !preMd5.equals(MD5Utils.md5file((File)this.file));
            return bl;
        }
        catch (StreamException e) {
            throw new IOException(e);
        }
        finally {
            w.abort();
        }
    }

    public boolean exists() {
        return this.file.exists();
    }

    public void delete() {
        this.file.delete();
    }

    public void mkdirs() {
        try {
            FileUtils.forceMkdirParent((File)this.file);
        }
        catch (IOException e) {
            throw new RuntimeException("file:" + this.file.getAbsolutePath(), e);
        }
    }

    public String toString() {
        return this.file.toString();
    }

    public Reader readRaw() throws IOException {
        return new InputStreamReader((InputStream)new FileInputStream(this.file), this.sniffEncoding());
    }

    public String asString() throws IOException {
        StringWriter w = new StringWriter();
        this.writeRawTo(w);
        return w.toString();
    }

    public void writeRawTo(Writer w) throws IOException {
        try (Reader r = this.readRaw();){
            IOUtils.copy((Reader)r, (Writer)w);
        }
    }

    /*
     * Exception decompiling
     */
    public String sniffEncoding() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static {
        JAXP.setNamespaceAware(true);
    }

    public static class DefaultDataHolder
    extends MapBackedDataHolder {
        public DefaultDataHolder(Set<PluginMeta> pluginsMeta, XmlFile xmlFile) {
            this.put(PluginMeta.class, pluginsMeta);
            this.put(XmlFile.class, xmlFile);
        }
    }
}

