/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.extension.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.qlangtech.tis.TIS;
import com.qlangtech.tis.extension.Describable;
import com.qlangtech.tis.extension.Descriptor;
import com.qlangtech.tis.extension.ElementPluginDesc;
import com.qlangtech.tis.extension.IPropertyType;
import com.qlangtech.tis.extension.impl.EnumFieldMode;
import com.qlangtech.tis.extension.impl.SuFormProperties;
import com.qlangtech.tis.extension.util.GroovyShellEvaluate;
import com.qlangtech.tis.extension.util.GroovyShellUtil;
import com.qlangtech.tis.extension.util.MultiItemsViewType;
import com.qlangtech.tis.extension.util.OverwriteProps;
import com.qlangtech.tis.extension.util.PluginExtraProps;
import com.qlangtech.tis.manage.common.Option;
import com.qlangtech.tis.plugin.annotation.FormField;
import com.qlangtech.tis.plugin.annotation.FormFieldType;
import com.qlangtech.tis.plugin.annotation.SubForm;
import com.qlangtech.tis.plugin.annotation.Validator;
import com.qlangtech.tis.plugin.ds.DataTypeMeta;
import com.qlangtech.tis.plugin.ds.ElementCreatorFactory;
import com.qlangtech.tis.runtime.module.misc.IMessageHandler;
import com.qlangtech.tis.trigger.util.JsonUtil;
import com.qlangtech.tis.trigger.util.UnCacheString;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.lang.StringUtils;
import org.jvnet.tiger_types.Types;

public class PropertyType
implements IPropertyType {
    private static final ConvertUtilsBean convertUtils = new ConvertUtilsBean();
    private static final JSONArray bolOps;
    private final Class ownerClazz;
    public final Class fieldClazz;
    public final Type type;
    private volatile Class itemType;
    public final String displayName;
    public final FormField formField;
    public final Field f;
    private Boolean inputRequired;
    private MultiItemsViewType multiItemsViewType;
    public PluginExtraProps.Props extraProp;
    private Validator[] validators;
    private Function<List<? extends Descriptor>, List<? extends Descriptor>> subDescFilter;

    public String propertyName() {
        return this.f.getName();
    }

    public Object serialize2FrontendOutput(Object val) {
        if (val == null) {
            return null;
        }
        try {
            return this.formField.type().valProcessor.serialize2Output(this, val);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public PropertyType(Class ownerClazz, Field f, FormField formField) {
        this(ownerClazz, f, f.getType(), f.getGenericType(), f.getName(), formField);
    }

    PropertyType(Class ownerClazz, Field f, Class fieldClazz, Type type, String displayName, FormField formField) {
        this.ownerClazz = Objects.requireNonNull(ownerClazz, "ownerClass can not be null");
        this.f = f;
        this.fieldClazz = fieldClazz;
        this.type = type;
        this.displayName = displayName;
        if (formField == null) {
            throw new IllegalStateException("param formField can not be null");
        }
        this.formField = formField;
    }

    public List<Option> getEnumPropOptions() {
        ArrayList opts = Lists.newArrayList();
        Object enumPp = Objects.requireNonNull(this.getExtraProps(), "extraProps can not be null, for property:" + this.f.getName()).get((Object)"enum");
        if (enumPp == null) {
            throw new IllegalStateException("enumPp can not be empty");
        }
        JSONArray enums = null;
        if (enumPp instanceof JSONArray) {
            enums = (JSONArray)enumPp;
        } else if (enumPp instanceof UnCacheString) {
            enums = (JSONArray)((UnCacheString)enumPp).getValue();
        } else {
            throw new IllegalStateException("unsupport type:" + enumPp.getClass().getName());
        }
        for (int i = 0; i < enums.size(); ++i) {
            JSONObject opt = enums.getJSONObject(i);
            opts.add(new Option(opt.getString("label"), opt.get((Object)"val")));
        }
        return opts;
    }

    public static void setDefaultVal(Object dftVal, JSONObject props) {
        if (dftVal != null) {
            Class<?> dftValClazz = dftVal.getClass();
            if (dftValClazz != String.class && dftValClazz != UnCacheString.class && !Number.class.isAssignableFrom(dftValClazz) && dftValClazz != Boolean.class && !dftValClazz.isEnum()) {
                throw new IllegalStateException("default value must be type of String or primitive,but now is type:" + dftVal.getClass());
            }
            props.put("dftVal", dftVal);
        }
    }

    public static void setLabel(String label, JSONObject props) {
        if (StringUtils.isEmpty((String)label)) {
            throw new IllegalArgumentException("param label can not be null");
        }
        Objects.requireNonNull(props, "props can not be null").put("label", (Object)label);
    }

    public static void setDisabled(JSONObject props) {
        Objects.requireNonNull(props, "props can not be null").put("disable", (Object)true);
    }

    public static void setReadOnly(JSONObject props) {
        Objects.requireNonNull(props, "props can not be null").put("readonly", (Object)true);
    }

    public boolean isCollectionType() {
        return List.class.isAssignableFrom(this.fieldClazz);
    }

    public static Map<String, PropertyType> filterFieldProp(Map<String, IPropertyType> props) {
        return props.entrySet().stream().filter(e -> e.getValue() instanceof PropertyType).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (PropertyType)e.getValue()));
    }

    public static Map<String, IPropertyType> buildPropertyTypes(final Optional<ElementPluginDesc> descriptor, final Class<? extends Describable> clazz) {
        try {
            final HashMap<String, IPropertyType> propMapper = new HashMap<String, IPropertyType>();
            final Optional<PluginExtraProps> extraProps = PluginExtraProps.load(descriptor, clazz);
            PluginExtraProps.visitAncestorsClass(clazz, new PluginExtraProps.IClassVisitor<Void>(){

                @Override
                public Void process(Class<?> targetClass, Void v, boolean finalChild) {
                    FormField formField = null;
                    SubForm subFormFields = null;
                    Class<? extends Describable> subFromDescClass = null;
                    Field targetField = null;
                    try {
                        Field[] fieldArray = targetClass.getDeclaredFields();
                        int n = fieldArray.length;
                        for (int i = 0; i < n; ++i) {
                            Field f;
                            targetField = f = fieldArray[i];
                            if (!Modifier.isPublic(f.getModifiers()) || Modifier.isStatic(f.getModifiers())) continue;
                            subFormFields = f.getAnnotation(SubForm.class);
                            if (subFormFields != null) {
                                subFromDescClass = subFormFields.desClazz();
                                if (subFromDescClass == null) {
                                    throw new IllegalStateException("field " + f.getName() + "'s SubForm annotation descClass can not be null");
                                }
                                Descriptor subFormDesc = Objects.requireNonNull(TIS.get().getDescriptor(subFromDescClass), "subFromDescClass:" + subFromDescClass + " relevant descriptor can not be null");
                                propMapper.put(f.getName(), new SuFormProperties(clazz, f, subFormFields, subFormDesc, PropertyType.filterFieldProp(PropertyType.buildPropertyTypes(ElementPluginDesc.create(subFormDesc), subFromDescClass))));
                                continue;
                            }
                            formField = f.getAnnotation(FormField.class);
                            if (formField == null) continue;
                            PluginExtraProps.Props fieldExtraProps = null;
                            PropertyType ptype = new PropertyType(clazz, f, formField);
                            if (extraProps.isPresent() && (fieldExtraProps = ((PluginExtraProps)extraProps.get()).getProp(f.getName())) != null) {
                                ptype.setExtraProp(fieldExtraProps);
                                String placeholder = fieldExtraProps.getPlaceholder();
                                Object dftVal = fieldExtraProps.getDftVal();
                                String help = fieldExtraProps.getHelpContent();
                                JSONObject props = fieldExtraProps.getProps();
                                if (fieldExtraProps.getBoolean("disable")) {
                                    propMapper.remove(f.getName());
                                    continue;
                                }
                                if (StringUtils.isNotEmpty((String)help) && StringUtils.startsWith((String)help, (String)IMessageHandler.TSEARCH_PACKAGE)) {
                                    props.put("help", GroovyShellEvaluate.eval(help));
                                }
                                if (dftVal != null && StringUtils.startsWith((String)String.valueOf(dftVal), (String)IMessageHandler.TSEARCH_PACKAGE) && !(dftVal instanceof UnCacheString)) {
                                    PropertyType pt = ptype;
                                    Function process = pt.getEnumFieldMode() != null ? pt.getEnumFieldMode().createDefaultValProcess(targetClass, f) : Function.identity();
                                    PropertyType.setDefaultVal(GroovyShellEvaluate.scriptEval(String.valueOf(dftVal), process), props);
                                }
                                if (placeholder != null && StringUtils.startsWith((String)placeholder, (String)IMessageHandler.TSEARCH_PACKAGE)) {
                                    props.put("placeholder", GroovyShellEvaluate.scriptEval(placeholder, new Function[0]));
                                }
                                if (descriptor.isPresent() && formField.type() == FormFieldType.ENUM) {
                                    PropertyType.resolveEnumProp(f, ((ElementPluginDesc)descriptor.get()).getElementDesc(), fieldExtraProps, opts -> Option.toJson((List)((List)opts)));
                                }
                                if (descriptor.isPresent() && formField.type() == FormFieldType.MULTI_SELECTABLE) {
                                    PluginExtraProps.Props feProps = fieldExtraProps;
                                    ElementPluginDesc paretPluginRef = (ElementPluginDesc)descriptor.get();
                                    PropertyType.resolveEnumProp(f, paretPluginRef.getElementDesc(), feProps, cols -> {
                                        List mcols = (List)cols;
                                        return ptype.multiSelectablePropProcess(viewType -> {
                                            MultiItemsViewType multiItemsViewType = viewType;
                                            switch (multiItemsViewType.viewType) {
                                                case IdList: {
                                                    return Option.toJson((List)mcols);
                                                }
                                                case TupleList: {
                                                    return DataTypeMeta.createViewBiz((DataTypeMeta.IMultiItemsView)multiItemsViewType, (Object)mcols);
                                                }
                                            }
                                            throw new IllegalStateException("unhandle view type:" + multiItemsViewType);
                                        }, true);
                                    });
                                }
                            }
                            propMapper.put(f.getName(), ptype);
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException("field:" + targetField.getName() + " of targetClass:" + targetClass.getName(), e);
                    }
                    return null;
                }
            });
            return propMapper;
        }
        catch (Exception e) {
            throw new RuntimeException("parse desc:" + clazz.getName(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JSONArray resolveEnumProp(Field field, Descriptor descriptor, PluginExtraProps.Props fieldExtraProps, Function<Object, Object> process) {
        JSONObject props = fieldExtraProps.getProps();
        Object anEnum = props.get((Object)"enum");
        JSONArray enums = new JSONArray();
        if (anEnum != null && anEnum instanceof String) {
            try {
                GroovyShellUtil.descriptorThreadLocal.set(descriptor);
                props.put("enum", GroovyShellEvaluate.scriptEval((String)anEnum, process));
            }
            finally {
                GroovyShellUtil.descriptorThreadLocal.remove();
            }
        } else if (anEnum == null && (field.getType() == Boolean.TYPE || field.getType() == Boolean.class)) {
            props.put("enum", (Object)bolOps);
        }
        return enums;
    }

    public static Map<String, PropertyType> filterFieldProp(boolean useCache, Descriptor descriptor) {
        return PropertyType.filterFieldProp(descriptor.getPropertyTypes(useCache));
    }

    private MultiItemsViewType getMultiItemsViewType() {
        if (this.multiItemsViewType == null) {
            this.multiItemsViewType = MultiItemsViewType.createMultiItemsViewType(this);
        }
        return this.multiItemsViewType;
    }

    public void setMultiItemsViewType(MultiItemsViewType multiItemsViewType) {
        this.multiItemsViewType = multiItemsViewType;
    }

    public void setMultiItemsViewType(PropertyType oldPt) {
        this.multiItemsViewType = oldPt.getMultiItemsViewType();
    }

    public boolean isIdentity() {
        return this.formField.identity();
    }

    @JSONField(serialize=false)
    public JSONObject getExtraProps() {
        if (this.extraProp == null) {
            return null;
        }
        return this.extraProp.getProps();
    }

    @JSONField(serialize=false)
    public Optional<PluginExtraProps.FieldRefCreateor> getRefCreator() {
        if (this.extraProp == null) {
            return Optional.empty();
        }
        return this.extraProp.getRefCreator();
    }

    @JSONField(serialize=false)
    public EnumFieldMode getEnumFieldMode() {
        if (this.formField.type() != FormFieldType.ENUM && this.formField.type() != FormFieldType.SELECTABLE) {
            return null;
        }
        return EnumFieldMode.parse(this.extraProp != null ? this.getExtraProps().getString("enumMode") : null);
    }

    public void setExtraProp(PluginExtraProps.Props extraProp) {
        this.extraProp = extraProp;
    }

    public Object dftVal() {
        if (this.extraProp == null) {
            return null;
        }
        return this.extraProp.getDftVal();
    }

    public int ordinal() {
        return this.formField.ordinal();
    }

    public boolean advance() {
        return this.extraProp != null && this.extraProp.isAdvance() || this.formField.advance();
    }

    public int typeIdentity() {
        return this.formField.type().getIdentity();
    }

    public void appendExternalProp(JSONObject attrVal) {
        this.formField.type().appendExternalProps.accept(attrVal);
    }

    @JSONField(serialize=false)
    public Validator[] getValidator() {
        if (this.validators == null) {
            HashSet result = Sets.newHashSet();
            Map<Validator, PluginExtraProps.Props.ValidatorCfg> validators = (this.extraProp == null ? Collections.emptyList() : this.extraProp.getExtraValidators()).stream().collect(Collectors.toMap(v -> ((PluginExtraProps.Props.ValidatorCfg)v).validator, v -> (PluginExtraProps.Props.ValidatorCfg)v));
            PluginExtraProps.Props.ValidatorCfg validatorCfg = null;
            for (Validator v2 : this.formField.validate()) {
                validatorCfg = validators.get((Object)v2);
                if (validatorCfg != null) {
                    if (validatorCfg.disable) continue;
                    result.add(v2);
                    continue;
                }
                result.add(v2);
            }
            for (PluginExtraProps.Props.ValidatorCfg cfg : validators.values()) {
                if (cfg.disable) continue;
                result.add(cfg.validator);
            }
            this.validators = result.toArray(new Validator[result.size()]);
        }
        return this.validators;
    }

    public boolean isInputRequired() {
        if (this.inputRequired == null) {
            this.inputRequired = false;
            for (Validator v : this.getValidator()) {
                if (v != Validator.require) continue;
                this.inputRequired = true;
                return this.inputRequired;
            }
        }
        return this.inputRequired;
    }

    @JSONField(serialize=false)
    public Enum[] getEnumConstants() {
        return (Enum[])this.fieldClazz.getEnumConstants();
    }

    @JSONField(serialize=false)
    public Class getItemType() {
        if (this.itemType == null) {
            this.itemType = this.computeItemType();
        }
        return this.itemType;
    }

    public Object getFrontendOutput(Object instance) {
        return this.getVal(true, instance);
    }

    public Object getVal(boolean serialize2Frontend, Object instance) {
        try {
            List<Object> val = this.f.get(instance);
            if (this.formField.type() == FormFieldType.MULTI_SELECTABLE) {
                return this.getMultiItemsViewType().serialize2Frontend(this.isCollectionType() ? val : Collections.singletonList(val));
            }
            return serialize2Frontend ? this.serialize2FrontendOutput(val) : val;
        }
        catch (Exception e) {
            throw new RuntimeException("property:" + this.f.getName(), e);
        }
    }

    public <T> T multiSelectablePropProcess(Function<MultiItemsViewType, T> consumer) {
        return this.multiSelectablePropProcess(consumer, false);
    }

    public <T> T multiSelectablePropProcess(Function<MultiItemsViewType, T> consumer, boolean validate) {
        if (this.formField.type() == FormFieldType.MULTI_SELECTABLE) {
            return consumer.apply(this.getMultiItemsViewType());
        }
        if (validate) {
            throw new IllegalStateException(" illegal form type:" + this.formField.type());
        }
        return null;
    }

    public void setVal(Object instance, Object val) {
        PropVal fieldVal = new PropVal(val, this.fieldClazz, this);
        try {
            this.f.set(instance, this.formField.type().valProcessor.processInput(instance, fieldVal));
        }
        catch (Throwable e) {
            throw new RuntimeException("\ntarget instance:" + instance.getClass() + "\nfield:" + this.f.getName() + "\nprop class:" + val.getClass(), e);
        }
    }

    private Class computeItemType() {
        if (this.fieldClazz.isArray()) {
            return this.fieldClazz.getComponentType();
        }
        if (Collection.class.isAssignableFrom(this.fieldClazz)) {
            Type col = Types.getBaseClass((Type)this.type, Collection.class);
            if (col instanceof ParameterizedType) {
                return Types.erasure((Type)Types.getTypeArgument((Type)col, (int)0));
            }
            return Object.class;
        }
        return null;
    }

    @JSONField(serialize=false)
    public Descriptor getItemTypeDescriptor() {
        return TIS.get().getDescriptor(this.getItemType());
    }

    public boolean isDescribable() {
        return Describable.class.isAssignableFrom(this.fieldClazz);
    }

    public static String getPluginImpl(JSONObject valJ) {
        JSONObject descVal = valJ.getJSONObject("descVal");
        String impl = Objects.requireNonNull(descVal, "prop:descVal json:" + JsonUtil.toString((Object)valJ)).getString("impl");
        return impl;
    }

    @JSONField(serialize=false)
    public Descriptor getItemTypeDescriptorOrDie() {
        Class it = this.getItemType();
        if (it == null) {
            throw new AssertionError((Object)(this.fieldClazz + " is not an array/collection type in " + this.displayName + ". See https://wiki.jenkins-ci.org/display/JENKINS/My+class+is+missing+descriptor"));
        }
        Descriptor d = TIS.get().getDescriptor(it);
        if (d == null) {
            throw new AssertionError((Object)(it + " is missing its descriptor in " + this.displayName + ". See https://wiki.jenkins-ci.org/display/JENKINS/My+class+is+missing+descriptor"));
        }
        return d;
    }

    @JSONField(serialize=false)
    public List<? extends Descriptor> getApplicableDescriptors() {
        String subDescEnumFilter;
        JSONObject eprops = null;
        if (this.subDescFilter == null && (eprops = this.getExtraProps()) != null && StringUtils.isNotEmpty((String)(subDescEnumFilter = eprops.getString("subDescEnumFilter")))) {
            Class fieldClazz = this.ownerClazz;
            String className = fieldClazz.getSimpleName() + "_" + this.f.getName() + "_SubFilter";
            String pkg = fieldClazz.getPackage().getName();
            String script = "\tpackage " + pkg + " ;\nimport java.util.function.Function;\nimport java.util.List;\nimport " + Descriptor.class.getName() + ";\nclass " + className + " implements Function<List<? extends Descriptor>,List<? extends Descriptor>> { \n\t@Override \n\tpublic List<? extends Descriptor> apply(List<? extends Descriptor> desc) {" + subDescEnumFilter + "\t}}";
            this.subDescFilter = (Function)GroovyShellEvaluate.createParamizerScript(fieldClazz, className, script);
        }
        if (this.subDescFilter == null) {
            this.subDescFilter = descs -> descs;
        }
        try {
            return this.subDescFilter.apply(TIS.get().getDescriptorList(this.fieldClazz));
        }
        catch (Exception e) {
            throw new RuntimeException("formField:" + this.f, e);
        }
    }

    @JSONField(serialize=false)
    public List<? extends Descriptor> getApplicableItemDescriptors() {
        Class itemType = this.getItemType();
        if (itemType == null) {
            return null;
        }
        return TIS.get().getDescriptorList(itemType);
    }

    @JSONField(serialize=false)
    public ElementCreatorFactory getCMetaCreator() {
        return Objects.requireNonNull(this.multiItemsViewType, (String)"multiItemsViewType can not be null").tupleFactory;
    }

    static {
        convertUtils.register(new Converter(){

            public <T> T convert(Class<T> type, Object value) {
                if (value instanceof UnCacheString) {
                    return (T)((UnCacheString)value).getValue();
                }
                if (value instanceof JSONArray) {
                    JSONArray array = (JSONArray)value;
                    List convert = array.toJavaList(String.class);
                    return (T)convert;
                }
                return (T)value;
            }
        }, List.class);
        bolOps = new JSONArray();
        OverwriteProps.ENUM_BOOLEAN.forEach(option -> {
            JSONObject b = new JSONObject();
            b.put("label", (Object)option.getName());
            b.put("val", option.getValue());
            bolOps.add((Object)b);
        });
    }

    public static class PropVal {
        private final Object val;
        private final Class targetClazz;
        public final PropertyType propertyType;

        public PropVal(Object val, Class targetClazz, PropertyType propertyType) {
            this.val = val;
            this.targetClazz = targetClazz;
            this.propertyType = propertyType;
        }

        public <T> T convertedVal() {
            return (T)convertUtils.convert(this.val, this.targetClazz);
        }

        public Object rawVal() {
            return this.val;
        }

        public Class getTargetClazz() {
            return this.targetClazz;
        }
    }
}

