/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.extension.impl;

import com.qlangtech.tis.TIS;
import com.qlangtech.tis.extension.PluginWrapper;
import com.qlangtech.tis.extension.impl.ClassicPluginStrategy;
import com.qlangtech.tis.extension.impl.IOUtils;
import com.qlangtech.tis.maven.plugins.tpi.PluginClassifier;
import com.qlangtech.tis.util.PluginMeta;
import com.qlangtech.tis.util.Util;
import com.qlangtech.tis.util.YesNoMaybe;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Expand;
import org.apache.tools.ant.taskdefs.Zip;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.PatternSet;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.ZipFileSet;
import org.apache.tools.ant.types.resources.MappedResourceCollection;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.GlobPatternMapper;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipExtraField;
import org.apache.tools.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PluginManifest {
    public static final String META_PATH_EXTENDPOINTS = "META-INF/annotations/extendpoints.txt";
    private static final Logger LOGGER = LoggerFactory.getLogger(PluginManifest.class);
    static final Pattern fromJpl = Pattern.compile("^file:.+/(.+?)/target/.+?$");
    public final URL baseResourceURL;
    protected final Attributes atts;
    protected final List<File> libs;
    private static final FilenameFilter JAR_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".jar");
        }
    };

    public static PluginManifest create(Class<?> classInPlugin) {
        if (classInPlugin == null) {
            throw new IllegalArgumentException("classInPlugin can not be null");
        }
        String clazz = classInPlugin.getName();
        URL location = classInPlugin.getResource("/" + StringUtils.replace((String)clazz, (String)".", (String)"/") + ".class");
        Matcher m = null;
        if (location != null) {
            Pattern p = Pattern.compile("^.*file:(.+?)/WEB-INF/lib.+?!.*$");
            m = p.matcher(location.toString());
            if (m.find()) {
                ExplodePluginManifest explodePluginManifest;
                block17: {
                    File pluginDir = new File(m.group(1));
                    if (!pluginDir.exists()) {
                        throw new IllegalStateException("plugin Dir is not exist:" + pluginDir.getAbsolutePath());
                    }
                    File manifest = new File(pluginDir, "META-INF/MANIFEST.MF");
                    if (!manifest.exists()) {
                        throw new IllegalStateException("META-INF/MANIFEST.MF is not exist :" + manifest.getAbsolutePath());
                    }
                    Manifest mfst = new Manifest();
                    FileInputStream in = FileUtils.openInputStream((File)manifest);
                    try {
                        mfst.read(in);
                        explodePluginManifest = new ExplodePluginManifest(mfst.getMainAttributes(), pluginDir);
                        if (in == null) break block17;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (in != null) {
                                try {
                                    ((InputStream)in).close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            throw new RuntimeException(manifest.getAbsolutePath(), e);
                        }
                    }
                    ((InputStream)in).close();
                }
                return explodePluginManifest;
            }
            m = fromJpl.matcher(location.toString());
            if (m.matches()) {
                try {
                    String pluginName = m.group(1);
                    File archive = new File(TIS.pluginDirRoot, pluginName + ".hpl");
                    PluginManifest hplManifest = PluginManifest.create(null, archive);
                    if (!(hplManifest instanceof JPLPluginManifest)) {
                        throw new IllegalStateException("hplManifest must be type of " + JPLPluginManifest.class.getSimpleName());
                    }
                    return hplManifest;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            throw new IllegalStateException("location is illegal:" + location);
        }
        throw new IllegalStateException("Cannot find class '" + classInPlugin.getName() + " using the classloader");
    }

    public static PluginManifest create(File tpi) {
        PluginManifest pluginManifest;
        if (!tpi.exists()) {
            return null;
        }
        JarInputStream tpiFIle = new JarInputStream((InputStream)FileUtils.openInputStream((File)tpi), false);
        try {
            Manifest mfst = tpiFIle.getManifest();
            Objects.requireNonNull(mfst, "tpi relevant manifest can not be null:" + tpi.getAbsolutePath());
            pluginManifest = PluginManifest.createPluginManifest(mfst);
        }
        catch (Throwable throwable) {
            try {
                try {
                    tpiFIle.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("tpi path:" + tpi.getAbsolutePath(), e);
            }
        }
        tpiFIle.close();
        return pluginManifest;
    }

    private static PluginManifest createPluginManifest(Manifest mfst) {
        return new ExplodePluginManifest(mfst.getMainAttributes(), null){

            @Override
            public List<File> getLibs() {
                throw new UnsupportedOperationException();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PluginManifest create(File pluginWorkDir, File archive) throws IOException {
        File lib;
        File[] libs;
        Manifest manifest;
        URL baseResourceURL = null;
        File expandDir = null;
        boolean isLinked = PluginManifest.isLinked(archive);
        if (isLinked) {
            manifest = PluginManifest.loadLinkedManifest(archive);
        } else {
            if (archive.isDirectory()) {
                expandDir = archive;
            } else {
                expandDir = new File(pluginWorkDir == null ? archive.getParentFile() : pluginWorkDir, FilenameUtils.getBaseName((String)archive.getName()));
                PluginManifest.explode(archive, expandDir);
            }
            File manifestFile = new File(expandDir, "META-INF/MANIFEST.MF");
            if (!manifestFile.exists()) {
                throw new IOException("Plugin installation failed. No manifest at " + manifestFile);
            }
            try (FileInputStream fin = new FileInputStream(manifestFile);){
                manifest = new Manifest(fin);
            }
        }
        Attributes atts = manifest.getMainAttributes();
        ArrayList<File> paths = new ArrayList<File>();
        if (isLinked) {
            PluginManifest.parseClassPath(manifest, archive, paths, "Libraries", ",");
            baseResourceURL = PluginManifest.resolve(archive, atts.getValue("Resource-Path")).toURI().toURL();
            return new JPLPluginManifest(atts, baseResourceURL, paths, PluginManifest.parseShortName(atts, "Short-Name"));
        }
        File classes = new File(expandDir, "WEB-INF/classes");
        if (classes.exists()) {
            paths.add(classes);
        }
        if ((libs = (lib = new File(expandDir, "WEB-INF/lib")).listFiles(JAR_FILTER)) != null) {
            paths.addAll(Arrays.asList(libs));
        }
        baseResourceURL = expandDir.toPath().toUri().toURL();
        return new ExplodePluginManifest(atts, baseResourceURL, paths, expandDir);
    }

    public abstract List<String> getClasspath();

    public PluginManifest(Attributes atts, URL baseResourceURL, List<File> libs) {
        this.baseResourceURL = baseResourceURL;
        this.atts = Objects.requireNonNull(atts, "param atts can not be null");
        this.libs = libs;
    }

    public YesNoMaybe supportsDynamicLoad() {
        String v = this.atts.getValue("Support-Dynamic-Loading");
        if (v == null) {
            return YesNoMaybe.MAYBE;
        }
        return Boolean.parseBoolean(v) ? YesNoMaybe.YES : YesNoMaybe.NO;
    }

    public String getVersionOf() {
        String v = this.atts.getValue("tis-Version");
        if (v != null) {
            return v;
        }
        v = this.atts.getValue("Implementation-Version");
        if (v != null) {
            return v;
        }
        return "???";
    }

    public String getPluginClass() {
        return this.atts.getValue("Plugin-Class");
    }

    public long getLastModfiyTime() {
        return Long.parseLong(this.atts.getValue("Last-Modify-Time"));
    }

    public String getGroupId() {
        return this.atts.getValue("Group-Id");
    }

    public String getURL() {
        return this.atts.getValue("Url");
    }

    public String getLongName() {
        String name = this.atts.getValue("Long-Name");
        return name;
    }

    public boolean isCommunityVIP() {
        return Boolean.parseBoolean(this.atts.getValue("communityVIP"));
    }

    public PluginMeta getPluginMeta() {
        return new PluginMeta(this.computeShortName(""), this.getVersionOf(), this.parseClassifier(), this.getLastModfiyTime());
    }

    public boolean getUsePluginFirstClassLoader() {
        if (this.atts == null) {
            return false;
        }
        String usePluginFirstClassLoader = this.atts.getValue("PluginFirstClassLoader");
        return Boolean.valueOf(usePluginFirstClassLoader);
    }

    public List<File> getLibs() {
        return this.libs;
    }

    public String getMaskedClasses() {
        String masked = this.atts.getValue("Mask-Classes");
        return masked;
    }

    public Optional<PluginClassifier> parseClassifier() {
        String attrClazzier = this.atts.getValue("classifier");
        return Optional.ofNullable(StringUtils.isEmpty((String)attrClazzier) ? null : PluginClassifier.create((String)attrClazzier));
    }

    public String computeShortName(String fileName) {
        return PluginManifest.parseShortName(this.atts, fileName);
    }

    public static String parseShortName(Attributes atts, String fileName) {
        String n = atts.getValue("Short-Name");
        if (n != null) {
            return n;
        }
        n = atts.getValue("Extension-Name");
        if (n != null) {
            return n;
        }
        return FilenameUtils.getBaseName((String)fileName);
    }

    public ClassicPluginStrategy.DependencyMeta getDependencyMeta() {
        ClassicPluginStrategy.DependencyMeta dependencyMeta = new ClassicPluginStrategy.DependencyMeta();
        String v = this.atts.getValue("Plugin-Dependencies");
        if (v != null) {
            for (String s : v.split(",")) {
                PluginWrapper.Dependency d = PluginWrapper.Dependency.parse(s);
                if (d.optional) {
                    dependencyMeta.optionalDependencies.add(d);
                    continue;
                }
                dependencyMeta.dependencies.add(d);
            }
        }
        return dependencyMeta;
    }

    public String getMasked() {
        String masked = this.atts.getValue("Global-Mask-Classes");
        return masked;
    }

    public static boolean isLinked(File archive) {
        return archive.getName().endsWith(".hpl") || archive.getName().endsWith(".jpl");
    }

    private static File resolve(File base, String relative) {
        File rel = new File(relative);
        if (rel.isAbsolute()) {
            return rel;
        }
        return new File(base.getParentFile(), relative);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Manifest loadLinkedManifest(File archive) throws IOException {
        Manifest manifest;
        String firstLine;
        try (FileInputStream manifestHeaderInput = new FileInputStream(archive);){
            firstLine = IOUtils.readFirstLine((InputStream)manifestHeaderInput, (String)"UTF-8");
        }
        if (!firstLine.startsWith("Manifest-Version:")) {
            archive = PluginManifest.resolve(archive, firstLine);
        }
        FileInputStream manifestInput = new FileInputStream(archive);
        try {
            manifest = new Manifest(manifestInput);
        }
        catch (Throwable throwable) {
            try {
                manifestInput.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new IOException("Failed to load " + archive, e);
            }
        }
        manifestInput.close();
        return manifest;
    }

    private static void parseClassPath(Manifest manifest, File archive, List<File> paths, String attributeName, String separator) throws IOException {
        String classPath = manifest.getMainAttributes().getValue(attributeName);
        if (classPath == null) {
            return;
        }
        for (String s : classPath.split(separator)) {
            File file = PluginManifest.resolve(archive, s);
            if (file.getName().contains("*")) {
                FileSet fs = new FileSet();
                File dir = file.getParentFile();
                fs.setDir(dir);
                fs.setIncludes(file.getName());
                for (String included : fs.getDirectoryScanner(new Project()).getIncludedFiles()) {
                    paths.add(new File(dir, included));
                }
                continue;
            }
            if (!file.exists()) {
                throw new IOException("No such file: " + file);
            }
            paths.add(file);
        }
    }

    private static void explode(File archive, File destDir) throws IOException {
        destDir.mkdirs();
        File explodeTime = new File(destDir, ".timestamp2");
        boolean explodeTimeExist = false;
        explodeTimeExist = explodeTime.exists();
        if (explodeTimeExist && explodeTime.lastModified() == archive.lastModified()) {
            return;
        }
        LOGGER.info("start to explode archive:{}", (Object)archive.getAbsolutePath());
        Util.deleteRecursive(destDir);
        try {
            Project prj = new Project();
            PluginManifest.unzipExceptClasses(archive, destDir, prj);
            PluginManifest.createClassJarFromWebInfClasses(archive, destDir, prj);
        }
        catch (BuildException x) {
            throw new IOException("Failed to expand " + archive, x);
        }
        try {
            if (!explodeTimeExist) {
                FileUtils.touch((File)explodeTime);
            }
            explodeTime.setLastModified(archive.lastModified());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createClassJarFromWebInfClasses(File archive, File destDir, Project prj) throws IOException {
        File classesJar = new File(destDir, "WEB-INF/lib/classes.jar");
        ZipFileSet zfs = new ZipFileSet();
        zfs.setProject(prj);
        zfs.setSrc(archive);
        zfs.setIncludes("WEB-INF/classes/");
        MappedResourceCollection mapper = new MappedResourceCollection();
        mapper.add((ResourceCollection)zfs);
        GlobPatternMapper gm = new GlobPatternMapper();
        gm.setFrom("WEB-INF/classes/*");
        gm.setTo("*");
        mapper.add((FileNameMapper)gm);
        final long dirTime = archive.lastModified();
        try (final ZipOutputStream wrappedZOut = new ZipOutputStream((OutputStream)new NullOutputStream()){

            public void putNextEntry(ZipEntry ze) throws IOException {
                ze.setTime(dirTime + 1999L);
                super.putNextEntry(ze);
            }
        };){
            Zip z = new Zip(){

                protected void zipDir(Resource dir, ZipOutputStream zOut, String vPath, int mode, ZipExtraField[] extra) throws IOException {
                    super.zipDir(dir, wrappedZOut, vPath, mode, extra);
                }
            };
            z.setProject(prj);
            z.setTaskType("zip");
            classesJar.getParentFile().mkdirs();
            z.setDestFile(classesJar);
            z.add((ResourceCollection)mapper);
            z.execute();
        }
    }

    private static void unzipExceptClasses(File archive, File destDir, Project prj) {
        Expand e = new Expand();
        e.setProject(prj);
        e.setTaskType("unzip");
        e.setSrc(archive);
        e.setDest(destDir);
        PatternSet p = new PatternSet();
        p.setExcludes("WEB-INF/classes/");
        e.addPatternset(p);
        e.execute();
    }

    public static class JPLPluginManifest
    extends PluginManifest {
        private final String pluginName;

        public JPLPluginManifest(Attributes atts, URL baseResourceURL, List<File> libs, String pluginName) {
            super(atts, baseResourceURL, libs);
            this.pluginName = pluginName;
        }

        @Override
        public String computeShortName(String fileName) {
            return this.pluginName;
        }

        @Override
        public List<String> getClasspath() {
            return this.libs.stream().map(lib -> String.valueOf(lib.toPath().normalize())).collect(Collectors.toList());
        }
    }

    public static class ExplodePluginManifest
    extends PluginManifest {
        private final File pluginDir;

        public ExplodePluginManifest(Attributes atts, File pluginDir) {
            this(atts, null, Collections.emptyList(), pluginDir);
        }

        public ExplodePluginManifest(Attributes atts, URL baseResourceURL, List<File> libs, File pluginDir) {
            super(atts, baseResourceURL, libs);
            this.pluginDir = pluginDir;
        }

        @Override
        public List<String> getClasspath() {
            return List.of(this.getPluginLibDir().getAbsolutePath() + "/*");
        }

        public File getPluginLibDir() {
            return new File(this.pluginDir, "WEB-INF/lib");
        }
    }
}

