/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.extension.impl;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import org.apache.tools.ant.AntClassLoader;

public class PluginFirstClassLoader
extends AntClassLoader
implements Closeable {
    private List<URL> urls = new ArrayList<URL>();
    private final Vector pathComponents;
    private final String pluginName;

    public PluginFirstClassLoader(String pluginName) {
        super(null, false);
        this.pluginName = pluginName;
        try {
            Field $pathComponents = AntClassLoader.class.getDeclaredField("pathComponents");
            $pathComponents.setAccessible(true);
            this.pathComponents = (Vector)$pathComponents.get(this);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new Error(e);
        }
    }

    public void addPathFiles(Collection<File> paths) throws IOException {
        for (File f : paths) {
            this.urls.add(f.toURI().toURL());
            this.addPathFile(f);
        }
    }

    public List<URL> getURLs() {
        return this.urls;
    }

    protected URL findResource(String name) {
        URL url = null;
        Enumeration e = this.pathComponents.elements();
        while (e.hasMoreElements() && url == null) {
            File pathComponent = (File)e.nextElement();
            url = this.getResourceURL(pathComponent, name);
            if (url == null) continue;
            this.log("Resource " + name + " loaded from ant loader", 4);
        }
        return url;
    }

    protected Enumeration findResources(String arg0, boolean arg1) throws IOException {
        Enumeration enu = super.findResources(arg0, arg1);
        return enu;
    }

    protected Enumeration<URL> findResources(String name) throws IOException {
        Enumeration enu = super.findResources(name);
        return enu;
    }

    public URL getResource(String arg0) {
        URL url = super.getResource(arg0);
        return url;
    }

    public InputStream getResourceAsStream(String name) {
        InputStream is = super.getResourceAsStream(name);
        return is;
    }

    public String toString() {
        return "PluginFirstClassLoader,pluginName:" + this.pluginName;
    }
}

